/*
 *	SILCConnectionHandler.java		2002/11/16
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.util.Arrays;
import com.alistairphipps.util.Hex;
import java.lang.String;
import com.alistairphipps.jsilc.core.*;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

/** Handles translation between SILC packets and events and vice versa
 * 
 * @author Alistair K Phipps
 * @version 20021117
 */
public class SILCConnectionHandler implements ConnectionHandler
{
	private SILCConnection _conn;
	
	public SILCConnectionHandler( String strUsername, String strHost, int iPort ) throws java.net.UnknownHostException, java.io.IOException
	{
		_conn = new SILCConnection( strUsername, strHost, iPort );
	}
	
	public synchronized void putEvent( OutEvent e )
	{
		try
		{
			if( e instanceof MessageOutEvent )
			{
				SILCPayload pl = new SILCPrivateMessagePayload( false, ((MessageOutEvent)e).getMessage() );	// false as not an action
				SILCPacket p = new SILCPacket( SILCPacketType.PRIVATE_MESSAGE, _conn.getLocalIdType(), _conn.getLocalId(), ( (SILCEntity)e.getDest() ).getIdType(), ( (SILCEntity)e.getDest() ).getId(), pl );
				_conn.putPacket( p );
			} // TODO: handle other types of events
		}
		catch( Exception x )
		{
			x.printStackTrace();
		}
	}

	public InEvent getEvent()
	{
		try
		{
			// TODO: handle other types of packets
			SILCPacket p = _conn.getPacket();
			MessageInEvent e;
			switch( p.getType() )
			{
			case SILCPacketType.PRIVATE_MESSAGE:
				e = new MessageInEvent( new SILCEntity( p.getSourceIdType(), p.getSourceId(), getFriendlyName( p.getSourceIdType(), p.getSourceId() ) ), ( (SILCPrivateMessagePayload)p.getPayload() ).getMessage() );
				break;
			case SILCPacketType.HEARTBEAT:
				e = new MessageInEvent( new SILCEntity( _conn.getRemoteIdType(), _conn.getRemoteId(), getFriendlyName( _conn.getRemoteIdType(), _conn.getRemoteId() ) ), "Received Heartbeat" );
				break;
			default:
				e = new MessageInEvent( new SILCEntity( _conn.getRemoteIdType(), _conn.getRemoteId(), getFriendlyName( _conn.getRemoteIdType(), _conn.getRemoteId() ) ), "Unknown SILC packet received: \n" + p.toString() );
			}
			return e;
		}
		catch( Exception x )
		{
			x.printStackTrace();
			return null; // XXX maybe return an informative message instead
		}
	}

	private String getFriendlyName( byte yIdType, byte[] ylId )
	{
		String strRet = SILCIdType.toString( yIdType ) + " - ";
		if( ( yIdType == _conn.getRemoteIdType() ) && ( Arrays.equals( ylId, _conn.getRemoteId() ) ) )
			return strRet + _conn.getServerName();
		if( ( yIdType == SILCIdType.CLIENT ) )
			return strRet + getClientName( ylId );
		return strRet + "Unknown";
	}

	private String getClientName( byte[] ylId )
	{	// 
		String strRet = Hex.toString( ylId );	// fallback
/*		try	// FIXME: this isn't working
		{
			// send a whois
			SILCArgumentPayload[] argl = new SILCArgumentPayload[ 2 ];
			argl[0] = new SILCArgumentPayload( (byte)4, ylId );	// specify client ID
			byte ylCount[] = new byte[1];
			ylCount[0] = (byte)1;
			argl[1] = new SILCArgumentPayload( (byte)2, ylCount );// specify max number of results desired
			SILCPayload pl = new SILCCommandPayload( SILCCommandType.WHOIS, argl );
			SILCPacket p = new SILCPacket( SILCPacketType.COMMAND, _conn.getLocalIdType(), _conn.getLocalId(), _conn.getRemoteIdType(), _conn.getRemoteId(), pl );
			_conn.putPacket( p );

			// wait for whois response
			SILCPacket pin = _conn.getPacket();
			System.out.println( pin.toString() );	// XXX temp
			assert( pin.getType() == SILCPacketType.COMMAND_REPLY ); // FIXME: shouldn't assert - we could get a failure or whatever
			SILCCommandPayload plin = (SILCCommandPayload)pin.getPayload();
			SILCArgumentPayload[] arglIn = plin.getArgList();
			Charset csUTF8 = Charset.forName( "UTF-8" );

			for( int i = 0; i < arglIn.length; i++ )
			{
				if( arglIn[i].getType() == 3 )
				{
					strRet = csUTF8.decode( ByteBuffer.wrap( arglIn[i].getData() ) ).toString();
				}
			}
		}
		catch( Exception e )
		{
			e.printStackTrace();
		}
		finally
		{*/
			return strRet;
		//}
	}

/*	private byte[] getClientId( String strName )
	{
		return new byte[0];	// TODO
	}*/
}

