/*
 *	SILCEntity.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import com.alistairphipps.jsilc.core.*;
import java.lang.String;
import java.util.Arrays;

/**
 * A SILC entity - server, client or channel
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public class SILCEntity implements Entity
{
	/** ID type (one of SILCIdType) */
	private byte _yIdType;
	/** ID */
	private byte[] _ylId;
	/** friendly name */
	String _strName;

	/** ctor to set up member variables
	 * @param yIdType Type of silc ID in Id parameter
	 * @param ylId Silc ID
	 * @param strName friendly name for this entity
	 */
	public SILCEntity( byte yIdType, byte[] ylId, String strName )
	{
		_yIdType = yIdType;
		_ylId = ylId;
		_strName = strName;
	}
	
	/** returns the ID type
	 * @return ID type
	 */
	public byte getIdType()
	{
		return _yIdType;
	}

	/** returns the ID
	 * @return ID
	 */
	public byte[] getId()
	{
		return _ylId;
	}
	
	/** returns the "friendly" name - such as nickname of user
	 * @return friendly name string
	 */
	public String getFriendlyName()
	{
		return _strName;
	}

	// doc inherited - need to override so hashmap works
	public boolean equals( Object o )
	{
		if( !( o instanceof SILCEntity ) )
			return false;
		if( o == null )	// covered by the above?
			return false;
		SILCEntity e = (SILCEntity)o;
		if( e._yIdType == _yIdType )
		{
			if( Arrays.equals( e._ylId, _ylId ) )
				return true;
		}
		return false;
	}

	// doc inherited - have to override this too so that if equals() is true, hashcodes are the same
	public int hashCode()
	{
		// this is a poor hashcode - but as long as it gives the same results for the same contents...
		int iRet;
		iRet = _yIdType << 15;
		// only care about the last 10 bytes
		int iNum = ( _ylId.length > 10 ) ? 10 : _ylId.length;
		for( int i = 0; i < iNum; i++ )
			iRet |= _ylId[i] << ( _ylId.length - i );
		return iRet;
	}
}
