/*
 *	SILCIdType.java		2002/11/08
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.silcprotocol;

import java.lang.String;

/** Defines different ID Types that can be sent/received.
 *
 * @author Alistair K Phipps
 * @version 20021108
 */
public class SILCIdType
{
	/** when no specific Id can be used */
	public static final byte NONE = 0;
	/** identifies a server */
	public static final byte SERVER = 1;
	/** identifies a client */
	public static final byte CLIENT = 2;
	/** identifies a channel */
	public static final byte CHANNEL = 3;
	
	public static String toString( byte y )
	{
		switch( y )
		{
		case NONE:
			return "None";
		case SERVER:
			return "Server";
		case CLIENT:
			return "Client";
		case CHANNEL:
			return "Channel";
		default:
			return "Unknown";
		}
	}
}

