/*

  silcbase64.h

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2007 - 2008 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.

  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/

/****h* silcutil/Base64 Interface
 *
 * DESCRIPTION
 *
 * This interface provides Base64 encoding and decoding routines.
 *
 ***/

#ifndef SILCBASE64_H
#define SILCBASE64_H

/****f* silcutil/silc_base64_encode
 *
 * SYNOPSIS
 *
 *    char *silc_base64_encode(SilcStack stack,
 *                             unsigned char *data, SilcUInt32 len);
 *
 * DESCRIPTION
 *
 *    Encodes data into Base 64 (PEM) encoding. Returns NULL terminated
 *    Base 64 encoded data string.  Returns NULL if system is out of memory.
 *
 *    If `stack' is non-NULL the returned buffer is allocated from `stack'.
 *
 ***/
char *silc_base64_encode(SilcStack stack, unsigned char *data, SilcUInt32 len);

/****f* silcutil/silc_base64_encode_file
 *
 * SYNOPSIS
 *
 *    char *silc_base64_encode_file(SilcStack stack,
 *                                  unsigned char *data, SilcUInt32 data_len);
 *
 * DESCRIPTION
 *
 *    Same as silc_base64_encode() but puts newline ('\n') every 72
 *    characters.  Returns NULL if system is out of memory.
 *
 *    If `stack' is non-NULL the returned buffer is allocated from `stack'.
 *
 ***/
char *silc_base64_encode_file(SilcStack stack,
			      unsigned char *data, SilcUInt32 data_len);

/****f* silcutil/silc_base_decode
 *
 * SYNOPSIS
 *
 *    unsigned char *silc_base_decode(SilcStack stack,
 *                                    unsigned char *base64,
 *                                    SilcUInt32 base64_len,
 *                                    SilcUInt32 *ret_len);
 *
 * DESCRIPTION
 *
 *    Decodes Base 64 (PEM) into data. Returns the decoded data.  Returns
 *    NULL if the data is not valid Base 64 encoded data.
 *
 *    If `stack' is non-NULL the returned buffer is allocated from `stack'.
 *
 ***/
unsigned char *silc_base64_decode(SilcStack stack,
				  unsigned char *base64,
				  SilcUInt32 base64_len,
				  SilcUInt32 *ret_len);

#endif /* SILCBASE64_H */
