/*

  silcdll.c

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2007 - 2008 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.

  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/

#include "silcruntime.h"

/* Load shared object */

SilcDll silc_dll_load(const char *object_path)
{
#ifdef SILC_UNIX
#if defined(HAVE_DLOPEN)
#if defined(RTLD_NOW)
  return dlopen(object_path, RTLD_NOW);
#elif defined(RTLD_LAZY)
  return dlopen(object_path, RTLD_LAZY);
#else
  return dlopen(object_path, 0);
#endif /* RTLD_NOW */
#endif /* HAVE_DLOPEN */
#elif SILC_WIN32
  return LoadLibrary(object_path);
#else
  /* XXX Symbian */
#endif /* SILC_UNIX */
  silc_set_errno_reason(SILC_ERR_NOT_SUPPORTED,
			"Shared objects are not supported on this platform");
  return NULL;
}

/* Close shared object */

void silc_dll_close(SilcDll dll)
{
#ifdef SILC_UNIX
#if defined(HAVE_DLOPEN)
  dlclose(dll);
#endif /* HAVE_DLOPEN */
#elif SILC_WIN32
  FreeLibrary(dll);
#else
  /* XXX Symbian */
#endif /* SILC_UNIX */
}

/* Get symbol address from shared object */

void *silc_dll_getsym(SilcDll dll, const char *symbol)
{
#ifdef SILC_UNIX
#if defined(HAVE_DLOPEN)
  return (void *)dlsym(dll, symbol);
#endif /* HAVE_DLOPEN */
#elif SILC_WIN32
  return (void *)GetProcAddress(dll, symbol);
#else
  /* XXX Symbian */
#endif /* SILC_UNIX */
  silc_set_errno_reason(SILC_ERR_NOT_SUPPORTED,
			"Shared objects are not supported on this platform");
  return NULL;
}

/* Get error string */

const char *silc_dll_error(SilcDll dll)
{
#ifdef SILC_UNIX
#if defined(HAVE_DLOPEN)
  return dlerror();
#endif /* HAVE_DLOPEN */
#elif SILC_WIN32
  return NULL;
#else
  /* XXX Symbian */
#endif /* SILC_UNIX */
  return NULL;
}
