/*

  silcenv.c

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2007 - 2008 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.

  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/

#include "silcruntime.h"

/* Set environment variable with value */

SilcBool silc_setenv(const char *variable, const char *value)
{
#if defined(HAVE_SETENV)
  return setenv(variable, value, TRUE) == 0;
#elif defined (HAVE_PUTENV)
  char tmp[1024];
  silc_snprintf(tmp, sizeof(tmp), "%s=%s", variable, value);
  return putenv(tmp) == 0;
#endif /* HAVE_SETENV */
  return FALSE;
}

/* Get environment variable value */

const char *silc_getenv(const char *variable)
{
#if defined(HAVE_GETENV)
  return (const char *)getenv(variable);
#endif /* HAVE_GETENV */
  return NULL;
}

/* Unset environment variable */

SilcBool silc_unsetenv(const char *variable)
{
#if defined(HAVE_UNSETENV)
  return unsetenv(variable) == 0;
#endif /* HAVE_GETENV */
  return FALSE;
}

/* Clear environment */

SilcBool silc_clearenv(void)
{
#if defined(HAVE_CLEARENV)
  return clearenv() == 0;
#endif /* HAVE_GETENV */
  return FALSE;
}
