/*

  silctimer_i.h

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 2007 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.

  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/

#ifndef SILCTIMER_I_H
#define SILCTIMER_I_H

#ifndef SILCTIMER_H
#error "Do not include this header directly"
#endif

/* Timer context */
struct SilcTimerObject {
  SilcUInt64 start_sec;		/* Start seconds */
  SilcUInt64 timer_sec;		/* Timer seconds */
  SilcUInt32 start_usec;	/* Start microseconds */
  SilcUInt32 timer_usec;	/* Timer microseconds */
  unsigned int running    : 1;	/* Set when timer is running */
  unsigned int sync_diff  : 15;	/* Synchronization delta */
  unsigned int sync_tdiff : 16;	/* Synchronization tick delta */
};

#endif /* SILCTIMER_I_H */
