/*
 * Cryptographic Functions Common Header
 *
 * Production Implementation, (c) 1999 Andreas Steinmetz
 *
 * License:
 * This code is in the 'public domain' (*) under the GNU public license
 * for use with the virtual private network daemon (vpnd).
 * The copyright holder will however retain the copyright.
 * In addition to vpnd this code is put in the 'public domain' (*)
 * for all GPL/LGPL based open source software products.
 * For all other software products please contact astmail@yahoo.com
 * for a license agreement. There is no guarantee for the fitness
 * and usability of this code for any purpose. The author takes no
 * responsibility for any damages caused by the use of this code.
 * Distribution and use of this code is explicitly granted provided
 * that the above header is not modified and the above conditions
 * are met.
 * (*) 'public domain' is used here in the sense of the Wassenaar treaty.
 *
 * This implementation is tuned for speed and should be 64 bit clean.
 *
 * Data sizes:
 *
 * WORD08 means an unsigned word of 8 bits length
 * WORD32 means an unsigned word of at least 32 bits length
 *
 */

/* get simple type sizes */

#include <limits.h>

/* assert that required definitions are not yet defined */

#ifdef WORD08
#undef WORD08
#endif

#ifdef WORD32
#undef WORD32
#endif

#ifdef BITS32
#undef BITS32
#endif

/* make sure unsigned char is 8 bits wide */

#if UCHAR_MAX == 0xff
#define WORD08 unsigned char
#else
#error No 8 bit value available
#endif

/* make sure that WORD32 is at least 32 bits wide,
   default the macro BITS32 to nothing if WORD32
   is exactly 32 bits wide */

#if USHRT_MAX == 0xffffffff
#define WORD32 unsigned short
#define BITS32(a) (a)
#elif ULONG_MAX == 0xffffffff
#define WORD32 unsigned long
#define BITS32(a) (a)
#elif USHRT_MAX > 0xffffffffUL
#define WORD32 unsigned short
#define BITS32(a) ((a)&0xffffffff)
#elif ULONG_MAX > 0xffffffffUL
#define WORD32 unsigned long
#define BITS32(a) ((a)&0xffffffff)
#else
#error No 32 bit value available
#endif

/* use defined calling conventions for WIN32 */

#ifdef WIN32
#define FASTCALL  __fastcall
#ifdef X86ASM
#define CRYPTOCALL __cdecl
#else
#define CRYPTOCALL __fastcall
#endif
#else
#define FASTCALL
#define CRYPTOCALL
#endif

/* assert that WIN32 inline assembler reserved words are not defined */

#ifdef WIN32
#ifdef BYTE
#undef BYTE
#endif
#ifdef WORD
#undef WORD
#endif
#ifdef DWORD
#undef DWORD
#endif
#ifdef PTR
#undef PTR
#endif
#endif
