/*
 * virtual private network daemon (vpnd)
 *
 * cryptographic stuff (c) 1999 Andreas Steinmetz, astmail@yahoo.com
 * other code (c) 1999 D.O.M. Datenverarbeitung GmbH, author Andreas Steinmetz
 *
 * License:
 * This code is in the public domain (*) under the GNU public license.
 * The copyright holders will however retain their copyright.
 * There is no guarantee for the fitness and usability of this code
 * for any purpose. The author and the copyright holders take no
 * responsibility for any damages caused by the use of this code.
 * Distribution and use of this code is explicitly granted provided
 * that the above header is not modified and the above conditions
 * are met.
 * (*) 'public domain' is used here in the sense of the Wassenaar treaty.
 */

#include "vpnd.h"

/*============================================================================*/
/* the inevitable: global variables                                           */
/*============================================================================*/

VPN globals;				/* temporary gobals home	*/
char *pidfile=NULL;			/* process id file		*/
WORD08 timeout=0;			/* sigalrm flag for script test	*/
WORD08 verbose=0;			/* verbose mode for script test	*/
WORD08 terminate=0;			/* termination request (signal)	*/
WORD08 dns=0;				/* dns lookup allowed flag	*/

#ifdef DEBUG
int debug=0;				/* debug level			*/
#endif

void (*mactab[4])(WORD08 *,WORD32,WORD08 *,void *)= /* mac procedures	*/
{
	checksum,
	(void (*)(WORD08 *,WORD32,WORD08 *,void *))(md5hmac),
	(void (*)(WORD08 *,WORD32,WORD08 *,void *))(sha1hmac),
	(void (*)(WORD08 *,WORD32,WORD08 *,void *))(rmd160hmac)
};

void (*macinit[4])(WORD08 *,WORD32,void *)=	/* mac key init procs	*/
{
	(void (*)(WORD08 *,WORD32,void *))(NULL),
	(void (*)(WORD08 *,WORD32,void *))(md5hmkey),
	(void (*)(WORD08 *,WORD32,void *))(sha1hmkey),
	(void (*)(WORD08 *,WORD32,void *))(rmd160hmkey)
};

WORD08 maclen[4]={2,16,20,20};		/* message auth length		*/

/*
 * initvars
 *
 * input: anchor - pointer to vpnd global data
 *
 * This procedure initializes vpnd global data.
 */

void initvars(VPN *anchor)
{
	static WORD08 dftiv[BLOWFISH_BLOCKSIZE]={1,2,3,4,5,6,7,8};


	memset(anchor,0,sizeof(VPN));
	anchor->pty=anchor->tty=anchor->peer=anchor->server=anchor->ping=
		anchor->serial=anchor->lock=-1;
	anchor->speed=B115200;
	anchor->conffile="/etc/vpnd.conf";
	anchor->randomdev="/dev/random";
	anchor->keyfile="/etc/vpnd.key";
	anchor->lkeyfile="vpnd.lcl.key";
	anchor->rkeyfile="vpnd.rmt.key";
	anchor->cipher=BLOWFISH;
	anchor->encrypt=blowfish_encrypt;
	memcpy(anchor->piv,dftiv,BLOWFISH_BLOCKSIZE);
}
