/*
 * virtual private network daemon (vpnd)
 *
 * cryptographic stuff (c) 1999 Andreas Steinmetz, astmail@yahoo.com
 * other code (c) 1999 D.O.M. Datenverarbeitung GmbH, author Andreas Steinmetz
 *
 * License:
 * This code is in the public domain (*) under the GNU public license.
 * The copyright holders will however retain their copyright.
 * There is no guarantee for the fitness and usability of this code
 * for any purpose. The author and the copyright holders take no
 * responsibility for any damages caused by the use of this code.
 * Distribution and use of this code is explicitly granted provided
 * that the above header is not modified and the above conditions
 * are met.
 * (*) 'public domain' is used here in the sense of the Wassenaar treaty.
 */

#include "vpnd.h"

/*============================================================================*/
/* events and friends: signal handling and setup                              */
/*============================================================================*/

/*
 * sigdie
 *
 * This procedure is a signal front end that calls die if a
 * termination signal is received.
 */

void sigdie(int sig)
{
	/* debug message */

	ENTER("sigdie");

	/* print info if not in modem chat test mode */

	if(!verbose)logmsg(SIGNAL,sig,NULL);

	/* signal termination request */

	terminate=1;

	/* debug message */

	LEAVE("sigdie");
}

/*
 * chatalarm
 *
 * This procedure is a signal front end that calls die if a
 * termination signal is received.
 */

void chatalarm(int sig)
{
	/* debug message */

	ENTER("chatalarm");

	/* print info */

	if(verbose)printf("command timed out\n");

	/* set timeout flag */

	timeout=1;

	/* debug message */

	LEAVE("chatalarm");
}

/*
 * setsig
 *
 * input: signal - the signal for which action is to be taken
 *	  action - the action to be taken for the signal
 *
 * This procedure sets up a signal handler for the
 * desired signal which is sequentialized and
 * multiple signal aware.
 */

void setsig(int signal,void (*action)(int))
{
	struct sigaction act;	/* signal setup structure */


	/* debug message */

	ENTER("setsig");

	/* preset signal setup structure */

	act.sa_handler=action;
	sigemptyset(&act.sa_mask);
	act.sa_flags=0;

	/* set signal handler */

	sigaction(signal,&act,NULL);

	/* debug message */

	LEAVE("setsig");
}

/*
 * blocksig
 *
 * input: signal - the signal which is to be blocked
 *
 * This procedure blocks a signal from delivery.
 */

void blocksig(int signal)
{
	sigset_t t;	/* signal setup structure */


	/* debug message */

	ENTER("blocksig");

	/* preset signal setup structure */

	sigemptyset(&t);
	sigaddset(&t,signal);

	/* block signal */

	sigprocmask(SIG_BLOCK,&t,NULL);

	/* debug message */

	LEAVE("blocksig");
}
