/* MD5 Production Implementation                                              */
/* This implementation: (c) 1999, 2005 Andreas Steinmetz                      */
/* MD5 algorithm by Ron Rivest, see RFC1321                                   */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2202                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact ast@domdv.de                */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation does not depend on any run time library.      */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the MD5 routines.                               */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for MD5 transformation    WORD08[64]                            */
/* resulting MD5 or HMAC hash           WORD08[16]                            */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* MD5_FULL defined:                                                          */
/*                                                                            */
/* 1. Call md5init                                                            */
/* 2. For all data to be hashed call md5next                                  */
/* 3. To retrieve the hash call md5end                                        */
/*                                                                            */
/* MD5_FAST defined:                                                          */
/*                                                                            */
/* Call md5 to get the hash for the specified data                            */
/*                                                                            */
/* MD5_HMAC_FULL defined:                                                     */
/*                                                                            */
/* 1. Call md5hmkey once to preprocess the selected key                       */
/* 2. Call md5hminit                                                          */
/* 3. For all data to be hashed call md5hmnext                                */
/* 4. To retrieve the hash call md5hmend                                      */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the MD5HMDATA structure                                           */
/*                                                                            */
/* MD5_HMAC_FAST defined:                                                     */
/*                                                                            */
/* 1. Call md5hmkey once to preprocess the selected key                       */
/* 2. Call md5hmac to get the hash for the specified data                     */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the MD5HMDATA structure                                           */

.text

.ifndef MD5_FULL
.ifndef MD5_FAST
.ifndef MD5_HMAC_FULL
.ifndef MD5_HMAC_FAST
		MD5_FULL=1
		MD5_FAST=1
		MD5_HMAC_FULL=1
		MD5_HMAC_FAST=1
		MD5_PARANOID=1
.endif
.endif
.endif
.endif

.ifdef	MD5_HMAC_FULL
		_MD5_HMAC=1
.endif
.ifdef	MD5_HMAC_FAST
		_MD5_HMAC=1
.endif
.ifdef	MD5_FULL
		_MD5_FULL=1
.endif
.ifdef	_MD5_HMAC
		_MD5_FULL=1
		MD5_PARANOID=1
.endif

/* static void md5block(WORD32 *md5,WORD08 *block) */

		.type	md5block,@function
		.align	16
md5block:
		movl	(%r8),%eax
		movl	4(%r8),%esi
		movl	8(%r8),%ecx
		movl	12(%r8),%edx

		movq	%rbx,%r11

		/* round 1 */

		movl	%edx,%ebx
		addl	(%rdi),%eax
		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		addl	4(%rdi),%edx
		leal	0xd76aa478(%ebx,%eax,),%eax
		movl	%ecx,%ebx
		roll	$7,%eax
		addl	%esi,%eax

		xorl	%esi,%ebx
		andl	%eax,%ebx
		xorl	%ecx,%ebx
		leal	0xe8c7b756(%ebx,%edx,),%edx
		addl	8(%rdi),%ecx
		roll	$12,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		xorl	%eax,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		leal	0x242070db(%ebx,%ecx,),%ecx
		addl	12(%rdi),%esi
		roll	$17,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%eax,%ebx
		leal	0xc1bdceee(%ebx,%esi,),%esi
		addl	16(%rdi),%eax
		roll	$22,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		leal	0xf57c0faf(%ebx,%eax,),%eax
		addl	20(%rdi),%edx
		roll	$7,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		xorl	%esi,%ebx
		andl	%eax,%ebx
		xorl	%ecx,%ebx
		leal	0x4787c62a(%ebx,%edx,),%edx
		addl	24(%rdi),%ecx
		roll	$12,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		xorl	%eax,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		leal	0xa8304613(%ebx,%ecx,),%ecx
		addl	28(%rdi),%esi
		roll	$17,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%eax,%ebx
		leal	0xfd469501(%ebx,%esi,),%esi
		addl	32(%rdi),%eax
		roll	$22,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		leal	0x698098d8(%ebx,%eax,),%eax
		addl	36(%rdi),%edx
		roll	$7,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		xorl	%esi,%ebx
		andl	%eax,%ebx
		xorl	%ecx,%ebx
		leal	0x8b44f7af(%ebx,%edx,),%edx
		addl	40(%rdi),%ecx
		roll	$12,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		xorl	%eax,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		leal	0xffff5bb1(%ebx,%ecx,),%ecx
		addl	44(%rdi),%esi
		roll	$17,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%eax,%ebx
		leal	0x895cd7be(%ebx,%esi,),%esi
		addl	48(%rdi),%eax
		roll	$22,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		xorl	%ecx,%ebx
		andl	%esi,%ebx
		xorl	%edx,%ebx
		leal	0x6b901122(%ebx,%eax,),%eax
		addl	52(%rdi),%edx
		roll	$7,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		xorl	%esi,%ebx
		andl	%eax,%ebx
		xorl	%ecx,%ebx
		leal	0xfd987193(%ebx,%edx,),%edx
		addl	56(%rdi),%ecx
		roll	$12,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		xorl	%eax,%ebx
		andl	%edx,%ebx
		xorl	%esi,%ebx
		leal	0xa679438e(%ebx,%ecx,),%ecx
		addl	60(%rdi),%esi
		roll	$17,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		xorl	%edx,%ebx
		andl	%ecx,%ebx
		xorl	%eax,%ebx
		leal	0x49b40821(%ebx,%esi,),%esi
		roll	$22,%esi
		movl	%ecx,%ebx
		addl	%ecx,%esi

		/* round 2 */

		addl	4(%rdi),%eax
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xf61e2562(%ebx,%eax,),%eax
		roll	$5,%eax
		movl	%esi,%ebx
		addl	%esi,%eax

		addl	24(%rdi),%edx
		xorl	%eax,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xc040b340(%ebx,%edx,),%edx
		roll	$9,%edx
		movl	%eax,%ebx
		addl	%eax,%edx

		addl	44(%rdi),%ecx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0x265e5a51(%ebx,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%ebx
		addl	%edx,%ecx

		addl	(%rdi),%esi
		xorl	%ecx,%ebx
		andl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0xe9b6c7aa(%ebx,%esi,),%esi
		roll	$20,%esi
		movl	%ecx,%ebx
		addl	%ecx,%esi

		addl	20(%rdi),%eax
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xd62f105d(%ebx,%eax,),%eax
		roll	$5,%eax
		movl	%esi,%ebx
		addl	%esi,%eax

		addl	40(%rdi),%edx
		xorl	%eax,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0x02441453(%ebx,%edx,),%edx
		roll	$9,%edx
		movl	%eax,%ebx
		addl	%eax,%edx

		addl	60(%rdi),%ecx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0xd8a1e681(%ebx,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%ebx
		addl	%edx,%ecx

		addl	16(%rdi),%esi
		xorl	%ecx,%ebx
		andl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0xe7d3fbc8(%ebx,%esi,),%esi
		roll	$20,%esi
		movl	%ecx,%ebx
		addl	%ecx,%esi

		addl	36(%rdi),%eax
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0x21e1cde6(%ebx,%eax,),%eax
		roll	$5,%eax
		movl	%esi,%ebx
		addl	%esi,%eax

		addl	56(%rdi),%edx
		xorl	%eax,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xc33707d6(%ebx,%edx,),%edx
		roll	$9,%edx
		movl	%eax,%ebx
		addl	%eax,%edx

		addl	12(%rdi),%ecx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0xf4d50d87(%ebx,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%ebx
		addl	%edx,%ecx

		addl	32(%rdi),%esi
		xorl	%ecx,%ebx
		andl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0x455a14ed(%ebx,%esi,),%esi
		roll	$20,%esi
		movl	%ecx,%ebx
		addl	%ecx,%esi

		addl	52(%rdi),%eax
		xorl	%esi,%ebx
		andl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xa9e3e905(%ebx,%eax,),%eax
		roll	$5,%eax
		movl	%esi,%ebx
		addl	%esi,%eax

		addl	8(%rdi),%edx
		xorl	%eax,%ebx
		andl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xfcefa3f8(%ebx,%edx,),%edx
		roll	$9,%edx
		movl	%eax,%ebx
		addl	%eax,%edx

		addl	28(%rdi),%ecx
		xorl	%edx,%ebx
		andl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0x676f02d9(%ebx,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%ebx
		addl	%edx,%ecx

		addl	48(%rdi),%esi
		xorl	%ecx,%ebx
		andl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0x8d2a4c8a(%ebx,%esi,),%esi
		roll	$20,%esi
		addl	%ecx,%esi
		movl	%edx,%ebx

		/* round 3 */

		xorl	%ecx,%ebx
		addl	20(%rdi),%eax
		xorl	%esi,%ebx
		leal	0xfffa3942(%ebx,%eax,),%eax
		roll	$4,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	32(%rdi),%edx
		xorl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0x8771f681(%ebx,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	44(%rdi),%ecx
		xorl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0x6d9d6122(%ebx,%ecx,),%ecx
		roll	$16,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	56(%rdi),%esi
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xfde5380c(%ebx,%esi,),%esi
		roll	$23,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	4(%rdi),%eax
		xorl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xa4beea44(%ebx,%eax,),%eax
		roll	$4,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	16(%rdi),%edx
		xorl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0x4bdecfa9(%ebx,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	28(%rdi),%ecx
		xorl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0xf6bb4b60(%ebx,%ecx,),%ecx
		roll	$16,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	40(%rdi),%esi
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xbebfbc70(%ebx,%esi,),%esi
		roll	$23,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	52(%rdi),%eax
		xorl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0x289b7ec6(%ebx,%eax,),%eax
		roll	$4,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	(%rdi),%edx
		xorl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0xeaa127fa(%ebx,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	12(%rdi),%ecx
		xorl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0xd4ef3085(%ebx,%ecx,),%ecx
		roll	$16,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	24(%rdi),%esi
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0x04881d05(%ebx,%esi,),%esi
		roll	$23,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	36(%rdi),%eax
		xorl	%ecx,%ebx
		xorl	%esi,%ebx
		leal	0xd9d4d039(%ebx,%eax,),%eax
		roll	$4,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	48(%rdi),%edx
		xorl	%esi,%ebx
		xorl	%eax,%ebx
		leal	0xe6db99e5(%ebx,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	60(%rdi),%ecx
		xorl	%eax,%ebx
		xorl	%edx,%ebx
		leal	0x1fa27cf8(%ebx,%ecx,),%ecx
		roll	$16,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	8(%rdi),%esi
		xorl	%edx,%ebx
		xorl	%ecx,%ebx
		leal	0xc4ac5665(%ebx,%esi,),%esi
		roll	$23,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		/* round 4 */

		addl	(%rdi),%eax
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		leal	0xf4292244(%ebx,%eax,),%eax
		roll	$6,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	28(%rdi),%edx
		notl	%ebx
		orl	%eax,%ebx
		xorl	%esi,%ebx
		leal	0x432aff97(%ebx,%edx,),%edx
		roll	$10,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	56(%rdi),%ecx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%eax,%ebx
		leal	0xab9423a7(%ebx,%ecx,),%ecx
		roll	$15,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	20(%rdi),%esi
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		leal	0xfc93a039(%ebx,%esi,),%esi
		roll	$21,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	48(%rdi),%eax
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		leal	0x655b59c3(%ebx,%eax,),%eax
		roll	$6,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	12(%rdi),%edx
		notl	%ebx
		orl	%eax,%ebx
		xorl	%esi,%ebx
		leal	0x8f0ccc92(%ebx,%edx,),%edx
		roll	$10,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	40(%rdi),%ecx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%eax,%ebx
		leal	0xffeff47d(%ebx,%ecx,),%ecx
		roll	$15,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	4(%rdi),%esi
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		leal	0x85845dd1(%ebx,%esi,),%esi
		roll	$21,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	32(%rdi),%eax
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		leal	0x6fa87e4f(%ebx,%eax,),%eax
		roll	$6,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	60(%rdi),%edx
		notl	%ebx
		orl	%eax,%ebx
		xorl	%esi,%ebx
		leal	0xfe2ce6e0(%ebx,%edx,),%edx
		roll	$10,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	24(%rdi),%ecx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%eax,%ebx
		leal	0xa3014314(%ebx,%ecx,),%ecx
		roll	$15,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	52(%rdi),%esi
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		leal	0x4e0811a1(%ebx,%esi,),%esi
		roll	$21,%esi
		movl	%edx,%ebx
		addl	%ecx,%esi

		addl	16(%rdi),%eax
		notl	%ebx
		orl	%esi,%ebx
		xorl	%ecx,%ebx
		leal	0xf7537e82(%ebx,%eax,),%eax
		roll	$6,%eax
		movl	%ecx,%ebx
		addl	%esi,%eax

		addl	%eax,(%r8)

		addl	44(%rdi),%edx
		notl	%ebx
		orl	%eax,%ebx
		xorl	%esi,%ebx
		leal	0xbd3af235(%ebx,%edx,),%edx
		roll	$10,%edx
		movl	%esi,%ebx
		addl	%eax,%edx

		addl	%edx,12(%r8)

		addl	8(%rdi),%ecx
		notl	%ebx
		orl	%edx,%ebx
		xorl	%eax,%ebx
		leal	0x2ad7d2bb(%ebx,%ecx,),%ecx
		roll	$15,%ecx
		movl	%eax,%ebx
		addl	%edx,%ecx

		addl	%ecx,8(%r8)

		addl	36(%rdi),%esi
		notl	%ebx
		orl	%ecx,%ebx
		xorl	%edx,%ebx
		leal	0xeb86d391(%ebx,%esi,),%esi
		roll	$21,%esi
		addl	%ecx,%esi

		movq	%r11,%rbx

		addl	%esi,4(%r8)

		ret

/* void md5init(MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5init
		.type	md5init,@function
		.align	16
md5init:
		movl	$0x67452301,(%rdi)
		movl	$0xefcdab89,4(%rdi)
		movl	$0x98badcfe,8(%rdi)
		movl	$0x10325476,12(%rdi)
		movl	$0,16(%rdi)
		movb	$0,84(%rdi)
		ret

.endif

/* void md5next(WORD08 *data,WORD32 length,MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5next
		.type	md5next,@function
		.align	16
md5next:
		movq	%rdi,%r9
		movq	%rdx,%r8
		movl	%esi,%r10d
		leaq	20(%rdx),%rdi

		addl	%esi,16(%r8)

		movzbq	84(%r8),%rcx
		testl	%esi,%esi
		je	md5nxtloop1end
		testq	%rcx,%rcx
		je	md5nxtloop1end
md5nextloop1:	movb	(%r9),%al
		incq	%r9
		movb	%al,(%rdi,%rcx,)
		incq	%rcx
		cmpq	$64,%rcx
		je	md5nextcont1
		decl	%r10d
		jne	md5nextloop1
		jmp	md5nxtloop1end
md5nextcont1:	call	md5block
		xorq	%rcx,%rcx
		decl	%r10d

md5nxtloop1end:	movq	%r9,%rdi
		movq	%rcx,%r9
		cmpl	$64,%r10d
		jnae	md5nxtloop2end

md5nextloop2:	call	md5block
		subl	$64,%r10d
		addq	$64,%rdi
		cmpl	$64,%r10d
		jnb	md5nextloop2

md5nxtloop2end:	movl	%r10d,%edx
		shrl	$2,%r10d
		je	md5nxtloop3end

md5nextloop3:	movl	(%rdi),%eax
		addq	$4,%rdi
		movl	%eax,20(%r8,%r9,)
		addq	$4,%r9
		decl	%r10d
		jne	md5nextloop3

md5nxtloop3end:	andl	$3,%edx
		je	md5nextend

md5nextloop4:	movb	(%rdi),%al
		incq	%rdi
		movb	%al,20(%r8,%r9,)
		incq	%r9
		decl	%edx
		jne	md5nextloop4

md5nextend:	movb	%r9b,84(%r8)
		ret

.endif

/* void md5end(WORD08 *result,MD5DATA *ptr) */

.ifdef _MD5_FULL

.globl md5end
		.type	md5end,@function
		.align	16
md5end:
		movq	%rdi,%r9
		movq	%rsi,%r8
		leaq	20(%rsi),%rdi

		movzbq	84(%r8),%r10
		incq	%r10
		movq	%r10,%rax
		movb	$128,-1(%rdi,%r10,)
		andl	$3,%eax
		je	md5endlp1aend

md5endloop1a:	movb	$0,(%rdi,%r10,)
		incl	%eax
		incq	%r10
		cmpl	$4,%eax
		jne	md5endloop1a

md5endlp1aend:	shrq	$2,%r10
		jmp	md5endlp1bbeg

md5endloop1b:	movl	$0,(%rdi,%r10,4)
		incq	%r10

md5endlp1bbeg:	cmpq	$14,%r10
		je	md5endloop1end
		cmpq	$16,%r10
		jne	md5endloop1b
		xorq	%r10,%r10
		call	md5block
		jmp	md5endloop1b

md5endloop1end:	movl	16(%r8),%edx
		shlq	$3,%rdx
		movq	%rdx,76(%r8)
		call	md5block

		movq	(%r8),%rcx
		movq	8(%r8),%rdx
		movq	%rcx,(%r9)
		movq	%rdx,8(%r9)

.ifdef MD5_PARANOID
		xorq	%rax,%rax
		movq	%rax,20(%r8)
		movq	%rax,28(%r8)
		movq	%rax,36(%r8)
		movq	%rax,44(%r8)
		movq	%rax,52(%r8)
		movq	%rax,60(%r8)
		movq	%rax,68(%r8)
		movq	%rax,76(%r8)
.endif
		ret

.endif

/* void md5(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef MD5_FAST

.globl md5
		.type	md5,@function
		.align	16
md5:
		subq	$80,%rsp

		movl	%esi,%r10d
		movq	%rsp,%r8
		movl	$0x67452301,(%rsp)
		movl	$0xefcdab89,4(%rsp)
		movl	$0x98badcfe,8(%rsp)
		movl	$0x10325476,12(%rsp)

		pushq	%rsi
		movq	%rdx,%r9
		cmpl	$64,%r10d
		jnae	md5loop2end

md5loop2:	call	md5block
		subl	$64,%r10d
		addq	$64,%rdi
		cmpl	$64,%r10d
		jnb	md5loop2

md5loop2end:	movl	%r10d,%ecx
		movl	%r10d,%esi
		movq	%rdi,%rdx
		xorq	%r10,%r10
		leaq	24(%rsp),%rdi
		shrl	$2,%ecx
		je	md5loop3bbeg

md5loop3a:	movl	(%rdx,%r10,4),%eax
		movl	%eax,(%rdi,%r10,4)
		incq	%r10
		decl	%ecx
		jne	md5loop3a
		leaq	(,%r10,4),%r10

md5loop3bbeg:	andl	$3,%esi
		je	md5loop3end

md5loop3b:	movb	(%rdx,%r10,),%al
		movb	%al,(%rdi,%r10,)
		incq	%r10
		decl	%esi
		jne	md5loop3b

md5loop3end:	incq	%r10
		movq	%r10,%rax
		movb	$128,-1(%rdi,%r10,)
		andq	$3,%rax
		je	md5loop4aend

md5loop4a:	movb	$0,(%rdi,%r10,)
		incl	%eax
		incq	%r10
		cmpl	$4,%eax
		jne	md5loop4a

md5loop4aend:	shrq	$2,%r10
		jmp	md5loop4bbeg

md5loop4b:	movl	$0,(%rdi,%r10,4)
		incq	%r10

md5loop4bbeg:	cmpq	$14,%r10
		je	md5loop4end
		cmpq	$16,%r10
		jne	md5loop4b
		xorq	%r10,%r10
		call	md5block
		jmp	md5loop4b

md5loop4end:	popq	%rdx
		shlq	$3,%rdx
		movq	%rdx,56(%rdi)
		call	md5block

		movq	(%rsp),%rax
		movq	8(%rsp),%rcx
		movq	%rax,(%r9)
		movq	%rcx,8(%r9)

.ifdef MD5_PARANOID

		xorq	%rax,%rax
		movq	%rax,(%rdi)
		movq	%rax,8(%rdi)
		movq	%rax,16(%rdi)
		movq	%rax,24(%rdi)
		movq	%rax,32(%rdi)
		movq	%rax,40(%rdi)
		movq	%rax,48(%rdi)
		movq	%rax,56(%rdi)

.endif
		addq	$80,%rsp
		ret

.endif

/* void md5hmkey(WORD08 *key,WORD32 keylength,MD5HMDATA *ptr) */

.ifdef	_MD5_HMAC

.globl md5hmkey
		.type	md5hmkey,@function
		.align	16
md5hmkey:
		pushq	%r12
		pushq	%r13

		movq	%rdi,%r12
		movq	%rdx,%r13
		movq	%rsi,%r9
		subq	$104,%rsp

		cmpl	$65,%esi
		jnae	md5hmkey1

		movq	%rsp,%rdi
		call	md5init
		movq	%r12,%rdi
		movq	%rsp,%rdx
		call	md5next
		leaq	88(%rsp),%rdi
		movq	%rsp,%rsi
		movq	%rdi,%r12
		call	md5end
		xorq	%rax,%rax
		movq	$16,%r9
		movq	%rax,(%rsp)
		movq	%rax,8(%rsp)

md5hmkey1:	movl	$0x67452301,(%r13)
		movl	$0xefcdab89,4(%r13)
		movl	$0x98badcfe,8(%r13)
		movl	$0x10325476,12(%r13)
		movl	$0x67452301,16(%r13)
		movl	$0xefcdab89,20(%r13)
		movl	$0x98badcfe,24(%r13)
		movl	$0x10325476,28(%r13)

		movq	%rsp,%rdi
		xorq	%rcx,%rcx
		movb	$54,%dl
		jmp	md5hmkey2
md5hmkeyloop3:	movb	(%r12,%rcx,),%al
		xorb	%dl,%al
		movb	%al,(%rsp,%rcx,)
		incq	%rcx
md5hmkey2:	cmpl	%ecx,%r9d
		jne	md5hmkeyloop3

		jmp	md5hmkey3
md5hmkeyloop4:	movb	%dl,(%rsp,%rcx,)
		incq	%rcx
md5hmkey3:	cmpq	$64,%rcx
		jne	md5hmkeyloop4

		movq	%r13,%r8
		call	md5block

		xorq	%rcx,%rcx
		movb	$92,%dl
		jmp	md5hmkey4
md5hmkeyloop5:	movb	(%r12,%rcx,),%al
		xorb	%dl,%al
		movb	%al,(%rsp,%rcx,)
		incq	%rcx
md5hmkey4:	cmpl	%ecx,%r9d
		jne	md5hmkeyloop5

		jmp	md5hmkey5
md5hmkeyloop6:	movb	%dl,(%rsp,%rcx,)
		incq	%rcx
md5hmkey5:	cmpq	$64,%rcx
		jne	md5hmkeyloop6

		addq	$16,%r8
		call	md5block

		movq	$16,%rdx
		xorl	%eax,%eax
md5hmkeyloop7:	decl	%edx
		movl	%eax,(%rsp,%rdx,4)
		movb	%al,88(%rsp,%rdx,)
		jne	md5hmkeyloop7

		addq	$104,%rsp
		popq	%r13
		popq	%r12
		ret

.endif

/* void md5hminit(MD5DATA *ptr,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FULL

.globl md5hminit
		.type	md5hminit,@function
		.align	16
md5hminit:
		movq	(%rsi),%rax
		movq	%rax,(%rdi)
		movq	8(%rsi),%rax
		movq	%rax,8(%rdi)
		movl	$64,16(%rdi)
		movb	$0,84(%rdi)
		ret

.endif

/* void md5hmend(WORD08 *result,MD5DATA *ptr,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FULL

.globl md5hmend
		.type	md5hmend,@function
		.align	16
md5hmend:
		pushq	%r12
		movq	%rdx,%r12
		call	md5end

		movb	$0,84(%r8)
		movq	16(%r12),%rax
		movq	24(%r12),%rdx
		movq	%rax,(%r8)
		movq	%rdx,8(%r8)
		movl	$64,16(%r8)

		movq	%r8,%rdx
		movq	$16,%rsi
		movq	%r9,%rdi
		movq	%r9,%r12
		call	md5next

		movq	%r12,%rdi
		movq	%r8,%rsi
		call	md5end

		popq	%r12
		ret

.endif

/* void md5hmac(WORD08 *data,WORD32 length,WORD08 *result,MD5HMDATA *key) */

.ifdef	MD5_HMAC_FAST

.globl md5hmac
		.type	md5hmac,@function
		.align	16
md5hmac:
		pushq	%r12
		pushq	%r13
		movq	%rdx,%r12
		movq	%rcx,%r13
		subq	$88,%rsp

		movb	$0,84(%rsp)

		movq	(%rcx),%rax
		movq	8(%rcx),%rdx
		movq	%rax,(%rsp)
		movq	%rdx,8(%rsp)

		movl	$64,16(%rsp)

		movq	%rsp,%rdx
		call	md5next

		movq	%r12,%rdi
		movq	%rsp,%rsi
		call	md5end

		movb	$0,84(%rsp)

		movq	16(%r13),%rax
		movq	24(%r13),%rdx
		movq	%rax,(%rsp)
		movq	%rdx,8(%rsp)

		movl	$64,16(%rsp)

		movq	%r12,%rdi
		movq	$16,%rsi
		movq	%rsp,%rdx
		call	md5next

		movq	%r12,%rdi
		movq	%rsp,%rsi
		call	md5end

		addq	$88,%rsp
		popq	%r13
		popq	%r12
		ret

.endif
