/* SHA1 Production Implementation                                             */
/* This implementation: (c) 1999, 2005 Andreas Steinmetz                      */
/* SHA1 algorithm: see FIPS PUB 180-1                                         */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2202                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact ast@domdv.de                */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation does not depend on any run time library.      */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the SHA1 routines.                              */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for SHA1 transformation   WORD08[64]                            */
/* resulting SHA1 or HMAC hash          WORD08[20]                            */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* SHA1_FULL defined:                                                         */
/*                                                                            */
/* 1. Call sha1init                                                           */
/* 2. For all data to be hashed call sha1next                                 */
/* 3. To retrieve the hash call sha1end                                       */
/*                                                                            */
/* SHA1_FAST defined:                                                         */
/*                                                                            */
/* Call sha1 to get the hash for the specified data                           */
/*                                                                            */
/* SHA1_HMAC_FULL defined:                                                    */
/*                                                                            */
/* 1. Call sha1hmkey once to preprocess the selected key                      */
/* 2. Call sha1hminit                                                         */
/* 3. For all data to be hashed call sha1hmnext                               */
/* 4. To retrieve the hash call sha1hmend                                     */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the SHA1HMDATA structure                                          */
/*                                                                            */
/* SHA1_HMAC_FAST defined:                                                    */
/*                                                                            */
/* 1. Call sha1hmkey once to preprocess the selected key                      */
/* 2. Call sha1hmac to get the hash for the specified data                    */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the SHA1HMDATA structure                                          */

.text

.ifndef SHA1_FULL
.ifndef SHA1_FAST
.ifndef SHA1_HMAC_FULL
.ifndef SHA1_HMAC_FAST
		SHA1_FULL=1
		SHA1_FAST=1
		SHA1_HMAC_FULL=1
		SHA1_HMAC_FAST=1
		SHA1_PARANOID=1
.endif
.endif
.endif
.endif

.ifdef  SHA1_HMAC_FULL
                _SHA1_HMAC=1
.endif
.ifdef  SHA1_HMAC_FAST
                _SHA1_HMAC=1
.endif
.ifdef  SHA1_FULL
                _SHA1_FULL=1
.endif
.ifdef  _SHA1_HMAC
                _SHA1_FULL=1
                SHA1_PARANOID=1
.endif

/* static void sha1block(WORD32 *sha1,WORD08 *block) */

		.type	sha1block,@function
		.align	16
sha1block:
		movq	%rbx,%r11
		movq	%rbp,%r10

		/* load block to be hashed */

		subq	$64,%rsp
		movq	(%rdi),%rax
		movq	8(%rdi),%rbx
		movq	16(%rdi),%rcx
		movq	24(%rdi),%rdx
		bswapq	%rax
		bswapq	%rbx
		bswapq	%rcx
		bswapq	%rdx
		rolq	$32,%rax
		rolq	$32,%rbx
		rolq	$32,%rcx
		rolq	$32,%rdx
		movq	%rax,(%rsp)
		movq	%rbx,8(%rsp)
		movq	%rcx,16(%rsp)
		movq	%rdx,24(%rsp)

		movq	32(%rdi),%rax
		movq	40(%rdi),%rbx
		movq	48(%rdi),%rcx
		movq	56(%rdi),%rdx
		bswapq	%rax
		bswapq	%rbx
		bswapq	%rcx
		bswapq	%rdx
		rolq	$32,%rax
		rolq	$32,%rbx
		rolq	$32,%rcx
		rolq	$32,%rdx
		movq	%rax,32(%rsp)
		movq	%rbx,40(%rsp)
		movq	%rcx,48(%rsp)
		movq	%rdx,56(%rsp)

		/* load old hash */

		movl	(%r8),%ecx
		movl	4(%r8),%esi
		movl	8(%r8),%eax
		movl	12(%r8),%edi
		movl	16(%r8),%edx

		/* round 1 to 20 */

		movl	%ecx,%ebp
		movl	%eax,%ebx
		roll	$5,%ebp
		xorl	%edi,%ebx
		leal	0x5a827999(%ebp,%edx,),%edx
		andl	%esi,%ebx
		addl	(%rsp),%edx
		xorl	%edi,%ebx
		rorl	$2,%esi
		addl	%ebx,%edx

		movl	%edx,%ebp
		movl	%esi,%ebx
		roll	$5,%ebp
		xorl	%eax,%ebx
		leal	0x5a827999(%ebp,%edi,),%edi
		andl	%ecx,%ebx
		addl	4(%rsp),%edi
		xorl	%eax,%ebx
		rorl	$2,%ecx
		addl	%ebx,%edi

		movl	%edi,%ebp
		movl	%ecx,%ebx
		roll	$5,%ebp
		xorl	%esi,%ebx
		leal	0x5a827999(%ebp,%eax,),%eax
		andl	%edx,%ebx
		addl	8(%rsp),%eax
		xorl	%esi,%ebx
		rorl	$2,%edx
		addl	%ebx,%eax

		movl	%eax,%ebp
		movl	%edx,%ebx
		roll	$5,%ebp
		xorl	%ecx,%ebx
		leal	0x5a827999(%ebp,%esi,),%esi
		andl	%edi,%ebx
		addl	12(%rsp),%esi
		xorl	%ecx,%ebx
		rorl	$2,%edi
		addl	%ebx,%esi

		movl	%esi,%ebp
		movl	%edi,%ebx
		roll	$5,%ebp
		xorl	%edx,%ebx
		leal	0x5a827999(%ebp,%ecx,),%ecx
		andl	%eax,%ebx
		addl	16(%rsp),%ecx
		xorl	%edx,%ebx
		rorl	$2,%eax
		addl	%ebx,%ecx

		movl	%ecx,%ebp
		movl	%eax,%ebx
		roll	$5,%ebp
		xorl	%edi,%ebx
		leal	0x5a827999(%ebp,%edx,),%edx
		andl	%esi,%ebx
		addl	20(%rsp),%edx
		xorl	%edi,%ebx
		rorl	$2,%esi
		addl	%ebx,%edx

		movl	%edx,%ebp
		movl	%esi,%ebx
		roll	$5,%ebp
		xorl	%eax,%ebx
		leal	0x5a827999(%ebp,%edi,),%edi
		andl	%ecx,%ebx
		addl	24(%rsp),%edi
		xorl	%eax,%ebx
		rorl	$2,%ecx
		addl	%ebx,%edi

		movl	%edi,%ebp
		movl	%ecx,%ebx
		roll	$5,%ebp
		xorl	%esi,%ebx
		leal	0x5a827999(%ebp,%eax,),%eax
		andl	%edx,%ebx
		addl	28(%rsp),%eax
		xorl	%esi,%ebx
		rorl	$2,%edx
		addl	%ebx,%eax

		movl	%eax,%ebp
		movl	%edx,%ebx
		roll	$5,%ebp
		xorl	%ecx,%ebx
		leal	0x5a827999(%ebp,%esi,),%esi
		andl	%edi,%ebx
		addl	32(%rsp),%esi
		xorl	%ecx,%ebx
		rorl	$2,%edi
		addl	%ebx,%esi

		movl	%esi,%ebp
		movl	%edi,%ebx
		roll	$5,%ebp
		xorl	%edx,%ebx
		leal	0x5a827999(%ebp,%ecx,),%ecx
		andl	%eax,%ebx
		addl	36(%rsp),%ecx
		xorl	%edx,%ebx
		rorl	$2,%eax
		addl	%ebx,%ecx

		movl	%ecx,%ebp
		movl	%eax,%ebx
		roll	$5,%ebp
		xorl	%edi,%ebx
		leal	0x5a827999(%ebp,%edx,),%edx
		andl	%esi,%ebx
		addl	40(%rsp),%edx
		xorl	%edi,%ebx
		rorl	$2,%esi
		addl	%ebx,%edx

		movl	%edx,%ebp
		movl	%esi,%ebx
		roll	$5,%ebp
		xorl	%eax,%ebx
		leal	0x5a827999(%ebp,%edi,),%edi
		andl	%ecx,%ebx
		addl	44(%rsp),%edi
		xorl	%eax,%ebx
		rorl	$2,%ecx
		addl	%ebx,%edi

		movl	%edi,%ebp
		movl	%ecx,%ebx
		roll	$5,%ebp
		xorl	%esi,%ebx
		leal	0x5a827999(%ebp,%eax,),%eax
		andl	%edx,%ebx
		addl	48(%rsp),%eax
		xorl	%esi,%ebx
		rorl	$2,%edx
		addl	%ebx,%eax

		movl	%eax,%ebp
		movl	%edx,%ebx
		roll	$5,%ebp
		xorl	%ecx,%ebx
		leal	0x5a827999(%ebp,%esi,),%esi
		andl	%edi,%ebx
		addl	52(%rsp),%esi
		xorl	%ecx,%ebx
		rorl	$2,%edi
		addl	%ebx,%esi

		movl	%esi,%ebp
		movl	%edi,%ebx
		roll	$5,%ebp
		xorl	%edx,%ebx
		leal	0x5a827999(%ebp,%ecx,),%ecx
		andl	%eax,%ebx
		addl	56(%rsp),%ecx
		xorl	%edx,%ebx
		rorl	$2,%eax
		addl	%ebx,%ecx

		movl	%ecx,%ebp
		movl	%eax,%ebx
		roll	$5,%ebp
		xorl	%edi,%ebx
		leal	0x5a827999(%ebp,%edx,),%edx
		andl	%esi,%ebx
		addl	60(%rsp),%edx
		xorl	%edi,%ebx
		rorl	$2,%esi
		addl	%ebx,%edx

		movl	%edx,%ebx
		movl	52(%rsp),%ebp
		roll	$5,%ebx
		xorl	32(%rsp),%ebp
		leal	0x5a827999(%ebx,%edi,),%edi
		movl	%esi,%ebx
		xorl	8(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	(%rsp),%ebp
		andl	%ecx,%ebx
		roll	$1,%ebp
		xorl	%eax,%ebx
		addl	%ebp,%edi
		movl	%ebp,(%rsp)
		rorl	$2,%ecx
		addl	%ebx,%edi

		movl	%edi,%ebx
		movl	56(%rsp),%ebp
		roll	$5,%ebx
		xorl	36(%rsp),%ebp
		leal	0x5a827999(%ebx,%eax,),%eax
		movl	%ecx,%ebx
		xorl	12(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	4(%rsp),%ebp
		andl	%edx,%ebx
		roll	$1,%ebp
		xorl	%esi,%ebx
		addl	%ebp,%eax
		movl	%ebp,4(%rsp)
		rorl	$2,%edx
		addl	%ebx,%eax

		movl	%eax,%ebx
		movl	60(%rsp),%ebp
		roll	$5,%ebx
		xorl	40(%rsp),%ebp
		leal	0x5a827999(%ebx,%esi,),%esi
		movl	%edx,%ebx
		xorl	16(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	8(%rsp),%ebp
		andl	%edi,%ebx
		roll	$1,%ebp
		xorl	%ecx,%ebx
		addl	%ebp,%esi
		movl	%ebp,8(%rsp)
		rorl	$2,%edi
		addl	%ebx,%esi

		movl	%esi,%ebx
		movl	(%rsp),%ebp
		roll	$5,%ebx
		xorl	44(%rsp),%ebp
		leal	0x5a827999(%ebx,%ecx,),%ecx
		movl	%edi,%ebx
		xorl	20(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	12(%rsp),%ebp
		andl	%eax,%ebx
		roll	$1,%ebp
		xorl	%edx,%ebx
		addl	%ebp,%ecx
		movl	%ebp,12(%rsp)
		rorl	$2,%eax
		addl	%ebx,%ecx

		/* round 21 to 40 */

		movl	%ecx,%ebx
		movl	4(%rsp),%ebp
		roll	$5,%ebx
		xorl	48(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	24(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	16(%rsp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,16(%rsp)

		movl	%edx,%ebx
		movl	8(%rsp),%ebp
		roll	$5,%ebx
		xorl	52(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	28(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	20(%rsp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,20(%rsp)

		movl	%edi,%ebx
		movl	12(%rsp),%ebp
		roll	$5,%ebx
		xorl	56(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	32(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	24(%rsp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,24(%rsp)

		movl	%eax,%ebx
		movl	16(%rsp),%ebp
		roll	$5,%ebx
		xorl	60(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	36(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	28(%rsp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,28(%rsp)

		movl	%esi,%ebx
		movl	20(%rsp),%ebp
		roll	$5,%ebx
		xorl	(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	40(%rsp),%ebp
		xorl	%edi,%ebx
		xorl	32(%rsp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,32(%rsp)

		movl	%ecx,%ebx
		movl	24(%rsp),%ebp
		roll	$5,%ebx
		xorl	4(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	44(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	36(%rsp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,36(%rsp)

		movl	%edx,%ebx
		movl	28(%rsp),%ebp
		roll	$5,%ebx
		xorl	8(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	48(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	40(%rsp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,40(%rsp)

		movl	%edi,%ebx
		movl	32(%rsp),%ebp
		roll	$5,%ebx
		xorl	12(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	52(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	44(%rsp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,44(%rsp)

		movl	%eax,%ebx
		movl	36(%rsp),%ebp
		roll	$5,%ebx
		xorl	16(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	56(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	48(%rsp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,48(%rsp)

		movl	%esi,%ebx
		movl	40(%rsp),%ebp
		roll	$5,%ebx
		xorl	20(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	60(%rsp),%ebp
		xorl	%edi,%ebx
		xorl	52(%rsp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,52(%rsp)

		movl	%ecx,%ebx
		movl	44(%rsp),%ebp
		roll	$5,%ebx
		xorl	24(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	56(%rsp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,56(%rsp)

		movl	%edx,%ebx
		movl	48(%rsp),%ebp
		roll	$5,%ebx
		xorl	28(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	4(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	60(%rsp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,60(%rsp)

		movl	%edi,%ebx
		movl	52(%rsp),%ebp
		roll	$5,%ebx
		xorl	32(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	8(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	(%rsp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,(%rsp)

		movl	%eax,%ebx
		movl	56(%rsp),%ebp
		roll	$5,%ebx
		xorl	36(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	12(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	4(%rsp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,4(%rsp)

		movl	%esi,%ebx
		movl	60(%rsp),%ebp
		roll	$5,%ebx
		xorl	40(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	16(%rsp),%ebp
		xorl	%edi,%ebx
		xorl	8(%rsp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,8(%rsp)

		movl	%ecx,%ebx
		movl	(%rsp),%ebp
		roll	$5,%ebx
		xorl	44(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	20(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	12(%rsp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,12(%rsp)

		movl	%edx,%ebx
		movl	4(%rsp),%ebp
		roll	$5,%ebx
		xorl	48(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	24(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	16(%rsp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,16(%rsp)

		movl	%edi,%ebx
		movl	8(%rsp),%ebp
		roll	$5,%ebx
		xorl	52(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	28(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	20(%rsp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,20(%rsp)

		movl	%eax,%ebx
		movl	12(%rsp),%ebp
		roll	$5,%ebx
		xorl	56(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	32(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	24(%rsp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,24(%rsp)

		movl	%esi,%ebx
		movl	16(%rsp),%ebp
		roll	$5,%ebx
		xorl	60(%rsp),%ebp
		leal	0x6ed9eba1(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	36(%rsp),%ebp
		xorl	%edi,%ebx
		xorl	28(%rsp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,28(%rsp)

		/* round 41 to 60 */

		movl	%ecx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edx,),%edx
		movl	%esi,%ebx
		movl	%esi,%ebp
		orl	%eax,%ebx
		andl	%eax,%ebp
		andl	%edi,%ebx
		orl	%ebp,%ebx
		movl	20(%rsp),%ebp
		addl	%ebx,%edx
		xorl	(%rsp),%ebp
		xorl	40(%rsp),%ebp
		rorl	$2,%esi
		xorl	32(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edx
		movl	%ebp,32(%rsp)

		movl	%edx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		movl	%ecx,%ebp
		orl	%esi,%ebx
		andl	%esi,%ebp
		andl	%eax,%ebx
		orl	%ebp,%ebx
		movl	24(%rsp),%ebp
		addl	%ebx,%edi
		xorl	4(%rsp),%ebp
		xorl	44(%rsp),%ebp
		rorl	$2,%ecx
		xorl	36(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edi
		movl	%ebp,36(%rsp)

		movl	%edi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%eax,),%eax
		movl	%edx,%ebx
		movl	%edx,%ebp
		orl	%ecx,%ebx
		andl	%ecx,%ebp
		andl	%esi,%ebx
		orl	%ebp,%ebx
		movl	28(%rsp),%ebp
		addl	%ebx,%eax
		xorl	8(%rsp),%ebp
		xorl	48(%rsp),%ebp
		rorl	$2,%edx
		xorl	40(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%eax
		movl	%ebp,40(%rsp)

		movl	%eax,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%esi,),%esi
		movl	%edi,%ebx
		movl	%edi,%ebp
		orl	%edx,%ebx
		andl	%edx,%ebp
		andl	%ecx,%ebx
		orl	%ebp,%ebx
		movl	32(%rsp),%ebp
		addl	%ebx,%esi
		xorl	12(%rsp),%ebp
		xorl	52(%rsp),%ebp
		rorl	$2,%edi
		xorl	44(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%esi
		movl	%ebp,44(%rsp)

		movl	%esi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		movl	%eax,%ebp
		orl	%edi,%ebx
		andl	%edi,%ebp
		andl	%edx,%ebx
		orl	%ebp,%ebx
		movl	36(%rsp),%ebp
		addl	%ebx,%ecx
		xorl	16(%rsp),%ebp
		xorl	56(%rsp),%ebp
		rorl	$2,%eax
		xorl	48(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%ecx
		movl	%ebp,48(%rsp)

		movl	%ecx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edx,),%edx
		movl	%esi,%ebx
		movl	%esi,%ebp
		orl	%eax,%ebx
		andl	%eax,%ebp
		andl	%edi,%ebx
		orl	%ebp,%ebx
		movl	40(%rsp),%ebp
		addl	%ebx,%edx
		xorl	20(%rsp),%ebp
		xorl	60(%rsp),%ebp
		rorl	$2,%esi
		xorl	52(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edx
		movl	%ebp,52(%rsp)

		movl	%edx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		movl	%ecx,%ebp
		orl	%esi,%ebx
		andl	%esi,%ebp
		andl	%eax,%ebx
		orl	%ebp,%ebx
		movl	44(%rsp),%ebp
		addl	%ebx,%edi
		xorl	24(%rsp),%ebp
		xorl	(%rsp),%ebp
		rorl	$2,%ecx
		xorl	56(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edi
		movl	%ebp,56(%rsp)

		movl	%edi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%eax,),%eax
		movl	%edx,%ebx
		movl	%edx,%ebp
		orl	%ecx,%ebx
		andl	%ecx,%ebp
		andl	%esi,%ebx
		orl	%ebp,%ebx
		movl	48(%rsp),%ebp
		addl	%ebx,%eax
		xorl	28(%rsp),%ebp
		xorl	4(%rsp),%ebp
		rorl	$2,%edx
		xorl	60(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%eax
		movl	%ebp,60(%rsp)

		movl	%eax,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%esi,),%esi
		movl	%edi,%ebx
		movl	%edi,%ebp
		orl	%edx,%ebx
		andl	%edx,%ebp
		andl	%ecx,%ebx
		orl	%ebp,%ebx
		movl	52(%rsp),%ebp
		addl	%ebx,%esi
		xorl	32(%rsp),%ebp
		xorl	8(%rsp),%ebp
		rorl	$2,%edi
		xorl	(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%esi
		movl	%ebp,(%rsp)

		movl	%esi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		movl	%eax,%ebp
		orl	%edi,%ebx
		andl	%edi,%ebp
		andl	%edx,%ebx
		orl	%ebp,%ebx
		movl	56(%rsp),%ebp
		addl	%ebx,%ecx
		xorl	36(%rsp),%ebp
		xorl	12(%rsp),%ebp
		rorl	$2,%eax
		xorl	4(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%ecx
		movl	%ebp,4(%rsp)

		movl	%ecx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edx,),%edx
		movl	%esi,%ebx
		movl	%esi,%ebp
		orl	%eax,%ebx
		andl	%eax,%ebp
		andl	%edi,%ebx
		orl	%ebp,%ebx
		movl	60(%rsp),%ebp
		addl	%ebx,%edx
		xorl	40(%rsp),%ebp
		xorl	16(%rsp),%ebp
		rorl	$2,%esi
		xorl	8(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edx
		movl	%ebp,8(%rsp)

		movl	%edx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		movl	%ecx,%ebp
		orl	%esi,%ebx
		andl	%esi,%ebp
		andl	%eax,%ebx
		orl	%ebp,%ebx
		movl	(%rsp),%ebp
		addl	%ebx,%edi
		xorl	44(%rsp),%ebp
		xorl	20(%rsp),%ebp
		rorl	$2,%ecx
		xorl	12(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edi
		movl	%ebp,12(%rsp)

		movl	%edi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%eax,),%eax
		movl	%edx,%ebx
		movl	%edx,%ebp
		orl	%ecx,%ebx
		andl	%ecx,%ebp
		andl	%esi,%ebx
		orl	%ebp,%ebx
		movl	4(%rsp),%ebp
		addl	%ebx,%eax
		xorl	48(%rsp),%ebp
		xorl	24(%rsp),%ebp
		rorl	$2,%edx
		xorl	16(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%eax
		movl	%ebp,16(%rsp)

		movl	%eax,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%esi,),%esi
		movl	%edi,%ebx
		movl	%edi,%ebp
		orl	%edx,%ebx
		andl	%edx,%ebp
		andl	%ecx,%ebx
		orl	%ebp,%ebx
		movl	8(%rsp),%ebp
		addl	%ebx,%esi
		xorl	52(%rsp),%ebp
		xorl	28(%rsp),%ebp
		rorl	$2,%edi
		xorl	20(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%esi
		movl	%ebp,20(%rsp)

		movl	%esi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		movl	%eax,%ebp
		orl	%edi,%ebx
		andl	%edi,%ebp
		andl	%edx,%ebx
		orl	%ebp,%ebx
		movl	12(%rsp),%ebp
		addl	%ebx,%ecx
		xorl	56(%rsp),%ebp
		xorl	32(%rsp),%ebp
		rorl	$2,%eax
		xorl	24(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%ecx
		movl	%ebp,24(%rsp)

		movl	%ecx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edx,),%edx
		movl	%esi,%ebx
		movl	%esi,%ebp
		orl	%eax,%ebx
		andl	%eax,%ebp
		andl	%edi,%ebx
		orl	%ebp,%ebx
		movl	16(%rsp),%ebp
		addl	%ebx,%edx
		xorl	60(%rsp),%ebp
		xorl	36(%rsp),%ebp
		rorl	$2,%esi
		xorl	28(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edx
		movl	%ebp,28(%rsp)

		movl	%edx,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		movl	%ecx,%ebp
		orl	%esi,%ebx
		andl	%esi,%ebp
		andl	%eax,%ebx
		orl	%ebp,%ebx
		movl	20(%rsp),%ebp
		addl	%ebx,%edi
		xorl	(%rsp),%ebp
		xorl	40(%rsp),%ebp
		rorl	$2,%ecx
		xorl	32(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%edi
		movl	%ebp,32(%rsp)

		movl	%edi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%eax,),%eax
		movl	%edx,%ebx
		movl	%edx,%ebp
		orl	%ecx,%ebx
		andl	%ecx,%ebp
		andl	%esi,%ebx
		orl	%ebp,%ebx
		movl	24(%rsp),%ebp
		addl	%ebx,%eax
		xorl	4(%rsp),%ebp
		xorl	44(%rsp),%ebp
		rorl	$2,%edx
		xorl	36(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%eax
		movl	%ebp,36(%rsp)

		movl	%eax,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%esi,),%esi
		movl	%edi,%ebx
		movl	%edi,%ebp
		orl	%edx,%ebx
		andl	%edx,%ebp
		andl	%ecx,%ebx
		orl	%ebp,%ebx
		movl	28(%rsp),%ebp
		addl	%ebx,%esi
		xorl	8(%rsp),%ebp
		xorl	48(%rsp),%ebp
		rorl	$2,%edi
		xorl	40(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%esi
		movl	%ebp,40(%rsp)

		movl	%esi,%ebx
		roll	$5,%ebx
		leal	0x8f1bbcdc(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		movl	%eax,%ebp
		orl	%edi,%ebx
		andl	%edi,%ebp
		andl	%edx,%ebx
		orl	%ebp,%ebx
		movl	32(%rsp),%ebp
		addl	%ebx,%ecx
		xorl	12(%rsp),%ebp
		xorl	52(%rsp),%ebp
		rorl	$2,%eax
		xorl	44(%rsp),%ebp
		roll	$1,%ebp
		addl	%ebp,%ecx
		movl	%ebp,44(%rsp)

		/* round 61 to 80 */

		movl	%ecx,%ebx
		movl	36(%rsp),%ebp
		roll	$5,%ebx
		xorl	16(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	56(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	48(%rsp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,48(%rsp)

		movl	%edx,%ebx
		movl	40(%rsp),%ebp
		roll	$5,%ebx
		xorl	20(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	60(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	52(%rsp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,52(%rsp)

		movl	%edi,%ebx
		movl	44(%rsp),%ebp
		roll	$5,%ebx
		xorl	24(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	56(%rsp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,56(%rsp)

		movl	%eax,%ebx
		movl	48(%rsp),%ebp
		roll	$5,%ebx
		xorl	28(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	4(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	60(%rsp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,60(%rsp)

		movl	%esi,%ebx
		movl	52(%rsp),%ebp
		roll	$5,%ebx
		xorl	32(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	8(%rsp),%ebp
		xorl	%edi,%ebx
		xorl	(%rsp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,(%rsp)

		movl	%ecx,%ebx
		movl	56(%rsp),%ebp
		roll	$5,%ebx
		xorl	36(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	12(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	4(%rsp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,4(%rsp)

		movl	%edx,%ebx
		movl	60(%rsp),%ebp
		roll	$5,%ebx
		xorl	40(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	16(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	8(%rsp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,8(%rsp)

		movl	%edi,%ebx
		movl	(%rsp),%ebp
		roll	$5,%ebx
		xorl	44(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	20(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	12(%rsp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,12(%rsp)

		movl	%eax,%ebx
		movl	4(%rsp),%ebp
		roll	$5,%ebx
		xorl	48(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	24(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	16(%rsp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,16(%rsp)

		movl	%esi,%ebx
		movl	8(%rsp),%ebp
		roll	$5,%ebx
		xorl	52(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	28(%rsp),%ebp
		xorl	%edi,%ebx
		xorl	20(%rsp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,20(%rsp)

		movl	%ecx,%ebx
		movl	12(%rsp),%ebp
		roll	$5,%ebx
		xorl	56(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	32(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	24(%rsp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,24(%rsp)

		movl	%edx,%ebx
		movl	16(%rsp),%ebp
		roll	$5,%ebx
		xorl	60(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	36(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	28(%rsp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,28(%rsp)

		movl	%edi,%ebx
		movl	20(%rsp),%ebp
		roll	$5,%ebx
		xorl	(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	40(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	32(%rsp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax
		movl	%ebp,32(%rsp)

		movl	%eax,%ebx
		movl	24(%rsp),%ebp
		roll	$5,%ebx
		xorl	4(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	44(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	36(%rsp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi
		movl	%ebp,36(%rsp)

		movl	%esi,%ebx
		movl	28(%rsp),%ebp
		roll	$5,%ebx
		xorl	8(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	48(%rsp),%ebp
		xorl	%edi,%ebx
		xorl	40(%rsp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addl	%ebp,%ecx
		movl	%ebp,40(%rsp)

		movl	%ecx,%ebx
		movl	32(%rsp),%ebp
		roll	$5,%ebx
		xorl	12(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%edx,),%edx
		movl	%esi,%ebx
		xorl	52(%rsp),%ebp
		xorl	%eax,%ebx
		xorl	44(%rsp),%ebp
		xorl	%edi,%ebx
		roll	$1,%ebp
		addl	%ebx,%edx
		rorl	$2,%esi
		addl	%ebp,%edx
		movl	%ebp,44(%rsp)

		movl	%edx,%ebx
		movl	36(%rsp),%ebp
		roll	$5,%ebx
		xorl	16(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%edi,),%edi
		movl	%ecx,%ebx
		xorl	56(%rsp),%ebp
		xorl	%esi,%ebx
		xorl	48(%rsp),%ebp
		xorl	%eax,%ebx
		roll	$1,%ebp
		addl	%ebx,%edi
		rorl	$2,%ecx
		addl	%ebp,%edi
		movl	%ebp,48(%rsp)

		movl	%edi,%ebx
		movl	40(%rsp),%ebp
		roll	$5,%ebx
		xorl	20(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%eax,),%eax
		movl	%edx,%ebx
		xorl	60(%rsp),%ebp
		xorl	%ecx,%ebx
		xorl	52(%rsp),%ebp
		xorl	%esi,%ebx
		roll	$1,%ebp
		addl	%ebx,%eax
		rorl	$2,%edx
		addl	%ebp,%eax

		movl	%eax,%ebx
		movl	44(%rsp),%ebp
		roll	$5,%ebx
		xorl	24(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%esi,),%esi
		movl	%edi,%ebx
		xorl	(%rsp),%ebp
		xorl	%edx,%ebx
		xorl	56(%rsp),%ebp
		xorl	%ecx,%ebx
		roll	$1,%ebp
		addl	%ebx,%esi
		rorl	$2,%edi
		addl	%ebp,%esi

		movl	%esi,%ebx
		movl	48(%rsp),%ebp
		roll	$5,%ebx
		xorl	28(%rsp),%ebp
		leal	0xca62c1d6(%ebx,%ecx,),%ecx
		movl	%eax,%ebx
		xorl	4(%rsp),%ebp
		xorl	%edi,%ebx
		xorl	60(%rsp),%ebp
		xorl	%edx,%ebx
		roll	$1,%ebp
		addl	%ebx,%ecx
		rorl	$2,%eax
		addq	$64,%rsp
		addl	%ebp,%ecx

		/* create new hash */

		addl	%ecx,(%r8)
		addl	%esi,4(%r8)
		addl	%eax,8(%r8)
		addl	%edi,12(%r8)
		addl	%edx,16(%r8)

		movq	%r10,%rbp
		movq	%r11,%rbx
		ret

/* void sha1init(SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1init
		.type	sha1init,@function
		.align	16
sha1init:
		movl	$0x67452301,(%rdi)
		movl	$0xefcdab89,4(%rdi)
		movl	$0x98badcfe,8(%rdi)
		movl	$0x10325476,12(%rdi)
		movl	$0xc3d2e1f0,16(%rdi)
		movl	$0,20(%rdi)
		movb	$0,88(%rdi)
		ret

.endif

/* void sha1next(WORD08 *data,WORD32 length,SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1next
		.type	sha1next,@function
		.align	16
sha1next:
		pushq	%r12
		pushq	%r13

		movq	%rdi,%r13
		movq	%rdx,%r8
		movl	%esi,%r12d
		leaq	24(%rdx),%rdi

		addl	%esi,20(%r8)

		movzbq	88(%r8),%rcx
		testl	%esi,%esi
		je	sha1nxtlp1end
sha1nextloop1:	testq	%rcx,%rcx
		je	sha1nxtlp1end
		movb	(%r13),%al
		incq	%r13
		movb	%al,(%rdi,%rcx,)
		incq	%rcx
		cmpq	$64,%rcx
		je	sha1nextcont1
		decl	%r12d
		jne	sha1nextloop1
		jmp	sha1nxtlp1end
sha1nextcont1:	call	sha1block
		xorq	%rcx,%rcx
		decl	%r12d

sha1nxtlp1end:	movq	%rcx,%r9
		cmpl	$64,%r12d
		jnae	sha1nxtlp2end

sha1nextloop2:	movq	%r13,%rdi
		call	sha1block
		subl	$64,%r12d
		addq	$64,%r13
		cmpl	$64,%r12d
		jnb	sha1nextloop2

sha1nxtlp2end:	movl	%r12d,%edx
		shrl	$2,%r12d
		je	sha1nxtlp3end

sha1nextloop3:	movl	(%r13),%eax
		addq	$4,%r13
		movl	%eax,24(%r8,%r9,)
		addq	$4,%r9
		decl	%r12d
		jne	sha1nextloop3

sha1nxtlp3end:	andl	$3,%edx
		je	sha1nextend

sha1nextloop4:	movb	(%r13),%al
		incq	%r13
		movb	%al,24(%r8,%r9,)
		incq	%r9
		decl	%edx
		jne	sha1nextloop4

sha1nextend:	movb	%r9b,88(%r8)

		popq	%r13
		popq	%r12
		ret

.endif

/* void sha1end(WORD08 *result,SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1end
		.type	sha1end,@function
		.align	16
sha1end:
		pushq	%r12

		movq	%rdi,%r9
		movq	%rsi,%r8
		leaq	24(%rsi),%rdi

		movzbq	88(%r8),%r12
		incq	%r12
		movq	%r12,%rax
		movb	$128,-1(%rdi,%r12,)
		andl	$3,%eax
		je	sha1endlp1aend

sha1endloop1a:	movb	$0,(%rdi,%r12,)
		incl	%eax
		incq	%r12
		cmpl	$4,%eax
		jne	sha1endloop1a

sha1endlp1aend:	shrq	$2,%r12
		jmp	sha1endlp1bbeg

sha1endloop1b:	movl	$0,(%rdi,%r12,4)
		incq	%r12

sha1endlp1bbeg:	cmpq	$14,%r12
		je	sha1endlp1end
		cmpq	$16,%r12
		jne	sha1endloop1b
		xorq	%r12,%r12
		call	sha1block
		leaq	24(%r8),%rdi
		jmp	sha1endloop1b

sha1endlp1end:	movl	20(%r8),%edx
		shlq	$3,%rdx
		bswapq	%rdx
		movq	%rdx,80(%r8)
		call	sha1block

		movq	(%r8),%rax
		movq	8(%r8),%rcx
		movl	16(%r8),%edx
		bswapq	%rax
		bswapq	%rcx
		bswapl	%edx
		rolq	$32,%rax
		rolq	$32,%rcx
		movq	%rax,(%r9)
		movq	%rcx,8(%r9)
		movl	%edx,16(%r9)

.ifdef SHA1_PARANOID
		xorq	%rax,%rax
		movq	%rax,24(%r8)
		movq	%rax,32(%r8)
		movq	%rax,40(%r8)
		movq	%rax,48(%r8)
		movq	%rax,56(%r8)
		movq	%rax,64(%r8)
		movq	%rax,72(%r8)
		movq	%rax,80(%r8)
.endif
		popq	%r12
		ret

.endif

/* void sha1(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef SHA1_FAST

.globl sha1
		.type	sha1,@function
		.align	16
sha1:
		pushq	%r12
		pushq	%r13
		subq	$84,%rsp

		movq	%rdi,%r13
		movl	%esi,%r12d
		movq	%rsp,%r8
		movl	$0x67452301,(%rsp)
		movl	$0xefcdab89,4(%rsp)
		movl	$0x98badcfe,8(%rsp)
		movl	$0x10325476,12(%rsp)
		movl	$0xc3d2e1f0,16(%rsp)

		pushq	%rsi
		movq	%rdx,%r9
		cmpl	$64,%r12d
		jnae	sha1loop2end

sha1loop2:	movq	%r13,%rdi
		call	sha1block
		subl	$64,%r12d
		addq	$64,%r13
		cmpl	$64,%r12d
		jnb	sha1loop2

sha1loop2end:	movl	%r12d,%ecx
		movl	%r12d,%esi
		movq	%r13,%rdx
		xorq	%r12,%r12
		leaq	28(%rsp),%rdi
		shrl	$2,%ecx
		je	sha1loop3bbeg

sha1loop3a:	movl	(%rdx,%r12,4),%eax
		movl	%eax,(%rdi,%r12,4)
		incq	%r12
		decl	%ecx
		jne	sha1loop3a
		leaq	(,%r12,4),%r12

sha1loop3bbeg:	andl	$3,%esi
		je	sha1loop3end

sha1loop3b:	movb	(%rdx,%r12,),%al
		movb	%al,(%rdi,%r12,)
		incq	%r12
		decl	%esi
		jne	sha1loop3b

sha1loop3end:	incq	%r12
		movq	%r12,%rax
		movb	$128,-1(%rdi,%r12,)
		andq	$3,%rax
		je	sha1loop4aend

sha1loop4a:	movb	$0,(%rdi,%r12,)
		incl	%eax
		incq	%r12
		cmpl	$4,%eax
		jne	sha1loop4a

sha1loop4aend:	shrq	$2,%r12
		jmp	sha1loop4bbeg

sha1loop4b:	movl	$0,(%rdi,%r12,4)
		incq	%r12

sha1loop4bbeg:	cmpq	$14,%r12
		je	sha1loop4end
		cmpq	$16,%r12
		jne	sha1loop4b
		xorq	%r12,%r12
		call	sha1block
		leaq	28(%rsp),%rdi
		jmp	sha1loop4b

sha1loop4end:	popq	%rdx
		shlq	$3,%rdx
		bswapq	%rdx
		movq	%rdx,56(%rdi)
		call	sha1block

		movq	(%rsp),%rax
		movq	8(%rsp),%rcx
		movl	16(%rsp),%edx
		bswapq	%rax
		bswapq	%rcx
		bswapl	%edx
		rolq	$32,%rax
		rolq	$32,%rcx
		movq	%rax,(%r9)
		movq	%rcx,8(%r9)
		movl	%edx,16(%r9)

.ifdef SHA1_PARANOID
		xorq	%rax,%rax
		movq	%rax,20(%rsp)
		movq	%rax,28(%rsp)
		movq	%rax,36(%rsp)
		movq	%rax,44(%rsp)
		movq	%rax,52(%rsp)
		movq	%rax,60(%rsp)
		movq	%rax,68(%rsp)
		movq	%rax,76(%rsp)
.endif

		addq	$84,%rsp
		popq	%r13
		popq	%r12
		ret

.endif

/* void sha1hmkey(WORD08 *key,WORD32 keylength,SHA1HMDATA *ptr) */

.ifdef	_SHA1_HMAC

.globl sha1hmkey
		.type	sha1hmkey,@function
		.align	16
sha1hmkey:
		pushq	%r12
		pushq	%r13

		movq	%rdi,%r12
		movq	%rdx,%r13
		movq	%rsi,%r9
		subq	$112,%rsp

		cmpl	$65,%esi
		jnae	sha1hmkey1

		movq	%rsp,%rdi
		call	sha1init
		movq	%r12,%rdi
		movq	%rsp,%rdx
		call	sha1next
		leaq	92(%rsp),%rdi
		movq	%rsp,%rsi
		movq	%rdi,%r12
		call	sha1end
		xorq	%rax,%rax
		movq	$20,%r9
		movq	%rax,(%rsp)
		movq	%rax,8(%rsp)
		movl	%eax,16(%rsp)

sha1hmkey1:	movl	$0x67452301,(%r13)
		movl	$0xefcdab89,4(%r13)
		movl	$0x98badcfe,8(%r13)
		movl	$0x10325476,12(%r13)
		movl	$0xc3d2e1f0,16(%r13)
		movl	$0x67452301,20(%r13)
		movl	$0xefcdab89,24(%r13)
		movl	$0x98badcfe,28(%r13)
		movl	$0x10325476,32(%r13)
		movl	$0xc3d2e1f0,36(%r13)

		movq	%rsp,%rdi
		xorq	%rcx,%rcx
		movb	$54,%dl
		jmp	sha1hmkey2
sha1hmkeyloop3:	movb	(%r12,%rcx,),%al
		xorb	%dl,%al
		movb	%al,(%rsp,%rcx,)
		incq	%rcx
sha1hmkey2:	cmpl	%ecx,%r9d
		jne	sha1hmkeyloop3

		jmp	sha1hmkey3
sha1hmkeyloop4:	movb	%dl,(%rsp,%rcx,)
		incq	%rcx
sha1hmkey3:	cmpq	$64,%rcx
		jne	sha1hmkeyloop4

		movq	%r13,%r8
		call	sha1block

		xorq	%rcx,%rcx
		movb	$92,%dl
		jmp	sha1hmkey4
sha1hmkeyloop5:	movb	(%r12,%rcx,),%al
		xorb	%dl,%al
		movb	%al,(%rsp,%rcx,)
		incq	%rcx
sha1hmkey4:	cmpl	%ecx,%r9d
		jne	sha1hmkeyloop5

		jmp	sha1hmkey5
sha1hmkeyloop6:	movb	%dl,(%rsp,%rcx,)
		incq	%rcx
sha1hmkey5:	cmpq	$64,%rcx
		jne	sha1hmkeyloop6

		addq	$20,%r8
		movq	%rsp,%rdi
		call	sha1block

		movq	$20,%rdx
		xorl	%eax,%eax
sha1hmkeyloop7:	decl	%edx
		movl	%eax,(%rsp,%rdx,4)
		movb	%al,92(%rsp,%rdx,)
		jne	sha1hmkeyloop7

		addq	$112,%rsp
		popq	%r13
		popq	%r12
		ret

.endif

/* void sha1hminit(SHA1DATA *ptr,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FULL

.globl sha1hminit
		.type	sha1hminit,@function
		.align	16
sha1hminit:
		movq	(%rsi),%rax
		movq	%rax,(%rdi)
		movq	8(%rsi),%rax
		movq	%rax,8(%rdi)
		movl	16(%rsi),%eax
		movl	%eax,16(%rdi)
		movl	$64,20(%rdi)
		movb	$0,88(%rdi)
		ret

.endif

/* void sha1hmend(WORD08 *result,SHA1DATA *ptr,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FULL

.globl sha1hmend
		.type	sha1hmend,@function
		.align	16
sha1hmend:
		pushq	%r12
		movq	%rdx,%r12
		call	sha1end

		movb	$0,88(%r8)
		movq	20(%r12),%rax
		movq	28(%r12),%rdx
		movl	36(%r12),%ecx
		movq	%rax,(%r8)
		movq	%rdx,8(%r8)
		movl	%ecx,16(%r8)
		movl	$64,20(%r8)

		movq	%r8,%rdx
		movq	$20,%rsi
		movq	%r9,%rdi
		movq	%r9,%r12
		call	sha1next

		movq	%r12,%rdi
		movq	%r8,%rsi
		call	sha1end

		popq	%r12
		ret

.endif

/* void sha1hmac(WORD08 *data,WORD32 length,WORD08 *result,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FAST

.globl sha1hmac
		.type	sha1hmac,@function
		.align	16
sha1hmac:
		pushq	%r12
		pushq	%r13
		movq	%rdx,%r12
		movq	%rcx,%r13
		subq	$92,%rsp

		movb	$0,88(%rsp)

		movq	(%r13),%rax
		movq	8(%r13),%rdx
		movl	16(%r13),%ecx
		movq	%rax,(%rsp)
		movq	%rdx,8(%rsp)
		movl	%ecx,16(%rsp)

		movl	$64,20(%rsp)

		movq	%rsp,%rdx
		call	sha1next

		movq	%r12,%rdi
		movq	%rsp,%rsi
		call	sha1end

		movb	$0,88(%rsp)

		movq	20(%r13),%rax
		movq	28(%r13),%rdx
		movl	36(%r13),%ecx
		movq	%rax,(%rsp)
		movq	%rdx,8(%rsp)
		movl	%ecx,16(%rsp)

		movl	$64,20(%rsp)

		movq	%r12,%rdi
		movq	$20,%rsi
		movq	%rsp,%rdx
		call	sha1next

		movq	%r12,%rdi
		movq	%rsp,%rsi
		call	sha1end

		addq	$92,%rsp
		popq	%r13
		popq	%r12
		ret

.endif
