/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CipherProc.h,v 1.4.8.1 1998/11/12 03:05:28 heller Exp $
____________________________________________________________________________*/

#pragma once



#ifdef __cplusplus
extern "C" {
#endif


typedef struct CipherContext	CipherContext;


typedef enum 
	{
	kCipherOp_Encrypt = 13,
	kCipherOp_Decrypt,
	kCipherOp_Init,
	kCipherOp_Verify,
	kDummyCipherOp = 65536
	} CipherOp;


#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#endif

typedef struct
	{
	CipherOp	op;
	
	const CipherContext *	context;
	
	union
		{
		struct
			{
			const void *	src;
			void *			dest;
			ItemCount		startBlock;
			ItemCount		numBlocks;
			} doCipher;
		
		struct
			{
			const uchar *	keyToExpand;
			} doInit;
		};
	
	} CipherProcAPIStruct;
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#endif

enum
{
	uppCipherProcInfo = kCStackBased
		 | RESULT_SIZE(SIZE_CODE(sizeof(OSStatus)))
		 | STACK_ROUTINE_PARAMETER(1,
		 		SIZE_CODE(sizeof( CipherProcAPIStruct * )))
};


typedef OSStatus (*CipherProcPtr)( CipherProcAPIStruct *api );

#if TARGET_RT_MAC_CFM

typedef UniversalProcPtr CipherProcUPP;

#define CallCipherProcX(userRoutine, api )					\
		CallUniversalProc((UniversalProcPtr)(userRoutine), 	\
		uppCipherProcInfo, (api) )
#else
typedef CipherProcPtr CipherProcUPP;

#define CallCipherProcX(userRoutine, api )		\
		(*(userRoutine))( api )
#endif



#ifdef __cplusplus
}
#endif
