/*____________________________________________________________________________
	Copyright (C) 1994-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: SleepAlert.cp,v 1.3.8.1 1998/11/12 03:06:15 heller Exp $
____________________________________________________________________________*/

#include "MacResources.h"
#include "MacFiles.h"

#include "SleepAlert.h"
#include "PGPDiskPreferences.h"
#include "PGPDisk.h"



	
	static OSErr
CreateAndOpenPrefsResFork( short *fileRef )
{
	OSErr	err	= noErr;
	FSSpec	spec;
	
	err	= GetPrefsFileSpec( &spec );
	if ( IsntErr( err ) )
	{
		err	= FSpDeleteResourceFork( &spec );
	}
	
	if ( IsntErr( err ) )
	{
		FSpCreateResFile( &spec, kPGPDiskFileCreator, kPrefsFileType,
					smSystemScript );
		err	= ResError();
		
		if ( IsntErr( err ) )
		{
			*fileRef	= FSpOpenResFile( &spec, fsRdWrPerm );
			err	= ResError();
		}
	}
	

	return( err );
}


/*___________________________________________________________________________
	We do this so the driver has a known resource file where it can get an
	alert.
___________________________________________________________________________*/
	void
CopySleepAlertToPrefs( void )
{
	OSErr	err	= noErr;
	short	fileRef;
	short	saveResFile	= CurResFile();
	
	err	= CreateAndOpenPrefsResFork( &fileRef );
	if ( IsntErr( err ) )
	{
		err	= CopyResource( saveResFile, 'ALRT', kSleepRequestAlertResID,
					fileRef, 'ALRT', kSleepRequestAlertResID);
		if ( IsntErr( err ) )
		{
			err	= CopyResource( saveResFile, 'DITL', kSleepRequestAlertResID,
						fileRef, 'DITL', kSleepRequestAlertResID);
		}
		
		if ( IsntErr( err ) )
		{
			err	= CopyResource( saveResFile, 'ALRT', kSleepDemandAlertResID,
						fileRef, 'ALRT', kSleepDemandAlertResID);
			if ( IsntErr( err ) )
			{
				err	= CopyResource( saveResFile, 'DITL',
							kSleepDemandAlertResID, fileRef, 'DITL',
							kSleepDemandAlertResID);
			}
		}
		
		CloseResFile( fileRef );
		if ( IsntErr( err ) )
		{
			err	= ResError();
		}
		
		if ( IsErr( err ) )
		{
			FSSpec	spec;
			
			GetPrefsFileSpec( &spec );
			FSpDeleteResourceFork( &spec );
		}
	}
	
	AssertNoErr( err, "CopySleepAlertToPrefs" );
	
	UseResFile( saveResFile );
}







