/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: TunerStruct.h,v 1.2.8.1 1998/11/12 03:06:16 heller Exp $
____________________________________________________________________________*/

#pragma once

typedef struct TunerStruct
	{
	// requests correspond to 1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024,
	// 2048, 4096 blocks as in 2^0, 2^1, 2^2, etc blocks
	enum { kNumTune = 13 };
	ushort	maxBlocks[ kNumTune ];	// for 2^0 thru 2^12 blocks
	} TunerStruct;


const TunerStruct	kDefaultReadTunerStruct = 
	{
//		1	2	4	8	16	32	64	128	256	512		1024	2048	4096
	{	1,	2,	4,	8,	16,	16,	32,	32,	32,	64,		128,	200,	200 }
	};

// assuming scratch buffer size is 128K
const TunerStruct	kDefaultWriteTunerStruct128 = 
	{
//		1	2	4	8	16	32	64	128	256	512		1024	2048	4096
	{	1,	2,	4,	8,	16,	16,	32,	32,	64,	64,		64,		64,		64 }
	};

