/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CInterruptLevelFileTester.cp,v 1.4.8.1 1998/11/12 03:06:20 heller Exp $
____________________________________________________________________________*/

#include <Timer.h>
#include <stddef.h>
#include "pgpMacMemory.h"

#include "SetupA5.h"


#if TARGET_RT_MAC_CFM
assumes 68K non-CFM
#endif

#include "CInterruptLevelFileTester.h"


CInterruptLevelFileTester::CInterruptLevelFileTester( )
	: CInterruptLevelTester()
	{
	OSErr	err	= noErr;
	
	mCurMark			= 0;
	
	RememberA5();
	}


CInterruptLevelFileTester::~CInterruptLevelFileTester( )
	{
	if ( mTestInProgress )
		{
		Stop();
		}
	}
	
	
	void
CInterruptLevelFileTester::HandleIOCompletion( MyPB *myPB )
	{
	ParamBlockRec *	pb	= &myPB->pb;
	
	mCurMark	+= pb->ioParam.ioActCount;
	if ( mCurMark > mEOF )
		mCurMark	= 0;
	
	inherited::HandleIOCompletion( myPB );
	}
	
	
	
	void
CInterruptLevelFileTester::DoIOFromTimeMgrTask()
	{
	ParamBlockRec *	pb;
	OSErr			err	= noErr;
	ulong			reqCount;
	
	mPB.thisObject	= this;
	pb	= &mPB.pb;
	
	reqCount	= sizeof( mBuffer );
	if ( mCurMark + reqCount > mEOF )
		{
		mCurMark	= 0;
		}
	
	MacDebug_FillWithGarbage( pb, sizeof( *pb ) );
	pb->ioParam.ioCompletion	= sIOCompletion;
	pb->ioParam.ioRefNum		= mFileRefNum;
	pb->ioParam.ioBuffer		= mBuffer;
	pb->ioParam.ioReqCount		= reqCount;
	pb->ioParam.ioPosMode		= fsFromStart;
	pb->ioParam.ioPosOffset		= mCurMark;
	
	if ( mIODirection == kReadDirection )
		{
		err	= PBReadAsync( pb );
		}
	else
		{
		err	= PBWriteAsync( pb );
		}
	}
	
	
	
	OSErr
CInterruptLevelFileTester::Setup( short	fileRefNum )
	{
	OSErr	err	= noErr;
	
	err	= inherited::Setup( fileRefNum );
	if ( IsntErr( err ) )
		{
		err	= GetEOF( fileRefNum, &mEOF );
		AssertNoErr( err, "CInterruptLevelFileTester::Setup" );
		}
		
	return( err );
	}

	
	

