/*____________________________________________________________________________
	CManualTranslator.cp
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CManualTranslator.cp,v 1.49.2.1.2.1 1998/11/12 03:06:32 heller Exp $
____________________________________________________________________________*/
#include <string.h>
#include <TextUtils.h>

#include "pgpMem.h"
#include "pgpMacMemory.h"
#include "MacFiles.h"
#include "pgpErrors.h"

#include "CManualTranslator.h"
#include "TranslatorUtils.h"
#include "PluginLibUtils.h"
#include "PassphraseCache.h"
#include "WarningAlert.h"
#include "TranslatorStrings.h"
#include "CWrappers.h"
#include "CSecureMemory.h"
#include "SignatureStatusMessage.h"
#include "PGPSharedParse.h"
#include "TranslatorPrefs.h"
#include "pgpWordWrap.h"
#include "pgpVersionHeader.h"
#include "PGPSharedEncryptDecrypt.h"
#include "pgpClientLib.h"
#include "pgpClientErrors.h"


#if 0
						PluginError
					CManualDecryptVerifyTranslator::TranslateFile(
						long			transContext,
						ConstemsMIMETypeHandle	inMIMEtypeHandle,
						const FSSpec *	inSpec,
						StringHandle**	addressesHandle,		// nil for manual translators
						emsMIMETypeHandle*	outMIMETypeHandlePtr,// nil for manual translators
						const FSSpec *	outSpec,
						StringHandle*	returnedMessage,		// nil for manual translators
						StringHandle*	errorMessage,
						long *			resultCode
						)
					{
						CComboError		err;
						Boolean			reportedError	= false;
						DecryptVerifyEventHandlerData	eventData( this );
						
						(void)transContext;
						(void)inMIMEtypeHandle;
						(void)addressesHandle;
						
						InitPtrToNil( outMIMETypeHandlePtr );
						InitPtrToNil( returnedMessage );
						InitPtrToNil( errorMessage );
						
						if ( IsntNull( resultCode ) )
							*resultCode	= EMSR_OK;

						void *			inBuffer	= NULL;
						ulong			inBufferSize;
						ulong			blockStart;
						ulong			blockSize;
						PGPKeySetRef	newKeysSet = kInvalidPGPKeySetRef;
						
						Boolean			isEncrypted	= false;
						Boolean			isSigned	= false;
						
						err.pgpErr = PGPNewKeySet( mContext, &newKeysSet );
						if( err.IsntError() )
						{
							err.err	= FSpReadFileIntoBuffer( inSpec, &inBuffer, &inBufferSize );
							if ( err.IsntError() )
							{
								if ( FindEncryptedBlock( inBuffer,
										inBufferSize, &blockStart, &blockSize ) )
								{
									isEncrypted	= true;
								}
								else if ( FindSignedBlock( inBuffer,
											inBufferSize, &blockStart, &blockSize ) )
								{
									isSigned	= true;
								}
								
								if ( ! ( isSigned || isEncrypted ) )
								{
									WarningAlert( kWANoteAlertType, kWAOKStyle,
										kTranslatorErrorStringsResID,
										kMessageIsNotEncryptedStrIndex);
									err.pgpErr	= kPGPError_UnknownError;
									reportedError	= true;
								}
							}
						}
						if ( err.IsntError() )
						{
							err.pgpErr	= LoadDefaultKeySet( FALSE );
						}
						
						if ( err.IsntError() && isEncrypted )
						{
							void *			outputData	= NULL;
							PGPSize			outputDataSize;
							
							do
							{
								PGPContextRef	c	= mContext;
						
								err.pgpErr	= PGPDecode( c,	
										PGPOInputBuffer( c,
											&((const char *)inBuffer)[ blockStart ], blockSize),
										PGPOAllocatedOutputBuffer( c,
											&outputData, MAX_PGPSize, &outputDataSize ),
										PGPOOutputLineEndType( c, kPGPLineEnd_CR),
										PGPOEventHandler( c, sPGPEventHandler, &eventData ),
										PGPOSendNullEvents( c, 10 ),
										PGPOKeySetRef( c, mKeySet ),
										PGPOImportKeysTo( c, newKeysSet ),
										PGPOLastOption( c )
										);
							} while ( err.pgpErr == kPGPError_BadPassphrase );
							
							if ( err.IsntError() )
							{
								short	fileRef;
								
								// write out:
								//	- data preceeding encrypted block
								//	- signing information (if any)
								//	- decrypted data
								//	- data following encrypted block
								err.err	= FSpOpenDF( outSpec, fsRdWrPerm, &fileRef );
								if ( err.IsntError() )
								{
									long	count;

									count	= blockStart;
									err.err	= FSWrite( fileRef, &count, inBuffer );
									if ( err.IsntError()  &&
										eventData.mHaveSignatureData )
									{
										Str255	signatureStatusString;
										long	count;
										
										GetSignatureStatusMessage( &eventData.mSignatureData,
											signatureStatusString );
										AppendPString( "\p\r", signatureStatusString );
										
										count	= StrLength( signatureStatusString );
										err.err	= FSWrite( fileRef,
												&count, &signatureStatusString[ 1 ] );
									}
									if ( err.IsntError() )
									{
										count	= outputDataSize;
										err.err	= FSWrite( fileRef, &count, outputData );
									}
									if ( err.IsntError() )
									{
										const char *	data	=
											&((const char *)inBuffer)[ blockStart + blockSize ];
											
										count	= inBufferSize - ( blockStart + blockSize );
										err.err		= FSWrite( fileRef, &count, data );
									}
									
									FSClose( fileRef );
								}
								
								if( err.IsntError() &&
									PGPKeySetRefIsValid( eventData.mClientHandlerData.newKeySet ) )
								{
									err.pgpErr = PGPAddKeys(eventData.mClientHandlerData.newKeySet,
														newKeysSet );
									if( err.IsntError() )
									{
										err.pgpErr = PGPCommitKeyRingChanges( newKeysSet );
									}
								}
								
								PGPFreeData( outputData );
								outputData	= NULL;
							}
						
							if ( err.IsntError() )
							{
								RememberDecryptionPassBuffer(
										eventData.mClientHandlerData.passBuffer,
										eventData.mClientHandlerData.decryptionKey );
							}
							else
							{
								gDecryptionPassphraseCache->Forget( );
							}
						}
						else if ( err.IsntError()  && isSigned )
						{
							PGPContextRef	c	= mContext;
						
							err.pgpErr	= PGPDecode( c,	
									PGPOInputBuffer( c,
										&((const char *)inBuffer)[ blockStart ], blockSize),
									PGPODiscardOutput( c, TRUE ),
									PGPOOutputLineEndType( c, kPGPLineEnd_CR),
									PGPOEventHandler( c, sPGPEventHandler, &eventData ),
									PGPOSendNullEvents( c, 10 ),
									PGPOKeySetRef( c, mKeySet ),
									PGPOImportKeysTo( c, newKeysSet ),
									PGPOLastOption( c )
									);
							
							if ( err.IsntError() )
							{
								short	fileRef;
								
								pgpAssert( eventData.mHaveSignatureData );
								
								// write out:
								//	- our verification info
								//	- original data
								err.err	= FSpOpenDF( outSpec, fsRdWrPerm, &fileRef );
								if ( err.IsntError() )
								{
									Str255		signingMessage;
									long		count;
									
									GetSignatureStatusMessage( &eventData.mSignatureData,
												signingMessage );
									AppendPString( "\p\r", signingMessage );
									
									count	= StrLength( signingMessage );
									err.err	= FSWrite( fileRef, &count, &signingMessage[ 1 ] );
									if ( err.IsntError( ) )
									{
										long	count	= inBufferSize;
										
										err.err	= FSWrite( fileRef, &count, inBuffer );
									}
									FSClose( fileRef );
								}

								if( err.IsntError() &&
									PGPKeySetRefIsValid( eventData.mClientHandlerData.newKeySet ) )
								{
									err.pgpErr = PGPAddKeys(eventData.mClientHandlerData.newKeySet,
														newKeysSet );
									if( err.IsntError() )
									{
										err.pgpErr = PGPCommitKeyRingChanges( newKeysSet );
									}
								}
							}
						}
						
						if ( IsntNull( inBuffer ) )
						{
							pgpFreeMac( inBuffer );
							inBuffer	= nil;
						}
							
						// important: if we got an error, we must make sure that the output
						// is the same as the input or Eudora will grab whatever crap
						// we put into it.
						if ( err.IsError() ) 
						{
							(void)FSpCopyFiles( PGPGetContextMemoryMgr( mContext ),
										inSpec, outSpec );
						}

						if( err.IsntError() )
						{
							PGPUInt32	numNewKeys;
							PGPError	tempErr;
							
							tempErr = PGPCountKeys( newKeysSet, &numNewKeys );
							if( IsntPGPError( tempErr ) && numNewKeys > 0 )
							{
								// Offer to import the keys
								PGPKeySetRef	importSet;
								char			prompt[256];
								
								GetIndCString( prompt, kTranslatorStringsRID,
										kSelectiveImportAfterSendPromptStrIndex );
								
								tempErr = PGPSelectKeysDialog( mContext,
										kPGPSelectKeysImportVariation, prompt,
										newKeysSet, mKeySet, &importSet );
								
								if( IsntPGPError( tempErr ) )
								{
									(void) PGPSharedAddKeysToDefaultKeyring( importSet );
									(void) PGPFreeKeySet( importSet );
								}
							}
						}

						if ( ! reportedError )
						{
							ReportError( err );
						}
						
						if( PGPKeySetRefIsValid( newKeysSet ) )
							PGPFreeKeySet( newKeysSet );
							
						return( CComboErrorToEudoraError( err ) );
					}
#else

	PGPError
CManualDecryptVerifyTranslator::PGPDecodeEventHandler(
	PGPContextRef					context,
	PGPEvent *						event,
	DecryptVerifyEventHandlerData *	data)
{	
	CComboError	err;
	
	switch( event->type )
	{
		case kPGPEvent_OutputEvent:
		{
			if( event->data.outputData.forYourEyesOnly && ( data->mFYEOData == nil ) )
			{
				SInt32	eof;
				
				err.err = ::SetFPos( data->mOutputFileRef, fsFromStart, 0 );
				if ( err.IsntError() )
				{
					err.err = ::GetEOF( data->mOutputFileRef, &eof );
				}
				
				if ( err.IsntError() )
				{
					data->mFYEOData = (char *) PGPNewSecureData( PGPGetContextMemoryMgr( context ),
																 eof + 1,
																 kPGPMemoryMgrFlags_None );
					if ( IsNull( data->mFYEOData ) )
					{
						err.pgpErr = kPGPError_OutOfMemory;
					}
				}
				
				if ( err.IsntError() )
				{
					data->mFYEOData[eof] = 0;
					err.err = ::FSRead( data->mOutputFileRef, &eof, data->mFYEOData );
				}
			}
		}
		break;
		
		
		case kPGPEvent_EndLexEvent:
		{
			if( data->mClientHandlerData.outputBufferSize != 0 )
			{
				long	count;
				Str255	str;
				short	strIndex;

				if( data->mClientHandlerData.signatureDataValid )
				{
					GetSignatureStatusMessage(&data->mSignatureData,
								str );
					
					count = StrLength( str );
					if ( IsntNull( data->mFYEOData ) )
					{
						PGPSize	newSize = strlen( data->mFYEOData ) + count + 1;
						
						err.pgpErr = PGPReallocData( PGPGetContextMemoryMgr( context ),
													 &data->mFYEOData,
													 newSize,
													 kPGPMemoryMgrFlags_None );
						if ( err.IsntError() )
						{
							strncat( data->mFYEOData, (char * ) &str[1], count );
							data->mFYEOData[newSize - 1] = 0;
						}
					}
					else
					{
						err.err = FSWrite( data->mOutputFileRef,
								&count, &str[1] );
					}
					if( err.IsntError() )
					{
						if( data->mClientHandlerData.sectionType ==
									kPGPAnalyze_Encrypted )
						{
							strIndex = kBeginDecryptedVerifiedMsgStrIndex;
						}
						else
						{
							strIndex = kBeginVerifiedMsgStrIndex;
						}
						
						GetIndString( str, kTranslatorStringsRID,
								strIndex );
						
						count = StrLength( str );
						if ( IsntNull( data->mFYEOData ) )
						{
							PGPSize	newSize = strlen( data->mFYEOData ) + count + 1;
							
							err.pgpErr = PGPReallocData( PGPGetContextMemoryMgr( context ),
														 &data->mFYEOData,
														 newSize,
														 kPGPMemoryMgrFlags_None );
							if ( err.IsntError() )
							{
								strncat( data->mFYEOData, (char *) &str[1], count );
								data->mFYEOData[newSize - 1] = 0;
							}
						}
						else
						{
							err.err = FSWrite( data->mOutputFileRef,
									&count, &str[1] );
						}
					}
				}
				
				if( err.IsntError() )
				{
					count = data->mClientHandlerData.outputBufferSize;
				
					if ( IsntNull( data->mFYEOData ) )
					{
						PGPSize	newSize = strlen( data->mFYEOData ) + count + 1;
						
						err.pgpErr = PGPReallocData( PGPGetContextMemoryMgr( context ),
													 &data->mFYEOData,
													 newSize,
													 kPGPMemoryMgrFlags_None );
						if ( err.IsntError() )
						{
							strncat( data->mFYEOData, (char *) data->mClientHandlerData.outputBuffer,
								count );
							data->mFYEOData[newSize - 1] = 0;
						}
					}
					else
					{
						err.err = FSWrite( data->mOutputFileRef, &count,
									data->mClientHandlerData.outputBuffer );
					}
				}


				if( err.IsntError() &&
					data->mClientHandlerData.signatureDataValid )
				{
					if( data->mClientHandlerData.sectionType ==
								kPGPAnalyze_Encrypted )
					{
						strIndex = kEndDecryptedVerifiedMsgStrIndex;
					}
					else
					{
						strIndex = kEndVerifiedMsgStrIndex;
					}
						
					GetIndString( str, kTranslatorStringsRID,
							strIndex );
					
					count = StrLength( str );
					if ( IsntNull( data->mFYEOData ) )
					{
						PGPSize	newSize = strlen( data->mFYEOData ) + count + 1;
						
						err.pgpErr = PGPReallocData( PGPGetContextMemoryMgr( context ),
													 &data->mFYEOData,
													 newSize,
													 kPGPMemoryMgrFlags_None );
						if ( err.IsntError() )
						{
							strncat( data->mFYEOData, (char *) &str[1], count );
							data->mFYEOData[newSize - 1] = 0;
						}
					}
					else
					{
						err.err = FSWrite( data->mOutputFileRef,
								&count, &str[1] );
					}
				}
			}
			
			break;
		}
	}
	
	if( err.IsntError() )
	{
		err.pgpErr = CManualTranslator::PGPDecodeEventHandler( context,
					event, data );
	}
	
	return( err.ConvertToPGPError() );
}


	PluginError
CManualDecryptVerifyTranslator::TranslateFile(
	long			transContext,
	ConstemsMIMETypeHandle	inMIMEtypeHandle,
	const FSSpec *	inSpec,
	StringHandle**	addressesHandle,		// nil for manual translators
	emsMIMETypeHandle*	outMIMETypeHandlePtr,// nil for manual translators
	const FSSpec *	outSpec,
	StringHandle*	returnedMessage,		// nil for manual translators
	StringHandle*	errorMessage,
	long *			resultCode
	)
{
	CComboError		err;
	Boolean			reportedError	= false;
	DecryptVerifyEventHandlerData	eventData( this );
	
	(void)transContext;
	(void)inMIMEtypeHandle;
	(void)addressesHandle;
	
	InitPtrToNil( outMIMETypeHandlePtr );
	InitPtrToNil( returnedMessage );
	InitPtrToNil( errorMessage );
	
	if ( IsntNull( resultCode ) )
		*resultCode	= EMSR_OK;

	PGPKeySetRef	newKeysSet = kInvalidPGPKeySetRef;
	
	pgpFixBeforeShip( "Show error for non-PGP data" );
	
	err.pgpErr = PGPNewKeySet( mContext, &newKeysSet );
	if ( err.IsntError() )
	{
		err.pgpErr = LoadDefaultKeySet( FALSE );
	}
	
	if ( err.IsntError() )
	{
		PGPContextRef	c	= mContext;

		err.err	= FSpOpenDF( outSpec, fsRdWrPerm, &eventData.mOutputFileRef );
		if ( err.IsntError() )
		{
			err.pgpErr	= PGPDecode( c,	
					PGPOInputFileFSSpec( c, inSpec ),
					PGPOOutputLineEndType( c, kPGPLineEnd_CR),
					PGPOEventHandler( c, sPGPDecodeEventHandler, &eventData ),
					PGPOSendNullEvents( c, 10 ),
					PGPOKeySetRef( c, mKeySet ),
					PGPOImportKeysTo( c, newKeysSet ),
					PGPOPassThroughIfUnrecognized( c, TRUE ),
					PGPOLastOption( c )
					);
		
			FSClose( eventData.mOutputFileRef );
			eventData.mOutputFileRef = -1;
		}
		
		if ( err.IsntError() )
		{
			if( err.IsntError() &&
				PGPKeySetRefIsValid( eventData.mClientHandlerData.newKeySet ) )
			{
				err.pgpErr = PGPAddKeys(eventData.mClientHandlerData.newKeySet,
									newKeysSet );
				if( err.IsntError() )
				{
					err.pgpErr = PGPCommitKeyRingChanges( newKeysSet );
				}
			}
		}
	
		if ( err.IsntError() )
		{
			RememberDecryptionPassBuffer(
					eventData.mClientHandlerData.passBuffer,
					eventData.mClientHandlerData.decryptionKey );
		}
		else
		{
			gDecryptionPassphraseCache->Forget( );
		}
		
		// FYEO
		if ( err.IsntError() && ( eventData.mFYEOData != nil ) )
		{
			err.pgpErr = PGPForYourEyesOnlyDialog( c , eventData.mFYEOData );
		}
		if ( eventData.mFYEOData != nil )
		{
			pgpClearMemory( eventData.mFYEOData, strlen( eventData.mFYEOData ) );
			PGPFreeData( eventData.mFYEOData );
		}
	}

	// important: if we got an error, we must make sure that the output
	// is the same as the input or Eudora will grab whatever crap
	// we put into it. We also do this if the message was FYEO

	if ( err.IsError() || ( eventData.mFYEOData != nil ) ) 
	{
		(void)FSpCopyFiles( PGPGetContextMemoryMgr( mContext ),
					inSpec, outSpec );
	}

	if( err.IsntError() )
	{
		PGPUInt32	numNewKeys;
		PGPError	tempErr;
		
		tempErr = PGPCountKeys( newKeysSet, &numNewKeys );
		if( IsntPGPError( tempErr ) && numNewKeys > 0 )
		{
			// Offer to import the keys
			PGPKeySetRef	importSet;
			char			prompt[256];
			
			GetIndCString( prompt, kTranslatorStringsRID,
					kSelectiveImportAfterSendPromptStrIndex );
			
			tempErr = PGPSelectKeysDialog( mContext,
					kPGPSelectKeysImportVariation, prompt,
					newKeysSet, mKeySet, &importSet );
			
			if( IsntPGPError( tempErr ) )
			{
				(void) PGPSharedAddKeysToDefaultKeyring( importSet );
				(void) PGPFreeKeySet( importSet );
			}
		}
	}

	if ( ! reportedError )
	{
		ReportError( err );
	}
	
	if( PGPKeySetRefIsValid( newKeysSet ) )
		PGPFreeKeySet( newKeysSet );
		
	return( CComboErrorToEudoraError( err ) );
}
#endif


#pragma mark -



	PluginError
CManualAddKeyTranslator::TranslateFile(
	long				transContext,
	ConstemsMIMETypeHandle	inMIMEtypeHandle,
	const FSSpec *		inSpec,
	StringHandle**		addressesHandle,		// nil for manual translators
	emsMIMETypeHandle*	outMIMETypeHandlePtr,	// nil for manual translators
	const FSSpec *		outSpec,
	StringHandle*		returnedMessage,		// nil for manual translators
	StringHandle*		errorMessage,
	long *				resultCode
	)
{
	CComboError		err;
	PluginError		emsrErr	= EMSR_OK;
	Boolean			reportedError	= false;
	
	(void)transContext;
	(void)inMIMEtypeHandle;
	(void)addressesHandle;
	(void)outMIMETypeHandlePtr;
	(void)returnedMessage;
	(void)errorMessage;
	(void)resultCode;
	
	// preserve the data; we aren't going to change anything
	err.err	= FSpCopyFiles( PGPGetContextMemoryMgr( mContext ), inSpec,
						outSpec );
	if ( err.IsntError() )
	{
		PGPUInt32		numKeysAdded = 0;
		PGPUInt32		numKeysFound = 0;
		PGPContextRef	c	= mContext;
		PGPBoolean		cantOpenMutable	= FALSE;
		PGPKeySetRef	keysFound;
		
		err.pgpErr	= PGPImportKeySet( c,
					&keysFound,
					PGPOInputFileFSSpec(c, inSpec),
					PGPOLastOption( c )
					);
		if ( err.IsntError() )
		{
			err.pgpErr	= PGPCountKeys( keysFound, &numKeysFound );
		}
		
		if ( err.IsntError() && numKeysFound != 0 )
		{
			PGPKeySetRef	keysToImport	= kInvalidPGPKeySetRef;
			Str255			pPrompt;
			char			cPrompt[ sizeof( pPrompt ) ];
			
			GetIndString( pPrompt, kTranslatorStringsRID,
				kSelectiveImportPromptStrIndex );
			PToCString( pPrompt, cPrompt );
			
			err.pgpErr	= PGPSelectKeysDialog( c,
					kPGPSelectKeysImportVariation,
					cPrompt,
					keysFound,
					mKeySet,
					&keysToImport );
			if ( err.IsntError() )
			{
				err.pgpErr	= PGPCountKeys( keysToImport, &numKeysAdded );
				if ( numKeysAdded != 0 )
				{
					/* we're about to change it, so get rid of it */
					if ( IsntNull( mKeySet ) )
					{
						PGPFreeKeySet( mKeySet );
						mKeySet	= NULL;
					}
					
					err.pgpErr	=
						PGPSharedAddKeysToDefaultKeyring( keysToImport );
				}
				PGPFreeKeySet( keysToImport );
			}
			PGPFreeKeySet( keysFound );
		}
		
		reportedError	= true;	// most cases do, see below
		if ( numKeysAdded != 0 )
		{
			if ( numKeysAdded == 1 )
			{
				WarningAlert( kWANoteAlertType, kWAOKStyle,
					kTranslatorErrorStringsResID,
					kKeyAddedSuccessfullyStrIndex );
			}
			else
			{
				Str255	numKeysStr;
				NumToString( numKeysAdded, numKeysStr );
				
				WarningAlert( kWANoteAlertType, kWAOKStyle,
					kTranslatorErrorStringsResID,
					kKeysAddedSuccessfullyStrIndex, numKeysStr );
			}
		}
		else if ( err.pgpErr == kPGPError_FilePermissions ||
					cantOpenMutable)
		{
			WarningAlert( kWAStopAlertType, kWAOKStyle,
				kTranslatorErrorStringsResID,
				kCantAddKeyAddItInPGPkeysInsteadStrIndex );
		}
		else if ( err.IsCancelError() )
		{
			reportedError	= true;
		}
		else if ( err.HavePGPError()  )
		{
			Str255	errorString;
			
			PGPGetClientErrorString( err.pgpErr,
				sizeof( errorString ), (char *)errorString);
			CToPString( (char *)errorString, errorString );

			WarningAlert( kWANoteAlertType, kWAOKStyle,
				kTranslatorErrorStringsResID,
				kErrorWhileAddingKeyStrIndex, errorString );
		}
		else if ( numKeysAdded == 0 )
		{
			WarningAlert( kWAStopAlertType, kWAOKStyle,
				kTranslatorErrorStringsResID, kNoKeysPresentStrIndex );
		}
		else
		{
			reportedError	= false;
		}
				
		// we handle all our own error reporting
		err.err		= noErr;
		err.pgpErr	= noErr;
	}
	
	if ( ! reportedError )
	{
		ReportError( err );
	}
	
	emsrErr	= CComboErrorToEudoraError( err );
	
	return( emsrErr );
}








CManualEncryptSignTranslator::CManualEncryptSignTranslator(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	emsProgress			progressHook,
	Boolean				doSign )
	: CManualTranslator( context, tlsContext, progressHook)
{
	mDoSign = doSign;
}


#pragma global_optimizer on


	PluginError
CManualEncryptSignTranslator::TranslateFile(
	long			transContext,
	ConstemsMIMETypeHandle	inMIMEtypeHandle,
	const FSSpec *	inSpec,
	StringHandle**	addressesHandle,			// nil for manual translators
	emsMIMETypeHandle*	outMIMETypeHandlePtr,	// nil for manual translators
	const FSSpec *	outSpec,
	StringHandle*	returnedMessage,			// nil for manual translators
	StringHandle*	errorMessage,
	long *			resultCode
	)
{
	CComboError			err;
	PGPOptionListRef	options	= kInvalidPGPOptionListRef;
	PGPContextRef		c	= mContext;

	(void)transContext;
	(void)inMIMEtypeHandle;
	(void)addressesHandle;
	(void)outMIMETypeHandlePtr;
	(void)returnedMessage;
	(void)errorMessage;
	(void)resultCode;
		
	pgpAssert( IsNull( addressesHandle ) );
	InitPtrToNil( outMIMETypeHandlePtr );
	InitPtrToNil( returnedMessage );
	InitPtrToNil( errorMessage );

	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), inSpec,
				"\pManualEncryptIn" );
	
	
	err.pgpErr	= PGPBuildOptionList( c, &options,
				PGPOOutputLineEndType( c, kPGPLineEnd_CR),
				PGPOLastOption( c ) );
	
	if ( err.IsntError() )
	{
		err	= HandleEncryptSign( inSpec, outSpec,
				addressesHandle, mDoSign, options, false );
	}
	
	PGPFreeOptionList( options );

	// important: if we got an error, we must make sure that the output
	// is the same as the input or Eudora will grab whatever crap we put
	// into it.
	if ( err.IsError() ) 
	{
		(void)FSpCopyFiles( PGPGetContextMemoryMgr( mContext ), inSpec, outSpec );
	}
	
	ReportError( err );
	
	return( CComboErrorToEudoraError( err ) );
}




	PluginError
CManualSignTranslator::TranslateFile(
	long			transContext,
	ConstemsMIMETypeHandle	inMIMEtypeHandle,
	const FSSpec *	inSpec,
	StringHandle**	addressesHandle,		// nil for manual translators
	emsMIMETypeHandle*	outMIMETypeHandlePtr,// nil for manual translators
	const FSSpec *	outSpec,
	StringHandle*	returnedMessage,		// nil for manual translators
	StringHandle*	errorMessage,
	long *			resultCode
	)
{
	CComboError		err;
	PGPKeyRef		signingKey	= kInvalidPGPKeyRef;
	
	Boolean					reportedError	= false;


	(void)transContext;
	(void)inMIMEtypeHandle;
	(void)addressesHandle;
	(void)outMIMETypeHandlePtr;
	(void)returnedMessage;
	(void)errorMessage;
	(void)resultCode;
	
	pgpAssert( IsNull( addressesHandle ) );
	InitPtrToNil( outMIMETypeHandlePtr );
	InitPtrToNil( returnedMessage );
	InitPtrToNil( errorMessage );
	
	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), inSpec,
				"\pManualSignIn" );
	
	ulong	wordWrapLength;
	Boolean	shouldWordWrap	= PrefShouldBreakLines( &wordWrapLength );
	FSSpec	tempSpec;
		
	if ( shouldWordWrap )
	{
		err.err	= FSpGetUniqueSpec( outSpec, &tempSpec );
		if ( err.IsntError() )
		{
			PGPMemoryMgrRef	memoryMgr	= NULL;
			
			err.pgpErr	= PGPNewMemoryMgr( 0, &memoryMgr );
			if ( err.IsntError() )
			{
				err.pgpErr	= pgpWordWrapFileFSSpec( memoryMgr, inSpec,
					&tempSpec, wordWrapLength, "\r");
				PGPFreeMemoryMgr( memoryMgr );
			}
		}
	}
	else
	{
		tempSpec	= *inSpec;
	}
	
	if ( err.IsntError() )
	{
		PGPPassBufferRef	passBuffer;
		
		// prompt for passphrase if none was entered
		err = GetSigningPassBuffer( &passBuffer, &signingKey );
		if ( err.IsntError() )
		{
			err.pgpErr = PGPGuaranteeMinimumEntropy( mContext );
		}
		
		if ( err.IsntError() )
		{
			PGPContextRef				c = mContext;
			char						comment[ 256 ];
				
			PrefGetComment( comment );
			EncryptSignEventHandlerData	data(this);
			
			err.pgpErr	= PGPEncode( c,
				PGPOInputFileFSSpec( c, &tempSpec ),
				PGPOOutputFileFSSpec( c, outSpec ),
				PGPOSignWithKey( c, signingKey,
					PGPOPassBuffer(c, passBuffer),
					PGPOLastOption(c) ),
				PGPOLocalEncoding( c, kPGPLocalEncoding_None ),
				PGPOArmorOutput(c, TRUE),
				PGPOOutputLineEndType( c, kPGPLineEnd_CR),
				PGPOClearSign(c, TRUE ),
				PGPODataIsASCII( c, TRUE ),
				PGPOEventHandler( c, sPGPEncodeEventHandler, &data ),
				PGPOSendNullEvents( c, TRUE ),
				PGPOVersionString( c, pgpVersionHeaderString ),
				PGPOCommentString( c, comment ),
				PGPOLastOption(c)
				);
		
			if ( shouldWordWrap )
			{
				// delete our intermediate file
				(void)FSpDelete( &tempSpec );
			}
			
			if( err.IsntError() )
			{
				RememberSigningPassBuffer( passBuffer, signingKey );
				
				// remember it for encryption as well (but not vice versa)
				RememberDecryptionPassBuffer( passBuffer, signingKey );
			}
			else
			{
				gSigningPassphraseCache->Forget();
			}
			
			PGPFreePassBuffer( passBuffer );
		}
		
		DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), outSpec,
					"\pManualEncryptSignOut" );
	}

	// important: if we got an error, we must make sure that the output
	// is the same as the input or Eudora will grab whatever crap we put
	// into it.
	if ( err.IsError() ) 
	{
		(void)FSpCopyFiles( PGPGetContextMemoryMgr( mContext ), inSpec, outSpec );
	}
	
	if ( ! reportedError )
	{
		ReportError( err );
	}
	
	return( CComboErrorToEudoraError( err ) );
}


