/*____________________________________________________________________________
	CVerifyTranslator.cp
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CVerifyTranslator.cp,v 1.23.8.1 1998/11/12 03:06:37 heller Exp $
____________________________________________________________________________*/

#include <TextUtils.h>

#include "MacStrings.h"
#include "MacFiles.h"
#include "MacIcons.h"
#include "pgpMacMemory.h"
#include "PGPUserInterface.h"
#include "MyMIMEUtils.h"
#include "TranslatorIDs.h"
#include "PluginLibUtils.h"
#include "TranslatorUtils.h"
#include "TranslatorStrings.h"
#include "SignatureStatusMessage.h"
#include "PGPSharedParse.h"
#include "PGPSharedEncryptDecrypt.h"

#include "CVerifyTranslator.h"



	PluginError
CVerifyTranslator::CanTranslate(
	long			transContext,
	emsMIMEtype **	inMimeTypeHandle,
	const FSSpec *	inFSp,
	StringHandle**	addressesHandle,
	long *			aprox_len,
	StringHandle *	errorMessage,
	long *			result_code)
{
	PluginError	err	= EMSR_CANT_TRANS;
	
	(void)inFSp;
	(void)addressesHandle;
	(void)aprox_len;
	(void)result_code;
	InitPtrToNil( errorMessage );
	
	err	= CanTranslateMIMEType( transContext, inMimeTypeHandle,
			"\pmultipart", "\psigned", "\papplication/pgp-signature");

	return( err );
}






	PluginError
CVerifyTranslator::TranslateFile(
	long					transContext,
	ConstemsMIMETypeHandle	inMIMEtypeHandle,
	const FSSpec *			inSpec,
	StringHandle**			addressesHandle,
	emsMIMETypeHandle *		outMIMETypeHandlePtr,
	const FSSpec *			outSpec,
	StringHandle*			returnedMessage,
	StringHandle*			errorMessage,
	long *					resultCode)
{
	CComboError		err;
	
	(void)transContext;
	(void)inMIMEtypeHandle;
	(void)addressesHandle;
	
	if ( IsntNull( resultCode ) )
	{
		*resultCode	= EMSC_SIGUNKNOWN;
	}
	
	InitPtrToNil( outMIMETypeHandlePtr );
	InitPtrToNil( returnedMessage );
	InitPtrToNil( errorMessage );

	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), inSpec,
				"\pVerifyInput" );
		
	err.pgpErr	= LoadDefaultKeySet( FALSE );
	
	FInfo	fInfo;
	FSpGetFInfo( outSpec, &fInfo );
	FSpDeleteResourceFork( outSpec );
	FSpChangeFileType( outSpec, 'TEXT' );
		
	if ( err.IsntError( ) )
	{
		PGPContextRef	c = mContext;
		PGPKeySetRef	newKeysSet;
		
		err.pgpErr = PGPNewKeySet( c, &newKeysSet );
		if( err.IsntError() )
		{
			DecryptVerifyEventHandlerData	eventData(this);

			err.pgpErr	= PGPDecode( c,
				PGPOInputFileFSSpec( c, inSpec ),
				PGPOOutputFileFSSpec( c, outSpec ),
				PGPOOutputLineEndType( c, kPGPLineEnd_CR),
				PGPOEventHandler( c, sPGPDecodeEventHandler, &eventData ),
				PGPOSendNullEvents( c, TRUE ),
				PGPOKeySetRef( c, mKeySet ),
				PGPOImportKeysTo( c, newKeysSet ),
				PGPOLastOption(c) );
			
			pgpAssert( IsntNull( resultCode ) );
			if ( ! eventData.mHaveSignatureData )
			{
				*resultCode	= EMSC_SIGBAD;
			}
			else
			{
				*resultCode		=
					SignatureDataToEudoraResult(
						&eventData.mSignatureData.sigData );
			}

			if ( IsntNull( returnedMessage ) )
			{
				if ( eventData.mHaveSignatureData )
				{
					Str255		statusMessage;
					
					GetSignatureStatusMessage( &eventData.mSignatureData,
						statusMessage );
					*returnedMessage	= NewString( statusMessage );
				}
				else
				{
					*returnedMessage	= NULL;
				}
			}
			
			if( err.IsntError() &&
				PGPKeySetRefIsValid( eventData.mClientHandlerData.newKeySet ) )
			{
				err.pgpErr = PGPAddKeys(eventData.mClientHandlerData.newKeySet,
									newKeysSet );
				if( err.IsntError() )
				{
					err.pgpErr = PGPCommitKeyRingChanges( newKeysSet );
				}
			}

			if( err.IsntError() )
			{
				PGPUInt32	numNewKeys;
				PGPError	tempErr;
				
				tempErr = PGPCountKeys( newKeysSet, &numNewKeys );
				if( IsntPGPError( tempErr ) && numNewKeys > 0 )
				{
					// Offer to import the keys
					PGPKeySetRef	importSet;
					char			prompt[256];
					
					GetIndCString( prompt, kTranslatorStringsRID,
							kSelectiveImportAfterSendPromptStrIndex );
					
					tempErr = PGPSelectKeysDialog( c,
							kPGPSelectKeysImportVariation, prompt,
							newKeysSet, mKeySet, &importSet );
					
					if( IsntPGPError( tempErr ) )
					{
						(void) PGPSharedAddKeysToDefaultKeyring( importSet );
						(void) PGPFreeKeySet( importSet );
					}
				}
			}

			PGPFreeKeySet( newKeysSet );
		}
	}
	
	DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), outSpec,
				"\pVerifyOutput" );
	
	// we deleted the resource fork.
	// This makes Eudora unhappy.  Recreate one.
	(void)FSpCreateResFile( outSpec,
		fInfo.fdCreator, fInfo.fdType, smSystemScript );
		
		
	ReportError( err );
	
	return( CComboErrorToEudoraError( err ) );
}







