/*____________________________________________________________________________
	TranslatorPrefs.h
	
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: TranslatorPrefs.h,v 1.5.16.1 1998/11/12 03:06:51 heller Exp $
____________________________________________________________________________*/

#pragma once
 
#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
	PGPUInt32			numAlgs;
	PGPCipherAlgorithm	algs[ 20 ];
} PreferredAlgorithmsStruct;

void		RefreshPrefs( void );
Boolean		PrefShouldUsePGPMimeEncrypt( void );
Boolean		PrefShouldUsePGPMimeSign( void );
Boolean		PrefShouldBreakLines( ulong *lineLength );

ulong		PrefGetSigningPassphraseCacheSeconds( void );
ulong		PrefGetEncryptionPassphraseCacheSeconds( void );

Boolean		PrefGetComment( char comment[ 256 ] );

PGPCipherAlgorithm	PrefGetConventionalCipher( void );

void		PrefGetPreferredAlgorithms( PreferredAlgorithmsStruct *algs );



#ifdef __cplusplus
}
#endif