/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CFYEODialog.cp,v 1.1.2.5.2.1 1998/11/12 03:07:10 heller Exp $
____________________________________________________________________________*/

#include <ctype.h>

#include <URegistrar.h>
#include <LPushButton.h>
#include <LCheckbox.h>
#include <PP_Messages.h>
#include <UCursor.h>
#include <UDrawingState.h>
#include <UTextTraits.h>

#include "PGPclientLib.h"
#include "PGPclientLibDialogs.h"
#include "PGPclientLibUtils.h"
#include "pgpMem.h"

#include "CString.h"
#include "CFYEODialog.h"

namespace {
	const ResIDT	DLOG_FYEO				=	4774;
	const ResIDT	txtr_Courier10			=	4754;
	
	const ResIDT	PICT_TempestFontBase	=	4000;
	
	enum {
		STRx_FYEO	=	4774,
		kWarningID	=	1
	};
	
	const PaneIDT	view_Tempest				=	1000;
	const PaneIDT	button_OK					=	'bOK ';
	const PaneIDT	checkbox_UseTempestFont		=	1002;
	
	const MessageT	msg_UseTempestFont			=	checkbox_UseTempestFont;
	
	const UInt8		kTabSize	=	4;
	const UInt8		kIndent		=	2;
	
	const UInt16	kTempestFontHeight	=	14;
	const UInt16	kTempestFontWidth	=	8;
	const UInt16	kTempestMod			=	16;
	const SInt16	kTempestPictHeight	=	168;
	const SInt16	kTempestPictWidth	=	128;
}


	PGPError
PGPForYourEyesOnlyDialog(
	PGPContextRef	inContext,
	const char *	inString)
{
	PGPError			result;
	PGPclientLibState	state;
	
	PGPValidatePtr(inString);
	
	try {
		result = EnterPGPclientLib(inContext, &state);
		if (IsntPGPError(result)) {
			MessageT	message;
			
			UCursor::SetArrow();
			message = PGPUIWarningAlert(	kWACautionAlertType,
											kWAOKCancelStyle,
											STRx_FYEO,
											kWarningID);
			if (message == msg_OK) {
				DialogRef	theDialog;

				RegisterClass_(CFYEODialog);
				RegisterClass_(CTempestView);
				
				theDialog = CFYEODialog::CreateDialog(DLOG_FYEO);
				if (IsntNull(theDialog)) {
					CFYEODialog *	dialog = reinterpret_cast<CFYEODialog *>(
												::GetWRefCon(theDialog));
					
					pgpAssertAddrValid(dialog, VoidAlign);
					
					result = dialog->SetInfo(inContext, inString);
					if (IsntPGPError(result)) {
						result = dialog->DoDialog();
					}
					
					delete dialog;
					::DisposeDialog(theDialog);
				} else {
					result = kPGPError_OutOfMemory;
				}
			}
		}
		ExitPGPclientLib(&state);
	}
	
	catch (...) {
		result = kPGPError_UnknownError;
	}
	
	return result;
}
	
	
	
CFYEODialog::CFYEODialog(
	LStream *	inStream)
		: CPGPModalGrafPortView(inStream), mTempestView(nil)
{
	mWindowIsMoveable = true;
}



CFYEODialog::~CFYEODialog()
{
}



	PGPError
CFYEODialog::SetInfo(
	PGPContextRef	inContext,
	const char *	inString)
{
	PGPError		result = kPGPError_NoErr;

	mContext = inContext;
	mTempestView->SetString(inString);
		
	return result;
}



	void
CFYEODialog::FinishCreateSelf()
{
	CPGPModalGrafPortView::FinishCreateSelf();
	dynamic_cast<LPushButton &>(*FindPaneByID(button_OK)).AddListener(this);
	dynamic_cast<LCheckBox &>(*FindPaneByID(checkbox_UseTempestFont)).AddListener(this);
	mTempestView = &dynamic_cast<CTempestView &>(*FindPaneByID(view_Tempest));
}



	void
CFYEODialog::ListenToMessage(
	MessageT	inMessage,
	void *		ioParam)
{
	switch (inMessage) {
		case msg_UseTempestFont:
		{
			if (*reinterpret_cast<SInt32 *>(ioParam) != 0) {
				mTempestView->UseTempest(true);
			} else {
				mTempestView->UseTempest(false);
			}
			Refresh();
		}
		break;
			
			
		default:
		{
			CPGPModalGrafPortView::ListenToMessage(inMessage, ioParam);
		}
		break;
	}
}




CTempestView::CTempestView(
	LStream * inStream)
		: LView(inStream), mUseTempest(true), mResizeImage(true), mTempestFont(nil)
{
	Rect		bounds = {0, 0, 168, 128};
	SInt16		font = PICT_TempestFontBase + ((::TickCount() % 4) * 2) + 1;
	PicHandle	fontPict = ::GetPicture(font);
	
	PGPThrowIfNil_(fontPict);
	mTempestFont = new LGWorld(bounds, 0, useTempMem);
	PGPThrowIfNil_(mTempestFont);
	mTempestFont->BeginDrawing();
	::DrawPicture(fontPict, &bounds);
	mTempestFont->EndDrawing();
	::ReleaseResource(reinterpret_cast<Handle>(fontPict));
}



CTempestView::~CTempestView()
{
	delete mTempestFont;
}



	void
CTempestView::DrawSelf()
{
	StColorPenState		state;
	Rect				frame;
	UInt16				frameWidth;
	UInt16				charWidth;
	UInt16				lineHeight;
	UInt16				imageHeight = 0;
		
	state.Normalize();
	CalcLocalFrameRect(frame);
	frameWidth = (frame.right - kIndent) - (frame.left + kIndent);
	::MoveTo(kIndent, kIndent);
	
	// Get font info
	if (mUseTempest) {
		StColorState	colorState;
		RGBColor		color;
		
		mTempestFont->BeginDrawing();
		GetCPixel(0, 0, &color);
		mTempestFont->EndDrawing();
		lineHeight = kTempestFontHeight;
		charWidth = kTempestFontWidth;
		::RGBForeColor(&color);
		::PaintRect(&frame);
	} else {
		FontInfo	fontInfo;
		
		UTextTraits::SetPortTextTraits(txtr_Courier10);
		::GetFontInfo(&fontInfo);
		lineHeight = fontInfo.ascent + fontInfo.descent + fontInfo.leading;
		charWidth = ::CharWidth('m');
		::EraseRect(&frame);
		::Move(0, fontInfo.ascent);
	}
	
	// Adjust base image and draw chars
	const char *		currChar = mString;
	UInt16				numCharsToDraw = 0;
	UInt16				numCharsDrawn = 0;
	SPoint32			scrollUnit;
	
	GetScrollUnit(scrollUnit);
	scrollUnit.v = lineHeight;
	// Hack to prevent PP from screwing up our font
	{
		StTextState	textState;

		SetScrollUnit(scrollUnit);
	}
	imageHeight += lineHeight;
	while (*currChar != 0) {
		numCharsToDraw = GetNumCharsToDraw(currChar, numCharsDrawn, frameWidth, charWidth);
		if (numCharsToDraw > 0) {
			for (UInt16 i = 0; i < numCharsToDraw; i++) {
				if (mResizeImage) {
					::Move(charWidth, 0);
				} else if (mUseTempest) {
					Rect 	glyph;
					Rect 	location;
					Point	penLoc;
					
					::GetPen(&penLoc);
					::SetRect(&location, penLoc.h, penLoc.v, penLoc.h + charWidth,
						penLoc.v + lineHeight);
					if ((*currChar < ' ') || (*currChar > 126)) {
						glyph.top = 6 * lineHeight;
						glyph.left = 4 * charWidth;
					} else {
						glyph.top = ((*currChar - ' ') / kTempestMod) * lineHeight;
						glyph.left = ((*currChar - ' ') % kTempestMod) * charWidth;
					}
					glyph.bottom = glyph.top + lineHeight;
					glyph.right = glyph.left + charWidth;
					state.Normalize();
					::LockPixels(::GetGWorldPixMap(mTempestFont->GetMacGWorld()));
					::CopyBits(	&((GrafPtr)mTempestFont->GetMacGWorld())->portBits,
								&GetMacPort()->portBits,
								&glyph, &location, srcCopy, nil);
					::UnlockPixels(::GetGWorldPixMap(mTempestFont->GetMacGWorld()));
					::Move(charWidth, 0);
				} else {
					::DrawChar(*currChar);
				}
				currChar++;
			}
			numCharsDrawn += numCharsToDraw;
		} else {
			if ((! isspace(*currChar)) || (*currChar == '\r')) {
				Point	location;
				
				::GetPen(&location);
				::Move(-location.h + kIndent, lineHeight);
				imageHeight += lineHeight;
				numCharsDrawn = 0;
			} else {
				switch (*currChar) {
					case '\t':
					{
						UInt8	theTab = 4 - (numCharsDrawn % 4);
						
						numCharsDrawn += theTab;
						::Move(theTab * charWidth, 0);
					}
					break;
					
					
					case ' ':
					{
						::Move(charWidth, 0);
						numCharsDrawn++;
					}
					break;
					
					
					default:
					{
					}
					break;
				}
			}
			if (isspace(*currChar)) {
				currChar++;
			}
		}
	}
	
	if (mResizeImage) {
		SDimension32	imageSize;
		
		GetImageSize(imageSize);
		ResizeImageTo(imageSize.width, imageHeight + (2 * kIndent), false);
		mResizeImage = false;
		ScrollImageTo(0, 0, false);
		Refresh();
	}
}



	UInt16
CTempestView::GetNumCharsToDraw(
	const char *	inCurrChar,
	UInt16			inHowManyAlreadyDrawn,
	UInt16			inFrameWidth,
	UInt16			inCharWidth)
{
	UInt16	result = 0;
	UInt16	currentPoint = inHowManyAlreadyDrawn * inCharWidth;
	
	while ((*inCurrChar != 0) && (! isspace(*inCurrChar))
	&& ((currentPoint + inCharWidth) <= inFrameWidth)) {
		currentPoint += inCharWidth;
		result++;
		inCurrChar++;
	}
	
	if ((*inCurrChar != 0) && (! isspace(*inCurrChar)) && (inHowManyAlreadyDrawn > 0)) {
		result = 0;
	}
	
	return result;	
}


