/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CSplitWindow.cp,v 1.24.8.1 1998/11/12 03:08:19 heller Exp $
____________________________________________________________________________*/

#include <LowMem.h>

#include <LTableView.h>
#include <LTableMonoGeometry.h>
#include <LTableSingleSelector.h>
#include <LTableArrayStorage.h>
#include <LIconPane.h>
#include <LEditText.h>
#include <UGAColorRamp.h>
#include <URegistrar.h>
#include <UDesktop.h>
#include <UDrawingUtils.h>
#include <PP_Messages.h>
#include <Threads.h>
#include <string.h>

#include "CSplitWindow.h"

#include "CKeyTable.h"
#include "CPGPKeys.h"
#include "CKeyDragTask.h"
#include "ResourceConstants.h"

#include "pgpClientLib.h"
#include "pgpUserInterface.h"
#include "pgpFileSpec.h"
#include "pgpAdminPrefs.h"
#include "CGAProgressDialog.h"
#include "CPGPStDialogHandler.h"
#include "CComboError.h"
#include "CSecureMemory.h"
#include "CWarningAlert.h"
#include "GetPassphrase.h"

#include "pgpMem.h"
#include "pgpErrors.h"
#include "MacFiles.h"
#include "MacStrings.h"

const Int32	kMinimumRequiredShares	= 2;
const Int32 kMaximumSplitShares		= 255;

enum	{
			kStringListID		= 1022,
			kCreatingSharesStringID = 1,
			kSavingSharesStringID,
			kSplittingKeyStringID,
			kShareFileSuffixStringID,
			kSplitWarningStringID,
			kNameRequiredStringID,
			kNewHolderPassphraseStringID,
			kChooseShareFolderStringID
		};	

const ResIDT	dialog_AddShareholder		= 145;

PGPBoolean PGPGetDirectory(
	PGPBoolean		useWD,
	Int32 *			aDir,
	Int16 *			vref,
	PGPByte *		name );

CSplitWindow::CSplitWindow(LStream *inStream)
	:	LGADialog(inStream),
		LDragAndDrop( GetMacPort(), this )
{
	RegisterClass_(CShareholderList);
}

CSplitWindow::~CSplitWindow()
{
}

	void
CSplitWindow::FinishCreateSelf()
{
	LGADialog::FinishCreateSelf();

	( mHolderList = (CShareholderList *) FindPaneByID( kHolderList ) )->
		AddListener(this);
	mHolderList->InsertCols(1, 1, NULL, 0, TRUE);

	( mSplitKeyButton = (LPushButton *) FindPaneByID( kSplitKeyButton ) )->
		AddListener(this);
	( mRemoveButton = (LPushButton *) FindPaneByID( kRemoveHolderButton ) )->
		AddListener(this);
	( (LPushButton *) FindPaneByID( kSplitCancelButton ) )->
		AddListener( this );
	( (LPushButton *) FindPaneByID( kAddHolderButton ) )->
		AddListener( this );
	( mSelArrows = (LLittleArrows *) FindPaneByID( kShareArrows ) )->
		AddListener( this );
	( (LLittleArrows *) FindPaneByID( kReqdShareArrows ) )->
		AddListener( this );
	mScroller = (LActiveScroller *) FindPaneByID( kHolderScroller );
	mSplitName = (LStaticText *) FindPaneByID( kSplitKeyName );
	mSelName = (LStaticText *) FindPaneByID( kSelectedShareName );
	mReqdShares = (LStaticText *) FindPaneByID( kRequiredShareNum );
	mSelShares = (LStaticText *) FindPaneByID( kSelectedShareNum );
	mTotalShares = (LStaticText *) FindPaneByID( kTotalShareNum );
	mActiveSelection = FALSE;
}

	void
CSplitWindow::SetSplitKey(
	PGPKeyRef	key )
{
	PGPError		err;
	Str255			pstr;
	PGPSize			len;
	PGPInt32		alg;
	LIconPane *		skIcon;
	
	pgpAssert(PGPKeyRefIsValid(key));
	err = PGPGetKeyIDFromKey( key, &mKeyID );
	pgpAssertNoErr(err);
	err = PGPGetKeyNumber( key, kPGPKeyPropAlgID, (PGPInt32 *) &mAlgorithm );
	pgpAssertNoErr(err);

	err = PGPGetPrimaryUserIDNameBuffer( key, sizeof( pstr ) - 1,
					(char *) &pstr[1], &len);
	pgpAssertNoErr( err );
	pstr[0] = len - 1;
	mSplitName->SetDescriptor(pstr);
	err = PGPGetKeyNumber( key, kPGPKeyPropAlgID, &alg );
	pgpAssertNoErr( err );
	skIcon = (LIconPane *) FindPaneByID( kSplitKeyIcon );
	if( alg == kPGPPublicKeyAlgorithm_DSA )
		skIcon->SetIconID( kDSAKeyIconID );
	else
		skIcon->SetIconID( kRSAKeyIconID );
	
	Show();
}

SFReply		sSFReply;
Int32		sGoodDirID;

	static pascal Boolean
DirFilter(
	ParmBlkPtr				pbp)
{
	return TRUE;
}

	static pascal short
DirFileHook(
	Int16					item,
	DialogPtr				dialog)
{
	Int16	ret,
			iKind;
	Handle	iHandle;
	Rect	iRect;
	
	ret = item;
	switch( item )
	{
		case -1:
			break;
		case 11:
			if(sSFReply.fType)
			{
				sGoodDirID = sSFReply.fType;
				ret = 1;
			}
			break;
		case 12:
			sGoodDirID = LMGetCurDirStore();
			ret = 1;
			break;
		case 100:
			if( !sSFReply.fType )
			{
				GetDialogItem( dialog, 11, &iKind, &iHandle, &iRect );
				HiliteControl( (ControlHandle) iHandle, 0xFF );
			}
			else
			{
				GetDialogItem( dialog, 11, &iKind, &iHandle, &iRect );
				HiliteControl( (ControlHandle) iHandle, 0 );
			}
			YieldToAnyThread();
			break;
	}
	return ret;
}

	PGPBoolean
PGPGetDirectory(
	PGPBoolean		useWD,
	Int32 *			aDir,
	Int16 *			vref,
	PGPByte *		name )
{
	SFTypeList		typeList;
	FileFilterUPP	ffil;
	DlgHookUPP		dirHook;
	static Point	where={0,0};
	WDPBRec			pb;
	PGPByte			s[32];
	
	ffil	= NewFileFilterProc( DirFilter );
	dirHook = NewDlgHookProc( DirFileHook );
	UDesktop::Deactivate();
	SFPGetFile(where, "\p", ffil, -1, typeList, dirHook,
				&sSFReply, 2003, NULL);
	UDesktop::Activate();
	DisposeRoutineDescriptor(ffil);
	DisposeRoutineDescriptor(dirHook);
	if( sSFReply.good )
	{
		if(useWD)
		{
			*vref = -LMGetSFSaveDisk();
			*aDir = sGoodDirID;
		}
		else
		{
			pb.ioCompletion		= NULL;
			pb.ioNamePtr		= s;
			pb.ioVRefNum		= -LMGetSFSaveDisk();
			pb.ioWDIndex		= 0;
			pb.ioWDProcID		= 'ERIK';
			pb.ioWDVRefNum		= -LMGetSFSaveDisk();
			if( !PBGetWDInfoSync( &pb ) )
			{
				if( pb.ioNamePtr[0] < 28 )
				{
					CopyPString( pb.ioNamePtr, name );
					CopyPString( "\p:", name );
				}
				*aDir = sGoodDirID;
			}
		}
		return TRUE;
	}
	else
		return FALSE;
}

	PGPError
CSplitWindow::MakeShareFile(
	PGPShareRef				shareRef,
	ShareholderListEntry	*holder,
	Int32					dirID,
	Int16					vRefNum )
{
	CComboError				err;
	char					rawstr[256];
	short					strInx;
	Str255					pstr,
							numstr,
							suffix,
							prefix;
	FSSpec					fsSpec;
	PFLFileSpecRef			fsRef	= NULL;
	PGPShareFileRef			sfRef	= NULL;
	PGPShareRef				splitShares = NULL;
	PGPKeyRef				holderKey;
	PGPOptionListRef		encOptions = NULL;
	
	strcpy( rawstr, holder->name );
	strInx = strcspn(rawstr, "\\/:*?""<>|[]");
	rawstr[strInx] = '\0';
	while( ( strInx > 0 ) && ( rawstr[strInx - 1] == ' ' ) )
	{
		strInx--;
		rawstr[strInx] = '\0';
	}
	GetIndString( pstr, kStringListID, kShareFileSuffixStringID );
	NumToString( holder->numShares, numstr );
	PrintPString( suffix, pstr, numstr );
	CToPString( rawstr, prefix );
	while( prefix[0] + suffix[0] > 31 )
		--prefix[0];
	AppendPString( suffix, prefix );
	
	fsSpec.parID		= dirID;
	fsSpec.vRefNum		= vRefNum;
	CopyPString( prefix, fsSpec.name );
	err.err = FSpGetUniqueSpec( &fsSpec, &fsSpec );
	if( err.IsError() )
		goto done;
	err.err = FSpCreate( &fsSpec, kPGPMacFileCreator_Keys,
						kPGPMacFileCreator_SplitKey, smSystemScript );
	if( err.IsError() )
		goto done;
	err.pgpErr = PFLNewFileSpecFromFSSpec( gPGPMemoryMgr, &fsSpec, &fsRef );
	if( err.IsError() )
		goto done;
	err.pgpErr = PGPNewShareFile( fsRef, &sfRef );
	if( err.IsError() )
		goto done;
	err.pgpErr = PGPSetShareFileUserID( sfRef, holder->name );
	if( err.IsError() )
		goto done;
	err.pgpErr = PGPSplitShares( shareRef, holder->numShares, &splitShares );
	if( err.IsError() )
		goto done;
	if( holder->hasKey )
	{
		err.pgpErr = PGPSetShareFileOwnerKeyID( sfRef, holder->keyID );
		if( err.IsError() )
			goto done;
		err.pgpErr = PGPGetKeyByKeyID( CPGPKeys::TheApp()->GetKeySet(),
							&holder->keyID, holder->algorithm, &holderKey );
		if( err.IsError() )
			goto done;
		err.pgpErr = PGPBuildOptionList( gPGPContext, &encOptions,
							PGPOEncryptToKey( gPGPContext, holderKey ),
							PGPOLastOption( gPGPContext ) );
		if( err.IsError() )
			goto done;
	}
	else
	{
		err.pgpErr = PGPBuildOptionList( gPGPContext, &encOptions,
							PGPOConventionalEncrypt( gPGPContext,
								PGPOPassphrase( gPGPContext, holder->phrase ),
								PGPOLastOption( gPGPContext ) ),
							PGPOLastOption( gPGPContext ) );
		if( err.IsError() )
			goto done;
	}
	err.pgpErr = PGPCopySharesToFile( gPGPContext, sfRef, encOptions,
										splitShares );
	if( err.IsError() )
		goto done;
	err.pgpErr = PGPSaveShareFile( sfRef );
	if( err.IsError() )
		goto done;
done:
	if( IsntNull( encOptions ) )
		PGPFreeOptionList( encOptions );
	if( IsntNull( splitShares ) )
		PGPFreeShares( splitShares );
	if( IsntNull( sfRef ) )
		PGPFreeShareFile( sfRef );
	if( IsntNull( fsRef ) )
		PFLFreeFileSpec( fsRef );
	return( err.ConvertToPGPError() );
}

	void
CSplitWindow::Split()
{
	Int32				shareFileDirID;
	Int16				shareFileVRef;
	PGPError			err = kPGPError_NoErr;
	PGPByte				*passKey = NULL,
						*oldPassKey = NULL;
	PGPSize				passKeySize,
						oldPassKeySize;
	CSecureCString256	passphrase;
	Str255				pstr;
	PGPKeyRef			targetKey;
	PGPBoolean			wasSplit = FALSE;
	
	err = PGPGetKeyByKeyID( CPGPKeys::TheApp()->GetKeySet(),
						&mKeyID, mAlgorithm, &targetKey );	CKERR;
	
	// Ask user for directory to save Share Files
	if( !PGPGetDirectory( TRUE, &shareFileDirID, &shareFileVRef, NULL ) )
		goto done;
	
	// Reconstitute or get passphrase for target key and validate it
	{
		err = GetPassForKey( targetKey, &wasSplit, passphrase,
							&oldPassKey, &oldPassKeySize );	CKERR;
	}
	if( CWarningAlert::Display(kWACautionAlertType, kWAYesNoStyle,
					kStringListID, kSplitWarningStringID) != msg_OK )
		goto done;
	{
		CPGPStDialogHandler			dialogHandler( kProgressDialogResID, nil );
		CGAProgressDialog *			dialogObj;
		Int32						totalValue,
									reqdValue;
		PGPShareRef					shareRef;
		PGPInt32					algorithm;
		
		dialogObj = (CGAProgressDialog *)
					dialogHandler.GetDialog();
		totalValue = mTotalShares->GetValue();
		reqdValue = mReqdShares->GetValue();

		// Create Shares
		GetIndString( pstr, kStringListID, kCreatingSharesStringID );
		dialogObj->SetCaption( pstr );
		dialogObj->SetPercentComplete( 10 );
		dialogObj->Show();
		for( short eventIndex = 0; eventIndex < 4; eventIndex++ )
			dialogHandler.DoDialog();
		
		err = PGPCreateShares( gPGPContext, targetKey, reqdValue, totalValue,
								&shareRef );	CKERR;
		err = PGPGetPasskeyFromShares( shareRef, &passKey, &passKeySize );CKERR;
		
		// Create each share file
		dialogObj->SetPercentComplete( 25 );
		{
			Uint32					dataSize = sizeof(ShareholderListEntry);
			ShareholderListEntry	holder;
			TableIndexT				rows,
									cols,
									rowIndex;
			STableCell				cell(1,1);
			Int32					cellPercent;
			Str255					namestr,
									rawstr;
			
			mHolderList->GetTableSize( rows, cols );
			cellPercent = 70 / rows;
			for( rowIndex = rows; rowIndex > 0; rowIndex-- )
			{
				cell.row = rowIndex;
				mHolderList->GetCellData(cell, &holder, dataSize);
				
				GetIndString( rawstr, kStringListID, kSavingSharesStringID );
				CToPString( holder.name, namestr );
				PrintPString( pstr, rawstr, namestr ); 
				dialogObj->SetCaption( pstr );
				
				err = MakeShareFile( shareRef, &holder,
									shareFileDirID, shareFileVRef );	CKERR;
				dialogObj->SetPercentComplete( 25 +  cellPercent );
				cellPercent *= 2;
			}
		}
			
		// Lock target key with new split (always last)
		GetIndString( pstr, kStringListID, kSplittingKeyStringID );
		dialogObj->SetCaption( pstr );
		dialogObj->SetPercentComplete( 95 );
		err = PGPChangePassphrase( targetKey, wasSplit ?
					PGPOPasskeyBuffer( gPGPContext, oldPassKey, oldPassKeySize ) :
					PGPOPassphrase( gPGPContext, passphrase ),
					PGPOPasskeyBuffer( gPGPContext, passKey, passKeySize ),
					PGPOLastOption( gPGPContext ) );	CKERR;
		err = PGPGetKeyNumber(targetKey, kPGPKeyPropAlgID, &algorithm);	CKERR;
		if(algorithm == kPGPPublicKeyAlgorithm_DSA)
		{
			PGPKeyIterRef		keyIter;
			PGPSubKeyRef		subKey;
			
			err = PGPNewKeyIter( CPGPKeys::TheApp()->GetKeyList(), &keyIter );
			CKERR;
			PGPKeyIterSeek( keyIter, targetKey );
			while( IsntPGPError ( err ) &&
				IsntPGPError( PGPKeyIterNextSubKey( keyIter, &subKey ) ) &&
				IsntNull( subKey ) )
			{
				err = PGPChangeSubKeyPassphrase( subKey,wasSplit ?
					PGPOPasskeyBuffer( gPGPContext, oldPassKey, oldPassKeySize ) :
					PGPOPassphrase( gPGPContext, passphrase ),
					PGPOPasskeyBuffer( gPGPContext, passKey, passKeySize ),
					PGPOLastOption( gPGPContext ) );
			}
			PGPFreeKeyIter( keyIter );
		}
		CPGPKeys::TheApp()->CommitDefaultKeyrings();
		dialogObj->SetPercentComplete( 100 );
	}
	BroadcastMessage( kKeyTableRedrawMessage, NULL );
done:
	if( IsPGPError( err ) )
		ReportPGPError( err );
	if( IsntNull( passKey ) )
		PGPFreeData( passKey );
	if( IsntNull( oldPassKey ) )
		PGPFreeData( oldPassKey );
		
	return;
}

	void
CSplitWindow::ListenToMessage(
	MessageT	inMessage,
	void *		ioParam)
{
	STableCell				cell;
	ShareholderListEntry	holder;
	Uint32					dataSize;
	
	switch(inMessage)
	{
		case msg_OK:
			Hide();
			Split();
		case msg_Cancel:
		{	
			TableIndexT				rows,
									cols,
									rowIndex;
			STableCell				cell(1,1);
			
			dataSize = sizeof(ShareholderListEntry);
			mHolderList->GetTableSize( rows, cols );
			for( rowIndex = rows; rowIndex > 0; rowIndex-- )
			{
				cell.row = rowIndex;
				mHolderList->GetCellData(cell, &holder, dataSize);
				if( !holder.hasKey && IsntNull( holder.phrase ) )
					PGPFreeData( holder.phrase );
			}
			delete this;
			break;
		}
		case kReqdShareArrows:
		{
			Int32	newValue = *(long *)ioParam,
					value,
					totalValue;
			
			totalValue = mTotalShares->GetValue();
			value = mReqdShares->GetValue();
			if( newValue >= kMinimumRequiredShares )
			{
				value = newValue;
				mReqdShares->SetValue(value);
			}
			if( totalValue >= value )
				mSplitKeyButton->Enable();
			else
				mSplitKeyButton->Disable();
			break;
		}
		case kShareArrows:
			if( mActiveSelection )
			{
				Int32	oldValue,
						newValue,
						totalValue,
						reqdValue;
				
				dataSize = sizeof(ShareholderListEntry);
				mHolderList->GetCellData( mSelectedCell, &holder, dataSize );
				
				oldValue = holder.numShares;
				newValue = mSelArrows->GetValue();
				totalValue = mTotalShares->GetValue();
				reqdValue = mReqdShares->GetValue();
				
				if( totalValue + ( newValue - oldValue ) > kMaximumSplitShares )
				{
					mSelArrows->SetValue( oldValue );
					SysBeep( 1 );
				}
				else
				{
					mSelShares->SetValue( newValue );
					holder.numShares = newValue;
					mHolderList->SetCellData( mSelectedCell, &holder, dataSize );
					mHolderList->RefreshCell( mSelectedCell );
					totalValue += newValue - oldValue;
					mTotalShares->SetValue( totalValue );
					if( totalValue >= reqdValue )
						mSplitKeyButton->Enable();
					else
						mSplitKeyButton->Disable();
				}
			}
			break;
		case kRemoveHolderButton:
		{
			cell = mHolderList->GetFirstSelectedCell();
			if( cell.row > 0 )
			{
				ShareholderListEntry	holder;
				Uint32					dataSize = sizeof(ShareholderListEntry);
				Int32					totalValue,
										reqdValue;
				
				mHolderList->GetCellData( cell, &holder, dataSize );
				totalValue = mTotalShares->GetValue();
				reqdValue = mReqdShares->GetValue();
				totalValue -= holder.numShares;
				mTotalShares->SetValue( totalValue );
				if( totalValue < kMinimumRequiredShares )
				pgpClearMemory( &holder, sizeof( ShareholderListEntry ) );
				mHolderList->SetCellData( cell, &holder, dataSize );
				mHolderList->RemoveRows(1, cell.row, true);
				
				mRemoveButton->Disable();
				if( totalValue < reqdValue )
					mSplitKeyButton->Disable();
			}
			break;
		}
		case kAddHolderButton:
		{
			CPGPStDialogHandler addHolderDialog(dialog_AddShareholder,
												CPGPKeys::TheApp());
			LWindow				*window;
			MessageT			dialogMessage;
			Str255				stringValue;
			
			window = addHolderDialog.GetDialog();
		tryAgain:
			do
			{
				dialogMessage = addHolderDialog.DoDialog();
			} while( dialogMessage != msg_OK && dialogMessage != msg_Cancel );
			if(dialogMessage == msg_OK)
			{
				((LEditText *)window->FindPaneByID('eNam'))->
											GetDescriptor(stringValue);

				if (stringValue[ 0 ] == '\0')
				{
					CWarningAlert::Display(kWACautionAlertType, kWAOKStyle,
									kStringListID, kNameRequiredStringID);
					goto tryAgain;
				}
				else
				{
					char			*passphrase = NULL;
					Str255			pstr;
					char			cstr[256];
					PGPError		err;
					PGPInt32		totalValue,
									reqdValue;
#if PGP_BUSINESS_SECURITY
					PGPBoolean		enforceLength,
									enforceQuality;
					PGPUInt32		minLength,
									minQuality;
#endif
					
					
					GetIndString( pstr, kStringListID,
									kNewHolderPassphraseStringID );
					PToCString( pstr, cstr );
#if PGP_BUSINESS_SECURITY
					err = PGPGetPrefBoolean( gAdminPrefRef,
							kPGPPrefEnforceMinChars, &enforceLength);
					pgpAssertNoErr( err );
					err = PGPGetPrefBoolean( gAdminPrefRef,
							kPGPPrefEnforceMinQuality, &enforceQuality);
					pgpAssertNoErr( err );
					err = PGPGetPrefNumber( gAdminPrefRef,
							kPGPPrefMinChars, &minLength);
					pgpAssertNoErr( err );
					err = PGPGetPrefNumber( gAdminPrefRef,
							kPGPPrefMinQuality, &minQuality);
					pgpAssertNoErr( err );
#endif

					err = PGPConfirmationPassphraseDialog( gPGPContext,
							PGPOUIDialogPrompt( gPGPContext, cstr ),
							PGPOUIOutputPassphrase( gPGPContext, &passphrase ),
#if PGP_BUSINESS_SECURITY
							enforceLength ?
								PGPOUIMinimumPassphraseLength(
									gPGPContext, minLength ) :
								PGPONullOption( gPGPContext ),
							enforceQuality ?
								PGPOUIMinimumPassphraseQuality(
									gPGPContext, minQuality ) :
								PGPONullOption( gPGPContext ),
#endif
							PGPOLastOption( gPGPContext ) );
					
					if( IsPGPError( err ) )
						break;
					
					pgpClearMemory( &holder, sizeof(ShareholderListEntry) );
					PToCString( stringValue, holder.name );
					holder.phrase		= passphrase;
					holder.hasKey		= FALSE;
					holder.numShares	= 1;
					holder.algorithm	= kPGPPublicKeyAlgorithm_Invalid;
					mHolderList->InsertRows(1, 32767,
						&holder,
						sizeof(ShareholderListEntry),
						true);
					totalValue = mTotalShares->GetValue() + 1;
					mTotalShares->SetValue( totalValue );
					reqdValue = mReqdShares->GetValue();
					if( totalValue >= reqdValue )
						mSplitKeyButton->Enable();
					else
						mSplitKeyButton->Disable();
				}
			}
			break;
		}
		case kSLSelectionChangedMessageID:
		{
			cell = mHolderList->GetFirstSelectedCell();
			if( cell.row > 0 )
			{
				Uint32		dataSize = sizeof(ShareholderListEntry);
				Str255		str;

				mRemoveButton->Enable();
				mActiveSelection = FALSE;
				mHolderList->GetCellData( cell, &holder, dataSize );
				mSelArrows->SetValue( holder.numShares );
				mSelShares->SetValue( holder.numShares );
				CToPString( holder.name, str );
				mSelName->SetDescriptor( str );
				mActiveSelection = TRUE;
				mSelectedCell = cell;
			}
			else
			{
				mRemoveButton->Disable();
				mSelShares->SetDescriptor( "\p" );
				mSelName->SetDescriptor( "\p" );
				mActiveSelection = FALSE;
			}
			break;
		}
		
		default:
			LGADialog::ListenToMessage( inMessage, ioParam );
			break;
	}
}

	Boolean
CSplitWindow::ItemIsAcceptable(
	DragReference		inDragRef,
	ItemReference		inItemRef)
{
	Boolean			isAcceptable = FALSE;
	ushort			numFlavors;
	OSStatus		status;
	DragAttributes	attributes;
	
	GetDragAttributes(inDragRef, &attributes);
	status = CountDragItemFlavors(inDragRef, inItemRef, &numFlavors);
	if(IsntErr(status))
	{
		for(ushort flavorIndex = 1; flavorIndex <= numFlavors; flavorIndex++)
		{
			FlavorType	flavorType;
			
			status = GetFlavorType(inDragRef, inItemRef, flavorIndex,
									&flavorType);
			if(IsntErr(status))
			{
				switch(flavorType)
				{
					case kKeyDragFlavor:
						isAcceptable = TRUE;
						break;
				}
					
				if(isAcceptable)
					break;
			}
		}
	}
	return(isAcceptable);
}

	void
CSplitWindow::ReceiveDragItem(
	DragReference	inDragRef,
	DragAttributes	inDragAttrs,
	ItemReference	inItemRef,
	Rect			&/*inItemBounds*/)	// In Local coordinates
{
	Boolean			received = FALSE;
	ushort			numFlavors;
	OSStatus		status;
	Size			dropSize;
	
	status = CountDragItemFlavors(inDragRef, inItemRef, &numFlavors);
	if(IsntErr(status))
	{
		for(ushort flavorIndex = 1; flavorIndex <= numFlavors; flavorIndex++)
		{
			FlavorType	flavorType;
			
			status = GetFlavorType( inDragRef, inItemRef, flavorIndex,
									&flavorType );
			if( IsntErr( status ) )
			{
				status = GetFlavorDataSize( inDragRef, inItemRef,
											flavorType, &dropSize );
				if(	flavorType == kKeyDragFlavor &&
					dropSize == sizeof(PGPKeyRef) )
				{
					PGPKeyRef				key;
					
					status = GetFlavorData( inDragRef, inItemRef,
							flavorType, &key, &dropSize, 0 );
					pgpAssertNoErr( status );
					if( PGPKeyRefIsValid( key ) )
					{
						PGPError				err;
						ShareholderListEntry	holder;
						PGPBoolean				expired,
												revoked,
												disabled,
												canEncrypt;
						PGPKeyID				keyID;
						Boolean					keyIDOK = FALSE;
						Int32					totalValue,
												reqdValue;
						PGPInt32				alg;
						PGPSize					nameLen;
						
						err = PGPGetKeyBoolean( key, kPGPKeyPropIsRevoked,
								&revoked );
						pgpAssertNoErr( err );
						err = PGPGetKeyBoolean( key, kPGPKeyPropIsExpired,
								&expired );
						pgpAssertNoErr( err );
						err = PGPGetKeyBoolean( key, kPGPKeyPropIsDisabled,
								&disabled );
						pgpAssertNoErr( err );
						err = PGPGetKeyBoolean( key, kPGPKeyPropCanEncrypt,
								&canEncrypt );
						pgpAssertNoErr( err );
						err = PGPGetKeyIDFromKey( key, &keyID );
						if( IsntPGPError( err ) )
						{
							if( PGPCompareKeyIDs( &keyID, &mKeyID ) )
							{
								STableCell		cell(1,1);
								Uint32			dataSize =
													sizeof(ShareholderListEntry);
								TableIndexT		rows,
												cols,
												rowIndex;
								
								keyIDOK = TRUE;
								mHolderList->GetTableSize( rows, cols );
								for( rowIndex = rows; rowIndex > 0; rowIndex-- )
								{
									cell.row = rowIndex;
									mHolderList->GetCellData(cell, &holder,
															dataSize);
									if( holder.hasKey &&
										!PGPCompareKeyIDs(	&holder.keyID,
															&keyID ) )
									{
										keyIDOK = FALSE;
										break;
									}
								}
							}
						}
						if( !expired && !revoked && !disabled && canEncrypt &&
							keyIDOK )
						{
							pgpClearMemory( &holder,
								sizeof(ShareholderListEntry) );
							holder.numShares	= 1;
							holder.hasKey		= TRUE;
							err = PGPGetKeyIDFromKey( key, &holder.keyID );
							pgpAssertNoErr(err);
							err = PGPGetKeyNumber( key, kPGPKeyPropAlgID, &alg );
							pgpAssertNoErr(err);
							holder.algorithm = (PGPPublicKeyAlgorithm) alg;
							err = PGPGetPrimaryUserIDNameBuffer( key,
									kMaxShareholderUserIDLength + 1,
									holder.name, &nameLen );
							pgpAssertNoErr(err);

							mHolderList->InsertRows(1, 32767,
								&holder,
								sizeof(ShareholderListEntry),
								true);
							
							totalValue = mTotalShares->GetValue();
							reqdValue = mReqdShares->GetValue();
							mTotalShares->SetValue( ++totalValue );
							if( totalValue >= reqdValue )
								mSplitKeyButton->Enable();

							received = TRUE;
						}
					}
				}
				if(received)
					break;
			}
		}
	}
}

