/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	
	
	$Id: CPGPmenu.cp,v 1.22.2.2.2.1 1998/11/12 03:08:50 heller Exp $
____________________________________________________________________________*/


#include <string.h>

#include <UDrawingState.h>
#include <UEnvironment.h>
#include <URegistrar.h>

#include <LPushButton.h>
#include <LScrollBar.h>
#include <LScrollerView.h>
#include <LTextGroupBox.h>
#include <LTextEditView.h>
#include <LGAPushButtonImp.h>
#include <LStdScrollBarImp.h>
#include <LGATextGroupBoxImp.h>

#include "plugin.h"

#include "BETA.h"
#include "pgpLeaks.h"
#include "pgpMem.h"
#include "WarningAlert.h"
#include "MacStrings.h"
#include "pflPrefTypes.h"
#include "pgpClientPrefs.h"
#include "PGPUtilities.h"
#include "pgpOpenPrefs.h"
#include "pgpSDKPrefs.h"
#include "PGPSharedEncryptDecrypt.h"
#include "pgpKeys.h"
#include "pgpMacCustomContextAlloc.h"
#include "pgpClientErrors.h"
#include "pgpFeatures.h"

#include "CString.h"
#include "StSaveCurResFile.h"
#include "StSaveHeapZone.h"
#include "CRestorePortColorsAttachment.h"

#include "CmenuGetKeysPatch.h"
#include "CmenuMenuSelectPatch.h"
#include "CmenuSetMenuBarPatch.h"
#include "CmenuDrawMenuBarPatch.h"
#include "CmenuInsertMenuPatch.h"
#include "CmenuWaitNextEventPatch.h"
#include "CmenuPutScrapPatch.h"
#include "CmenuEventAvailPatch.h"
#include "CmenuGetResourcePatch.h"
#include "COutputDialog.h"
#include "CPGPmenu.h"

// Define the beta string
#if BETA
ConstStringPtr		kBetaHasExpired	=	"\pThis beta version of PGPmenu has"
										" expired and will now only decrypt"
										" and verify. Please contact the beta"
										" site or beta test coordinator for"
										" the latest version.";
#endif

// Define the demo string
#if PGP_DEMO
ConstStringPtr		kDemoHasExpired = 	"\pThank you for evaluating PGP. Your"
										" 30 day evaluation copy has expired."
										" You may continue to decrypt and"
										" verify messages for another 30"
										" days.";
#endif

// Globals
static SGlobals				sGlobals;
static UniversalProcPtr		sOldExitToShell =	nil;
static CPGPmenuPlug *		sPlugin			=	nil;
#if ! PGP_FINDERMENU
static PGPContextRef		sPGPContext		=	kInvalidPGPContextRef;
#endif

struct SMenuApps {
	PGPBoolean	privateScrap;
	PGPBoolean	useOutputDialog;
	OSType		creator;
	Str31		name;
};


// Constants
const SInt32	kSystem8 = 0x00000800;

// Termination routine declarations
#ifdef __cplusplus
	extern "C" {
#endif
	void __terminate(void);
#ifdef __cplusplus
	}
#endif



	pascal void
MyExitToShell()
{
	delete sPlugin;
	__terminate();
#if ! PGP_FINDERMENU

	if (PGPContextRefIsValid(sPGPContext)) {
		PGPFreeContext(sPGPContext);
	}
#endif
	::CallUniversalProc(	sOldExitToShell,
							kUPPExitToShellProcInfo);
}


	SInt32
main (
	ProcessInfoRec *	inProcInfoPtr,
	FSSpec *			inFSSpecPtr,
	Boolean				inPrivateScrap,
	Boolean				inUseOutputDialog)
{
#if PGP_FINDERMENU
	(void) inPrivateScrap;
	(void) inUseOutputDialog;
#endif

	SInt32	result = noErr;
	
	// Set debug info
	SetDebugThrow_(debugAction_LowLevelDebugger);
	SetDebugSignal_(debugAction_LowLevelDebugger);
	
	try {
		// zero the globals
		pgpClearMemory(&sGlobals, sizeof(sGlobals));

#if ! PGP_FINDERMENU
		PGPError	pgpErr;
		
		pgpErr = pgpNewContextCustomMacAllocators(&sPGPContext);
		PGPThrowIfPGPErr_(pgpErr);
		
		sGlobals.privateScrap = inPrivateScrap;
		sGlobals.useOutputDialog = inUseOutputDialog;
#endif
			// Create our plug object
			sPlugin = new CPGPmenuPlug(inProcInfoPtr, inFSSpecPtr);

			// Patch ExitToShell so that we properly unload our fragment
			UniversalProcPtr	newExitToShellUPP;

			sOldExitToShell = ::GetToolTrapAddress(_ExitToShell);
			newExitToShellUPP = (UniversalProcPtr) ::NewRoutineDescriptor(
									(ProcPtr) MyExitToShell,
									kUPPExitToShellProcInfo,
									GetCurrentArchitecture());
			if ((newExitToShellUPP == nil)
			|| (newExitToShellUPP == (UniversalProcPtr) MyExitToShell)) {
				PGPThrowOSErr_(kUnknownErr);
			}
			::SetToolTrapAddress(	(UniversalProcPtr) newExitToShellUPP,
									_ExitToShell);
	}
	
	catch (CComboError & comboError) {
		result = kUnloadPlug;
	}
	
	catch (...) {
		result = kUnknownErr;
	}
	
	return result;
}



CPGPmenuPlug::CPGPmenuPlug(
	ProcessInfoRec *	inProcInfoPtr,	// Proc info for captured browser
	FSSpec *			inFSSpecPtr)	// FSSpec for this plugin
		: mGlobals(sGlobals)
{
	StSaveHeapZone		savedZone(::SystemZone());
	OSStatus			err = kNoErr;

#if ! PGP_FINDERMENU
	PGPFlags			featureFlags;

	if (IsntPGPError(PGPGetFeatureFlags(kPGPFeatures_GeneralSelector,
	&featureFlags))) {
		mGlobals.disableEncrypt = ! PGPFeatureExists(
										featureFlags,
										kPGPFeatureMask_CanEncrypt);
		mGlobals.disableSign = ! PGPFeatureExists(
									featureFlags,
									kPGPFeatureMask_CanSign);
		mGlobals.disableDecrypt = ! PGPFeatureExists(
										featureFlags,
										kPGPFeatureMask_CanDecrypt);
		mGlobals.disableVerify = ! PGPFeatureExists(
										featureFlags,
										kPGPFeatureMask_CanVerify);
	} else {
#endif
		mGlobals.disableEncrypt = false;
		mGlobals.disableSign = false;
		mGlobals.disableDecrypt = false;
		mGlobals.disableVerify = false;
		
#if ! PGP_FINDERMENU
	}
#endif

// Handle beta and demo code
#if BETA || PGP_DEMO
#if BETA
	if (BetaExpired()) {
		ConstStringPtr	theString = kBetaHasExpired;
#endif

#if PGP_DEMO
	PGPDemoState	theState = GetDemoState();
	
	if (theState == kDemoStateExpired) {
		PGPThrowOSErr_(kUnloadPlug);
	} else if (theState == kDemoStateEncryptionSigningDisabled) {
		ConstStringPtr theString = kDemoHasExpired;
#endif

		StringPtr	noteString = (StringPtr) ::NewPtr(theString[0] + 1);
		NMRecPtr	theNotificationRecP =
						(NMRecPtr) ::NewPtrClear(sizeof(NMRec));
		
		if ((noteString != nil) && (theNotificationRecP != nil)) {
			::BlockMoveData(	theString,
								noteString,
								theString[0] + 1);
			theNotificationRecP->qType = nmType;
			theNotificationRecP->nmSound = (Handle) -1;
			theNotificationRecP->nmStr = noteString;
			theNotificationRecP->nmResp = (NMUPP) -1;
			
			::NMInstall(theNotificationRecP);
		}
		mGlobals.disableEncrypt = true;
		mGlobals.disableSign = true;
	}
#endif

#if ! PGP_FINDERMENU
	mGlobals.mungeDialogs = false;
	
	// Save the PGPContextRef
	mGlobals.pgpContext = sPGPContext;
	PGPsdkLoadDefaultPrefs(sPGPContext);
#endif
	
	// Save away our FSSpec and ProcInfo
	mGlobals.processProcInfo = *inProcInfoPtr;
	mGlobals.processSpec = *inProcInfoPtr->processAppSpec;
	::BlockMoveData(	inProcInfoPtr->processName,
						mGlobals.processName,
						inProcInfoPtr->processName[0] + 1);
	mGlobals.processProcInfo.processAppSpec = &mGlobals.processSpec;
	mGlobals.processProcInfo.processName = mGlobals.processName;
	mGlobals.plugSpec = *inFSSpecPtr;
	
	// Find QDGlobals
	UQDGlobals::SetQDGlobals((QDGlobals*)(*((long*)::LMGetCurrentA5()) -
							(sizeof(QDGlobals) - sizeof(GrafPtr))));
	
	// Set the ColorQD environment variable
	Int32		qdVersion = gestaltOriginalQD;
	
	::Gestalt(gestaltQuickdrawVersion, &qdVersion);
	UEnvironment::SetFeature(	env_SupportsColor,
							 	(qdVersion > gestaltOriginalQD));
	
#if ! PGP_FINDERMENU
	// Register classes
	RegisterClass_(LPushButton);
	RegisterClass_(LScrollerView);
	RegisterClass_(LTextEditView);
	RegisterClass_(COutputDialog);
	RegisterClass_(CRestorePortColorsAttachment);
	RegisterClass_(LTextGroupBox);
	RegisterClassID_(LGAPushButtonImp, LPushButton::imp_class_ID);
	RegisterClassID_(LGATextGroupBoxImp, LTextGroupBox::imp_class_ID);
	RegisterClassID_(LStdScrollBarImp, LScrollBar::imp_class_ID);
	CPGPEncoderDecoder::Init(sPGPContext);
#endif
	
	// We've got all of the info we need from the app, so we now open our
	// resources
	LFile	thePlugFile(mGlobals.plugSpec);
	
	thePlugFile.OpenResourceFork(fsRdWrPerm);
	
	// Add patches
	new CmenuDrawMenuBarPatch(mGlobals);
	new CmenuInsertMenuPatch(mGlobals);
	new CmenuSetMenuBarPatch(mGlobals);
	new CmenuMenuSelectPatch(mGlobals);
	new CmenuWaitNextEventPatch(mGlobals);

#if ! PGP_FINDERMENU
	new CmenuPutScrapPatch(mGlobals);
	new CmenuGetKeysPatch(mGlobals);
	new CmenuEventAvailPatch();
	new CmenuGetResourcePatch(mGlobals);
#endif
	
	thePlugFile.CloseResourceFork();
};



CPGPmenuPlug::~CPGPmenuPlug()
{
#if ! PGP_FINDERMENU
	CPGPEncoderDecoder::Cleanup();
#endif
}



	void
CPGPmenuPlug::ShowError(
	PGPError	inErr)
{
	CString		theErrorString;
	
	PGPGetClientErrorString(	inErr,
								theErrorString.GetBufferSize() + 1,
								theErrorString);
	WarningAlert(	kWAStopAlertType,
					kWAOKStyle,
					STRx_Errors,
					kErrorStringID,
					CString(inErr),
					theErrorString);
}
