/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	

	$Id: CPGPtoolsWipeTask.h,v 1.12.8.1 1998/11/12 03:09:23 heller Exp $
____________________________________________________________________________*/
#pragma once

#include "pgpMacWiping.h"

#include "CPGPtoolsTask.h"
	

class CPGPtoolsWipeTask : public CPGPtoolsTask
{
	friend class CMyWiper;
	
private:
	CPGPtoolsTaskProgressDialog	*mProgress;


public:
						CPGPtoolsWipeTask( const FSSpec *spec );
	virtual				~CPGPtoolsWipeTask(void);
							
	virtual	OSStatus	CalcProgressBytes(PGPContextRef context,
							ByteCount *bytes);
	virtual void		GetTaskItemName(StringPtr name);
	
	virtual CToolsError	Wipe(PGPContextRef context,
							CPGPtoolsTaskProgressDialog * progressDialogObj );

protected:
	
	FSSpec				mWipeSpec;
	PGPUInt32			mNumWipePasses;
	UInt32				mAllocBlockSize;
	/* careful, it should be able to hold more then 2^32 bytes */
	PGPUInt64			mTotalBytesToWipe;
	UInt32				mTotalFilesToWipe;
	UInt32				mNumLockedFiles;
	UInt32				mNumOpenFiles;
	PGPWipingPattern	*mPatternList;
	void				*mWipeBuffer;
	UInt32				mWipeBufferSize;
	
	PGPUInt64			mCurFileBytesWiped;
	
	PGPUInt64			CalcFileSize( const CInfoPBRec *cpb );
	void				PrescanFile( const CInfoPBRec *	cpb);
	OSStatus			PrescanFolder( short vRefNum, long dirID );
	OSStatus			Prescan( void );
	
	
	UInt32				GetScaledProgress( PGPUInt64 num );
	OSStatus			WipeHook( ConstStringPtr fileName,
							PGPUInt64 additionalDone );
	OSStatus			WipeFile( const FSSpec *spec );
	OSStatus			WipeFolder( short vRefNum, long dirID );
	CToolsError			WipeSpec( const FSSpec *spec );
};