/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: PGPtoolsEncryptDecrypt.h,v 1.10.8.1 1998/11/12 03:09:30 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <PP_Types.h>

#include "MacCursors.h"

#include "PGPSharedEncryptDecrypt.h"

const OSType	kPGPMacFileTypeMacPGPEncryptedData = 'Cryp';

typedef struct AnimatedCursorAnalyzeCallbackInfo
{
	AnimatedCursorRef	animatedCursor;
	Boolean				userAborted;

} AnimatedCursorAnalyzeCallbackInfo;

void		GetDefaultEncryptSignName(ConstStringPtr srcName,
						Boolean textOutput, Boolean detachedSignature,
						StringPtr destName );
void		GetDefaultEncryptSignFSSpec(const FSSpec *sourceSpec,
						Boolean textOutput, Boolean detachedSignature,
						FSSpec *destSpec);
Boolean		GetDefaultDecryptVerifyFSSpec(const FSSpec *sourceSpec,
						FSSpec *destSpec);
Boolean		GetDefaultDecryptVerifyName(ConstStringPtr srcName,
						StringPtr destname );
Boolean		GetDetachedSigFileSourceSpec(const FSSpec *sigSpec,
						FSSpec *sourceSpec);
PGPError	AnimatedCursorAnalyzeCallbackProc(void *arg, size_t soFar,
						size_t total);
