/*____________________________________________________________________________
	DebugTrapsOff.h
____________________________________________________________________________*/


#pragma once

#if USE_MAC_DEBUG_TRAPS	// [

/*
This file defeats the debugging traps mechanism for all debugging traps.
To turn off debugging traps in an individual file, #include this file
after #including DebugTraps.h
(which is typically #included in a global prefix file).

This may be necessary in a few rare circumstances where mutual recursion
between DebugTraps and other debugging code occurs.

You can also #undef an individual routine if it's a single routine
that's a problem.

How to generate this file:
	This file is derived from DebugTraps.h. If you change DebugTraps.h,
	do not edit this file. Instead, generate a new file as follows:
	1. Copy all #defines from DebugTraps.h to a scratch window
	2. globally replace all #define with #undef
	3. using grep, strip text after the #undef'd symbol
	3. strip any other extraneous stuff from this file
	4. save
*/


// ___________________________ Memory Manager ______________________________

#undef BlockMove				
#undef BlockMoveData			
#undef NewPtr
#undef NewPtrClear
#undef NewPtrSys			
#undef NewPtrSysClear
#undef GetPtrSize				
#undef SetPtrSize				
#undef PtrZone					
#undef DisposePtr				
#undef PtrToHand
#undef NewHandle
#undef NewHandleClear
#undef NewHandleSys
#undef NewHandleSysClear
#undef GetHandleSize			
#undef SetHandleSize			
#undef ReallocateHandle		
#undef DisposeHandle			
#undef HLock					
#undef HUnlock					
#undef HGetState				
#undef HSetState				
#undef HandAndHand				
#undef HandToHand
#undef HPurge					
#undef HNoPurge				
#undef EmptyHandle				
#undef HandleZone				
#undef RecoverHandle			
#undef RecoverHandleSys		
#undef SetZone					
#undef GetZone					
#undef TempNewHandle
#undef TempDisposeHandle		
#undef MoveHHi					
#undef PtrAndHand				


// __________________________ Resource Manager _______________________________
				

#undef ReleaseResource

#undef CloseResFile
#undef HomeResFile
#undef CreateResFile
#undef OpenResFile
#undef UseResFile
#undef GetIndType
#undef Get1IndType
#undef GetIndResource
#undef Get1IndResource
#undef GetResource
#undef Get1Resource
#undef GetNamedResource
#undef Get1NamedResource
#undef LoadResource
#undef ReleaseResource
#undef DetachResource
#undef GetResAttrs
#undef GetResInfo
#undef SetResInfo
#undef AddResource
#undef GetResourceSizeOnDisk
#undef GetMaxResourceSize
#undef RsrcMapEntry
#undef SetResAttrs
#undef ChangedResource
#undef RemoveResource
#undef UpdateResFile
#undef WriteResource
#undef GetResFileAttrs
#undef SetResFileAttrs
#undef OpenRFPerm
#undef HOpenResFile
#undef HCreateResFile
#undef FSpOpenResFile
#undef FSpCreateResFile
#undef ReadPartialResource
#undef WritePartialResource
#undef SetResourceSize
#undef GetNextFOND




// _____________________________ Quickdraw _________________________________

#undef NewRgn
#undef DisposeRgn



// _____________________________ Menu Manager _________________________________

#undef NewMenu
#undef DisposeMenu
#undef GetMenuBar
#undef GetNewMBar


// _____________________________ Icons _________________________________

#undef NewIconSuite
#undef DisposeIconSuite
#undef GetIconSuite


// _____________________________ Alias Manager _____________________________
#undef NewAlias
#undef NewAliasMinimal
#undef NewAliasMinimalFromFullPath


// _____________________________ Apple Event related _________________________
#undef AECreateDesc
#undef AECoercePtr
#undef AECoerceDesc
#undef AEDisposeDesc
#undef AEDuplicateDesc
#undef AECreateList
#undef AEGetNthDesc
#undef AEGetAttributeDesc
#undef AECreateAppleEvent
#undef AESend
#undef AEGetTheCurrentEvent
#undef AEResolve
#undef CreateOffsetDescriptor
#undef CreateCompDescriptor
#undef CreateLogicalDescriptor
#undef CreateObjSpecifier
#undef CreateRangeDescriptor



// _____________________________ Window Mgr _________________________________

#undef GetNewWindow
#undef NewWindow
#undef GetNewCWindow
#undef NewCWindow
#undef DisposeWindow
#undef CloseWindow


// _____________________________ Dialog Mgr _________________________________

#undef NewDialog
#undef GetNewDialog
#undef DisposeDialog
#undef CloseDialog
#undef ModalDialog
#undef Alert
#undef StopAlert
#undef NoteAlert
#undef CautionAlert

// _____________________________ Graphics _________________________________
#undef DisposeGDevice
#undef DisposeCTable


// _____________________________ File Mgr _________________________________
#undef FSpCreate

	
#endif // ] USE_MAC_DEBUG_TRAPS