/*____________________________________________________________________________
	Copyright (C) 1998 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPNodeArrayTree.cp,v 1.1.2.1.4.1 1998/11/12 03:19:16 heller Exp $
____________________________________________________________________________*/

#include "CPGPNodeArrayTree.h"

CPGPNodeArrayTree::CPGPNodeArrayTree()
	  : LNodeArrayTree()
{
}

CPGPNodeArrayTree::~CPGPNodeArrayTree()
{
}

// The PowerPlant implementation of this function has a bug where it returns
// only the number of rows revealed by the root node. If the root is already
// revealed, the PP implementation always returns zero even though some
// subnodes may have been expanded in the process.

	Uint32
CPGPNodeArrayTree::DeepExpandNode(Uint32 inWideOpenIndex)
{
	SHierarchyNode	*expandedNode;
	Uint32			revealedRows = 0;

	if (!mHierarchyArray.FetchItemAt((Int32) inWideOpenIndex, &expandedNode)) {
		SignalPStr_("\pInvalid index for Node to Deep Expand");
		return 0;
	}
	
										// Expand all descendents
	Uint32	lastDescendent = inWideOpenIndex +
								CountAllDescendents(inWideOpenIndex);
	for (Uint32 i = inWideOpenIndex + 1; i <= lastDescendent; i++) {
		revealedRows += ExpandNode(i);
	}
	
	revealedRows += ExpandNode(inWideOpenIndex);	// Expand this Node
	
	return revealedRows;
}
