/*____________________________________________________________________________
	Copyright (C) 1996,1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: MacStrings.h,v 1.18.12.1 1998/11/12 03:19:49 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <Resources.h>

#include "pgpBase.h"
#include "pgpTypes.h"

PGP_BEGIN_C_DECLARATIONS
#if PRAGMA_IMPORT
#pragma import on
#endif

#ifdef __cplusplus
	inline unsigned char
StrSize(ConstStr255Param string) 
{
	return ( 1UL + string[ 0 ] );
}
#else
#define StrSize(string) ( 1UL + string[ 0 ] )
#endif

void	NumVersionToString(const NumVersion *version, StringPtr versionString);
void	VersionToString(UInt16 version, StringPtr versionString);

void	CopyPString(ConstStr255Param srcStr, StringPtr destStr);
void	CopyPStringMax(ConstStr255Param srcStr, StringPtr destStr,
			UInt32 maxBytesToCopy);
void	AppendPString(ConstStr255Param	appendStr, StringPtr destStr);
void	AppendPStringMax(ConstStr255Param	appendStr, StringPtr destStr,
			UInt32 maxBytesToAppend);
void	InsertInPString(const uchar *source, uchar offset, uchar *dest);
void	DeleteFromPString(uchar *string, uchar offset, uchar count);
void	PrintPString(uchar *dest, const uchar *formatStr,
			const uchar *stringToPut);
Boolean	PStringsAreEqual(const uchar *str1, const uchar *str2);

Boolean	PStringHasSuffix( ConstStr255Param str,
			ConstStr255Param suffix, Boolean caseSensitive );
	
void	CToPString(const char *cString, StringPtr pString);
void	PToCString(ConstStr255Param pString, char * cString);

void	GetIndCString(char theString[256], ResID stringListResID,
					short stringListIndex);



/* Use this if you don't want to link in ANSI */
char *	CopyCString( const char *	src, char *	 dest );

OSErr	AppendStringToHandle( Handle theHandle, ConstStr255Param	string );


/* str1, str2 and str3 may be null */
void	InsertPStrings( ConstStr255Param baseString,
			ConstStr255Param str1, ConstStr255Param str2,
			ConstStr255Param str3, StringPtr resultString );

#if PRAGMA_IMPORT
#pragma import reset
#endif
PGP_END_C_DECLARATIONS





