/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.
	
	$Id: CPGPConfPassphraseGrafPort.h,v 1.4.10.1 1998/11/12 03:20:29 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPPassphraseGrafPortView.h"

class LProgressBar;

class CPGPConfPassphraseGrafPortView : public CPGPPassphraseGrafPortView
{
public:

	enum
	{
		class_ID = 'CPGP',
		
		kConfirmationEditFieldPaneID 	= 'eCnf',
		kPassphraseQualityBarPaneID		= 'Qual',
		kPassphraseQualityCaptionPaneID	= 'QCap',
		
		msg_ChangedConfirmation			= kConfirmationEditFieldPaneID
	};

						CPGPConfPassphraseGrafPortView(LStream *inStream);
	virtual				~CPGPConfPassphraseGrafPortView();

	virtual void		ClearPassphrase(void);
	virtual	void		ListenToMessage(MessageT inMessage, void *ioParam);

	PGPError			SetOptions(PGPContextRef context,
							CPGPConfirmationPassphraseDialogOptions *options);

protected:

	CPassphraseEdit		*mConfirmationEdit;
	LProgressBar		*mPassphraseQualityBar;

	virtual void		FinishCreateSelf(void);
	virtual	MessageT	HandleMessage(MessageT theMessage);

private:

	const CPGPConfirmationPassphraseDialogOptions	*mOptions;
};
