/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates, Inc. and its affiliates.
	All rights reserved.

	$Id: PGPsdkUILibInitAndTerm.cp,v 1.1.14.1 1998/11/12 03:21:05 heller Exp $
____________________________________________________________________________*/

#include "pgpConfig.h"

#include <CodeFragments.h>
#include <Gestalt.h>

#include "MacBasics.h"
#include "PGPsdkUILibUtils.h"
#include "pgpDebug.h"
#include "pgpMem.h"

PGP_BEGIN_C_DECLARATIONS

pascal OSErr 	INIT_PGPsdkUILib(CFragInitBlock *initBlock);
pascal void		TERM_PGPsdkUILib(void);

pascal OSErr __initialize(const CFragInitBlock *theInitBlock);
pascal OSErr __terminate(void);

PGP_END_C_DECLARATIONS

/* Disable 68020 code generation for the 68020 check itself */
#if GENERATING68K
	#pragma code68020 off
#endif

	pascal OSErr
INIT_PGPsdkUILib(CFragInitBlock *initBlock)
{
	long	gestaltResult;
	OSErr	err = noErr;
	
	/*
	** Check for a 68020 or later processor and bail immediately if
	** none is available. It is assumed that all clients of this
	** library are doing a similar chack and refusing to run.
	*/
	
	if( Gestalt( gestaltProcessorType, &gestaltResult ) == noErr &&
		gestaltResult >= gestalt68020 )
	{
		err = __initialize( initBlock );
		if( IsntErr( err ) )
		{
			/*
			** Remember the FSSpec of the library file se we can open it's
			** resource fork later.
			*/
			
			if( IsntNull( initBlock ) )
			{
				err = SetLibraryFSSpec(
					initBlock->fragLocator.u.onDisk.fileSpec );
			}
			else
			{
				/* Actual error is not important here */
				
				pgpDebugMsg( "INIT_PGPsdkUILib: No initBlock" );
				err = -1;
			}
		}

		pgpLeaksBeginSession( "PGPsdkUILib" );
	}
	
	pgpAssert( err == noErr );

	return( err );
}

	pascal void
TERM_PGPsdkUILib(void)
{
	long	gestaltResult;

	if( Gestalt( gestaltProcessorType, &gestaltResult ) == noErr &&
		gestaltResult >= gestalt68020 )
	{
		pgpLeaksEndSession();
	}
	
	__terminate();
}

#if GENERATING68K
	#pragma code68020 reset
#endif





/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
