/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: pgpIPsecBuffer.h,v 1.2.10.3 1999/09/30 18:43:01 dgal Exp $
____________________________________________________________________________*/
#ifndef Included_pgpIPsecBuffer_h	/* [ */
#define Included_pgpIPsecBuffer_h

#include "pgpPubTypes.h"
#include "pgpMemoryMgr.h"

typedef struct _PGPIPsecBuffer PGPIPsecBuffer;

struct _PGPIPsecBuffer
{
	PGPByte *		data;
	PGPUInt32		dataSize;
	PGPUInt32		allocatedSize;
	PGPIPsecBuffer *next;
};

#endif /* ] Included_pgpIPsecBuffer_h */


PGPError PGPCopyIPsecBuffer(PGPIPsecBuffer *inBuffer, PGPUInt32 inStart,
			PGPIPsecBuffer *outBuffer, PGPUInt32 outStart, PGPUInt32 numBytes);

PGPBoolean PGPIPsecBufferDataIsEqual(PGPIPsecBuffer *inBuffer, 
			PGPUInt32 inStart, PGPIPsecBuffer *outBuffer, PGPUInt32 outStart,
			PGPUInt32 numBytes);

/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
