/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	

	$Id: Lister.c,v 1.64.4.1.6.14 1999/10/11 20:35:12 philipn Exp $
____________________________________________________________________________*/

/*
 * Lister - Lists all network adapters on the machine
 *          the user selects the desired adapter(s)
 *          then this information is passed on.
 *
 */


/*
 * This is for reference
 *# NetBT\Linkage
 * LanmanServer\Linkage
 * LanmanWorkstation\Linkage
 * RemoteAccess\Linkage
 * NetBIOS\Linkage
 * Tcpip\Linkage
 */
#pragma message( "Compiling " __FILE__ ) 
#pragma message( "Last modified on " __TIMESTAMP__ ) 

#include <windows.h>
#include <windowsx.h>
#include <winreg.h>
#include <commctrl.h>
#include <stdio.h>
#include <stdlib.h>
#include <wchar.h> 
#include <mbstring.h>
#include "BuildFlags.h"
#include "globals.h"
#include "resource.h"
#include "Define.h"
#include "Lister.h"


const		DWORD INFINSTALL_PRIMARYINSTALL		= 0x00000001;
const		DWORD INFINSTALL_INPROCINTERP		= 0x00000002;
const		DWORD INFINSTALL_SUPPORTED			= 0x00000003;


/*___________________________________________________________________________
 *	Program Entry Point
 */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	HKEY		hMainKey	= HKEY_LOCAL_MACHINE;
	HKEY		hOpenKey	= NULL;
	HWND		hwnd;
	MSG			msg;
	WNDCLASSEX	wndclass;
	UINT		nBufferLengthMax = 1024;
	LPBYTE		pData		= NULL;

	/*Ensure Common control Dll is loaded*/
	InitCommonControls();

	bSansCmdLine = FALSE;
	bDelReg		 = FALSE;
	bRunOnce	 = FALSE;
	
	/*check windows version*/
	if (IsCorrectVersion() == FALSE)
	{
		MessageBox (GetFocus(), WRONGOS, szAppName, 0 | MB_ICONERROR);
		exit(0);
	}

	/*check the command line*/
	bSilentInstall = FALSE;

	/*void cmdline is ran from runonce this is to fix the problem with 
	  the sys32 dir. popping up when the runonce contains a value
	  but no data*/

	if (strcmp(szCmdLine, "void") == 0)
	{
		exit(0);
	}
	if (strcmp(szCmdLine, INSTALL) == 0)
	{
		goto begin;
	}

	if (strcmp(szCmdLine, "") == 0)
	{
		bSansCmdLine = TRUE;
		goto begin;
	}
	else if (strcmp(szCmdLine, INSTALLSILENT) == 0)
	{
		bSilentInstall = TRUE;
		goto begin;
	}
	else if (strcmp(szCmdLine, BINDREVIEW) == 0)
	{
		hwnd = GetDesktopWindow();
		BindReview(hwnd);
		goto done;
	}
	else if (((strcmp(szCmdLine, UNINSTALL) == 0) || 
			(strcmp(szCmdLine, "uninstall ") == 0)))	     
	{
		if (bIsNT)
		{
			HWND hDeskTop = NULL;
			DeleteRebindKey ();
			/*uninstall pgpnet nt*/
			RemovePGPnetServices ();
			RemovePGPnetSoftwareLinkKeys ();
			RemoveNetworkCardEntries ();
			/*delete current secured card list*/
			RegDeleteKeyNT (HKEY_LOCAL_MACHINE, PATHTOADAPTERLIST);	
			/*restore protocols*/
			RefreshProtocols ();
			/*delete protocol backup*/
			RegDeleteKeyNT (HKEY_LOCAL_MACHINE, PROTOBACKUPKEY);
			/*get handle to desktop*/
			hDeskTop = GetDesktopWindow();
			/*run binding engine*/
			BindReview	(hDeskTop);
		}
		else
		{
			Remove95(CLASSNETTRANS, 0);
			Remove95(ROOTNET, 1);
			Remove95(CLASSNET, 0);
		}
		goto done;
	}

	/*usageerror*/
	MessageBox (GetFocus(), USAGEERROR, "", 0 | MB_ICONERROR);
	goto done;
	
begin: 
	/*Get global instance handle*/
	g_hInstance = hInstance;

	/* Setup new window class */
	ZeroMemory(&wndclass, sizeof(wndclass));

	wndclass.cbSize			= sizeof(wndclass);
	wndclass.style			= CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	= WndProc;
	wndclass.cbClsExtra		= 0;
	wndclass.cbWndExtra		= 0;
	wndclass.hInstance		= hInstance;
	wndclass.hIcon			= LoadIcon(hInstance, "lister");
	wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;
	wndclass.hIconSm		= LoadIcon(hInstance, "lister");

	/* Register the window class */
	RegisterClassEx(&wndclass);

    /*Is there another version of this application running? If so, 
      we just bring it to the foreground.*/
    hwnd = FindWindow (szAppName, NULL);
    if (hwnd) 
    {
        /*Found another one!*/
        if (IsIconic(hwnd)) 
        {
            ShowWindow(hwnd, SW_RESTORE);
        }
        SetForegroundWindow (hwnd);
        return FALSE;
    }

	/* Create a window using the new window class */
						/*window class name*/
	hwnd = CreateWindow(szAppName,		
						/*window caption*/
						szAppName,	
						/*window style*/
						WS_OVERLAPPEDWINDOW,			 
						/*initial x position*/
						CW_USEDEFAULT,		
						/*initial y position*/
						CW_USEDEFAULT,			
						/*initial x size*/
						CW_USEDEFAULT,
						/*initial y size*/
						CW_USEDEFAULT,
						/*parent window handle*/
						NULL,							 
						/*window menu handle*/
						NULL,
						/*program instance handle*/
						hInstance,	
						/*creation parameters*/
						NULL);							 

	/* Start the message loop */
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;

done:
	return FALSE;
}


/*___________________________________________________________________________
 *	Window Procedure
 */
LRESULT CALLBACK WndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	/* Use message cracker macros to process messages */
	switch (iMsg)
	{
		case WM_CREATE:
			return HANDLE_WM_CREATE(hwnd, wParam, lParam, Lister_OnCreate);

		case WM_DESTROY:
			return HANDLE_WM_DESTROY(hwnd, wParam, lParam, Lister_OnDestroy);

        case WM_QUIT:
			/*Cleanup*/
			ImageList_Destroy(g_hImages);
			PostQuitMessage(0);
            return TRUE;
	}
	return DefWindowProc(hwnd, iMsg, wParam, lParam);
}


/*___________________________________________________________________________
 *	WM_CREATE Message Handler Function
 */
BOOL Lister_OnCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct)
{
	DialogBox(lpCreateStruct->hInstance, MAKEINTRESOURCE (IDD_LISTERDLG), hwnd, (DLGPROC) ListerDlgProc);
	FORWARD_WM_CREATE(hwnd, lpCreateStruct, DefWindowProc);
	return TRUE;
}


/*___________________________________________________________________________
 *	WM_DESTROY Message Handler Function
 */
void Lister_OnDestroy(HWND hwnd)
{
	PostQuitMessage(0);
	return;
}


/*___________________________________________________________________________
 *	ListerDlgProc Dialog Procedure
 */
BOOL CALLBACK ListerDlgProc (HWND hwndListerDlg, UINT imsg, WPARAM wParam, LPARAM lParam)
{
	HWND	hListControl = NULL;
	HWND	hOkButton	 = NULL;
	HWND	hHelpButton  = NULL;
	HWND	hSelectClear = NULL;
	LPNMHDR pnmh;
	LPNMLVKEYDOWN pnkd;


	switch (imsg)
    {
		case WM_INITDIALOG:
			HANDLE_WM_INITDIALOG(hwndListerDlg, wParam, lParam, Lister_InitDialog);
			/*return False because I set focus*/
			return FALSE;

		case WM_COMMAND:
			HANDLE_WM_COMMAND(hwndListerDlg, wParam, lParam, Lister_OnCommand);
			return TRUE;

		case WM_PAINT:
			return DefWindowProc(hwndListerDlg, imsg, wParam, lParam);

		case WM_NOTIFY:
			hListControl = GetDlgItem(hwndListerDlg, IDC_ADAPTERLIST);
			hOkButton = GetDlgItem(hwndListerDlg, IDB_PGPNETOK);
			hSelectClear = GetDlgItem(hwndListerDlg, IDB_SELECTCLEAR);
		    pnmh = (LPNMHDR) lParam;
			pnkd = (LPNMLVKEYDOWN) lParam; 

			/*this gets rid of the system colored selction bar*/
 			if ((pnmh->idFrom == IDC_ADAPTERLIST) && (pnmh->code == LVN_ITEMCHANGED))
			{
				LPNMLISTVIEW pnmv;

				pnmv = (LPNMLISTVIEW) lParam;
				if (pnmv->uNewState & LVIS_SELECTED)
				{
					ListView_SetItemState(pnmh->hwndFrom, pnmv->iItem, LVIS_FOCUSED,
						0x0F);
				}
				else if ((pnmv->uNewState == 0) && (pnmv->uOldState & LVIS_SELECTED))
				{
					ListView_SetItemState(pnmh->hwndFrom, pnmv->iItem, LVIS_FOCUSED,
						0x0F);
				}
			}
			
			/*something is selected/deselected with mouse or keyboard*/
			if  ((pnmh->idFrom == IDC_ADAPTERLIST) && 
				((pnmh->code == NM_CLICK) || (pnkd->hdr.code == LVN_KEYDOWN)))
			{
				LVHITTESTINFO pinfo;
				POINT point;
				LV_ITEM lviKey;
				LV_ITEM lviKeySingleSelect;
				BOOL bEverythingIsSelected;
				BOOL bSomethingIsSelected;
				BOOL bMouse = TRUE;
				int NumberOfItems;
				int rc;
				int i;
				int Count;
				

				/*set whether its mouse or keyboard*/
				if (pnkd->hdr.code == LVN_KEYDOWN)
					bMouse = FALSE;
				
				/*if keyboard, filter out all but spacebar*/
				if ((! bMouse) && (pnkd->wVKey != VK_SPACE))
					goto ReturnDefaultBehavior;	
				
				/*if mouse, get position and hittest*/
				if (bMouse)
				{
					GetCursorPos(&point);
					ScreenToClient(hListControl, &point);
					memset(&pinfo, 0, sizeof(pinfo));
					pinfo.pt = point;
					rc = ListView_HitTest(hListControl, &pinfo);
				}

				/*if mousedown was on an item*/
				if ((pinfo.iItem >= 0) || (! bMouse))
				{
					if (! bMouse)	
					{
						/*get # of items is control*/
						NumberOfItems = ListView_GetItemCount(hListControl);
						/*find out what item has focus*/
						for (i = 0; i < NumberOfItems; i++)
						{
							if (ListView_GetItemState(hListControl, i,LVIS_FOCUSED))
								break;
						}
					}
					/*fill struct and set mask*/
					lviKey.iSubItem = 0;		
					lviKey.stateMask =LVIS_SELECTED | LVIS_FOCUSED;
					lviKey.state = LVIS_FOCUSED;
					lviKey.mask = LVIF_IMAGE | LVIF_STATE; 
					/*set item # that is changing*/
					if (bMouse)
					{
						lviKey.iItem    = pinfo.iItem;
						i = pinfo.iItem;
					}
					else
					{
						lviKey.iItem    = i;
					}

					if (bSelectionArray [i] == 1)
					{
						bSelectionArray [i] = 0;
						lviKey.iImage   = UNSELECTEDICON;
					}
					else
					{
						/*this is what switches to single selection*/
						if (MULTICARD_SUPPORT == FALSE)
						{
							/*fill structure to change icon*/
							lviKeySingleSelect.mask     = LVIF_IMAGE | LVIF_STATE; 
							lviKeySingleSelect.iSubItem = 0;
							lviKeySingleSelect.stateMask = -1;
							lviKeySingleSelect.state = 0; 

							/*set image to change to*/
							lviKeySingleSelect.iImage = UNSELECTEDICON;
							NumberOfItems = ListView_GetItemCount(hListControl);
							for (Count = 0; Count < NumberOfItems; Count++)
							{
								/*clear the array*/
								bSelectionArray[Count] = 0;
								/*set current item*/
								lviKeySingleSelect.iItem = Count;
								/*set the new state info*/
								ListView_SetItem (hListControl, &lviKeySingleSelect);
							}
						}

						bSelectionArray [i] = 1;
						lviKey.iImage   = SELECTEDICON;
					}
			
					/*set the new state info*/
					ListView_SetItem (hListControl, &lviKey);
					
					/*initialize flags*/
					bSomethingIsSelected = FALSE;
					bEverythingIsSelected = TRUE;

					/*get # of items is control*/
					NumberOfItems = ListView_GetItemCount(hListControl);
					/*check if everything/anything is selected*/
					gNumberSelected = 0;
					for (i = 0; i < NumberOfItems; i++)
					{
						if (bSelectionArray [i] == 0)
							bEverythingIsSelected = FALSE;
						else
						{
							gNumberSelected ++;
							bSomethingIsSelected = TRUE;
						}
					}
					
					if(bEverythingIsSelected)
					{
						/*changed text on button*/
						SetWindowText(hSelectClear, "Clear &All");
					}
					else
					{
						/*changed text on button*/
						SetWindowText(hSelectClear, "Select &All");
					}

					/*disable Ok button if no selection on install*/
					if ((!bSomethingIsSelected) && (!bSansCmdLine))
						EnableWindow(hOkButton, FALSE);
					else
						EnableWindow(hOkButton, TRUE);
				}
			}
ReturnDefaultBehavior:
			return DefWindowProc(hwndListerDlg, imsg, wParam, lParam);
				
        case WM_QUIT:
			/*Cleanup*/
			ImageList_Destroy(g_hImages);
			EndDialog(hwndListerDlg,0);
		   	PostQuitMessage(0);
            return TRUE;
	
		default:
			return FALSE;
    }
return FALSE;
}


/*___________________________________________________________________________
 *	HelpDlgProc Dialog Procedure
 */
BOOL CALLBACK HelpDlgProc (HWND hwndHelpDlg, UINT imsg, WPARAM wParam, LPARAM lParam)
{
	LPTSTR lpBuffer = NULL;

	switch (imsg)
    {
		case WM_COMMAND:
			switch (wParam)
			{
				case IDB_HELPOK:
					EndDialog(hwndHelpDlg,0);
					return TRUE;

			}

		case WM_PAINT:
			lpBuffer = malloc(1024);
			LoadString(g_hInstance,IDS_HELPSTRING, lpBuffer, 1024);
			/*SetText*/
			SetDlgItemText(hwndHelpDlg, IDC_HELPTEXT, lpBuffer);
			if (lpBuffer)
				free (lpBuffer);
			return DefWindowProc(hwndHelpDlg, imsg, wParam, lParam);

		default:
			return FALSE;
    }
return FALSE;
}


/*___________________________________________________________________________
 *	ListerInitDialog Message Handler Function
 */
BOOL Lister_InitDialog(HWND hwndDlg, HWND hwnd, LPARAM lParam)
{
	/*common*/
	HKEY			hPGPnetkey	= NULL;
	LONG			lResult		= ERROR_SUCCESS;
	DWORD			dwType;
	UINT			i = 0;
	UINT			nCount = 0;
	BOOL			brc;
	DWORD			dwDisposition;
	/*List view*/
	LV_ITEM			lviKey;
	HWND			hListControl	= NULL;
	HWND			hOkButton		= NULL;
	HWND			hSelectClearAll = NULL;
	RECT			StatusRect;
	

	/*set the selection arrays*/
	memset(bSelectionArray, 0, sizeof (bSelectionArray));
	memset(bPreviousSelectionArray, 0, sizeof (bPreviousSelectionArray));
	
	/*Disable ok button if installing*/
	if (!bSansCmdLine)
	{
		hOkButton = GetDlgItem(hwndDlg, IDB_PGPNETOK);
		EnableWindow(hOkButton, FALSE);
	}

	/*create the list view*/
	hListControl = GetDlgItem(hwndDlg, IDC_ADAPTERLIST);

	/*set the title text*/
	SetDlgItemText(hwndDlg, IDC_CAPTIONSTATIC, DIALOG_TEXT);

	/*create the image list*/
	brc = CreateImageList();
	if (brc != TRUE)
		MessageBox (GetFocus(), ERR_IMGLISTCREATE, "", 0 | MB_ICONERROR);

	ListView_SetImageList(hListControl, g_hImages, LVSIL_SMALL);
	
	lviKey.mask     = LVIF_TEXT | LVIF_PARAM | LVIF_IMAGE | LVIF_STATE; 
	lviKey.iItem    = 0;
	lviKey.iSubItem = 0;
	lviKey.iImage   = UNSELECTEDICON;
	lviKey.stateMask = -1;
	lviKey.state = 0; 

	if (bIsNT)
	{
		HKEY			hMainKey	= HKEY_LOCAL_MACHINE;
		HKEY			hOpenKey	= NULL;
		HKEY			hOpenSubKey	= NULL;
		DWORD			dwSubKeys	= 0;
		DWORD			dwMaxSubKeyLen = 0;
		DWORD			ValueLength = 0;
		DWORD			MaxNameLenghth;
		DWORD			dwMaxValueLen;
		LPSTR			pValueBuffer = NULL;
		LPSTR			lpKeyName	 = NULL;
		UINT			index;


		/*open the network card key*/
		if (RegOpenKeyEx(hMainKey, NETWORKCARDSKEY, 0, KEY_ALL_ACCESS, &hOpenKey)
						== ERROR_SUCCESS)
		{
			/*get the number of network cards on the system*/
			if (RegQueryInfoKey (hOpenKey, NULL, NULL, NULL, &dwSubKeys, &dwMaxSubKeyLen, NULL, NULL,
							NULL, NULL, NULL, NULL) == ERROR_SUCCESS)
			{
				/*allocate mem for keyname*/
				lpKeyName = malloc (dwMaxSubKeyLen);
				ZeroMemory (lpKeyName, dwMaxSubKeyLen);

				/*dwSubKeys contains the # of netcards on system*/
				for (i = 0; i < dwSubKeys; i++)
				{
					/*get current key name*/
					RegEnumKey(hOpenKey, i, lpKeyName, dwMaxSubKeyLen);
					/*open the current network card key*/			
					if (RegOpenKeyEx(hOpenKey, lpKeyName, 0, KEY_ALL_ACCESS, &hOpenSubKey)
									== ERROR_SUCCESS)
					{
						/*get the max value length*/
						if (RegQueryInfoKey (hOpenSubKey, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
						NULL, &dwMaxValueLen, NULL, NULL) != ERROR_SUCCESS)
						{
							/*if failed set to MAX_NAME_LENGTH  (256)*/
							dwMaxValueLen = MAX_NAME_LENGTH;
						}

						/*set the card name (title)*/
						MaxNameLenghth = dwMaxValueLen;
						/*zero the memory*/
						ZeroMemory(gAdapterListNT[nCount].CardName, dwMaxValueLen);
						lResult = RegQueryValueEx(hOpenSubKey, "Title", 0,
								  &dwType, gAdapterListNT[nCount].CardName, &MaxNameLenghth);
						if (MaxNameLenghth = 0)
						{
							gAdapterListNT[nCount].Useable = FALSE;
							goto endparmsetting;
						}
						
						/*set the product name*/
						MaxNameLenghth = dwMaxValueLen;
						/*zero the memory*/
						ZeroMemory(gAdapterListNT[nCount].ProductName, dwMaxValueLen);
						lResult = RegQueryValueEx(hOpenSubKey, "ProductName", 0,
								  &dwType, gAdapterListNT[nCount].ProductName, &MaxNameLenghth);
						
						/*set the service name*/
						MaxNameLenghth = dwMaxValueLen;
						/*zero the memory*/
						ZeroMemory(gAdapterListNT[nCount].ServiceName, dwMaxValueLen);
						lResult = RegQueryValueEx(hOpenSubKey, "ServiceName", 0,
								  &dwType, gAdapterListNT[nCount].ServiceName, &MaxNameLenghth);

						/*set if card is bound to tcp/ip*/
						if (AmIBoundToTcpipNT(nCount))
							gAdapterListNT[nCount].TCPIPBound = TRUE;
						else
							gAdapterListNT[nCount].TCPIPBound = FALSE;
						/*set if card is bound to pgpnet transport*/
						if (AmIBoundToPGPNT(nCount))
							gAdapterListNT[nCount].PGPnetBound = TRUE;	
						else
							gAdapterListNT[nCount].PGPnetBound = FALSE;

						/*set the all caps. service name*/
						MaxNameLenghth = dwMaxValueLen;
						/*zero the memory*/
						ZeroMemory(gAdapterListNT[nCount].AllCapsServiceName, dwMaxValueLen);
						lResult = RegQueryValueEx(hOpenSubKey, "ServiceName", 0,
								  &dwType, gAdapterListNT[nCount].AllCapsServiceName, &MaxNameLenghth);

						/*set service name _toupper for strstr()*/
						for (index = 0; index < strlen (gAdapterListNT[nCount].AllCapsServiceName); index++)
						{
							if((gAdapterListNT[nCount].AllCapsServiceName[index] >= 97) && 
							(gAdapterListNT[nCount].AllCapsServiceName[index] <= 122))
								gAdapterListNT[nCount].AllCapsServiceName[index] = _toupper (gAdapterListNT[nCount].AllCapsServiceName[index]);
						}

						/*set if card is lan or wan*/
						if (strstr (gAdapterListNT[nCount].AllCapsServiceName, "NDISWAN") != NULL)
							gAdapterListNT[nCount].IsWan = TRUE;
						else 
							gAdapterListNT[nCount].IsWan = FALSE;
						
						/*if card is unuseable type it's unusable*/
						if ((strstr (gAdapterListNT[nCount].AllCapsServiceName, "ASYNCMAC") != NULL) ||
							(strstr (gAdapterListNT[nCount].AllCapsServiceName, "PGPMAC") != NULL)) 
							gAdapterListNT[nCount].Useable = FALSE;
						else 
							gAdapterListNT[nCount].Useable = TRUE;
						/*if cards not bound to tcpip of pgpnet it's unusable*/	
						if ((gAdapterListNT[nCount].PGPnetBound == FALSE) &&
							(gAdapterListNT[nCount].TCPIPBound == FALSE))
							gAdapterListNT[nCount].Useable = FALSE;
						/*if CardName is NULL then adapter key was bogus and it's unuseable*/
						if (strcmp (gAdapterListNT[nCount].CardName, "") == 0)
							gAdapterListNT[nCount].Useable = FALSE;

						/*set this items realmac value*/
						ZeroMemory (gAdapterListNT[nCount].RealMac, dwMaxValueLen);
						strcpy(gAdapterListNT[nCount].RealMac, "\\Device\\");
						strcat(gAdapterListNT[nCount].RealMac, gAdapterListNT[nCount].ServiceName);

						/*set the adapter number*/
						gAdapterListNT[nCount].AdapterNumber = atoi(lpKeyName);
endparmsetting:
						if (gAdapterListNT[nCount].Useable)
						{
							lviKey.mask     = LVIF_TEXT | LVIF_IMAGE;
							lviKey.pszText  = gAdapterListNT[nCount].CardName;
							lviKey.iItem	= nCount;
							lviKey.iImage   = UNSELECTEDICON;
							ListView_Arrange(hListControl, LVA_ALIGNLEFT);
							/*insert item into list control*/
							ListView_InsertItem(hListControl, &lviKey);
							/*if its bound to pgpnet, change icon*/
							if (gAdapterListNT[nCount].PGPnetBound)
							{
								/*set mask to change default image*/
								lviKey.mask     = LVIF_IMAGE; 
								lviKey.state	= 0;
								lviKey.iImage   = SELECTEDICON;

								/*set the new state info*/
								ListView_SetItem (hListControl, &lviKey);
								/*set selection in arrays*/
								bPreviousSelectionArray[nCount] = 1;
								bSelectionArray[nCount] = 1;
							}
							/*increment card count*/
							nCount++;
						}
					}
					else
					{
						/*setadapter could not open network cards key*/
						MessageBox (GetFocus(), ERROPENINGNETENTRY, TITLE, 0 | MB_ICONERROR);
					}
					/*cleanup*/
					if (hOpenSubKey)
					{
						RegCloseKey(hOpenSubKey);
					}
				}
			}
			else
			{
				/*setadapter could not open network cards key*/
				MessageBox (GetFocus(), ERRGETTINGNUMNETCARDS, TITLE, 0 | MB_ICONERROR);
			}

			/*create the PATHTOADAPTERLIST reg. key*/
			RegCreateKeyEx(HKEY_LOCAL_MACHINE, PATHTOADAPTERLIST,
			0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hPGPnetkey,
			&dwDisposition);

			/*cleanup*/
			if(lpKeyName)
				free(lpKeyName);
			if (hOpenKey)
				RegCloseKey(hOpenKey);
			if (hPGPnetkey)
				RegCloseKey(hPGPnetkey);
		}
	}
	else
	{
		/*Running 95 or 98*/
		HKEY			hNewKeyb		= NULL;
		HKEY			hDeviceDesc		= NULL;
		RegSearchState state;
		char			szSubKey[256];
		char			*szName;
		char			*szValue;
		LPTSTR 			pSubkeyBuffer	= NULL;	
		LPBYTE			pData;
		LPBYTE			pRealMacData;
		unsigned long	lpcbMaxValueLen;
		unsigned long	TempMaxValueLen;


		state.hKey = HKEY_LOCAL_MACHINE;
		state.nextState = NULL;
		state.dwKeyIndex = 0;
		state.dwValueIndex = 0;
		state.bMatch = FALSE;
		
		szName = "Class";
		szValue = "Net";
		strcpy(szSubKey, "Enum");

		if (RegOpenKeyEx(state.hKey, "Enum", 0, KEY_READ, &(state.hKey))
			== ERROR_SUCCESS)
		{
			/*search for  all net class cards*/
			while (RegistrySearch(szName, szValue, szSubKey, &state))
			{
				/*Check to see if adapter is bound to TCPIP*/
				if ((AmIBoundToTcpip95 (szSubKey)) ||
					(AmIBoundToPGP95 (szSubKey)))
				{
					/*create the adapter reg inside the PGPnet key*/
					RegCreateKeyEx(HKEY_LOCAL_MACHINE, PATHTOADAPTERLIST,
					0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hPGPnetkey,
					&dwDisposition);
					
					/*Get the DeviceDesc from the Reg. key and
					Insert the item into List control*/
					RegOpenKeyEx (HKEY_LOCAL_MACHINE, szSubKey, 0, KEY_READ, &hNewKeyb);
					RegQueryInfoKey (hNewKeyb, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
									NULL, &lpcbMaxValueLen, NULL, NULL);
					TempMaxValueLen = lpcbMaxValueLen;
					/*allocate memory*/
					pData = malloc(lpcbMaxValueLen + 1);
					pRealMacData = malloc(lpcbMaxValueLen + 1);
					/*clear memory*/
					ZeroMemory(pData, lpcbMaxValueLen + 1);
					ZeroMemory(pRealMacData, lpcbMaxValueLen + 1);
					/*get DeviceDesc value*/
					lResult = RegQueryValueEx(hNewKeyb, "DeviceDesc", 0,
							  &dwType, pData, &lpcbMaxValueLen);
					/*reset length*/
					lpcbMaxValueLen = TempMaxValueLen;
					/*get Driver value (needed for RealMac)*/
					lResult = RegQueryValueEx(hNewKeyb, "Driver", 0,
							  &dwType, pRealMacData, &lpcbMaxValueLen);
					 
					/*Write the adapter entry under PGPnetkey (REALNAME -> REG KEY)*/
					RegSetValueEx(hPGPnetkey, pData , 0, REG_SZ, szSubKey,(strlen (szSubKey)+1));

					if (strstr(pData, "PGPnet") == NULL)
					{
						lviKey.mask     = LVIF_TEXT | LVIF_IMAGE;
						lviKey.pszText  = pData;
						lviKey.iItem	= nCount;
						lviKey.iImage   = UNSELECTEDICON;
						ListView_Arrange(hListControl, LVA_ALIGNLEFT);
						/*insert item into list control*/
						ListView_InsertItem(hListControl, &lviKey);
						if (AmIBoundToPGP95 (szSubKey))
						{
							/*set mask to change default image*/
							lviKey.mask     = LVIF_IMAGE; 
							lviKey.state = 0;
							lviKey.iImage   = SELECTEDICON;

							/*set the new state info*/
							ListView_SetItem (hListControl, &lviKey);
							/*set selection in arrays*/
							bPreviousSelectionArray[nCount] = 1;
							bSelectionArray[nCount] = 1;
						}
						/*fill in path to card*/
						ZeroMemory(gAdapterList95 [nCount].Path, _MAX_PATH);
						strcpy (gAdapterList95 [nCount].Path, szSubKey);
						/*fill in the card name*/
						ZeroMemory(gAdapterList95 [nCount].CardName, MAX_NAME_LENGTH);
						strcpy (gAdapterList95 [nCount].CardName, pData);
						/*fill in RealMac to card*/
						ZeroMemory(gAdapterList95 [nCount].RealMac, 5);
						/*get the last 4 chars of pRealMacData for RealMac value  eg: 0000*/
						strcpy (gAdapterList95 [nCount].RealMac, pRealMacData + (strlen(pRealMacData) - 4));
						/*increment card count*/
						nCount++;
					}
					
					/*cleanup*/
					if(hPGPnetkey)
						RegCloseKey(hPGPnetkey);
					if(hNewKeyb)
						RegCloseKey(hNewKeyb);
					if(pData)
						free (pData);
					if(pRealMacData)
						free (pRealMacData);
				}
			}
			RegCloseKey(state.hKey);
		}
		FreeRegSearchState(&state);
	}

	/*create status window*/
	hwndStatus = CreateStatusWindow(WS_CHILD | WS_VISIBLE , "Press OK after making selection.", hwndDlg, 1234);	
	/*get the size of the status bar*/
	GetWindowRect(hwndStatus, &StatusRect);
	/*fill the Setparts array*/
	aSetPartsArray [0] =(int)((StatusRect.right - StatusRect.left) * .75);
	aSetPartsArray [1] = -1;
	/*break statusbar into 2 sections 75% and 25%*/
	SendMessage (hwndStatus, SB_SETPARTS,(WPARAM) 2, (LPARAM) (LPINT) aSetPartsArray); 
	/*get rect of 2nd part of  the statusbar*/		
	SendMessage (hwndStatus, SB_GETRECT,(WPARAM) 1, (LPARAM) (LPRECT) &StatusRect); 
	/*create a progressbar inside the 2nd part of the statusbar*/
	hwndPB = CreateWindowEx(0, PROGRESS_CLASS, (LPSTR) NULL, WS_CHILD | WS_VISIBLE | PBS_SMOOTH, 
				StatusRect.left, StatusRect.top, (int)((StatusRect.right - StatusRect.left)),
				(StatusRect.bottom - StatusRect.top), hwndStatus, (HMENU) 0, g_hInstance, NULL); 

	/*if no nics were found inform user*/
	gbNoCards = FALSE;
	if (nCount == 0)
	{ 
		if(bSansCmdLine)
		{
			/*no nics found, but one is already secured*/
			MessageBox (GetFocus(), NONICSONESECURED, TITLE, 0 | MB_ICONERROR);
		}
		else
		{
			/*no nics found, none are secured*/
			MessageBox (GetFocus(), NONICSNONESECURED, TITLE, 0 | MB_ICONERROR);
		}
		/*cancel out*/
		/*set flag that says we cancelled because no NICS found*/
		gbNoCards = TRUE;
		PostMessage(hwndDlg, WM_COMMAND, 1005, 0);
	}
	
	/*if silent install select all and press ok*/
	if (bSilentInstall)
	{
		if (MULTICARD_SUPPORT)
		{
		/*if this is a silent install we select all and press OK*/
		PostMessage(hwndDlg, WM_COMMAND, 1022, 0);
		PostMessage(hwndDlg, WM_COMMAND, 1004, 0);
		}
		else
		{
			/*if only 1 adapter select it by default*/
			if (nCount == 1)
			{
				/*there is only 1 adapter bound to TCP/IP*/
				/*fill struct and set mask*/
				lviKey.iSubItem = 0;		
				lviKey.stateMask =LVIS_SELECTED | LVIS_FOCUSED;
				lviKey.state = LVIS_FOCUSED;
				lviKey.mask = LVIF_IMAGE | LVIF_STATE; 
				lviKey.iItem = 0;
				lviKey.iImage   = SELECTEDICON;

				bSelectionArray [0] = 1;
				/*set the new state info*/
				ListView_SetItem (hListControl, &lviKey);			
				/*press OK*/
				PostMessage(hwndDlg, WM_COMMAND, 1004, 0);
			}
		}
	}
	else
	{
		if (MULTICARD_SUPPORT)
		{
			/*get handle to Select/Clear button*/
			hSelectClearAll = GetDlgItem(hwndDlg, IDB_SELECTCLEAR);
			/*set focus on Select/Clear button*/
			SetFocus (hSelectClearAll);
			/*make Select/Clear button default*/
			Button_SetStyle(hSelectClearAll, BS_DEFPUSHBUTTON, FALSE);
		}
		else
		/*this is what hides the select all button
		for single select only builds*/
		{
			/*get handle to select all button*/
			hSelectClearAll = GetDlgItem(hwndDlg, IDB_SELECTCLEAR);
			/*hide the button*/
			ShowWindow(hSelectClearAll, SW_HIDE);
			/*get handle to list control*/
			hListControl = GetDlgItem(hwndDlg, IDC_ADAPTERLIST);
			/*set focus on list control*/
			ListView_SetItemState(hListControl, 0, LVIS_FOCUSED,
							0x0F);
		}
	}
	return TRUE;
}


/*___________________________________________________________________________
 *	ListerOnCommand [WM_COMMAND]
 */
BOOL Lister_OnCommand(HWND hwndDlg, int id, HWND hwndCommand, UINT Event)
{
	HKEY			hkey			= NULL;
	HKEY			hMainKey		= HKEY_LOCAL_MACHINE;
	HKEY			hOpenKey		= NULL;
	DWORD			dwDisposition;
	BOOL			brc				= TRUE;
	LPSTR			lpBuffer		= NULL;
	LPSTR 			pszText			= NULL;
	LPSTR			SecuredKey		= NULL;
	char  			*RealMac		= NULL;
	BOOL			bEverythingIsSelected;
	int				NumberOfItems;
	int				Response;
	int				Count;
	int				cchTextMax		= 1024;
	LV_ITEM			lviKey;
	HWND			hOkButton		= NULL;
	HWND			hListControl	= NULL;
	

	switch (id)
    {
		case IDB_HELP:
			if(Event == BN_KILLFOCUS)
			{
				/*get handle to list control*/
				hListControl = GetDlgItem(hwndDlg, IDC_ADAPTERLIST);
				/*set focus on list control*/
				ListView_SetItemState(hListControl, 0, LVIS_FOCUSED,
						0x0F);
			}

			if(Event == BN_CLICKED)
			{
				/*hide the main window*/
				ShowWindow(hwndDlg, SW_HIDE);
				/*show the held dlg.*/
				DialogBox(g_hInstance, MAKEINTRESOURCE (IDD_HELPDIALOG), hwndDlg, (DLGPROC) HelpDlgProc);
				/*show the main dlg.*/
 				ShowWindow(hwndDlg, SW_SHOW);
			}
			return TRUE;

		case IDB_PGPNETOK:
			if(Event == BN_CLICKED)
			{
				int i;
				BOOL bChangesMade = FALSE;
				BOOL bSelectionMade = FALSE;
				BOOL bWAN_Exists = FALSE;
				BOOL bLAN_Exists = FALSE;

				/*get handle to list control*/
				hListControl = GetDlgItem(hwndDlg, IDC_ADAPTERLIST);			
				/*get # of items is control*/
				NumberOfItems = ListView_GetItemCount(hListControl);
				/*Set the range and increment of the progress bar.*/
				SendMessage(hwndPB, PBM_SETRANGE, 0, MAKELPARAM(0, 100)); 
				SendMessage(hwndPB, PBM_SETSTEP, (WPARAM) 10, 0);
				/*10%*/
				SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
				/*set statusbar text*/
				SetWindowText(hwndStatus,"Calculating selections...");
				/*20%*/
				SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
				Sleep (1700);
				/*check if anything was changed or selected*/
				for (i = 0; i < NumberOfItems;i++)
				{
					if (bSelectionArray[i] == 1)
						bSelectionMade = TRUE;
					if (bPreviousSelectionArray[i] != bSelectionArray[i])
						bChangesMade = TRUE;
				}
				/*30%*/
				SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
				/*if changes were made, do needed work*/
				if (bChangesMade && bSelectionMade)
					goto ChangesMade;
				/*if no selections, unbind from any secured cards*/
				if (!bSelectionMade && bChangesMade)
					goto NoSelectionUnbind;
				/*set statusbar text*/
				/*40%*/
				SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
				/*set statusbar text*/
				SetWindowText(hwndStatus,"No changes made.");
				/*reset step*/
				SendMessage(hwndPB, PBM_SETSTEP, (WPARAM) 60, 0);
				Sleep (1700);
				/*100%*/
				SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
				/*set statusbar text*/
				SetWindowText(hwndStatus,"Complete.");
				Sleep (500);
				/*no configuration changes were made, so exit.*/
				brc = SendMessage(hwndDlg, WM_QUIT, (WPARAM)NULL,(LPARAM)NULL);
				return TRUE;
NoSelectionUnbind:
				/*set statusbar text*/
				SetWindowText(hwndStatus,"No selection made, unbinding PGPnet from all NICS.");
				/*Set the range and increment of the progress bar.*/
				SendMessage(hwndPB, PBM_SETRANGE, 0, MAKELPARAM(0, 100)); 
				SendMessage(hwndPB, PBM_SETSTEP, (WPARAM)(70 / 4), 0); 
				Sleep (850);
				if (bIsNT)
				{
					/*unbind from everything*/
					/*uninstall pgpnet nt*/
					RemovePGPnetServices ();
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					RemovePGPnetSoftwareLinkKeys ();
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					RemoveNetworkCardEntries ();
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					/*delete current secured card list*/
					RegDeleteKeyNT (HKEY_LOCAL_MACHINE, PATHTOADAPTERLIST);	
					/*restore protocols*/
					RefreshProtocols ();
					/*delete protocol backup*/
					RegDeleteKeyNT (HKEY_LOCAL_MACHINE, PROTOBACKUPKEY);
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					Sleep(400);
				}
				else
				{
					/*unbind from everything*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					Remove95(CLASSNETTRANS, 0);
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					Remove95(ROOTNET, 1);
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					Remove95(CLASSNET, 0);
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
				}
				/*set statusbar text*/
				SetWindowText(hwndStatus,"Complete.");
				Sleep (750);
				ShowWindow(hwndDlg, SW_HIDE);
				Sleep (20);
				/*run bind engine*/
				BindReview	(hwndDlg);
				/*ask for reboot*/
				if (bSansCmdLine) 
				{
					RebootYesNo();
				}
				brc = SendMessage(hwndDlg, WM_QUIT, (WPARAM)NULL,(LPARAM)NULL);
				return TRUE;
ChangesMade:
				if (bIsNT)
				{
					LPSTR pDependonService = NULL;
					UINT irc = 0;
					UINT OurCardCount = 0;
					UINT i = 0;

					DeleteRebindKey ();
					/*set statusbar text*/
					/*40%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Removing existing PGPnet bindings.");
					Sleep (300);

					/*uninstall pgpnet nt*/
					RemovePGPnetServices ();
					RemovePGPnetSoftwareLinkKeys ();
					RemoveNetworkCardEntries ();
					/*delete current secured card list*/
					RegDeleteKeyNT (HKEY_LOCAL_MACHINE, PATHTOADAPTERLIST);	
					/*restore protocols*/
					RefreshProtocols ();
					/*delete protocol backup*/
					RegDeleteKeyNT (HKEY_LOCAL_MACHINE, PROTOBACKUPKEY);
					/*set statusbar text*/
					/*50%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Rebinding to new selection.");
					Sleep (300);

					/*get the DependOnService string*/
					pDependonService = BuildDependOnService (hListControl);
		
					/*allocate memory*/
					SecuredKey = malloc (MAX_PATH);
					/*get # of items in list control*/
					NumberOfItems = ListView_GetItemCount(hListControl);
					/*examine each card in list*/
					for (Count = 0; Count < NumberOfItems; Count ++)
					{
						/*clear memory*/
						ZeroMemory (SecuredKey, MAX_PATH);
						/*if card is selected*/
						if (bSelectionArray [Count] == 1)
						{
							char* Tempstr [5];
							
							ZeroMemory (Tempstr, 5);
							ZeroMemory (g_AdapterNum, 5);
							/*get and create free instace #*/
							gAdapterListNT[Count].InstanceNumber = GetFreeInstanceNumber (Count);
							/*backup the used instance, so it can be removed later*/
							sprintf ((char*)Tempstr, "%d", gAdapterListNT[Count].InstanceNumber);

							sprintf ((char*)g_AdapterNum, "%d", gAdapterListNT[Count].InstanceNumber);

							MyCreateBackupKey(HKEY_LOCAL_MACHINE, SECUREDADAPTERKEYINDEX,(char*)Tempstr,
										Count);
							
							/*create the secured card key*/
							strcpy (SecuredKey, SECUREDADAPTERKEY);
							strcat (SecuredKey, "\\");
							strcat (SecuredKey, gAdapterListNT[Count].CardName);
					
							/*create the secured card key*/
							RegCreateKeyEx(HKEY_LOCAL_MACHINE, SecuredKey,
							0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hOpenKey,
							&dwDisposition);
							/*cleanup*/
							if (hOpenKey)
							{
								RegCloseKey (hOpenKey);
								hOpenKey = NULL;
							}
							/*disable NetBT and Tcp/ip from*/
							/*the original NIC*/
							DisableProtocols (Count);
						}
					} 
					/*set statusbar text*/
					/*60%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Registering transport.");
					Sleep (300);

					/*create main pgp transport service key*/
					irc = CreatePGPTransportService ("ZZPGPMac");
					if (irc != 0)
					{
						/*CreatePGPTransportService fail, manually write entries*/
						ManualCreatePGPTransportService ("ZZPGPMac");
					}

					/*70%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Linking transport.");
					Sleep (300);

					/*link the pgp transport*/
					LinkPGPTransportService ();

					CreateTransportDriverLinkage();
					/*get # of items in list control*/
					NumberOfItems = ListView_GetItemCount(hListControl);

					/*examine each card in list*/
					for (Count = 0; Count < NumberOfItems; Count ++)
					{
						LPSTR CardInstanceName;
						
						
						ZeroMemory (gOurCardList[OurCardCount].CardName, EXPORTEDNAMELENGTH);
						/*allocate memory*/
						CardInstanceName = malloc (EXPORTEDNAMELENGTH);
						/*clear memory*/
						ZeroMemory (CardInstanceName, EXPORTEDNAMELENGTH);

						/*if card is selected*/
						if (bSelectionArray [Count] == 1)
						{
							if (gAdapterListNT [Count].IsWan)
							{
								bWAN_Exists = TRUE;
								sprintf (CardInstanceName, "NdisWanZZPGPMacMP%d", gAdapterListNT[Count].InstanceNumber);
								DisableUsFromUs (CardInstanceName);
							}
							else
							{
								bLAN_Exists = TRUE;
								sprintf (CardInstanceName, "ZZPGPMacMP%d", gAdapterListNT[Count].InstanceNumber);
								DisableUsFromUs (CardInstanceName);
							}
							/*save the exported card name*/
							strcpy (gOurCardList[OurCardCount].CardName, CardInstanceName);
							/*copy WINS values to our card*/
							CopyWINS (gAdapterListNT[Count].ServiceName, CardInstanceName);
							/*create exported driver*/
							CreateExportedDriver (CardInstanceName);
							LinkPGPDriverService (CardInstanceName);

							SetDriverParms (gAdapterListNT[Count].InstanceNumber, Count);

							OurCardCount ++;
						}
						if (CardInstanceName)
							free (CardInstanceName);
					}
					/*80%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Registering driver.");
					Sleep (300);

					/*90%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Linking driver.");
					Sleep (300);

					if (bLAN_Exists)
					{
						/*create main pgp driver service key*/
						irc = CreatePGPDriverService ("ZZPGPMacMP", "PGPnet VPN Driver Adapter",
												"NDIS", pDependonService);
						if (irc != 0)
						{
							/*CreatePGPDriverService fail, manually write entries*/
							#define NDISKEY			"SYSTEM\\CurrentControlSet\\Services\\ZZPGPMacMP"
							ManualCreatePGPDriverService(NDISKEY, "ZZPGPMacMP", "PGPnet VPN LAN Driver Adapter",
														"NDIS", pDependonService);
							#undef NDISKEY	
						}

						/*link the pgp driver*/
						LinkPGPDriverService ("ZZPGPMacMP");

						CreateLanSoftwareDriverLinkage	();
					}
					if (bWAN_Exists)
					{
						/*create main pgp driver service key*/
						irc = CreatePGPDriverService ("NdisWanZZPGPMacMP", "PGPnet VPN WAN Driver Adapter",
												"NDISWAN", pDependonService);
						if (irc != 0)
						{
							/*CreatePGPDriverService fail, manually write entries*/
							#define NDISWANKEY		"SYSTEM\\CurrentControlSet\\Services\\NdisWanZZPGPMacMP"
							ManualCreatePGPDriverService(NDISWANKEY, "NDISWANZZPGPMacMP", "PGPnet VPN WAN Driver Adapter",
							"NDISWAN", pDependonService);
							#undef	NDISWANKEY
						}
						/*link the pgp driver*/
						LinkPGPDriverService ("NdisWanZZPGPMacMP");

						CreateWanSoftwareDriverLinkage();
					}

					if (MULTICARD_SUPPORT == 0)
					{
						#define CARDTYPE "CardType"
						
						HKEY hKeyForCardType = NULL;
						DWORD dwDisposition;
						
						SendMessage(hwndPB, PBM_SETSTEP, (WPARAM) 5, 0);
						SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
						SetWindowText(hwndStatus,"Setting Card Type for service.");

						RegCreateKeyEx(HKEY_LOCAL_MACHINE, PATHTOPGPNETREGKEY,0, NULL,
								REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS, NULL,
								&hKeyForCardType, &dwDisposition);

						if (bWAN_Exists)
						{
							RegDeleteValue (hKeyForCardType, CARDTYPE);
							RegSetValueEx (hKeyForCardType, CARDTYPE, 0, REG_SZ, "NDISWAN", 8);
						}
						if (bLAN_Exists)
						{
							RegDeleteValue (hKeyForCardType, CARDTYPE);
							RegSetValueEx (hKeyForCardType, CARDTYPE, 0, REG_SZ, "NDIS", 5);
						}

						RegSetValueEx (hKeyForCardType, "AdapterNum", 0, REG_SZ, (char*)g_AdapterNum, strlen ((char*)g_AdapterNum)+1);

						if (hKeyForCardType)
							RegCloseKey (hKeyForCardType);

						#undef CARDTYPE		
					}

					/*100%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Complete.");
					Sleep (300);
					ShowWindow(hwndDlg, SW_HIDE);
					Sleep (20);
					/*run binding engine*/
					BindReview	(hwndDlg);
					for (i = 0; i < OurCardCount; i ++)
					{
						DisableExtraProtocols (gOurCardList[i].CardName);
					}
					/*second bind review needed because we disabled protocols*/
					BindReview	(hwndDlg);

					/*add Rebind entry to protect us from*/
					/*card removal*/
					AddRebindKey ();

					/*cleanup*/
					if (pDependonService)
						free (pDependonService);
				}
				else
				{
					/*We are running 95/98*/
					SetCursor(LoadCursor(NULL, IDC_WAIT));
					/*set statusbar text*/
					/*40%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Removing existing PGPnet bindings.");
					Sleep (500);
					Remove95(CLASSNETTRANS, 0);
					Remove95(ROOTNET, 1);
					Remove95(CLASSNET, 0);

					/*set statusbar text*/
					/*50%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Binding to new selections.");
					Sleep (500);
					SetSelectedItems95(hListControl);

					/*set statusbar text*/
					/*60%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Configuring protocols.");
					Sleep (500);
					ConfigSystemNetTrans();

					/*set statusbar text*/
					/*70%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Configuring selected NICS.");
					Sleep (500);
					ConfigSystemNet();
					ConfigEnumNet();

					/*set statusbar text*/
					/*80%*/
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Configuring protocols.");
					Sleep (500);
					ConfigEnumNetwork();
					
					/*set statusbar text*/
					/*100%*/
					SendMessage(hwndPB, PBM_SETSTEP, (WPARAM) 20, 0);
					SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
					SetWindowText(hwndStatus,"Complete.");
					SetRealMac();
					SetCursor(LoadCursor(NULL, IDC_ARROW));
					Sleep (500);
					ShowWindow(hwndDlg, SW_HIDE);
				}
			}
			/*cleanup*/
			if (SecuredKey)
				free (SecuredKey);
			/*quit*/
			/*set statusbar text*/
			SetWindowText(hwndStatus,"Complete.");
			Sleep (500);
			/*ask for reboot*/
			if (bSansCmdLine) 
			{
				RebootYesNo();
			}
			brc = SendMessage(hwndDlg, WM_QUIT, (WPARAM)NULL,(LPARAM)NULL);
			return TRUE;

		case IDB_SELECTCLEAR:
			if(Event == BN_CLICKED)
			{
				/*initialize flag*/
				bEverythingIsSelected = TRUE;
				/*get handle to list control*/
				hListControl = GetDlgItem(hwndDlg, IDC_ADAPTERLIST);
				/*get # of items is control*/
				NumberOfItems = ListView_GetItemCount(hListControl);
				/*check if Everything Is Selected*/
				for (Count = 0; Count < NumberOfItems; Count++)
				{
					if (bSelectionArray [Count] == 0)
						bEverythingIsSelected = FALSE;
				}
				/*fill structure to change icon*/
				lviKey.mask     = LVIF_IMAGE | LVIF_STATE; 
				lviKey.iSubItem = 0;
				lviKey.stateMask = -1;
				lviKey.state = 0; 
	
				/*get handle to Ok Button*/
				hOkButton = GetDlgItem(hwndDlg, IDB_PGPNETOK);
				if (bEverythingIsSelected)
				{
					/*changed text on button*/
					SetWindowText(hwndCommand, "Select &All");
					/*set image to change to*/
					lviKey.iImage = UNSELECTEDICON;
					if (!bSansCmdLine)
						EnableWindow(hOkButton, FALSE);
				}
				else
				{
					/*changed text on button*/
					SetWindowText(hwndCommand, "Clear &All");
					/*set image to change to*/
					lviKey.iImage = SELECTEDICON;
					if (!bSansCmdLine)
						EnableWindow(hOkButton, TRUE);
				}
					
				for (Count = 0; Count < NumberOfItems; Count++)
				{
					/*either set or clear the array*/
					if (bEverythingIsSelected)
						bSelectionArray[Count] = 0;
					else
						bSelectionArray[Count] = 1;
					/*set current item*/
					lviKey.iItem = Count;
					/*set the new state info*/
					ListView_SetItem (hListControl, &lviKey);
				}
			}
			return TRUE;

		case IDB_PGPNETCANCEL:
			if(Event == BN_CLICKED)
			{
				/*set statusbar text*/
				SetWindowText(hwndStatus,"Set Adapter cancelled.");
				/*if this was ran without command line, it is ok to*/
				/*just quit.*/
				if (bSansCmdLine) 
				{
					goto Cancel;
				}
				
				/*if cancelled and cards are found.*/
				if (gbNoCards)
				{
					goto CancelWriteEntry;
				}
				else
				{
					Response = MessageBox (GetFocus(), CONFIRM, TITLE,MB_YESNO | MB_ICONQUESTION | MB_DEFBUTTON2);
					switch (Response)
					{
					case IDYES:
						goto CancelWriteEntry;

					case IDNO:
						/*set statusbar text*/
						SetWindowText(hwndStatus,"Press OK after making selection.");
						return FALSE;
					}
				}
CancelWriteEntry:
			/*Write the PGPnetCancelled entry*/
			RegCreateKeyEx (HKEY_LOCAL_MACHINE, PATHTOPGPNETREGKEY,
						0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey,
						&dwDisposition);
			RegSetValueEx (hkey, "PGPnetCancelled", 0, REG_SZ, "UserCancelled", 14);
			RegCloseKey (hkey);
Cancel:
			/*Set the range and increment of the progress bar.*/
			SendMessage(hwndPB, PBM_SETRANGE, 0, MAKELPARAM(0, 100)); 
			SendMessage(hwndPB, PBM_SETSTEP, (WPARAM) 100, 0);
			/*100%*/
			SendMessage(hwndPB, PBM_STEPIT, (WPARAM) 0, (LPARAM) 0);
			Sleep(650);
			SendMessage (hwndDlg, WM_QUIT, (WPARAM)NULL,(LPARAM)NULL);
			}
			return TRUE;

		default:
			return FALSE;
    }
	return TRUE;
}


/*___________________________________________________________________________
 *	CreateImageList 
 */
BOOL CreateImageList ()
{
	HBITMAP			hBmp	= NULL;
	HWND			hHelpButton = NULL;
	int				iNumBits= 0;
	HDC				hDC     = NULL;

	hDC = GetDC (NULL);		/*DC for desktop*/
	iNumBits = GetDeviceCaps (hDC, BITSPIXEL) * GetDeviceCaps (hDC, PLANES);
	ReleaseDC (NULL, hDC);

	/*Check the resolution we are running at*/
	if (iNumBits <= 8) 
	{
		/*Low Res*/
		g_hImages = ImageList_Create (16, 16, ILC_COLOR | ILC_MASK, 
					NUM_BITMAPS, 0); 
		hBmp      = LoadBitmap (g_hInstance, MAKEINTRESOURCE (IDB_IMAGES4BIT));
		ImageList_AddMasked (g_hImages, hBmp, RGB(255, 0, 255));
		DeleteObject (hBmp);
		return TRUE;

	}
	else 
	{
		/*High res.*/
		g_hImages = ImageList_Create (16, 16, ILC_COLOR24 | ILC_MASK, 
					NUM_BITMAPS, 0); 
		hBmp      = LoadBitmap (g_hInstance, MAKEINTRESOURCE (IDB_IMAGES24BIT));
		ImageList_AddMasked (g_hImages, hBmp, RGB(255, 0, 255));
		DeleteObject (hBmp);
		return TRUE;
	}

	return FALSE;	
}

/*___________________________________________________________________________
 *	GetTxtAfterLastSlash
 */
LPTSTR GetTxtAfterLastSlash(LPTSTR Text)
{
	int		i				= 0;
	LPSTR	pszText			= NULL;
	
	while (*Text != '\0')
	{
		*Text ++;
	}

	/* *ServiceName is now at the end of the string*/
	while (*Text != '\\')
	{
		*Text --;
	}

	*Text ++;/*We do not want the '/'*/
	i = strlen(Text);
	pszText = malloc (i + 1);
	strcpy(pszText,Text);
	return pszText;
}	


/*___________________________________________________________________________
 *	GetTxtAfterFirstSlash
 */
LPTSTR GetTxtAfterFirstSlash(LPTSTR Text)
{
	int		i				= 0;
	LPSTR	pszText			= NULL;
	
	while (*Text != '\\')
	{
		*Text ++;
	}

	*Text ++;/*We do not want the '/'*/
	i = strlen(Text);
	pszText = malloc (i + 1);
	strcpy(pszText,Text);
	return pszText;
}

/*___________________________________________________________________________
 *	SetSelectedItems
 */
BOOL SetSelectedItems(HWND hwnd, BOOL SetBindings)
{
	return TRUE;
}


/*___________________________________________________________________________
 *	SetSelectedItems95
 */
BOOL SetSelectedItems95(HWND hwnd)
{
	HKEY	hkey;
	DWORD	dwDisposition;
	UINT	NumberOfItems;
	DWORD	dwIndex			= 0;
	int     cchTextMax		= 1024;
	LPSTR	pszText			= NULL;
	LPSTR	pszServiceName	= NULL;
	char	szText[20];


	/*get # of items is control*/
	NumberOfItems = ListView_GetItemCount(hwnd);

	if (NumberOfItems == 0)
		return FALSE;
	
	pszText		= malloc(cchTextMax);

	for (dwIndex = 0; dwIndex < NumberOfItems; dwIndex++)
	{
		ListView_GetItemText(hwnd, dwIndex, 0, pszText, cchTextMax);
		if (bSelectionArray[dwIndex] == 1)
		{
			/*clear memory*/
			ZeroMemory (szText, 20);
			/*build name of secured card entry*/
			wsprintf(szText, "FullSecuredCard%d",dwIndex);
			/*Write the FullSecuredCard reg entry*/
			RegCreateKeyEx(HKEY_LOCAL_MACHINE, PATHTOADAPTERLIST,
						0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hkey,
						&dwDisposition);
			RegSetValueEx(hkey, szText, 0, REG_SZ, pszText,
					strlen(pszText) + 1);
			RegCloseKey(hkey);
		}
	}
	/*cleanup*/
	if (pszText)
		free (pszText);

	return TRUE;
}


/*___________________________________________________________________________
 *	Invokes a binding review 	
 */
BOOL BindReview (HWND hwnd)
{
	FARPROC		fpExportedFunction	= NULL;
	HMODULE		hNetcfgDll			= NULL;
	LPCTSTR		lpModuleName		= NETCFGDLL;
	BOOL		brc;
	int			tResult;

	hNetcfgDll = LoadLibrary(lpModuleName); 

	if (hNetcfgDll == NULL)
		return FALSE;

	fpExportedFunction = (NetReviewFunc *) GetProcAddress(hNetcfgDll, SZNETREVIEW);
	if(fpExportedFunction == NULL)
	{
		brc = FreeLibrary(hNetcfgDll);
		return FALSE;
	}
	tResult = (*fpExportedFunction) (hwnd, 0);
	brc = FreeLibrary(hNetcfgDll);
	return TRUE;
}

/*___________________________________________________________________________
 *	AmIBoundToTcpip95
 */
BOOL AmIBoundToTcpip95 (char *Key)
{
	HKEY	hkey = NULL;
	UINT	nValues;
	LPSTR	pValueBuffer = NULL;
	DWORD	dwIndex;
	DWORD	nValueNameLen;
	DWORD   nValueNameLenb;
	LONG	lResult;
	BOOL	Pass;
	char	*BaseKey;

	Pass = FALSE;
	if(!Key)
		return FALSE;
	BaseKey = (char *)malloc(strlen(Key) + 12);
	ZeroMemory(BaseKey, (strlen(Key) + 12)); 

	strcat(BaseKey, Key);	
	strcat(BaseKey, "\\Bindings");
	/*Open key*/
	if (RegOpenKey(HKEY_LOCAL_MACHINE, BaseKey, &hkey) == ERROR_SUCCESS)
	{
		/*Determine number of values to enumerate*/
		RegQueryInfoKey(hkey, NULL, NULL, NULL, NULL, 
						NULL, NULL, &nValues, &nValueNameLen,
						NULL, NULL, NULL);

		/*Retrieve Registry values*/
		pValueBuffer = malloc(nValueNameLen + 1);
		for (dwIndex = 0; dwIndex < nValues; dwIndex++)
		{
			nValueNameLenb = nValueNameLen + 1;
			ZeroMemory(pValueBuffer,(nValueNameLen + 1)); 
			lResult = RegEnumValue( hkey, dwIndex, pValueBuffer, 
								&nValueNameLenb, NULL, NULL, NULL, NULL); 
			if (strstr(pValueBuffer, "MSTCP"))
				Pass = TRUE;
		}
	/*cleanup*/
	if	(pValueBuffer)
		free (pValueBuffer);
	if	(hkey)
		RegCloseKey (hkey);
	}
	if	(BaseKey)
		free (BaseKey);

	if (Pass)
		return TRUE;
	return FALSE;
}


/*___________________________________________________________________________
 *	AmIBoundToPGP95
 */
BOOL AmIBoundToPGP95 (char *Key)
{
	HKEY	hkey = NULL;
	UINT	nValues;
	LPSTR	pValueBuffer = NULL;
	DWORD	dwIndex;
	DWORD	nValueNameLen;
	DWORD   nValueNameLenb;
	LONG	lResult;
	BOOL	Pass;
	char	*BaseKey = NULL;

	Pass = FALSE;
	if(!Key)
		return FALSE;
	BaseKey = (char *)malloc(strlen(Key) + 12);
	ZeroMemory(BaseKey, (strlen(Key) + 12)); 

	strcat(BaseKey, Key);	
	strcat(BaseKey, "\\Bindings");
	/*Open key*/
	if (RegOpenKey(HKEY_LOCAL_MACHINE, BaseKey, &hkey) == ERROR_SUCCESS)
	{
		/*Determine number of keys to enumerate*/
		RegQueryInfoKey(hkey, NULL, NULL, NULL, NULL, 
						NULL, NULL, &nValues, &nValueNameLen,
						NULL, NULL, NULL);

		/*Retrieve Registry values*/
		pValueBuffer = malloc(nValueNameLen + 1);
		for (dwIndex = 0; dwIndex < nValues; dwIndex++)
		{
			nValueNameLenb = nValueNameLen + 1;
			ZeroMemory(pValueBuffer,(nValueNameLen + 1)); 
			lResult = RegEnumValue( hkey, dwIndex, pValueBuffer, 
								&nValueNameLenb, NULL, NULL, NULL, NULL); 
			if (strstr(pValueBuffer, "PGP"))
				Pass = TRUE;
		}
	/*cleanup*/
	if (pValueBuffer)
		free(pValueBuffer);
	if (hkey)
		RegCloseKey (hkey);
	}
	if(BaseKey)
		free(BaseKey);

	if (Pass)
		return TRUE;
	return FALSE;
}


/*___________________________________________________________________________
 *	AmIBoundToPGPNT
 */
BOOL AmIBoundToPGPNT (UINT index)
{
	HKEY	hPGPnetKey = NULL;
	HKEY	hSecuredCardKey = NULL;
	BOOL	bReturn = FALSE;


	if (strlen(gAdapterListNT[index].CardName) == 0)
		goto cleanup;

	/*open adapterlist key*/
	if (RegOpenKey(HKEY_LOCAL_MACHINE, SECUREDADAPTERKEY, &hPGPnetKey) == ERROR_SUCCESS)
	{		
		/*check for service name key, if there then it is bound*/
		if (RegOpenKey(hPGPnetKey, gAdapterListNT[index].CardName, &hSecuredCardKey) == ERROR_SUCCESS)
		{
			bReturn = TRUE;
			goto cleanup;
		}
	}

cleanup:
	if (hSecuredCardKey)
			RegCloseKey(hSecuredCardKey);
	if (hPGPnetKey)
		RegCloseKey (hPGPnetKey);
	
	return bReturn;
}


/*___________________________________________________________________________
 *	AmIBoundToTcpipNT
 */
BOOL AmIBoundToTcpipNT (UINT index)
{
	HKEY	hTcpipKey = NULL;
	BOOL	bReturn = TRUE;
	DWORD	dwMaxValueLen;
	DWORD	dwType;
	LPSTR	lpTcpipLinkage = NULL;


	/*Open key*/
	if (RegOpenKey(HKEY_LOCAL_MACHINE, TCPIPBINDKEY, &hTcpipKey) == ERROR_SUCCESS)
	{			
		/*get the max value length*/
		if (RegQueryInfoKey (hTcpipKey, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
							NULL, &dwMaxValueLen, NULL, NULL) == ERROR_SUCCESS)
		{
			/*allocate memory*/
			lpTcpipLinkage = malloc (dwMaxValueLen);
			/*get the tcp/ip bind values*/
			if (RegQueryValueEx(hTcpipKey, "bind", 0, &dwType, lpTcpipLinkage,
							&dwMaxValueLen) == ERROR_SUCCESS)
			{
				/*lpTcpipLinkage contains bind string*/
				bReturn = MultiStrStrCmp (lpTcpipLinkage, gAdapterListNT[index].ServiceName);
			}
			else
			{
				/*cannot query tcp/ip bindings*/
				MessageBox (GetFocus(), ERRTCPIPBINDCHECK, TITLE, 0 | MB_ICONERROR);
				bReturn = FALSE;
				goto Cleanup;
			}
		}

	}
	else
	{
		/*failed to open the tcpip service key*/
		MessageBox (GetFocus(), ERROPENINGTCPIP, TITLE, 0 | MB_ICONERROR);
		bReturn = FALSE;
		goto Cleanup;
	}
Cleanup:
	if (hTcpipKey)
		RegCloseKey(hTcpipKey);
	if (lpTcpipLinkage)
		free (lpTcpipLinkage);
	return bReturn;
}


/*___________________________________________________________________________
 *	RebootYesNo
 */
BOOL RebootYesNo ()
{
	int RC;
	HWND hDeskTop = NULL;

	if(bIsNT)
	{
		TOKEN_PRIVILEGES TpNew;
		HANDLE           hToken;
		LUID             ShutDownValue;

		OpenProcessToken( GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES |
						TOKEN_QUERY, &hToken);
		LookupPrivilegeValue( (LPSTR)NULL, SE_SHUTDOWN_NAME, &ShutDownValue);

		TpNew.PrivilegeCount = 1;
		TpNew.Privileges[0].Luid = ShutDownValue;
		TpNew.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

		AdjustTokenPrivileges( hToken, FALSE, &TpNew, sizeof(TpNew),
			(TOKEN_PRIVILEGES *)NULL, (DWORD *)NULL);
	}

 	RC = MessageBox (GetFocus (), STDREBOOTMSG, "Network Settings Change", MB_ICONWARNING | MB_YESNO);
	switch (RC)
	{
		case IDYES:
			ExitWindowsEx (EWX_REBOOT, 0);
			return TRUE;

		case IDNO:
			return FALSE;

		default:
			return FALSE;
	}
}


/*___________________________________________________________________________
 *	NeedReboot
 */
BOOL NeedReboot()
{
	HKEY			hMainKey		= HKEY_LOCAL_MACHINE;
	HKEY			hOpenKey		= NULL;
	LPSTR			Path;
	/*Set Runonce entry*/
	if (RegOpenKeyEx(hMainKey, RUNONCE, 0, KEY_ALL_ACCESS, &hOpenKey)
		== ERROR_SUCCESS)	
	{
		Path = SetExePath();
		strcat(Path, "\\setadapter.exe void");
		GetShortPathName(Path, Path, strlen(Path) + 1);

		RegSetValueEx(hOpenKey, "PGPnetNeedsReboot" , 0, REG_SZ, Path, strlen(Path)+1);
		RegCloseKey (hOpenKey);
		if (Path)
			free(Path);
	}
	return TRUE;
}


/*___________________________________________________________________________
 *	SetExePath
 */
char* SetExePath()
{
	char*		CommandLine;
	LPSTR		pstring;
	char*		pstringb;
	int			index;

	pstring = (char*)malloc(1024);
	ZeroMemory (pstring, 1024);
	GetModuleFileName(NULL, pstring, 1024);
	GetShortPathName(pstring, pstring, strlen(pstring) + 1);

	index = strlen(pstring);
	/*malloc index + 10 (10 needed for runonce)*/
	CommandLine = (char*)malloc (index + 10);
	ZeroMemory (CommandLine, index + 10);
	pstringb = pstring;

	while (*pstring == '"')
	{
		*pstring ++;
	}

	*pstringb = *pstring;

	while (*pstringb != '\0')
	{
		*pstringb ++;
	}
	while (*pstringb != '\\')
	{
		*pstringb --;
	}

	for (index = 0; pstring != pstringb; index ++)
	{
		CommandLine[index] = pstring[0];
		pstring++;
	}
	CommandLine[index] = '\0';
	return CommandLine;
}







/*****************************************************************************/

/*HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Ncpa\CurrentVersion\ConfigChanged

/*To install inf file:

fpNetInstall = (NetInstallFunc *) GetProcAddress( hNetcfgDll, SZNETINSTALL );

tResult = ( *fpNetInstall ) ( hWindow,
TZPRODUCTNAME,
szInfPath,
szSrcPath,
NULL,
INFINSTALL_SUPPORTED | INFINSTALL_INPROCINTERP,
&dwReturn );


char szMsg[200];
LoadString(g_hInst, IDS_WRONGOS, szMsg, sizeof(szMsg));
MessageBox (NULL, szMsg, g_szAppName, 
MB_OK|MB_ICONEXCLAMATION);
*/


/*windows 95/98 work
typedef struct
{
	char CardName[256];
	char Path[_MAX_PATH];
	char NetSlot[5];
	char TransSlot[5];
	char EnumNetSlot[5];
	char RealMac[5];
} * LPAdapter95, Adapter95;


X1) Get all NIC adapters For each one, check if it is
Xbound to TCP/ip if it is put it into list control
Xwith a empty selection icon.

X2) If it is'nt bound to TCP/ip check if its bound to 
XPGP, if it is put it into the list control with
Xa lock icon.

X3) Store state of things into bPreviousSelectionArray[]
Xand bSelectionArray[]

X4) as items are selected/deselected bSelectionArray[]
Xwill be modified.

X5) When Ok is pressed compare bPreviousSelectionArray[]
Xand bSelectionArray[], if they are the same, do nothing.
XIf they are different unbind from all existing secured 
Xcards then rebind to the new selection.
*/






























