/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	

	$Id: confignt.c,v 1.15.2.7 1999/10/27 19:46:23 philipn Exp $
____________________________________________________________________________*/
#pragma message( "Compiling " __FILE__ ) 
#pragma message( "Last modified on " __TIMESTAMP__ ) 

#include <windows.h>
#include <stdio.h>
#include <commctrl.h>
#include "Lister.h"
#include "globals.h"

/*___________________________________________________________________________
 *	creates the pgpnet transport service entry
 */
int CreatePGPTransportService (LPSTR DRIVERNAME)
{
	#define FILEPATH				"\\SystemRoot\\System32\\drivers\\PGPnet.sys"
	#define	DISPLAYNAME				"PGPnet VPN Driver Transport"
	#define DRIVER_NO_ERROR			0
	#define DRIVER_NOT_WINNT		1
	#define DRIVER_ACCESS_ERROR		2
	#define DRIVER_CREATE_FAIL		3
	#define DRIVER_ALREADY_STARTED	4
	#define DRIVER_MISC_ERROR		5
	#define UNKNOWN_ERROR			6

	int				err         = UNKNOWN_ERROR;
	SC_HANDLE		schSCMan	= NULL;
	SC_HANDLE		schServ		= NULL;
	DWORD			dwErr;


	/*open service control manager*/
	schSCMan = OpenSCManager (NULL, NULL, SC_MANAGER_CREATE_SERVICE);
	if (schSCMan == NULL) 
	{
		dwErr = GetLastError();
		if (dwErr == ERROR_ACCESS_DENIED)
		{
			err = DRIVER_ACCESS_ERROR;
			goto done;
		}
		else 
		{
			err = DRIVER_MISC_ERROR;
			goto done;
		}
	}
	/*ok, success open of service control manager*/
	else 
	{
		/*try to create new service ...*/
		schServ = CreateService (schSCMan, DRIVERNAME, DISPLAYNAME,
					SERVICE_ALL_ACCESS, SERVICE_FILE_SYSTEM_DRIVER,
					SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL,
					FILEPATH, "TDI", NULL, NULL, NULL, NULL);

		if (schServ == NULL)
		{
			err = DRIVER_CREATE_FAIL;
			goto done;
		}
		
	}
	err = DRIVER_NO_ERROR;

done :
	/*cleanup*/
	if (schServ)
		CloseServiceHandle (schServ);
	if (schSCMan)
		CloseServiceHandle (schSCMan);

	#undef FILEPATH
	#undef DISPLAYNAME
	#undef DRIVER_NO_ERROR
	#undef DRIVER_NOT_WINNT
	#undef DRIVER_ACCESS_ERROR
	#undef DRIVER_CREATE_FAIL
	#undef DRIVER_ALREADY_STARTED
	#undef DRIVER_MISC_ERROR
	#undef UNKNOWN_ERROR

	return err;
}


/*___________________________________________________________________________
 *	manually creates the pgpnet transport service entry
 */
BOOL ManualCreatePGPTransportService (LPSTR DRIVERNAME)
{
	#define FILEPATH				"\\SystemRoot\\System32\\drivers\\PGPnet.sys"
	#define KEYPATH					"SYSTEM\\CurrentControlSet\\Services\\ZZPGPMac"
	#define	DISPLAYNAME				"PGPnet VPN Driver Transport"
	#define	GROUP					"TDI"
	#define START			3
	#define TYPE			2
	#define	ERRORCONTROL	1
	
	HKEY hOpenKey = NULL;
	BOOL berr = TRUE;
	DWORD dwDisposition;
	DWORD dwValue = 0;
	

	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, KEYPATH,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hOpenKey,&dwDisposition)
					== ERROR_SUCCESS)
	{
		/*set DisplayName value*/
		RegSetValueEx (hOpenKey, "DisplayName", 0, REG_SZ, 
					DISPLAYNAME, strlen(DISPLAYNAME) + 1);

		/*ErrorControl*/
		dwValue = ERRORCONTROL;
		RegSetValueEx (hOpenKey, "ErrorControl", 0, REG_DWORD,
					(const BYTE*) &dwValue, sizeof(dwValue));

		/*set Group value*/
		RegSetValueEx (hOpenKey, "Group", 0, REG_SZ, 
					GROUP, strlen(GROUP) + 1);

		/*set ImagePath value*/
		RegSetValueEx (hOpenKey, "ImagePath", 0, REG_SZ, 
					FILEPATH, strlen(FILEPATH) + 1);

		/*Start*/
		dwValue = START;
		RegSetValueEx (hOpenKey, "Start", 0, REG_DWORD,
					(const BYTE*) &dwValue, sizeof(dwValue));

		/*Type*/
		dwValue = TYPE;
		RegSetValueEx (hOpenKey, "Type", 0, REG_DWORD,
					(const BYTE*) &dwValue, sizeof(dwValue));
	}
	else
		berr = FALSE;


	/*cleanup*/
	if (hOpenKey)
		RegCloseKey (hOpenKey);

	#undef FILEPATH
	#undef KEYPATH		
	#undef DISPLAYNAME			
	#undef GROUP				
	#undef START		
	#undef TYPE
	#undef ERRORCONTROL

	return berr;
}


/*___________________________________________________________________________
 *	creates linkage structure for the pgp vpn transport
 */
BOOL LinkPGPTransportService ()
{
	#define PGPTRANSLINKAGEKEY	"SYSTEM\\CurrentControlSet\\Services\\ZZPGPMac\\Linkage"
	#define PGPTRANSDISABLEKEY	"SYSTEM\\CurrentControlSet\\Services\\ZZPGPMac\\Linkage\\Disabled"

	HKEY hLinkageKey	= NULL;
	HKEY hDisabledKey	= NULL;
	BOOL err			= TRUE;
	DWORD dwDisposition;
	

	/*create the linkage subkey*/
	RegCreateKeyEx(HKEY_LOCAL_MACHINE, PGPTRANSLINKAGEKEY,
	0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hLinkageKey,
	&dwDisposition);

	/*create the linkage disabled subkey*/
	RegCreateKeyEx(HKEY_LOCAL_MACHINE, PGPTRANSDISABLEKEY,
	0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hDisabledKey,
	&dwDisposition);
	
	/*create bind entry*/
	RegSetValueEx (hLinkageKey, "Bind", 0, REG_MULTI_SZ, "", 0);
	RegSetValueEx (hDisabledKey, "Bind", 0, REG_MULTI_SZ, "", 0);

	/*create export entry*/
	RegSetValueEx (hLinkageKey, "Export", 0, REG_MULTI_SZ, "", 0);
	RegSetValueEx (hDisabledKey, "Export", 0, REG_MULTI_SZ, "", 0);

	/*create route entry*/
	RegSetValueEx (hLinkageKey, "Route", 0, REG_MULTI_SZ, "", 0);
	RegSetValueEx (hDisabledKey, "Route", 0, REG_MULTI_SZ, "", 0);

	/*cleanup*/
	if (hLinkageKey)
		RegCloseKey(hLinkageKey);
	if (hDisabledKey)
		RegCloseKey(hDisabledKey);
	#undef PGPTRANSLINKAGEKEY
	#undef PGPTRANSDISABLEKEY

	return err;
}


/*___________________________________________________________________________
 *	creates exported driver entries under service key
 */
BOOL CreateExportedDriver (LPSTR CardName)
{
	#define SERVICES_PATH	"SYSTEM\\CurrentControlSet\\Services\\"
	#define DISABLED_PATH	"\\Linkage\\Disabled"
	#define LINKAGE_PATH	"\\Linkage"

	HKEY hMainKey = NULL;
	HKEY hLinkKey = NULL;
	HKEY hDisableKey = NULL;
	LPSTR pKeyPath;
	DWORD dwValue;
	DWORD dwDisposition;
	BOOL berr = TRUE;


	/*allocate and clear memory*/
	pKeyPath = malloc (MAX_PATH);
	ZeroMemory (pKeyPath, MAX_PATH);	

	strcpy (pKeyPath, SERVICES_PATH);
	strcat (pKeyPath, CardName);

	/*create the main key*/
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, pKeyPath,
			0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hMainKey,
			&dwDisposition) == ERROR_SUCCESS)
	{
		/*set values*/
		dwValue = 4;
		RegSetValueEx (hMainKey, "Type", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof (dwValue));
		dwValue = 3;
		RegSetValueEx (hMainKey, "Start", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof (dwValue));
		dwValue = 1;
		RegSetValueEx (hMainKey, "ErrorControl", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof (dwValue));
	}
	else
		berr = FALSE;

	/*clear memory*/
	ZeroMemory (pKeyPath, MAX_PATH);

	strcpy (pKeyPath, SERVICES_PATH);
	strcat (pKeyPath, CardName);
	strcat (pKeyPath, LINKAGE_PATH);

	/*create the main key*/
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, pKeyPath,
			0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hLinkKey,
			&dwDisposition) == ERROR_SUCCESS)
	{
		/*set values*/
		RegSetValueEx (hLinkKey, "Bind", 0, REG_MULTI_SZ, "", 0);
		RegSetValueEx (hLinkKey, "Export", 0, REG_MULTI_SZ, "", 0);
		RegSetValueEx (hLinkKey, "Route", 0, REG_MULTI_SZ, "", 0);
	}
	else
		berr = FALSE;

	/*clear memory*/
	ZeroMemory (pKeyPath, MAX_PATH);

	strcpy (pKeyPath, SERVICES_PATH);
	strcat (pKeyPath, CardName);
	strcat (pKeyPath, DISABLED_PATH);

	/*create the main key*/
	if (RegCreateKeyEx(HKEY_LOCAL_MACHINE, pKeyPath,
			0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hDisableKey,
			&dwDisposition) == ERROR_SUCCESS)
	{
		/*set values*/
		RegSetValueEx (hDisableKey, "Bind", 0, REG_MULTI_SZ, "", 0);
		RegSetValueEx (hDisableKey, "Export", 0, REG_MULTI_SZ, "", 0);
		RegSetValueEx (hDisableKey, "Route", 0, REG_MULTI_SZ, "", 0);
	}
	else
		berr = FALSE;

	/*cleanup*/
	if (hMainKey)
		RegCloseKey (hMainKey);
	if (hLinkKey)
		RegCloseKey (hLinkKey);
	if (hDisableKey)
		RegCloseKey (hDisableKey);
	if (pKeyPath)
		free(pKeyPath);

	#undef SERVICES_PATH
	#undef DISABLED_PATH
	#undef LINKAGE_PATH

	return berr;
}


/*___________________________________________________________________________
 *	creates the pgpnet driver service entry
 */
int CreatePGPDriverService (LPSTR DRIVERNAME, LPSTR DisplayName, LPSTR pGroup, LPSTR pDependonService)
{
	#define FILEPATH				"\\SystemRoot\\System32\\drivers\\PGPnet.sys"
	#define DRIVER_NO_ERROR			0
	#define DRIVER_NOT_WINNT		1
	#define DRIVER_ACCESS_ERROR		2
	#define DRIVER_CREATE_FAIL		3
	#define DRIVER_ALREADY_STARTED	4
	#define DRIVER_MISC_ERROR		5
	#define UNKNOWN_ERROR			6

	int				err         = UNKNOWN_ERROR;
	SC_HANDLE		schSCMan	= NULL;
	SC_HANDLE		schServ		= NULL;
	DWORD			dwErr;


	/*open service control manager*/
	schSCMan = OpenSCManager (NULL, NULL, SC_MANAGER_CREATE_SERVICE);
	if (schSCMan == NULL) 
	{
		dwErr = GetLastError();
		if (dwErr == ERROR_ACCESS_DENIED)
		{
			err = DRIVER_ACCESS_ERROR;
			goto done;
		}
		else 
		{
			err = DRIVER_MISC_ERROR;
			goto done;
		}
	}
	/*ok, success open of service control manager*/
	else 
	{
		/*try to create new service ...*/
		char szText[256];
		schServ = CreateService (schSCMan, DRIVERNAME, DisplayName,
					SERVICE_ALL_ACCESS, SERVICE_KERNEL_DRIVER,
					SERVICE_AUTO_START, SERVICE_ERROR_NORMAL,
					FILEPATH, pGroup, NULL, pDependonService, NULL, NULL);
		if (schServ == NULL)	
			wsprintf(szText, "Error code: %d", GetLastError());

		if (schServ == NULL)
		{
			err = DRIVER_CREATE_FAIL;
			goto done;
		}
		
	}
	err = DRIVER_NO_ERROR;

done:
	/*cleanup*/
	if (schServ)
		CloseServiceHandle (schServ);
	if (schSCMan)
		CloseServiceHandle (schSCMan);
	#undef FILEPATH
	#undef DRIVER_NO_ERROR
	#undef DRIVER_NOT_WINNT
	#undef DRIVER_ACCESS_ERROR
	#undef DRIVER_CREATE_FAIL
	#undef DRIVER_ALREADY_STARTED
	#undef DRIVER_MISC_ERROR
	#undef UNKNOWN_ERROR

	return err;
}


/*___________________________________________________________________________
 *	creates linkage structure for the pgp vpn driver
 */
BOOL LinkPGPDriverService (LPSTR ServiceName)
{
	#define SERVICES			"SYSTEM\\CurrentControlSet\\Services\\"

	HKEY hLinkageKey			= NULL;
	HKEY hDisabledKey			= NULL;
	LPSTR PGPDriverLinkageKey	= NULL;
	LPSTR PGPDriverDisablekey	= NULL;
	BOOL err					= TRUE;
	DWORD dwDisposition;

	
	/*allocate memory*/
	PGPDriverLinkageKey = malloc (MAX_PATH);
	PGPDriverDisablekey = malloc (MAX_PATH);
	/*clear memory*/
	ZeroMemory(PGPDriverLinkageKey, MAX_PATH);
	ZeroMemory(PGPDriverDisablekey, MAX_PATH);

	/*construct linkage key*/
	strcpy(PGPDriverLinkageKey, SERVICES);
	strcat(PGPDriverLinkageKey, ServiceName);
	strcat(PGPDriverLinkageKey, "\\");
	strcat(PGPDriverLinkageKey, "Linkage");

	/*construct linkage disable key*/
	strcpy(PGPDriverDisablekey, SERVICES);
	strcat(PGPDriverDisablekey, ServiceName);
	strcat(PGPDriverDisablekey, "\\");
	strcat(PGPDriverDisablekey, "Linkage\\Disabled");

	/*create the linkage subkey*/
	RegCreateKeyEx(HKEY_LOCAL_MACHINE, PGPDriverLinkageKey,
	0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hLinkageKey,
	&dwDisposition);

	/*create the linkage disabled subkey*/
	RegCreateKeyEx(HKEY_LOCAL_MACHINE, PGPDriverDisablekey,
	0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hDisabledKey,
	&dwDisposition);
	
	/*create bind entry*/
	RegSetValueEx (hLinkageKey, "Bind", 0, REG_MULTI_SZ, "", 0);
	RegSetValueEx (hDisabledKey, "Bind", 0, REG_MULTI_SZ, "", 0);

	/*create export entry*/
	RegSetValueEx (hLinkageKey, "Export", 0, REG_MULTI_SZ, "", 0);
	RegSetValueEx (hDisabledKey, "Export", 0, REG_MULTI_SZ, "", 0);

	/*create route entry*/
	RegSetValueEx (hLinkageKey, "Route", 0, REG_MULTI_SZ, "", 0);
	RegSetValueEx (hDisabledKey, "Route", 0, REG_MULTI_SZ, "", 0);

	/*cleanup*/
	if (hLinkageKey)
		RegCloseKey(hLinkageKey);
	if (hDisabledKey)
		RegCloseKey(hDisabledKey);
	if (PGPDriverLinkageKey)
		free(PGPDriverLinkageKey);
	if (PGPDriverDisablekey)
		free (PGPDriverDisablekey);
	#undef SERVICES

	return err;
}


/*___________________________________________________________________________
 *	write out all the parameters for a given nic instance
 */
BOOL SetDriverParms (UINT Instance, UINT CardIndex)
{
	#define FULLSERVICESTUB	"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\"
	#define SERVICESTUB		"SYSTEM\\CurrentControlSet\\Services\\"
	#define TCPIPPARMS		"\\Parameters\\Tcpip"
	#define PARAMETERS		"\\Parameters"


	BOOL err = TRUE;
	HKEY hOpenSrcKey	= NULL;
	HKEY hOpenDestKey	= NULL;
	LPSTR SrcKey;
	LPSTR DestKey;
	LPBYTE pScratchBuffer = NULL;
	DWORD dwValue = 0;
	DWORD dwLongestValue = 0;
	DWORD dwLength;
	DWORD dwType;
	LPSTR PGPInstance;

	/*allocate memory*/
	SrcKey = malloc (MAX_PATH);
	DestKey = malloc (MAX_PATH);
	/*NdisWanZZPGPMacMP## + 1 = EXPORTEDNAMELENGTH*/
	PGPInstance = malloc (EXPORTEDNAMELENGTH);

	/*clear memory*/
	ZeroMemory (SrcKey, MAX_PATH);
	ZeroMemory (DestKey, MAX_PATH);
	ZeroMemory (PGPInstance, EXPORTEDNAMELENGTH);

	/*if this is a WAN card*/
	if (gAdapterListNT [CardIndex].IsWan)
		/*fill in pgpinstance*/
		sprintf (PGPInstance, "NdisWanZZPGPMacMP%d", Instance);
	else
		/*fill in pgpinstance*/
		sprintf (PGPInstance, "ZZPGPMacMP%d", Instance);

	/*create the srckey path*/
	strcpy (SrcKey, FULLSERVICESTUB);
	strcat (SrcKey, gAdapterListNT [CardIndex].ServiceName);
	strcat (SrcKey, TCPIPPARMS);
	/*create the destkey path*/
	strcpy (DestKey, FULLSERVICESTUB);
	strcat (DestKey, PGPInstance);
	strcat (DestKey, TCPIPPARMS);	

	/*copy the tcp/ip parms over*/
	if (CopyRegistryKeyValues (SrcKey, DestKey) == FALSE)
	{
		MessageBox (GetFocus(), ERRTCPCOPY, TITLE, 0 | MB_ICONERROR);
		err = FALSE;
		goto cleanup;
	}
	/*now we set the rest of the needed info*/
	/*clear memory*/
	ZeroMemory (SrcKey, MAX_PATH);
	ZeroMemory (DestKey, MAX_PATH);

	/*create the srckey path*/
	strcpy (SrcKey, SERVICESTUB);
	strcat (SrcKey, gAdapterListNT [CardIndex].ServiceName);
	strcat (SrcKey, PARAMETERS);
	/*create the destkey path*/
	strcpy (DestKey, SERVICESTUB);
	strcat (DestKey, PGPInstance);
	strcat (DestKey, PARAMETERS);

	/*open source key*/
	RegOpenKeyEx (HKEY_LOCAL_MACHINE, SrcKey, 0, KEY_ALL_ACCESS, &hOpenSrcKey);
	/*open destination key*/
	RegOpenKeyEx (HKEY_LOCAL_MACHINE, DestKey, 0, KEY_ALL_ACCESS, &hOpenDestKey);

	/*Determine longest value within hOpenSrcKey*/
	RegQueryInfoKey(hOpenSrcKey, NULL, NULL, NULL, NULL, 
					NULL, NULL, NULL, NULL,
					&dwLongestValue, NULL, NULL);

	/*set length*/
	dwLength = dwLongestValue + 1;
	/*allocate memory and zero*/
	pScratchBuffer = (LPBYTE) calloc(sizeof(BYTE), dwLongestValue + 1);
	/*get FIPSAddress*/
	if (RegQueryValueEx(hOpenSrcKey, "FIPAddress", 0, &dwType, pScratchBuffer, &dwLength)
					== ERROR_SUCCESS)
	{
		/*set to pgpnet card*/
		RegSetValueEx (hOpenDestKey, "FIPAddress", 0, dwType, pScratchBuffer, dwLength);
	}

	/*set length*/
	dwLength = dwLongestValue + 1;
	/*clear buffer*/
	ZeroMemory (pScratchBuffer, dwLength);
	
	/*set AutoIPAddress, EnumExportPref & ServerAdapter*/
	if (gAdapterListNT [CardIndex].IsWan)
	{
		dwValue = 1;
		RegSetValueEx (hOpenDestKey, "AutoIPAddress", 0, REG_DWORD, (const BYTE*)  &dwValue, sizeof(DWORD));
		dwValue = 0;
		RegSetValueEx (hOpenDestKey, "EnumExportPref", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof(DWORD));
		dwValue = 1;
		RegSetValueEx (hOpenDestKey, "ServerAdapter", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof(DWORD));
	}  

	/*set length*/
	dwLength = dwLongestValue + 1;
	/*clear buffer*/
	ZeroMemory (pScratchBuffer, dwLength);
	/*get FIPSAddress*/
	if (RegQueryValueEx(hOpenSrcKey, "FIPSubnetMask", 0, &dwType, pScratchBuffer, &dwLength)
					== ERROR_SUCCESS)
	{
		/*set to pgpnet card*/
		RegSetValueEx (hOpenDestKey, "FIPSubnetMask", 0, dwType, pScratchBuffer, dwLength);
	}

	/*set MediaType*/
	dwValue = 1;
	RegSetValueEx (hOpenDestKey, "MediaType", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof(DWORD));
	
	/*set dwValue to 0 for BusNumber && BusType*/
	dwValue = 0;
	/*BusNumber*/
	RegSetValueEx (hOpenDestKey, "BusNumber", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof(dwValue));
	/*BusType*/
	RegSetValueEx (hOpenDestKey, "BusType", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof(dwValue));
	/*set dwValue to instance #*/
	dwValue = gAdapterListNT [CardIndex].InstanceNumber;
	/*set to pgpnet card*/
	RegSetValueEx (hOpenDestKey, "InstanceNumber", 0, REG_DWORD,(const BYTE*) &dwValue, sizeof(dwValue));
	/*RealMac*/
	RegSetValueEx (hOpenDestKey, "RealMac", 0, REG_SZ, gAdapterListNT [CardIndex].RealMac,
				strlen(gAdapterListNT [CardIndex].RealMac) + 1);

	/*cleanup*/
cleanup:
	if (PGPInstance)
		free (PGPInstance);
	if (hOpenSrcKey)
		RegCloseKey (hOpenSrcKey);
	if (hOpenDestKey)
		RegCloseKey (hOpenDestKey);
	if (pScratchBuffer)
		free (pScratchBuffer);
	if (SrcKey)
		free (SrcKey);
	if (DestKey)
		free (DestKey);
	#undef FULLSERVICESTUB
	#undef SERVICESTUB
	#undef TCPIPPARMS
	#undef PARAMETERS

	return err;
}


/*___________________________________________________________________________
 *	returns a free adapter instance # within adapter registry key.
 *  the key is created and parameters entered.
 */
UINT GetFreeInstanceNumber(UINT CardIndex)
{
	#define AdapterKey			"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\NetworkCards\\"
	#define SignatureValue		"PGPnet"
	#define	ADAPTER_TITLE		"PGPnet VPN Driver Virtual Adapter"
	#define MANUF				"Network Associates Inc."
	#define	SIZEOFBUFFER		75

	HKEY	hOpenKey = NULL;
	HKEY	hOpenNetRules = NULL;
	UINT	uintIndex;
	LPSTR	lpstrKeyPath;
	DWORD	dwDisposition;

	
	/*allocate memory*/
	lpstrKeyPath = malloc (MAX_PATH);
	/*clear memory*/
	ZeroMemory (lpstrKeyPath, MAX_PATH);

	/*Find an open adapter position*/
	for(uintIndex = 1; uintIndex < 1000; uintIndex ++)
	{
		sprintf(lpstrKeyPath,AdapterKey"%d", uintIndex);

		/*create the instance # key*/
		if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, lpstrKeyPath,
					0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hOpenKey,
					&dwDisposition) == ERROR_SUCCESS)
		{
			if (dwDisposition == REG_CREATED_NEW_KEY)
			{
				LPSTR pScratchBuffer;
				DWORD dwValue;

				/*allocate memory*/
				pScratchBuffer = malloc (SIZEOFBUFFER);
				/*clear memory*/
				ZeroMemory (pScratchBuffer, SIZEOFBUFFER);
			
				/*set value to denote that its our key*/
				RegSetValueEx (hOpenKey, SignatureValue, 0, REG_SZ, SignatureValue,
				strlen(SignatureValue) + 1);
				/*set Description value*/
				RegSetValueEx (hOpenKey, "Description", 0, REG_SZ, 
				ADAPTER_TITLE, strlen(ADAPTER_TITLE) + 1);
				/*set Manufacturer value*/
				RegSetValueEx (hOpenKey, "Manufacturer", 0, REG_SZ, 
				MANUF, strlen(MANUF) + 1);
				/*if this is a WAN card*/
				if (gAdapterListNT [CardIndex].IsWan)
				{
					/*set ProductName value*/
					RegSetValueEx (hOpenKey, "ProductName", 0, REG_SZ, 
					"NdisWanZZPGPMacMP", 18);
				}
				else
				{
					/*set ProductName value*/
					RegSetValueEx (hOpenKey, "ProductName", 0, REG_SZ, 
					"ZZPGPMacMP", 11);
				}
				/*if this is a WAN card*/
				if (gAdapterListNT [CardIndex].IsWan)
					sprintf (pScratchBuffer, "NdisWanZZPGPMacMP%d", uintIndex);
				else
					sprintf (pScratchBuffer, "ZZPGPMacMP%d", uintIndex);
				/*set ServiceName value*/
				RegSetValueEx (hOpenKey, "ServiceName", 0, REG_SZ, 
				pScratchBuffer, strlen(pScratchBuffer) + 1);
				/*set Title value*/
				/*clear memory*/
				ZeroMemory (pScratchBuffer, SIZEOFBUFFER);
				/*if this is a WAN card*/
				if (gAdapterListNT [CardIndex].IsWan)
					sprintf (pScratchBuffer, "[%d] PGPnet VPN WAN Driver Virtual Adapter", uintIndex);
				else
					sprintf (pScratchBuffer, "[%d] PGPnet VPN LAN Driver Virtual Adapter", uintIndex);

				RegSetValueEx (hOpenKey, "Title", 0, REG_SZ, 
				pScratchBuffer, strlen(pScratchBuffer) + 1);
				/*set Hidden*/
				dwValue = 0x1;
				RegSetValueEx (hOpenKey, "Hidden", 0, REG_DWORD, 
				(const BYTE*) &dwValue, sizeof (dwValue));

				/*setup netrules, create key*/
				if(RegCreateKeyEx(hOpenKey, "NetRules",0,
								NULL, REG_OPTION_NON_VOLATILE,
								KEY_ALL_ACCESS, NULL, &hOpenNetRules,
								&dwDisposition) == ERROR_SUCCESS)
				{
					/*clear memory*/
					ZeroMemory (pScratchBuffer, SIZEOFBUFFER);
					/*if this is a WAN card*/
					if (gAdapterListNT [CardIndex].IsWan)
					{
						/*put bindform into buffer*/
						sprintf (pScratchBuffer, "\"NdisWanZZPGPMacMP%d\" yes yes container", uintIndex);
					}
					else
					{
						/*put bindform into buffer*/
						sprintf (pScratchBuffer, "\"ZZPGPMacMP%d\" yes yes container", uintIndex);
					}
					/*set bindform value*/
					RegSetValueEx (hOpenNetRules, "bindform", 0, REG_SZ, 
					pScratchBuffer, strlen(pScratchBuffer) + 1);
					/*set type value*/
					RegSetValueEx (hOpenNetRules, "type", 0, REG_SZ, 
					"PGP PGPAdapter", 15);
					/*create class entry*/
					RegSetValueEx (hOpenNetRules, "class", 0, REG_MULTI_SZ, "", 0);
					/*add multi_sz value*/
					AddStringToMultiString (hOpenNetRules, "class", "PGPAdapter basic");

				}

				/*cleanup*/
				if (hOpenNetRules)
					RegCloseKey (hOpenNetRules);
				if (pScratchBuffer)
					free (pScratchBuffer);

				goto cleanup;
			}
		}
		if (hOpenKey)
			RegCloseKey(hOpenKey);
	}
	/*failure to find slot*/
	uintIndex = 0;

	/*cleanup*/
cleanup:
	if (hOpenKey)
		RegCloseKey(hOpenKey);
	if (lpstrKeyPath)
		free(lpstrKeyPath);
	#undef AdapterKey
	#undef SignatureValue
	#undef ADAPTER_TITLE	
	#undef MANUF
	#undef PRODNAME
	#undef SIZEOFBUFFER

	return uintIndex;
}

/*___________________________________________________________________________
 *	creates reg. key
 */
BOOL MyCreateBackupKey(HKEY hKey, LPSTR Key, LPSTR Subkey, UINT Count)
{
	HKEY hOpenKey = NULL;
	BOOL bErr = TRUE;
	LPSTR FullKey;
	int KeyLength;
	DWORD dwDisposition;

	/*calculate key length*/
	KeyLength = (strlen(Key) + strlen(Subkey) + 3);

	/*allocate memory*/
	FullKey = malloc (KeyLength);
	/*clear memory*/
	ZeroMemory (FullKey, KeyLength);

	/*build key*/
	strcpy (FullKey, Key);
	strcat (FullKey, "\\");
	strcat (FullKey, Subkey);

	/*create the instance # key*/
	if(RegCreateKeyEx(hKey, FullKey,0, NULL, REG_OPTION_NON_VOLATILE,
				KEY_ALL_ACCESS, NULL, &hOpenKey,&dwDisposition)
				!= ERROR_SUCCESS)
	{
		ErrorReport("Unable to create key.", "MyCreateBackupKey ()"); 
		bErr = FALSE;
	}
	else
	{
		if (gAdapterListNT [Count].IsWan)
		{
			RegSetValueEx(hOpenKey,"WAN", 0, REG_SZ, "WAN", 4);
		}
		else
		{
			RegSetValueEx(hOpenKey,"LAN", 0, REG_SZ, "LAN", 4);
		}
	}
	
	/*cleanup*/
	if (hOpenKey)
		RegCloseKey (hOpenKey);
	if (FullKey)
		free (FullKey);

	return bErr;
}


/*___________________________________________________________________________
 *	creates HKEY_LOCAL_MACHINE\SOFTWARE\Network Associates\NdisWanZZPGPMacMP
 *  and all related parameters and NetRules.
 */
BOOL CreateWanSoftwareDriverLinkage ()
{
	#define CURVER				"SOFTWARE\\Network Associates\\NdisWanZZPGPMacMP\\CurrentVersion"
	#define NETRUL				"SOFTWARE\\Network Associates\\NdisWanZZPGPMacMP\\CurrentVersion\\NetRules"
	#define	ADAPTER_TITLE		"PGPnet VPN Driver Virtual Adapter"
	#define SERVICE_NAME		"NdisWanZZPGPMacMP"
	#define	SOFTWARE_TYPE		"driver"
	#define TITLE_NAME			"PGPnet VPN WAN Driver Virtual Adapter"
	#define BINDFORM			"\"PGPSys\" yes no container"
	#define	TYPE_VALUE			"PGPSys ndisDriver PGPDriver"
	#define USE_VALUE			"driver"

	HKEY	hCurrentVerKey = NULL;
	HKEY	hNetRuleKey = NULL;
	DWORD	dwDisposition;
	DWORD	dwValue = 1;
	BOOL	berr  = TRUE;


	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, CURVER,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hCurrentVerKey,&dwDisposition)
					== ERROR_SUCCESS)
	{
		/*set Description value*/
		RegSetValueEx (hCurrentVerKey, "Description", 0, REG_SZ, 
		ADAPTER_TITLE, strlen(ADAPTER_TITLE) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "ServiceName", 0, REG_SZ, 
		SERVICE_NAME, strlen(SERVICE_NAME) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "SoftwareType", 0, REG_SZ, 
		SOFTWARE_TYPE, strlen(SOFTWARE_TYPE) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "Title", 0, REG_SZ, 
		TITLE_NAME, strlen(TITLE_NAME) + 1);
		/*Hidden*/
		RegSetValueEx (hCurrentVerKey, "Hidden", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof(dwValue));
	}
	else
		berr = FALSE;
	/*cleanup*/
	if (hCurrentVerKey)
		RegCloseKey (hCurrentVerKey);

	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, NETRUL,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hNetRuleKey,&dwDisposition)
					== ERROR_SUCCESS)
	{
		/*create bindable entry*/
		RegSetValueEx (hNetRuleKey, "bindable", 0, REG_MULTI_SZ, "", 0);
		/*add bindable value*/
		AddStringToMultiString (hNetRuleKey, "bindable", "PGPDriver PGPAdapter non exclusive 100");
		/*set bindform value*/
		RegSetValueEx (hNetRuleKey, "bindform", 0, REG_SZ, 
		BINDFORM, strlen(BINDFORM) + 1);
		/*create class entry*/
		RegSetValueEx (hNetRuleKey, "class", 0, REG_MULTI_SZ, "", 0);
		/*add bindable value*/
		AddStringToMultiString (hNetRuleKey, "class", "PGPDriver basic");
		/*set type value*/
		RegSetValueEx (hNetRuleKey, "type", 0, REG_SZ, 
		TYPE_VALUE, strlen(TYPE_VALUE) + 1);
		/*set use value*/
		RegSetValueEx (hNetRuleKey, "use", 0, REG_SZ, 
		USE_VALUE, strlen(USE_VALUE) + 1);
	}
	else
		berr = FALSE;
	/*cleanup*/
	if (hNetRuleKey)
		RegCloseKey (hNetRuleKey);

	#undef CURVER
	#undef NETRUL
	#undef ADAPTER_TITLE
	#undef SERVICE_NAME
	#undef SOFTWARE_TYPE
	#undef TITLE_NAME
	#undef BINDFORM
	#undef TYPE_VALUE
	#undef USE_VALUE

	return berr;
}


/*___________________________________________________________________________
 *	manually creates HKEY_LOCAL_MACHINE\SOFTWARE\Network Associates\ZZPGPMacMP
 *  and all related parameters and NetRules.
 */
BOOL ManualCreatePGPDriverService (LPSTR KeyName, LPSTR DRIVERNAME, LPSTR DisplayName,
								   LPSTR pGroup, LPSTR pDependonService)
{

	#define IMAGEPATH		"\\SystemRoot\\System32\\drivers\\PGPnet.sys"
	#define START			2
	#define TYPE			1
	#define	ERRORCONTROL	1

	HKEY hOpenKey = NULL;
	BOOL berr = TRUE;
	BOOL bFoundEnd = FALSE;
	DWORD dwDisposition;
	DWORD dwValue = 0;
	int iCurrentChar = 0;
	int iNextChar = 0;
	int iLength = 0;
	

	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, KeyName,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hOpenKey,&dwDisposition)
					== ERROR_SUCCESS)
	{
		/*get the size of pDependonService*/
		while (! bFoundEnd)
		{	
			iNextChar = iCurrentChar + 1;

			if ((pDependonService [iCurrentChar] == '\0') &&
				(pDependonService [iNextChar] == '\0'))
			{
				bFoundEnd = TRUE;
				iLength = iNextChar + 1;
				break;
			}
			
			iCurrentChar ++;
		}
		
		/*set DependOnService value*/
		RegSetValueEx (hOpenKey, "DependOnService", 0, REG_MULTI_SZ, 
					pDependonService, iLength);

		/*set DisplayName value*/
		RegSetValueEx (hOpenKey, "DisplayName", 0, REG_SZ, 
					DisplayName, strlen(DisplayName) + 1);

		/*ErrorControl*/
		dwValue = ERRORCONTROL;
		RegSetValueEx (hOpenKey, "ErrorControl", 0, REG_DWORD,
					(const BYTE*) &dwValue, sizeof(dwValue));

		/*set Group value*/
		RegSetValueEx (hOpenKey, "Group", 0, REG_SZ, 
					pGroup, strlen(pGroup) + 1);

		/*set ImagePath value*/
		RegSetValueEx (hOpenKey, "ImagePath", 0, REG_SZ, 
					IMAGEPATH, strlen(IMAGEPATH) + 1);

		/*Start*/
		dwValue = START;
		RegSetValueEx (hOpenKey, "Start", 0, REG_DWORD,
					(const BYTE*) &dwValue, sizeof(dwValue));

		/*Type*/
		dwValue = TYPE;
		RegSetValueEx (hOpenKey, "Type", 0, REG_DWORD,
					(const BYTE*) &dwValue, sizeof(dwValue));
	}
	else
		berr = FALSE;


	/*cleanup*/
	if (hOpenKey)
		RegCloseKey (hOpenKey);

	#undef IMAGEPATH		
	#undef START			
	#undef TYPE				
	#undef ERRORCONTROL		

	return berr;
}


/*___________________________________________________________________________
 *	creates HKEY_LOCAL_MACHINE\SOFTWARE\Network Associates\ZZPGPMacMP
 *  and all related parameters and NetRules.
 */
BOOL CreateLanSoftwareDriverLinkage ()
{
	#define CURVER				"SOFTWARE\\Network Associates\\ZZPGPMacMP\\CurrentVersion"
	#define NETRUL				"SOFTWARE\\Network Associates\\ZZPGPMacMP\\CurrentVersion\\NetRules"
	#define	ADAPTER_TITLE		"PGPnet VPN Driver Virtual Adapter"
	#define SERVICE_NAME		"ZZPGPMacMP"
	#define	SOFTWARE_TYPE		"driver"
	#define TITLE_NAME			"PGPnet VPN Driver Virtual Adapter"
	#define BINDFORM			"\"PGPSys\" yes no container"
	#define	TYPE_VALUE			"PGPSys ndisDriver PGPDriver"
	#define USE_VALUE			"driver"

	HKEY	hCurrentVerKey = NULL;
	HKEY	hNetRuleKey = NULL;
	DWORD	dwDisposition;
	DWORD	dwValue = 1;
	BOOL    berr = TRUE;


	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, CURVER,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hCurrentVerKey,&dwDisposition)
					== ERROR_SUCCESS)
	{
		/*set Description value*/
		RegSetValueEx (hCurrentVerKey, "Description", 0, REG_SZ, 
		ADAPTER_TITLE, strlen(ADAPTER_TITLE) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "ServiceName", 0, REG_SZ, 
		SERVICE_NAME, strlen(SERVICE_NAME) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "SoftwareType", 0, REG_SZ, 
		SOFTWARE_TYPE, strlen(SOFTWARE_TYPE) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "Title", 0, REG_SZ, 
		TITLE_NAME, strlen(TITLE_NAME) + 1);
		/*Hidden*/
		RegSetValueEx (hCurrentVerKey, "Hidden", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof(dwValue));
	}
	else
		berr = FALSE;
	/*cleanup*/
	if (hCurrentVerKey)
		RegCloseKey (hCurrentVerKey);

	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, NETRUL,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hNetRuleKey,&dwDisposition)
					== ERROR_SUCCESS)
	{
		/*create bindable entry*/
		RegSetValueEx (hNetRuleKey, "bindable", 0, REG_MULTI_SZ, "", 0);
		/*add bindable value*/
		AddStringToMultiString (hNetRuleKey, "bindable", "PGPDriver PGPAdapter non exclusive 100");
		/*set bindform value*/
		RegSetValueEx (hNetRuleKey, "bindform", 0, REG_SZ, 
		BINDFORM, strlen(BINDFORM) + 1);
		/*create class entry*/
		RegSetValueEx (hNetRuleKey, "class", 0, REG_MULTI_SZ, "", 0);
		/*add bindable value*/
		AddStringToMultiString (hNetRuleKey, "class", "PGPDriver basic");
		/*set type value*/
		RegSetValueEx (hNetRuleKey, "type", 0, REG_SZ, 
		TYPE_VALUE, strlen(TYPE_VALUE) + 1);
		/*set use value*/
		RegSetValueEx (hNetRuleKey, "use", 0, REG_SZ, 
		USE_VALUE, strlen(USE_VALUE) + 1);
	}
	else
		berr = FALSE;
	/*cleanup*/
	if (hNetRuleKey)
		RegCloseKey (hNetRuleKey);

	#undef CURVER
	#undef NETRUL
	#undef ADAPTER_TITLE
	#undef SERVICE_NAME
	#undef SOFTWARE_TYPE
	#undef TITLE_NAME
	#undef BINDFORM
	#undef TYPE_VALUE
	#undef USE_VALUE

	return berr;
}


/*___________________________________________________________________________
 *	creates HKEY_LOCAL_MACHINE\SOFTWARE\Network Associates\ZZPGPMac
 *  and all related parameters and NetRules.
 */
BOOL CreateTransportDriverLinkage ()
{
	#define CURVER				"SOFTWARE\\Network Associates\\ZZPGPMac\\CurrentVersion"
	#define NETRUL				"SOFTWARE\\Network Associates\\ZZPGPMac\\CurrentVersion\\NetRules"
	#define	ADAPTER_TITLE		"PGPnet VPN Driver Transport"
	#define SERVICE_NAME		"ZZPGPMac"
	#define	SOFTWARE_TYPE		"transport"
	#define TITLE_NAME			"PGPnet VPN Driver Transport"
	#define BINDFORM			"\"ZZPGPMac\" yes yes simple"
	#define	TYPE_VALUE			"ZZPGPMac TcpipTransport"
	#define USE_VALUE			"transport none none"

	HKEY	hCurrentVerKey = NULL;
	HKEY	hNetRuleKey = NULL;
	DWORD	dwDisposition;
	DWORD	dwValue = 1;
	BOOL    berr = TRUE;


	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, CURVER,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hCurrentVerKey,&dwDisposition)
					== ERROR_SUCCESS)
	{
		/*set Description value*/
		RegSetValueEx (hCurrentVerKey, "Description", 0, REG_SZ, 
		ADAPTER_TITLE, strlen(ADAPTER_TITLE) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "ServiceName", 0, REG_SZ, 
		SERVICE_NAME, strlen(SERVICE_NAME) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "SoftwareType", 0, REG_SZ, 
		SOFTWARE_TYPE, strlen(SOFTWARE_TYPE) + 1);
		/*set ServiceName value*/
		RegSetValueEx (hCurrentVerKey, "Title", 0, REG_SZ, 
		TITLE_NAME, strlen(TITLE_NAME) + 1);
		/*Hidden*/
		RegSetValueEx (hCurrentVerKey, "Hidden", 0, REG_DWORD, (const BYTE*) &dwValue, sizeof(dwValue));


	}
	else
		berr = FALSE;
	/*cleanup*/
	if (hCurrentVerKey)
		RegCloseKey (hCurrentVerKey);

	if(RegCreateKeyEx(HKEY_LOCAL_MACHINE, NETRUL,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hNetRuleKey,&dwDisposition)
					== ERROR_SUCCESS)
	{
		/*create bindable entry*/
		RegSetValueEx (hNetRuleKey, "bindable", 0, REG_MULTI_SZ, "", 0);
		/*add bindable value*/
		AddStringToMultiString (hNetRuleKey, "bindable", "ZZPGPMac ndisDriver non non 100");
		/*set bindform value*/
		RegSetValueEx (hNetRuleKey, "bindform", 0, REG_SZ, 
		BINDFORM, strlen(BINDFORM) + 1);
		/*create class entry*/
		RegSetValueEx (hNetRuleKey, "class", 0, REG_MULTI_SZ, "", 0);
		/*add bindable value*/
		AddStringToMultiString (hNetRuleKey, "class", "TcpipTransport basic");
		/*set type value*/
		RegSetValueEx (hNetRuleKey, "type", 0, REG_SZ, 
		TYPE_VALUE, strlen(TYPE_VALUE) + 1);
		/*set use value*/
		RegSetValueEx (hNetRuleKey, "use", 0, REG_SZ, 
		USE_VALUE, strlen(USE_VALUE) + 1);
	}
	else
		berr = FALSE;
	/*cleanup*/
	if (hNetRuleKey)
		RegCloseKey (hNetRuleKey);

	#undef CURVER
	#undef NETRUL
	#undef ADAPTER_TITLE
	#undef SERVICE_NAME
	#undef SOFTWARE_TYPE
	#undef TITLE_NAME
	#undef BINDFORM
	#undef TYPE_VALUE
	#undef USE_VALUE

	return berr;
}


/*___________________________________________________________________________
 *	disables tcpip and wins from original NIC and write back-up
 *  entries of what exactly was changed.
 */
BOOL DisableProtocols (UINT CardIndex)
{
	#define DISABLETCPIP	"SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Linkage\\Disabled"
	#define DISABLENETBT	"SYSTEM\\CurrentControlSet\\Services\\NetBT\\Linkage\\Disabled"
	#define DEVICESTUB		"\\Device\\"
	#define PROTOBACKUP		"SOFTWARE\\Network Associates\\PGP\\PGPnet\\ProtocolBackup"

	HKEY hTCPipKey = NULL;
	HKEY hNetBTKey = NULL;
	HKEY hProtBack = NULL;
	BOOL berr = TRUE;
	LPSTR BindString;
	DWORD dwDisposition;

	
	/*allocate memory for bind string*/
	BindString = malloc (MAX_NAME_LENGTH);
	ZeroMemory (BindString, MAX_NAME_LENGTH);
	
	/*build complete bindstring to be put into*/
	/*a protocols disabled key.*/
	strcpy (BindString, "\\Device\\");
	strcat (BindString, gAdapterListNT [CardIndex].ServiceName);

	/*create protocol backup registry key*/
	RegCreateKeyEx(HKEY_LOCAL_MACHINE, PROTOBACKUP,0, NULL, REG_OPTION_NON_VOLATILE,
					KEY_ALL_ACCESS, NULL, &hProtBack,&dwDisposition);

	/*record the disable*/
	RegSetValueEx (hProtBack, BindString, 0, REG_SZ, "", 1);

	/*open the tcpip disable key*/
	if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, DISABLETCPIP, 0, KEY_ALL_ACCESS, &hTCPipKey)
				== ERROR_SUCCESS)
	{
		/*add to disable bind key*/
		AddStringToMultiString (hTCPipKey, "Bind", BindString);
	}

	/*open the netbt disable key*/
	if (!gAdapterListNT[CardIndex].IsWan)
	{
		if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, DISABLENETBT, 0, KEY_ALL_ACCESS, &hNetBTKey)
				== ERROR_SUCCESS)
		{
			/*add to disable bind key*/
			AddStringToMultiString (hNetBTKey, "Bind", BindString);
		}
	}

	/*cleanup*/
	if (BindString)
		free (BindString);
	if (hTCPipKey)
		RegCloseKey (hTCPipKey);
	if (hNetBTKey)
		RegCloseKey (hNetBTKey);
	if (hProtBack)
		RegCloseKey (hProtBack);

	#undef DEVICESTUB
	#undef DISABLETCPIP
	#undef DISABLENETBT
	#undef PROTOBACKUP

	return berr;
}

/*___________________________________________________________________________
 *	disables our protocol from all instances of our
 *  driver.
 */
BOOL DisableUsFromUs (LPSTR AdapterName)
{
	#define OurTransportDisableKey		"SYSTEM\\CurrentControlSet\\Services\\ZZPGPMac\\Linkage\\Disabled"
	#define DEVICESTUB					"\\Device\\"
	HKEY hOurTransKey = NULL;
	BOOL berr = TRUE;
	LPSTR BindString;

	
	/*allocate memory for bind string*/
	BindString = malloc (MAX_NAME_LENGTH);
	ZeroMemory (BindString, MAX_NAME_LENGTH);

	/*open our disable key*/
	if (RegOpenKeyEx (HKEY_LOCAL_MACHINE, OurTransportDisableKey, 0, KEY_ALL_ACCESS, &hOurTransKey)
				== ERROR_SUCCESS)
	{
		strcpy (BindString, DEVICESTUB);
		strcat (BindString, AdapterName);
		/*add to disable bind key*/
		AddStringToMultiString (hOurTransKey, "Bind", BindString);
	}
	else
		berr = FALSE;

	/*cleanup*/
	if (hOurTransKey)
		RegCloseKey (hOurTransKey);
	if (BindString)
		free (BindString);

	#undef OurTransportDisableKey
	#undef DEVICESTUB

	return berr;
}


/*___________________________________________________________________________
 *	copies all WINS values to our NIC from the original NIC.
 *  
 */
BOOL CopyWINS (LPSTR pRealCard, LPSTR pOurCard)
{
	#define NETBTKEY	"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\NetBT\\Adapters\\"

	BOOL	berr = TRUE;
	LPSTR	pRealCardPath;
	LPSTR	pOurCardPath;


	/*allocate memory*/
	pRealCardPath = malloc (MAX_PATH);
	pOurCardPath = malloc (MAX_PATH);
	/*clear memory*/
	ZeroMemory (pRealCardPath, MAX_PATH);
	ZeroMemory (pOurCardPath, MAX_PATH);

	strcpy (pRealCardPath, NETBTKEY);
	strcpy (pOurCardPath, NETBTKEY);
	
	strcat (pRealCardPath, pRealCard);
	strcat (pOurCardPath, pOurCard);	
	
	CopyRegistryKeyValues (pRealCardPath, pOurCardPath);

	/*cleanup*/
	if(pOurCardPath)
		free (pOurCardPath);
	if(pRealCardPath)
		free (pRealCardPath);

	#undef NETBTKEY

	return berr;	
}

/*___________________________________________________________________________
 *	builds the DependOnServiceString
 */
LPSTR BuildDependOnService (HWND hListControl)
{
	LPSTR Buffer;
	UINT iLength = 0;
	UINT i = 0;
	int NumberOfItems;
	int Count;
	UINT x;
	int BufferPos = 0;


	/*get the number of cards in the list*/
	NumberOfItems = ListView_GetItemCount(hListControl);

	/*first calculate the length of all selected services*/
	for (Count = 0; Count < NumberOfItems; Count ++)
	{
		/*if card is selected*/
		if (bSelectionArray [Count] == 1)
		{
			iLength += strlen (gAdapterListNT [Count].ServiceName);
			/*for the null*/
			iLength ++;
		}
	}
	/*for the extra null*/
	iLength ++;

	Buffer = (char*)malloc(iLength);
	ZeroMemory (Buffer, iLength);

	/*now gather up all service names*/
	for (Count = 0; Count < NumberOfItems; Count ++)
	{
		/*if card is selected*/
		if (bSelectionArray [Count] == 1)
		{
			i ++;
			if (i == 1)
			{
				strcpy (Buffer, gAdapterListNT [Count].ServiceName);
				BufferPos = strlen (gAdapterListNT [Count].ServiceName) + 1;
			}
			else
			{
				for (x = 0; x <= (strlen(gAdapterListNT [Count].ServiceName)); x++)
				{
					Buffer [BufferPos] = gAdapterListNT [Count].ServiceName [x];
					BufferPos ++;
				}
			}
		}
	}
	return Buffer; 
}


/*___________________________________________________________________________
 *	Disable all protocols that bind to us except
 *	the ones we use.
 */
BOOL DisableExtraProtocols (LPSTR BindString)
{
	#define DEVICESTUB "\\Device\\"

	HKEY		hMainKey	= HKEY_LOCAL_MACHINE;
	HKEY		hOpenKey	= NULL;
	/*these are service keys we use PLUS all ZZPGPMac.... keys*/
	LPTSTR LinkedKeys[]				= {"RasArp",
									   "NetBT",
									   "LanmanServer",
									   "LanmanWorkstation",
									   "RemoteAccess",
									   "NetBIOS",
									   "Tcpip"};
	HKEY			hNewKey			= NULL;
	HKEY			hNewKeyb		= NULL;
	HKEY			hLinkKey		= NULL;
	HKEY			hDisableKey		= NULL;
	LPBYTE			pData			= NULL;
	LPBYTE			pOurBindStr		= NULL;
	LPTSTR 			pSubkeyBuffer	= NULL;	
	LPTSTR			KeyTitle        = NULL;
	LPTSTR			CurrentKey      = NULL;
	LPTSTR			DisableKey      = NULL;
	unsigned long	nSubkeyNameLen;
	unsigned long	dwBufSize;
	DWORD			nSubkeys;
	DWORD			dwIndex;
	DWORD			dwIndexb;
	DWORD			dwSize;
	DWORD			dwType;
	LONG			lResult			= ERROR_SUCCESS;
	BOOL			Pass;
	BOOL			bRC;
	BOOL			bregerr			= FALSE;
	BOOL			ItemDisabled	= FALSE;	


	/*Open key*/
	if (RegOpenKeyEx(hMainKey, SERVICESSUBKEY, 0, KEY_ALL_ACCESS, &hOpenKey) == ERROR_SUCCESS)
	{
		/*allocate memory for our bind string*/
		pOurBindStr = malloc (strlen(DEVICESTUB) + strlen(BindString) + 1);
		ZeroMemory (pOurBindStr, (strlen(DEVICESTUB) + strlen(BindString) + 1));
	
		/*build our bind string*/
		strcpy (pOurBindStr, DEVICESTUB);
		strcat (pOurBindStr, BindString);

		/*Determine number of keys to enumerate*/
		RegQueryInfoKey(hOpenKey, NULL, NULL, NULL, &nSubkeys, 
						&nSubkeyNameLen, NULL, NULL, NULL,
						NULL, NULL, NULL);

		/*Retrieve Registry values*/
		pSubkeyBuffer = malloc(nSubkeyNameLen + 1);
		CurrentKey = malloc(1024);
		DisableKey = malloc(1024);
		for (dwIndex = 0; dwIndex < nSubkeys; dwIndex++)
		{
			dwBufSize = nSubkeyNameLen + 1;
			lResult = RegEnumKeyEx(hOpenKey, dwIndex, pSubkeyBuffer, &dwBufSize, 
							       NULL, NULL, NULL, NULL);

			Pass = TRUE;
			for (dwIndexb = 0; dwIndexb <= 6; dwIndexb++)
			{
				/*check if key is one of the ones NOT to touch*/
				if ((strcmp (pSubkeyBuffer, LinkedKeys[dwIndexb])==0) ||
					(strstr(pSubkeyBuffer, "PGPMac") != NULL))
					Pass = FALSE;
					/*we now check if changes need to be made*/
			}
			if (Pass)
			{
				ZeroMemory(CurrentKey, 1024);
				ZeroMemory(DisableKey, 1024);
				/*SERVICESSUBKEY contains the path to the top of the 
				services reg. key. pSubkeyBuffer contains the name
				of the current key to examine within the services tree.*/
				strcpy(CurrentKey, SERVICESSUBKEY);
				strcat(CurrentKey, "\\");
				strcat(CurrentKey, pSubkeyBuffer);
				strcat(CurrentKey, "\\Linkage");
				strcpy(DisableKey, CurrentKey);
				strcat(DisableKey, "\\Disabled");

				if (lResult = RegOpenKeyEx(hMainKey, CurrentKey, 0, KEY_ALL_ACCESS,
								&hLinkKey) == ERROR_SUCCESS)
				{
					if (RegQueryValueEx (hLinkKey, BIND, NULL, &dwType, NULL,	&dwSize)
										== ERROR_SUCCESS)
					{
						pData = (LPBYTE) calloc(sizeof(BYTE), dwSize);
						ZeroMemory (pData, dwSize);
						if (RegQueryValueEx (hLinkKey, BIND, NULL, &dwType, pData, &dwSize)
											== ERROR_SUCCESS)
							bRC = MultiStrStrCmp((char*)pData, (char*)pOurBindStr);
							
						if(bRC)
						{
							/*Add pOurBindStr to Linkage\\Disable Bind value
							of CurrentKey*/
							if (lResult = RegOpenKeyEx(hMainKey, DisableKey, 0, KEY_ALL_ACCESS, &hDisableKey)
											== ERROR_SUCCESS)	
							{
								AddStringToMultiString (hDisableKey,
														BIND,
														pOurBindStr);
								RegCloseKey (hDisableKey);
								ItemDisabled = TRUE;
							}
						}
						if (pData)
							free(pData);
					}
					RegCloseKey(hLinkKey);
				}
			}
		}
	}
	/*cleanup*/
	if (CurrentKey)
		free(CurrentKey);
	if (DisableKey)
		free(DisableKey);
	if (pSubkeyBuffer)
		free(pSubkeyBuffer);
	if (pOurBindStr)
		free(pOurBindStr);
	if (hOpenKey)
		RegCloseKey(hOpenKey);

	#undef DEVICESTUB

	return ItemDisabled;
}
