/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	

	$Id: remove95.c,v 1.7.4.1.6.4 1999/08/26 20:46:58 philipn Exp $
____________________________________________________________________________*/
#pragma message( "Compiling " __FILE__ ) 
#pragma message( "Last modified on " __TIMESTAMP__ ) 

#include <windows.h>
#include "Define.h"
#include "globals.h"
#include "lister.h"

/*___________________________________________________________________________
 *	Removes any existings PGPnet network components 	
 */
BOOL Remove95(char *Key, int Flag)
{
	HKEY	hRootKey = NULL;
	HKEY	hDeleteKey = NULL;
	HKEY	hAdapterlist = NULL;
	HKEY	hRealAdapter = NULL;
	LPSTR	pValueBuffer = NULL;
	LPSTR	pProtocolValueBuffer = NULL;
	LPSTR	pSubKeyValueBuffer = NULL;
	LPBYTE	RegDataValue = NULL;
	LPBYTE	DataBuffer = NULL;
	UINT	nValues;
	UINT	nProtocols;
	UINT	nSubkey;
	DWORD	SavedMaxProtocolNameLen;
	DWORD	nMaxProtocolNameLen;
	DWORD	nMaxValueNameLen;
	DWORD	nMaxValueDataLen;
	DWORD	SavedMaxValueNameLen;
	DWORD	SavedMaxValueDataLen;
	DWORD	nMaxDataNameLen;
	DWORD	nValueNameLen;
	DWORD	nSubkeyNameLen;
	DWORD	dwKeyIndex;
	DWORD	dwIndex;
	DWORD	dwValueIndex;
	DWORD	dwBufSize;
	DWORD	nDataNameLen;
	UINT	RC;
	BOOL	bDelete;

	/*copy real cards old bindings back*/
	if (Flag)
	{
		if (RegOpenKey(HKEY_LOCAL_MACHINE, BACKUP95BINDINGSKEY, &hAdapterlist)
						== ERROR_SUCCESS)
		{
			/*Determine number of keys to enumerate*/
			RegQueryInfoKey(hAdapterlist, NULL, NULL, NULL, NULL, 
							NULL, NULL, &nValues, &nMaxValueNameLen,
							&nMaxValueDataLen, NULL, NULL);

			/*Retrieve Registry values*/
			for (dwIndex = 0; dwIndex < nValues; dwIndex++)
			{
				/*save the max value and data lengths*/
				SavedMaxValueNameLen = (nMaxValueNameLen + 1);
				SavedMaxValueDataLen = (nMaxValueDataLen + 1);
				/*allocate space for reg. value and data*/
				pValueBuffer = malloc(nMaxValueNameLen + 1);
				RegDataValue = malloc(nMaxValueDataLen + 1);
				/*clear the space just allocated*/
				ZeroMemory(pValueBuffer,(nMaxValueNameLen + 1)); 
				ZeroMemory(RegDataValue,(nMaxValueDataLen + 1)); 
				/*enumerate through the reg. values and data*/
				RegEnumValue(hAdapterlist, dwIndex, pValueBuffer, 
							&SavedMaxValueNameLen, NULL, NULL,
							RegDataValue, &SavedMaxValueDataLen); 

				/*at this point RegDataValue has a key path*/
				/*and pValueBuffer has the data value that*/	
				/*must be moved here*/

				/*check that you dont have NumberSecured entry*/
				if  ((strstr(pValueBuffer, "NumberSecured") == NULL))
				{
					/*open the key to the real adapter*/
					if ((RegOpenKey(HKEY_LOCAL_MACHINE, RegDataValue, &hRealAdapter)
						== ERROR_SUCCESS))
					{
						DWORD	dwCount;

						/*Determine number of keys to enumerate*/
						RegQueryInfoKey(hRealAdapter, NULL, NULL, NULL, NULL, 
										NULL, NULL, &nProtocols, &nMaxProtocolNameLen,
										NULL, NULL, NULL);	

						/*allocate space for reg. value and data*/
						pProtocolValueBuffer = malloc(nMaxProtocolNameLen + 1);
						/*Retrieve Registry values and delete all PGPMAC*/
						for (dwCount = 0; dwCount < nProtocols; dwCount++)
						{
							/*save the max value and data lengths*/
							SavedMaxProtocolNameLen = nMaxProtocolNameLen + 1;
							/*clear the space just allocated*/
							ZeroMemory(pProtocolValueBuffer, SavedMaxProtocolNameLen);
							/*enumerate through the reg. values and data*/
							RegEnumValue(hRealAdapter, dwCount, pProtocolValueBuffer, 
									&SavedMaxProtocolNameLen, NULL, NULL, NULL, NULL);
							/*at this point pProtocolValueBuffer has the name of*/
							/*a protocol that is bound to the real adapter we are*/
							/*working with at the moment. If it is a PGPnet protocol*/
							/*delete it.*/
							if  ((strstr(pProtocolValueBuffer, "PGPMAC") != NULL))
							{
								/*delete our binding to real adapter*/
								RegDeleteValue(hRealAdapter, pProtocolValueBuffer);
								dwCount --;
							}
						}
						/*now add the old protocol back to the real adapter*/
						RegSetValueEx(hRealAdapter, pValueBuffer, 0, REG_SZ, "", 1);
						/*cleanup*/
						if (pProtocolValueBuffer)
							free (pProtocolValueBuffer);
						if (hRealAdapter)
							RegCloseKey (hRealAdapter);
					}
				}
				/*cleanup*/
				if (pValueBuffer);
					free (pValueBuffer);
				if (RegDataValue)
					free (RegDataValue);

			}
		}
		/*cleanup*/
		if (hAdapterlist)
			RegCloseKey (hAdapterlist);
		/*delete backup info*/
		RegDeleteKey(HKEY_LOCAL_MACHINE, BACKUP95BINDINGSKEY);
		RegDeleteKey(HKEY_LOCAL_MACHINE, "Enum\\Network\\PGPMAC");
		RegDeleteKey(HKEY_LOCAL_MACHINE, PATHTOADAPTERLIST);
	}

	
	if (RegOpenKey(HKEY_LOCAL_MACHINE, Key, &hRootKey) == ERROR_SUCCESS)
	{
		/*Determine number of keys to enumerate*/
		RegQueryInfoKey(hRootKey, NULL, NULL, NULL, &nSubkey, 
					&nSubkeyNameLen, NULL, NULL, NULL,
					NULL, NULL, NULL);
		/*Retrieve Registry values*/
		pSubKeyValueBuffer = malloc(nSubkeyNameLen + 1);
		for (dwKeyIndex = 0; dwKeyIndex < nSubkey; dwKeyIndex++)
		{
			bDelete = FALSE;
			ZeroMemory(pSubKeyValueBuffer,(nSubkeyNameLen + 1)); 
			dwBufSize = (nSubkeyNameLen +1);
			if ((RC = RegEnumKey(hRootKey, dwKeyIndex, pSubKeyValueBuffer, dwBufSize)) 
								== ERROR_SUCCESS)
			{
				dwBufSize = (nSubkeyNameLen +1);
				if (RegOpenKey(hRootKey, pSubKeyValueBuffer, &hDeleteKey)
								== ERROR_SUCCESS)
				{
 					/*Determine number of values to enumerate*/
					RC = RegQueryInfoKey(hDeleteKey, NULL, NULL, NULL, NULL, 
										NULL, NULL, &nValues, &nMaxValueNameLen,
										&nMaxDataNameLen, NULL, NULL);

					/*Retrieve Registry values*/
					pValueBuffer = malloc(nMaxValueNameLen + 1);
					DataBuffer = malloc(nMaxDataNameLen + 1);

					for (dwValueIndex = 0; dwValueIndex < nValues; dwValueIndex++)
					{
						nValueNameLen = (nMaxValueNameLen + 1);
						nDataNameLen = (nMaxDataNameLen + 1);
						ZeroMemory(pValueBuffer,(nMaxValueNameLen + 1));
						ZeroMemory(DataBuffer,(nMaxDataNameLen + 1));
						RegEnumValue(hDeleteKey, dwValueIndex, pValueBuffer, &nValueNameLen,
									NULL, NULL, DataBuffer, &nDataNameLen);
						if((strcmp (pValueBuffer, "PGPnetDelFlag") == 0) &&
							(strcmp (DataBuffer, "PGPnetDelFlag") == 0))
						{
							bDelete = TRUE;
							dwValueIndex = nValues;
						}

					}
					RegCloseKey(hDeleteKey);
					if (bDelete)
					{
						if(RegDeleteKey( hRootKey, pSubKeyValueBuffer) == ERROR_SUCCESS)
							dwKeyIndex = 0;
					}
					/*cleanup*/
					if (pValueBuffer)
						free(pValueBuffer);
					if (DataBuffer)
						free(DataBuffer);
				}
			}
		}
		RegDeleteKey(HKEY_LOCAL_MACHINE, "Enum\\Root\\PGPnet");
		free(pSubKeyValueBuffer);
		RegCloseKey(hRootKey);
	}
return TRUE;
}
