{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: C3po.pas,v 1.12.12.7 1999/09/27 23:12:47 build Exp $ }
{=____________________________________________________________________________ }
unit C3PO;

interface

uses
pgpcmdlg,
  clipbrd,statunit,
  OleAuto,
    dialogs,
  Windows,
  wintypes,
  winprocs,
  SysUtils,
  C3POinc,
  pgp2,
  richedit,
  forms,
  encrypt,
  stdctrls,
  controls,
  classes,
  commctrl,

  pgpexsdk,pgperrors;

resourcestring

alreadydonemess='PGP processed this message automatically once when you pressed send before.  You should select ''Encrypt Now'' or ''Sign Now''.';
accesspgp='Access PGP functions';
encryptselected='&Encrypt/Sign Selected Text';
encryptnow='Encrypt Now';
signnow='Sign Now';
encryptsignnow='Encrypt and Sign &Now';
encryptselprompt='Encrypt or Sign selected text in the current mail';
encryptnowprompt='Encrypt the message now';
signnowprompt='Sign the message now';
encryptsignnowprompt='Encrypt and sign the message now';
decryptitemmenu='&Decrypt/Verify';
decryptitemprompt='Decrypt the current mail';
withoutdecryptmenu='&Open without decrypt/verify';
withoutdecryptprompt='Open this item without decrypting';
addkeymenu='&Add PGP Key to Ring';
addkeyprompt='Add this PGP key to public keyring';
maildefkeymenu='&Mail Default PGP Key';
maildefkeyprompt='Mail your main PGP key to someone';
mailkeymenu='Mail PGP &Key(s)';
mailkeyprompt='Mail one or more PGP keys to someone';
keymanmenu='Launch &PGPkeys';
keymanprompt='Run PGPkeys program';
prefmenu='&Options';
prefprompt='Show the PGP Preferences Options Window';
aboutmenu='About &PGP for GroupWise';
aboutprompt='See information about PGP for GroupWise';
pgpdefmenu='PGP is &Default Provider';
pgpdefprompt='PGP will handle outgoing messages';
signonemenu='&Sign on Send';
signoneprompt='Sign messages on send or when encrypt now is selected';
encryptonemenu='&Encrypt on Send';
encryptoneprompt='Encrypt messages on send or when encrypt now selected';
ignoreinternalmenu='&Ignore Internal';
ignoreinternalprompt='Do not encrypt internal mail.  Main message body will still be signed';
signtool='PGP Sign outgoing messages on send';
encrypttool='PGP Encrypt outgoing messages on send';
decrypttool='PGP Decrypt/Verify this message';


type
{***********************************************************
   Object Name:   Command sub classed from TGWCommand

   Description:   This object defines an instance of a command

************************************************************}
  Command = class(TGWCommand)
  private
    { Private declarations }
   LongPrmt : string;
   base:variant;
   ToolTp : string;
   oldopencmd:variant; //used to hold groupwise commands
   function GetLongPrompt : string;
   function GetToolTip : string;
   procedure setok(OKStat:integer);
    function GetBaseCmd: variant;

  public //the added public variables may or may not be set, depending on type and context
        dirty:boolean;                     //used to see whether the command has been check
     m_nCmd : longint;                                 // Command ID information
     fOK:integer;  //normally returns 0 if all OK, 1 if not OK - used only for encrypt commands
     toolbarid:longint; //windows toolbarid of any toolbar buttons added
     window:thandle; //handle of the toolbar
     toolbar:boolean; //true if the command is on the toolbar, false otherwise
     done:boolean; //true if validated once already, false if first time
     messageid:string; //messageid of the window containing the command
        encryptedalready:boolean;//true if sign or encrypt on send has been processed
    Constructor Create(nCmd: longint);                // Used to create Command Object

  automated
   function getOK:integer;
    property BaseCmd: variant read GetBaseCmd;
    property OK:integer read getOK;
    property LongPrompt: string read GetLongPrompt;
    property ToolTip: string read GetToolTip;
    procedure Execute;
    function Validate: longint;
  end;







{***********************************************************
   Object Name:  CommandFactory sub classed from TCommandFactory

   Description:  This interface is used to manage commands in GroupWise.
                 A command occurs in multiple locations including the Menu and
                 Toolbar.

   Comments:     Modification of the menus is done according to the following algorithm:
                   0 CommandFactory::Init() called once, long before any menu modifications actually occur.
                   1 Menu Load from disk
                   2 Send menu out to C3PO servers (CommandFactory::CustomizeMenu())
                   3 At INIT_MENU_POPUP time
                      Call CommandFactory::CustomizeMenu() for all interested C3PO servers (i.e. those
                      that returned TRUE to the initial call to CustomizeMenu() ).
                   4 Validate the menu

************************************************************}
  CommandFactory = class(TCommandFactory)
  private
  ContextMenuID: integer;
  public
    Constructor Create;                                    // Used to create CommandFactory Object
  automated
    function BuildCommand( Context: string;
                           PersistentID: string;
                           BaseCommand: variant;
                           Parms: variant): variant;

    procedure CustomizeContextMenu( Context: string;
                                    GWMenu: variant);

    function CustomizeMenu( Context: string;
                            GWMenu: variant): wordbool;

    function Init(lcid : longint): longint;

    function CustomizeToolBar( Context: string;
                               GWToolbar: variant): wordbool;

    function WantCommand( Context: string;
                          PersistentID: string): wordbool;

  end;

{***********************************************************
   Object Name:  EventMonitor sub classed from TEventMonitor

   Description:  This interface is passed to monitor "low level" actions
                 that occur in GW.

************************************************************}
EventMonitor =  class(TEventMonitor)
  private

  public

  automated
    procedure Notify(Context: string; evt: variant);

  end;

{***********************************************************
   Object Name:  IconFactory sub classed form TIconFactory

   Description:  This interface is used to retrieve icons that represent the
                 state of C3PO record types.

************************************************************}
  IconFactory = class(TIconFactory)
  private
    { Private declarations }

  public
  automated
    procedure GetIcons(ObjClass: string; var pIconFile: string; var plUnOpenIcon: longint; var plOpenIcon: longint);
  end;

  function enumproc(childhandle:thandle;address:longint):boolean; stdcall;
  function enumrichedit(childhandle:thandle;address:longint):boolean; stdcall;
const
{Constant for command object ID's}
PGPGW_NEWMENU_PGPMENU=98;
  PGPGW_NEWMENU_SEP=99;
  PGPGW_NEWMENU_PGP = 100;
  PGPGW_NEWMENU_ENCRYPT = 101;
  PGPGW_NEWMENU_DECRYPT = 102;
  PGPGW_NEWMENU_KEYTORING = 103;
  PGPGW_NEWMENU_MAILKEY = 104;
  PGPGW_NEWMENU_NEWKEY = 105;
  PGPGW_NEWMENU_REMOVEKEY = 106;
    PGPGW_NEWMENU_MULTIKEY = 107;
    PGPGW_PREFSET_SIGN=108;
    PGPGW_PREFSET_ENCRYPT=109;
    PGPGW_OVERRIDE_OPEN=110;
    PGPGW_NEWMENU_AUTOENCRYPT=111;
    PGPGW_NEWMENU_CANCEL=112;
    PGPGW_NEWMENU_SHOWPREFS=113;
    PGPGW_OVERRIDE_NEW=114;
    PGPGW_NEWMENU_ABOUTBOX=115;
   PGPGW_NEWMENU_ENCRYPTSELECTED=116;
   PGPGW_NEWMENU_IGNOREDECRYPT=117;
   PGPGW_PREFSET_PGPISDEFAULT=118;
   PGPGW_PREFSET_IGNOREINTERNAL=119;
   PGPGW_PREFSET_RICHEDIT=120;
   PGPGW_NEWMENU_ENCRYPTNOW=121;
   PGPGW_NEWMENU_SIGNNOW=122;
   PGPGW_NEWMENU_ENCRYPTSIGNNOW=123;
   PGPGW_OVERRIDE_REPLY=124;
   PGPGW_OVERRIDE_FORWARD=125;
var
replyornew:boolean;
signdirty,encryptdirty:boolean;
   g_C3POManager: variant;

   EncryptCmd : Command;
   PGPCmd : Command;
   DecryptCmd : Command;
   KeyToRingCmd : Command;
   MailKeyCmd : Command;
   NewKeyCmd : Command;
   RemoveKeyCmd : Command;
   checkonce:boolean;
   contextmenu:variant;


   implementation
   var
   gwmess:variant;
   cancelcmd,autoencrypt:variant;
   function NullVariant(v: Variant): Boolean;
begin
   case (VarType(v)) of
   varEmpty:
      result := TRUE;
   varNull:
      result := TRUE;
   varSmallint:
      result := TVarData(v).VSmallint = 0;
   varInteger:
      result := TVarData(v).VInteger = 0;
   varSingle:
      result := TVarData(v).VSingle = 0;
   varDouble:
      result := TVarData(v).VDouble = 0;
   varCurrency:
      result := TVarData(v).VCurrency = 0;
   varDate:
      result := TVarData(v).VDate = 0;
   varOleStr:
      result := TVarData(v).VOleStr = nil;
   varDispatch:
      result := TVarData(v).VDispatch = nil;
   varError:
      result := TRUE;
   varBoolean:
      result := TVarData(v).VBoolean;
   varVariant:
      result := FALSE;
   varUnknown:
      result := TVarData(v).VUnknown = nil;
   varString:
      result := TVarData(v).VString = nil;
   varTypeMask:
      result := FALSE;
   varByRef:
      result := FALSE;

   end;
end;

{***********************************************************
   Name:       TGWCommand.GetBaseCmd

   Description: This routine should get the Base Command and return it as a
                TGWCommand.

   In:          none

   Out:         TGWCommand : variant

   Comments:

************************************************************}
function Command.GetBaseCmd : Variant;
begin
result:=base;

end;



function Command.getOK :integer;
begin
     Result := fOK;
end;

procedure Command.setOK(OKstat:integer);
begin
     fOK:=OKStat;
end;


{***********************************************************
   Name:       CommandFactory.Create

   Description: Create CommandFactory object and reset ContextMenuID.

   In:          none

   Out:         none

   Comments:

************************************************************}
Constructor CommandFactory.Create;
begin
     inherited Create;

     ContextMenuID := -1;
     {form2.hide;}
end;

{***********************************************************
   Name:       CommandFactory.BuildCommand

   Description:  This method is invoked to create a Command object. The C3po cannot assume
                 that Command::WantComand has been called before this method is invoked.

   In:           Context: string - This is the context for the command. The context string
                                   contains either the class of a GW data object(e.g. GW.MESSAGE.MAIL.X)
                                   or the class of the specific user interface(e.g. GW.APPLICATION.BROWSER).
                 PersistentID: string - This can be either a "pre-defined" ID or is an ID provided in a previous run of GW.
                 BaseCommand: variant - The command object of the command being overridden.
                 parms: variant - The parameter list of the command.

   Out:          GWCommand: variant - Command object for persistentID.

   Comments:     Each time the BuilCommand is invoked, the C3po should return a new instance of a GWCommand
                 object. This is neccessary because BuildCommand can be called recursively.

************************************************************}
function CommandFactory.BuildCommand( Context: string;
                                      PersistentID: string;
                                      BaseCommand: variant;
                                      parms: variant): variant;

var cmd:command;clistate,gwmess:variant;mess,messid:string;
begin
    if comparetext('GW#C#SEND',PersistentID)=0 then //this command would do an autocreate on send button - note that this code never gets called in
                                                    //in this version, as GroupWise will not currently allow a command override of GW#C#SEND
    begin
     cmd:=Command.Create(PGPGW_NEWMENU_AUTOENCRYPT); //create the autoencrypt command
     cmd.encryptedalready:=false;
     cmd.oldopencmd:=basecommand; //hold onto the command we are overriding
     result:=cmd.OleObject; //return the new command
     cmd.Release;
    end;
    if comparetext('GW#C#PGPCANCEL',PersistentID)=0 then //if this context is sent - note that this is custom - GroupWise will not call thisanother custom command
    begin
     cmd:=Command.Create(PGPGW_NEWMENU_CANCEL); //create and return the command
     result:=cmd.OleObject;
     cmd.Release;
    end;
    if comparetext('GW#C#ENCRYPT',PersistentID)=0 then //another custom command
    begin
     cmd:=Command.Create(PGPGW_NEWMENU_AUTOENCRYPT);
     cmd.encryptedalready:=false;                                               
     result:=cmd.OleObject;
     cmd.Release;
    end;

    if comparetext('GW#C#AUTODECRYPT',PersistentID)=0 then //another custom command
    begin
     cmd:=Command.Create(PGPGW_OVERRIDE_OPEN);
     result:=cmd.OleObject;
     cmd.Release;
    end;
  if CompareText(eGW_CMDID_OPEN,PersistentID) = 0 then //this is sent by groupwise - it allows us to trap the open command
  begin
           Cmd := Command.Create(PGPGW_OVERRIDE_OPEN);
           cmd.oldopencmd:=basecommand; //hold on to the overriden command
           cmd.base:=cmd.oleobject;
           Result := Cmd.OleObject;
           Cmd.Release;
end;
if CompareText(eGW_CMDID_COMPOSE,PersistentID) = 0 then //this is also sent by groupwise - overrides new message
  begin
           Cmd := Command.Create(PGPGW_OVERRIDE_NEW);
           cmd.oldopencmd:=basecommand;
           Result := Cmd.OleObject;
           Cmd.Release;
           end;
if CompareText(eGW_CMDID_REPLY,PersistentID) = 0 then //this is also sent by groupwise - overrides new message
  begin
           Cmd := Command.Create(PGPGW_OVERRIDE_REPLY);
           cmd.oldopencmd:=basecommand;
           Result := Cmd.OleObject;
           Cmd.Release;
           end;
if CompareText(eGW_CMDID_FORWARD,PersistentID) = 0 then //this is also sent by groupwise - overrides new message
  begin
           Cmd := Command.Create(PGPGW_OVERRIDE_FORWARD);
           cmd.oldopencmd:=basecommand;
           Result := Cmd.OleObject;
           Cmd.Release;
           end;
end;

{***********************************************************
   Name:       CommandFactory.Init

   Description:  This method is the first method of Command::Factory called. It is used to tell
                 GroupWise what UI items will be modified.

   In:           lcid: longint - This is the locale ID of the application driving the C3po.

   Out:          The C3po server returns any combination of the following bits:

                 eGW_CMDINIT_MENUS  - The C3po intends to modify the menus (CustomizeMenu Interface)
                 eGW_CMDINIT_TOOLBARS  - The C3po intends to modify the toolbar (CustomizeMenu Interface)
                 eGW_CMDINIT_CONTEXT_MENUS - The C3po intends to modify the context menus (CustomizeMenu Interface)
                 eGW_CMDINIT_NO_PREDEFINED - Optimization flag that indicates the C3po will never respond to
                                             predefined commands. Returning this flag will supress calls to the
                                             WantCommand method for predefined commands.


   Comments:

************************************************************}
function CommandFactory.Init(lcid : longint): longint;
begin
    result := eGW_CMDINIT_MENUS or
               eGW_CMDINIT_CONTEXT_MENUS or eGW_CMDINIT_TOOLBARS;
    checkonce:=false;
    replyornew:=false;
end;

{***********************************************************
   Name:       CommandFactory.WantCommand

   Description:  This method is used to query the C3po for it's intention to
                 support a predefined command.

   In:           Context: string - This is the actual object class
                                   associates with the command.
                 PersistentID: string - This can be either a "pre-defined"
                                        ID or is an ID provided in a previous
                                        run of GW.

   Out:          True - I do want to support this predefined command
                 FALSE - I do not want to support this predefined command

   Comments:

************************************************************}
function CommandFactory.WantCommand( Context: string;
                                     PersistentID: string): wordbool;
begin //tell groupwise which commands are to be overridden - must also be in registry
   Result := FALSE;
     if CompareText(eGW_CMDID_OPEN,PersistentID) = 0 then
         Result := TRUE;
      if CompareText(eGW_CMDID_COMPOSE,PersistentID) = 0 then
         Result := TRUE;
               if CompareText(eGW_CMDID_REPLY,PersistentID) = 0 then
         Result := TRUE;
               if CompareText(eGW_CMDID_FORWARD,PersistentID) = 0 then
         Result := TRUE;

end;

function getmessageid:string; //returns the messageid of the current view
var handle:string;
begin

  form1.wpo.commandstring:='envcheckcurrentwindow(624)';
if form1.wpo.commandreturn='TRUE' then begin
form1.wpo.commandstring:='itemlistcreatefromcontrol(219;1;)';
handle:=form1.wpo.commandreturn;
 if CompareText('Token',Copy(handle,1,5))<>0 then begin
form1.wpo.commandstring:='itemlistgetitem('+handle+';0)';
result:=form1.wpo.commandreturn ;
form1.wpo.commandstring:='itemlistdelete';
end else begin result:='ERROR'; end;
end else begin
     form1.wpo.CommandString := 'ItemMessageIDFromView()';
     result:=form1.wpo.CommandReturn;
     end;

end;


{***********************************************************
   Name:         TCommandFactory.CustomizeContextMenu

   Description:  Method to Customize a Context Menu

   In:           Context: string - The context string is the class of the object
                                   owning the menu. For example, ObjClass would
                                   contain "GW.MESSAGE.MAIL" for the mail messages.

                 GWMenu: variant - The context menu to be modified.


   Out:          none

   Comments:


************************************************************}
procedure CommandFactory.CustomizeContextMenu( Context: string;
                                                GWMenu: variant);
var
PGPMenu,GWMenuAction : variant;
GWSeparator: variant;
MainMenuItems : variant;
pgpMenuCmd,Cmd : Command;
vMsgList : variant;
vMessage : variant;
vClientState : variant;
MenuID,count: integer;
messageid:string;
domenu:boolean;
begin
  MainMenuItems := GWMenu.MenuItems;                              // get menu items form Menu
    if (CompareText('GW.MESSAGE',Copy(context,1,10)) = 0)  then //if message type
      begin


  messageid:=getmessageid; //get the messageid


 if messageid='X00' then begin //if new message

   Cmd := Command.Create(PGPGW_NEWMENU_SEP); //separator
  GWSeparator := MainMenuItems.AddSeparator;
  Cmd.Release;

        PGPMenuCmd := Command.Create(PGPGW_NEWMENU_PGPMENU); //PGP Menu
     PGPMenu:=MainMenuItems.AddMenu('&PGP',PGPMenuCmd.OleObject);
     PGPMenuCmd.LongPrmt := accesspgp;
     PGPMenuCmd.Release;

    EncryptCmd := Command.Create(PGPGW_NEWMENU_ENCRYPTNOW); //encrypt selected item
      GWMenuAction := PGPMenu.MenuItems.Add(encryptnow, EncryptCmd.OleObject);
    EncryptCmd.LongPrmt := encryptnowprompt;
      ContextMenuID := GWMenuAction.MenuID;
      EncryptCmd.Release;
          EncryptCmd := Command.Create(PGPGW_NEWMENU_SIGNNOW); //encrypt selected item
      GWMenuAction := PGPMenu.MenuItems.Add(signnow, EncryptCmd.OleObject);
    EncryptCmd.LongPrmt := signnowprompt;
      ContextMenuID := GWMenuAction.MenuID;
      EncryptCmd.Release;
    EncryptCmd := Command.Create(PGPGW_NEWMENU_ENCRYPTSIGNNOW); //encrypt selected item
      GWMenuAction := PGPMenu.MenuItems.Add(encryptsignnow, EncryptCmd.OleObject);
    EncryptCmd.LongPrmt := encryptsignnowprompt;
      ContextMenuID := GWMenuAction.MenuID;
      EncryptCmd.Release;
          Cmd := Command.Create(PGPGW_NEWMENU_SEP); //separator
  GWSeparator := PGPMenu.MenuItems.AddSeparator;
  Cmd.Release;


            PGPCmd := Command.Create(PGPGW_NEWMENU_PGP); //load pgpkeys
      GWMenuAction := PGPMenu.MenuItems.Add(keymanmenu, PGPCmd.OleObject);
    PGPCmd.LongPrmt := keymanprompt;
      ContextMenuID := GWMenuAction.MenuID;
      PGPCmd.Release;


       MailKeyCmd := Command.Create(PGPGW_NEWMENU_SHOWPREFS); //load pgpprefs
     GWMenuAction :=  PGPMenu.MenuItems.Add(prefmenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := prefprompt;
      ContextMenuID := GWMenuAction.MenuID;
      MailKeyCmd.Release;

end;
domenu:=true;
if messageid<>'X00' then begin //if not new message

  for count:= 1 to mainmenuitems.count do begin
  contextmenu:=mainmenuitems.item(count);
  if contextmenu.caption='&PGP' then begin
  domenu:=false;
  break;
  end;
  end;
  if domenu then begin
    Cmd := Command.Create(PGPGW_NEWMENU_SEP); //separator
  GWSeparator := MainMenuItems.AddSeparator;
  Cmd.Release;

       PGPMenuCmd := Command.Create(PGPGW_NEWMENU_PGPMENU); //PGP Menu
     PGPMenu:=MainMenuItems.AddMenu('&PGP',PGPMenuCmd.OleObject);
  
     PGPMenuCmd.LongPrmt := accesspgp;
     PGPMenuCmd.Release;

       DecryptCmd := Command.Create(PGPGW_NEWMENU_DECRYPT); //decrypt selected item
      GWMenuAction := PGPMenu.MenuItems.Add(decryptitemmenu, DecryptCmd.OleObject);
    DecryptCmd.LongPrmt := decryptitemprompt;
      ContextMenuID := GWMenuAction.MenuID;
      DecryptCmd.Release;

(*        DecryptCmd := Command.Create(PGPGW_NEWMENU_IGNOREDECRYPT); //bypass autodecryption
      GWMenuAction := PGPMenu.MenuItems.Add(withoutdecryptmenu, DecryptCmd.OleObject);
    DecryptCmd.LongPrmt := withoutdecryptprompt;
      ContextMenuID := GWMenuAction.MenuID;
      DecryptCmd.Release;*)


(*        KeyToRingCmd := Command.Create(PGPGW_NEWMENU_KEYTORING); //import a key
      GWMenuAction := PGPMenu.MenuItems.Add(addkeymenu, KeyToRingCmd.OleObject);
       KeyToRingCmd.LongPrmt := addkeyprompt;
      ContextMenuID := GWMenuAction.MenuID;
      KeyToRingCmd.Release;*)
          Cmd := Command.Create(PGPGW_NEWMENU_SEP); //separator
  GWSeparator := PGPMenu.MenuItems.AddSeparator;
  Cmd.Release;


            PGPCmd := Command.Create(PGPGW_NEWMENU_PGP); //load pgpkeys
      GWMenuAction := PGPMenu.MenuItems.Add(keymanmenu, PGPCmd.OleObject);
    PGPCmd.LongPrmt := keymanprompt;
      ContextMenuID := GWMenuAction.MenuID;
      PGPCmd.Release;


       MailKeyCmd := Command.Create(PGPGW_NEWMENU_SHOWPREFS); //load pgpprefs
     GWMenuAction :=  PGPMenu.MenuItems.Add(prefmenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := prefprompt;
      ContextMenuID := GWMenuAction.MenuID;
      MailKeyCmd.Release;
   end;
end;
(*      MailKeyCmd := Command.Create(PGPGW_NEWMENU_MAILKEY); //mail default key
      GWMenuAction := PGPMenu.MenuItems.Add(maildefkeymenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := maildefkeyprompt;
      ContextMenuID := GWMenuAction.MenuID;
      MailKeyCmd.Release;*)

(*       MailKeyCmd := Command.Create(PGPGW_NEWMENU_MULTIKEY); //select key to mail
      GWMenuAction := PGPMenu.MenuItems.Add(mailkeymenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := mailkeyprompt;
      ContextMenuID := GWMenuAction.MenuID;
      MailKeyCmd.Release;*)




  end;

end;

{***********************************************************
   Name:       CommandFactory.CustomizeMenu

   Description:  Method to customise the menu.

   In:           Context: string - The context string property is the class of the
                                   containing window.  For example "GW.APPLICATION.BROWSER"
                 GWMenu: variant - The main menu object being modified.

   Out:          wordbool - The return value indicates whether the modifications to the
                 menu were "volatile".  If the return value is TRUE, CustomizeMenu()
                 will continue to be called each time the menu may need to be updated
                 e.g. at each popup creation).  Otherwise, C3PO servers can safely
                 assume that CustomizeMenu is called only once for any single instance
                 of a menu.  This simplifies the resulting code because there is
                 no need to check for commands that might already be on the menu.
                 That is, the C3PO's command are guaranteed to be absent from the
                 menu at the time of the first CustomizeMenu call.


   Comments:

************************************************************}
function CommandFactory.CustomizeMenu( Context: string;
                                       GWMenu: variant): wordbool;
var
GWSeparator,FileMenu : variant;
FileNewMenu : variant;
PGPMenu:variant;
PGPMenuCmd:command;

helpmenu,MainMenuItems : variant;
Cmd : Command;
begin
     MainMenuItems := GWMenu.MenuItems;
if (CompareText('GW.CLIENT.WINDOW.BROWSER',Context) = 0) then begin //see if it is main window
          helpmenu:=mainmenuitems.item('Help');
          cmd:=command.create(PGPGW_NEWMENU_ABOUTBOX); //add about PGP
          helpmenu.menuitems.add(aboutmenu,cmd.oleobject,eGW_HELPMENU_ABOUT);
          cmd.longprmt:=aboutprompt;
          cmd.release;
        end;

 if (CompareText('GW.MESSAGE',Copy(context,1,10)) = 0)  or (CompareText('GW.CLIENT.WINDOW.BROWSER',Context) = 0) then //see if it is a message
  begin
     PGPMenuCmd := Command.Create(PGPGW_NEWMENU_PGPMENU); //make a new menu
     PGPMenu:=MainMenuItems.AddMenu('&PGP',PGPMenuCmd.OleObject ,eGW_MAINMENU_WINDOWMENU);
     PGPMenuCmd.LongPrmt := accesspgp;
     PGPMenuCmd.Release;



(*    EncryptCmd := Command.Create(PGPGW_NEWMENU_ENCRYPT); //encrypt the item
      PGPMenu.MenuItems.Add(encryptnow, EncryptCmd.OleObject);
    EncryptCmd.LongPrmt := encryptnowprompt;
      EncryptCmd.Release;*)


       DecryptCmd := Command.Create(PGPGW_NEWMENU_DECRYPT); //decrypt the item
      PGPMenu.MenuItems.Add(Decryptitemmenu, DecryptCmd.OleObject);
    DecryptCmd.LongPrmt := decryptitemprompt;
      DecryptCmd.Release;

(*      if (CompareText('GW.MESSAGE',Copy(context,1,10)) <> 0) then begin //if it is the browser
              DecryptCmd := Command.Create(PGPGW_NEWMENU_IGNOREDECRYPT); //bypass auto decrypt
     PGPMenu.MenuItems.Add(withoutdecryptmenu, DecryptCmd.OleObject);
    DecryptCmd.LongPrmt := withoutdecryptprompt;
      DecryptCmd.Release;
      end;*)


(*        KeyToRingCmd := Command.Create(PGPGW_NEWMENU_KEYTORING); //import key
      PGPMenu.MenuItems.Add(addkeymenu, KeyToRingCmd.OleObject);
       KeyToRingCmd.LongPrmt := addkeyprompt;
      KeyToRingCmd.Release;*)


(*       MailKeyCmd := Command.Create(PGPGW_NEWMENU_MAILKEY); //mail default key
      PGPMenu.MenuItems.Add(maildefkeymenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := maildefkeyprompt;
      MailKeyCmd.Release;*)


(*       MailKeyCmd := Command.Create(PGPGW_NEWMENU_MULTIKEY); //select key to mail
      PGPMenu.MenuItems.Add(mailkeymenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := mailkeyprompt;
      MailKeyCmd.Release;*)
               if (CompareText('GW.MESSAGE',Copy(context,1,10)) = 0) then begin //if it is a new message
     Cmd := Command.Create(PGPGW_NEWMENU_SEP);  //separator
  GWSeparator := pgpmenu.menuitems.AddSeparator;
  Cmd.Release;
            EncryptCmd := Command.Create(PGPGW_NEWMENU_ENCRYPTNOW); //encrypt selected item
  PGPMenu.MenuItems.Add(encryptnow, EncryptCmd.OleObject);
    EncryptCmd.LongPrmt := encryptnowprompt;
        EncryptCmd.Release;
          EncryptCmd := Command.Create(PGPGW_NEWMENU_SIGNNOW); //encrypt selected item
   PGPMenu.MenuItems.Add(signnow, EncryptCmd.OleObject);
    EncryptCmd.LongPrmt := signnowprompt;
        EncryptCmd.Release;
    EncryptCmd := Command.Create(PGPGW_NEWMENU_ENCRYPTSIGNNOW); //encrypt selected item
  PGPMenu.MenuItems.Add(encryptsignnow, EncryptCmd.OleObject);
    EncryptCmd.LongPrmt := encryptsignnowprompt;
        EncryptCmd.Release;



         form1.pgp.encryptone:=form1.pgp.encryptmsg; //get the default encrypt and sign settings
         form1.pgp.signone:=form1.pgp.signmsg;
         Cmd := Command.Create(PGPGW_NEWMENU_SEP); //separator
  GWSeparator := pgpmenu.menuitems.AddSeparator;
  Cmd.Release;

               MailKeyCmd := Command.Create(PGPGW_PREFSET_SIGN); //add option to sign this message
      PGPMenu.MenuItems.Add(signonemenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := signoneprompt;
             signdirty:=true;
              Mailkeycmd.toolbar:=false;
      MailKeyCmd.Release;


      MailKeyCmd := Command.Create(PGPGW_PREFSET_ENCRYPT); //add option to encrypt this message
      PGPMenu.MenuItems.Add(encryptonemenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := encryptoneprompt;
             encryptdirty:=true;
         Mailkeycmd.toolbar:=false;
      MailKeyCmd.Release;

(*      MailKeyCmd := Command.Create(PGPGW_PREFSET_IGNOREINTERNAL); //add option to ignore internal mail
      PGPMenu.MenuItems.Add(ignoreinternalmenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := ignoreinternalprompt;
      MailKeyCmd.Release;*)


end;

     Cmd := Command.Create(PGPGW_NEWMENU_SEP);  //separator
  GWSeparator := pgpmenu.menuitems.AddSeparator;
  Cmd.Release;

            PGPCmd := Command.Create(PGPGW_NEWMENU_PGP); //load pgpkeys
      PGPMenu.MenuItems.Add(keymanmenu, PGPCmd.OleObject);
    PGPCmd.LongPrmt := keymanprompt;
      PGPCmd.Release;


              MailKeyCmd := Command.Create(PGPGW_NEWMENU_SHOWPREFS); //load pgpprefs
      PGPMenu.MenuItems.Add(prefmenu, MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := prefprompt;
        MailKeyCmd.Release;

(*          MailKeyCmd := Command.Create(PGPGW_PREFSET_RICHEDIT);
      PGPMenu.MenuItems.Add('&Keep Rich Edit Codes', MailKeyCmd.OleObject);
       MailKeyCmd.LongPrmt := 'Encrypt and decrypt with rich edit codes';
        MailKeyCmd.Release;*)

   end;                                                                // Call me each time to update


     result := false;
end;

function enumrichedit(childhandle:thandle;address:longint):boolean; stdcall; //callback to handle enumchildwindows to set max limit to richedit controls
type pint=^longint;
var classname:pchar;
begin
classname:=stralloc(256);
getclassname(childhandle,classname,256);
if classname='RICHEDIT' then begin
sendmessage(childhandle,EM_EXLIMITTEXT,0,32000);
sendmessage(childhandle,EM_REQUESTRESIZE,0,0);
result:=true
end;
strdispose(classname);
end;



function enumproc(childhandle:thandle;address:longint):boolean; stdcall; //callback to handle enumchildwindows and grab the toolbar
type pint=^longint;
var classname:pchar;
begin
classname:=stralloc(256);
getclassname(childhandle,classname,256);
if classname=toolbarclassname then begin
result:=false;
pint(address)^:=childhandle;
end else begin
result:=true;
end;
strdispose(classname);
end;


{***********************************************************
   Name:         TCommandFactory.CustomizeToolBar

   Description:  Method to customize the toolbar. The C3po must assume that its commands are absent from
                 the toolbar. For example, when a toolbar has been saved and restored in another session
                 of GruopWise, the commands can be put back onto the toolbar w/out any intervening calls to
                 CustomizeToolbar. For that reason, the C3po should query, the toolbar first before adding
                 anything to the toolbar window.

   In:           Context: string - Contains the class of the containing window.
                 GWToolbar: variant - Contains the GWToolbar object to be modified.

   Out:          wordbool - Returning TRUE from this method indicates that the toolbar modifications were
                            'volatile'. In that case, each time the toolbar is validated in the UI, the
                            CommandFactory::CustomizeToolbar method will be called.
   Comments:

************************************************************}
function CommandFactory.CustomizeToolBar( Context: string;
                                           GWToolbar: variant): wordbool;
var
MainToolBar: variant;
ToolbarItems: variant;
data,test:longint;
mess,messageid:string;
handle:thandle;
signtoolbar,clistate,gwmess:variant;
begin

     ToolbarItems := GWToolbar.ToolbarItems;


if (CompareText('GW.MESSAGE',Copy(context,1,10)) = 0)  then begin //if it is a message
if replyornew then begin
replyornew:=false;
     PGPCmd := Command.Create(PGPGW_PREFSET_SIGN); //add a sign option button
     signToolbar := ToolbarItems.Add('PGP sign on Send', PGPCmd.OleObject);
     PGPCmd.toolbarid:=signtoolbar.toolbarid;
            PGPcmd.toolbar:=true;
     PGPCmd.window:=0;
     signdirty:=true;
     signtoolbar.SetBitmap(extractfilepath(paramstr(0))+'pgpicons.dll',2{$IFDEF PGP6}+4{$ENDIF});
     PGPCmd.ToolTp := signtool;
     PGPCmd.Release;


     PGPCmd := Command.Create(PGPGW_PREFSET_ENCRYPT); //add an encrypt option button
     MainToolbar := ToolbarItems.Add('PGP encrypt on Send', PGPCmd.OleObject);
     PGPCmd.ToolTp := encrypttool;
        MainToolbar.SetBitmap(extractfilepath(paramstr(0))+'pgpicons.dll',1{$IFDEF PGP6}+4{$ENDIF});
        PGPCmd.toolbarid:=maintoolbar.toolbarid;
        encryptdirty:=true;
        PGPCmd.window:=0;
        PGPcmd.toolbar:=true;
     PGPCmd.Release;

     PGPCmd := Command.Create(PGPGW_NEWMENU_PGP);//load pgpkeys
     MainToolbar := ToolbarItems.Add('PGP Key Management', PGPCmd.OleObject);
     PGPCmd.ToolTp := Keymanprompt;
     MainToolbar.SetBitmap(extractfilepath(paramstr(0))+'pgpicons.dll',3{$IFDEF PGP6}+4{$ENDIF});
     PGPCmd.Release;

end else try
           clistate:=c3po.g_C3POManager.ClientState;
            gwMess := clistate.CommandMessage; //get the current messaage
                 PGPCmd := Command.Create(PGPGW_NEWMENU_DECRYPT); //add a decrypt now button
     MainToolbar := ToolbarItems.Add('PGP Decrypt', PGPCmd.OleObject);
     PGPCmd.ToolTp := decrypttool;
        MainToolbar.SetBitmap(extractfilepath(paramstr(0))+'pgpicons.dll',4{$IFDEF PGP6}+4{$ENDIF});
        PGPCmd.toolbarid:=maintoolbar.toolbarid;
        encryptdirty:=true;
        PGPCmd.window:=0;
        PGPcmd.toolbar:=true;
     PGPCmd.Release;

      except //exception gets thrown by clistate.commandmessage if it is a new message
     PGPCmd := Command.Create(PGPGW_PREFSET_SIGN); //add a sign option button
     signToolbar := ToolbarItems.Add('PGP sign on Send', PGPCmd.OleObject);
     PGPCmd.toolbarid:=signtoolbar.toolbarid;
            PGPcmd.toolbar:=true;
     PGPCmd.window:=0;
     signdirty:=true;
     signtoolbar.SetBitmap(extractfilepath(paramstr(0))+'pgpicons.dll',2{$IFDEF PGP6}+4{$ENDIF});
     PGPCmd.ToolTp := signtool;
     PGPCmd.Release;


     PGPCmd := Command.Create(PGPGW_PREFSET_ENCRYPT); //add an encrypt option button
     MainToolbar := ToolbarItems.Add('PGP encrypt on Send', PGPCmd.OleObject);
     PGPCmd.ToolTp := encrypttool;
        MainToolbar.SetBitmap(extractfilepath(paramstr(0))+'pgpicons.dll',1{$IFDEF PGP6}+4{$ENDIF});
        PGPCmd.toolbarid:=maintoolbar.toolbarid;
        encryptdirty:=true;
        PGPCmd.window:=0;
        PGPcmd.toolbar:=true;
     PGPCmd.Release;

     PGPCmd := Command.Create(PGPGW_NEWMENU_PGP);//load pgpkeys
     MainToolbar := ToolbarItems.Add('PGP Key Management', PGPCmd.OleObject);
     PGPCmd.ToolTp := Keymanprompt;
     MainToolbar.SetBitmap(extractfilepath(paramstr(0))+'pgpicons.dll',3{$IFDEF PGP6}+4{$ENDIF});
     PGPCmd.Release;

end;
end;
if (CompareText('GW.CLIENT.WINDOW.BROWSER',context)=0)  then begin //if browser
     PGPCmd := Command.Create(PGPGW_NEWMENU_PGP); //load pgpkeys
     MainToolbar := ToolbarItems.Add('PGP Key Management', PGPCmd.OleObject);
     PGPCmd.ToolTp := Keymanprompt;
     MainToolbar.SetBitmap(extractfilepath(paramstr(0))+'pgpicons.dll',3{$IFDEF PGP6}+4{$ENDIF});
     PGPCmd.Release;
end;

     result := false;
end;

{***********************************************************
   Name:       Command.GetLongPrompt

   Description: This routine should return the long prompt for the GWCommand.

   In:          none

   Out:         Longpromt: string

   Comments:

************************************************************}
function Command.GetLongPrompt : string;
begin
     Result := LongPrmt;                              // return a longprompt
end;

{***********************************************************
   Name:       TGWCommand.GetToolTip

   Description: This routine should return the tool tip for custom toolbar
                commands only.

   In:          none

   Out:         ToolTip: string

   Comments: Only commands genertated and placed on the toolbar with
   CommandFactory.Customise Toolbar(or explicitly added by the user) have
   this method invoked.
************************************************************}
function Command.GetToolTip : string;
begin
     Result := ToolTp;
end;


{***********************************************************
   Name:       Command.Execute

   Description: This routine should execute the command.

   In:          none

   Out:         none

   Comments:    At this point the processing of the command is the C3po's
                responsiblity.
************************************************************}
procedure Command.Execute; //key function

var
clipboard:tclipboard;
parms,cmd,clistate:variant;
persid,messid,mess,temp:string;
passwd:pchar;
winhandle:thandle;
status:statrec;
count,tempver:longint;
continue:boolean; temppath:pchar;
oldsign,oldenc,tempbool:boolean;
begin
 begin
     if m_nCmd = PGPGW_PREFSET_IGNOREINTERNAL then begin //toggle ignore internal option
     form1.ignoreinternal:=not form1.ignoreinternal;
     form1.setfield(ignoreinternalfield,form1.ignoreinternal); //set the field in the groupwise message store

     end else
          if m_nCmd = PGPGW_PREFSET_RICHEDIT then begin //currently unused - will handle rich text
     form1.richedit:=not form1.richedit;
     form1.setfield(richeditfield,form1.richedit);


     end else
     if m_nCmd = PGPGW_PREFSET_PGPISDEFAULT then begin //toggle whether PGP is default option
     form1.pgpisdefault:=not form1.pgpisdefault;
     form1.setfield(isdefaultfield,form1.pgpisdefault); //set the field in GW message store
     end else

     if   m_nCmd= PGPGW_NEWMENU_IGNOREDECRYPT then begin //bypass decryption
     form1.passthrough:=true;//used to tell the OPEN override to go straight to the groupwise command and not process
     messid:=getmessageid;
     if messid<>'ERROR' then begin
          form1.wpo.commandstring:='ItemOpen("'+messid+'")';//call the command that groupwise would use
           form1.wpo.commandstring:='refresh()';
          end;
     end else
     if m_nCmd=PGPGW_NEWMENU_ENCRYPTNOW then
     begin
      form1.sendbutton:=false;
     application.processmessages;
     winhandle:=getforegroundwindow;
          setforegroundwindow(form1.handle);
         fOK:=1;
          form1.wpo.commandstring:='itemmessageidfromview()';
          messid:= form1.wpo.commandreturn;
          if messid = 'X00' then begin
          {if not encryptedalready then} begin
          encryptform.eoption.itemindex:=0;
          form1.wpo.commandstring:='EditCopy()';
          temp:=form1.wpo.commandreturn;
          if pos('Token failed',form1.wpo.commandreturn)=0 then begin
          form1.wpo.commandstring:='EnvClipboardText()';
          temp:=form1.wpo.commandreturn;
          end;
          oldsign:=form1.pgp.signone;
          oldenc:=form1.pgp.encryptone;
           form1.pgp.signone:=false;
          form1.pgp.encryptone:=false;
         fOK:=encryptform.c3poencrypt(encryptform.eoption.itemindex in [0,1],not (pos('Token failed',temp)>0));
{         if fOK=0 then encryptedalready:=true else
         encryptedalready:=false;}
          begin
          setforegroundwindow(winhandle);
          form1.pgp.signone:=oldsign;
          form1.pgp.encryptone:=oldenc;;
         application.processmessages;
         end;
          end;
          end;
     end
     else
          if m_nCmd=PGPGW_NEWMENU_SIGNNOW then
     begin
           form1.sendbutton:=false;
     application.processmessages;
          winhandle:=getforegroundwindow;
          setforegroundwindow(application.handle);
         fOK:=1;
          form1.wpo.commandstring:='itemmessageidfromview()';
          messid:= form1.wpo.commandreturn;
          if messid = 'X00' then begin
          {if not encryptedalready then} begin
             encryptform.eoption.itemindex:=2;
          form1.wpo.commandstring:='EditCopy()';
          temp:=form1.wpo.commandreturn;
          if pos('Token failed',form1.wpo.commandreturn)=0 then begin
          form1.wpo.commandstring:='EnvClipboardText()';
          temp:=form1.wpo.commandreturn;
          end;
          oldsign:=form1.pgp.signone;
          oldenc:=form1.pgp.encryptone;
           form1.pgp.signone:=false;
          form1.pgp.encryptone:=false;
         fOK:=encryptform.c3poencrypt(encryptform.eoption.itemindex in [0,1],not (pos('Token failed',temp)>0));
{         if fOK=0 then encryptedalready:=true else
         encryptedalready:=false;}
         begin
         setforegroundwindow(winhandle);
          form1.pgp.signone:=oldsign;
          form1.pgp.encryptone:=oldenc;
         application.processmessages;
         end;
          end;
          end;
     end
     else
     if m_nCmd=PGPGW_NEWMENU_ENCRYPTSIGNNOW then
     begin
           form1.sendbutton:=false;
     application.processmessages;
          winhandle:=getforegroundwindow;
          setforegroundwindow(application.handle);
         fOK:=1;
          form1.wpo.commandstring:='itemmessageidfromview()';
          messid:= form1.wpo.commandreturn;
          if messid = 'X00' then begin
         { if not encryptedalready then} begin
          encryptform.eoption.itemindex:=1;
          form1.wpo.commandstring:='EditCopy()';
          temp:=form1.wpo.commandreturn;
          if pos('Token failed',form1.wpo.commandreturn)=0 then begin
          form1.wpo.commandstring:='EnvClipboardText()';
          temp:=form1.wpo.commandreturn;
          end;
          oldsign:=form1.pgp.signone;
          oldenc:=form1.pgp.encryptone;
           form1.pgp.signone:=false;
          form1.pgp.encryptone:=false;
         fOK:=encryptform.c3poencrypt(encryptform.eoption.itemindex in [0,1],not (pos('Token failed',temp)>0));
{         if fOK=0 then encryptedalready:=true else
         encryptedalready:=false;}
         begin
         setforegroundwindow(winhandle);
           form1.pgp.signone:=oldsign;
          form1.pgp.encryptone:=oldenc;
         application.processmessages;
         end;
          end;
          end;
     end
     else

     if m_nCmd = PGPGW_NEWMENU_ENCRYPTSELECTED then //encrypt selected text
     begin
     application.processmessages;
          winhandle:=getforegroundwindow;
          setforegroundwindow(application.handle);
         fOK:=1;
          form1.wpo.commandstring:='itemmessageidfromview()';
          messid:= form1.wpo.commandreturn;
          if messid = 'X00' then begin
       {  if not encryptedalready then }begin
          if form1.pgp.encryptone or form1.pgp.signone then begin //if an option is set, then encrypt
            fOK:=encryptform.c3poencrypt(form1.pgp.encryptone,true);

         end else
         if encryptform.showmodal = mrOK then //if no option is set, then ask the user
         fOK:=encryptform.c3poencrypt(encryptform.eoption.itemindex in [0,1],true); //encrypt the selected text
         setforegroundwindow(winhandle);
  {       if fOK=0 then encryptedalready:=true else
         encryptedalready:=false;}
          end;
         end else //if a new message is not open
     form1.wpo.commandstring:='NewMail()';

     end;
     if   m_nCmd = PGPGW_NEWMENU_ABOUTBOX then  //create an about box
     begin
          form1.pgp.about;
     end

     else if m_nCmd = PGPGW_NEWMENU_PGP then //show pgpkeys
     begin
     application.processmessages;
     setforegroundwindow(application.handle);
     temppath:=stralloc(MAX_PATH);
     PGPcomdlgGetPGPPath(temppath,MAX_PATH);
     winexec(pchar(strpas(temppath)+'pgpkeys.exe'),SW_NORMAL);
     strdispose(temppath);
     end
     else if m_nCmd = PGPGW_NEWMENU_CANCEL then begin //handle a canceled window - called by the token handler
     for count :=0 to (form1.killlist.items.count -1) do begin
     form1.pgp.wipefile(form1.killlist.items[0]);
     form1.killlist.items.Delete(0);
     end;
     encryptedalready:=false;
{     form1.wpo.commandstring:='itemmessageidfromview()';
           messid:= form1.wpo.commandreturn;
     if messid = 'X00' then
          encryptedalready:=false;}
     end
     else

      if m_nCmd =PGPGW_NEWMENU_AUTOENCRYPT then begin //auto encrypt - called when the send button is pressed
         fOK:=0;
         if form1.pgpisdefault then begin //if pgp is the provider then encrypt if the option is set and it is not already done
         form1.sendbutton:=true;
         if not encryptedalready {and (pos('-----BEGIN PGP',mess)=0)} then
         begin
              winhandle:=getforegroundwindow;
         if form1.pgp.encryptone or form1.pgp.signone then begin
               fok:=encryptform.c3poencrypt(form1.pgp.encryptone,false);
               setforegroundwindow(winhandle);
               if fok=0 then encryptedalready:=true;
               end;
         end;{ else
           if messagedlg(alreadydonemess,mtwarning,[mbYES,mbCancel],0)=mrYes then
           fok:=0 else fok:=1;}
         end;
     end
     else
     if m_nCmd = PGPGW_NEWMENU_ENCRYPT then //encrypt on command
     begin
     form1.sendbutton:=false;
     application.processmessages;
          winhandle:=getforegroundwindow;
          setforegroundwindow(application.handle);
         fOK:=1;
          form1.wpo.commandstring:='itemmessageidfromview()';
          messid:= form1.wpo.commandreturn;
          if messid = 'X00' then begin
          if not encryptedalready then begin
          if form1.pgp.encryptone or form1.pgp.signone then begin //if an option is set then encrypt
            fOK:=encryptform.c3poencrypt(form1.pgp.encryptone{encryptmsg},false);
            setforegroundwindow(winhandle);

         end else
         if encryptform.showmodal = mrOK then //if option not set, then ask the user and handle
         fOK:=encryptform.c3poencrypt(encryptform.eoption.itemindex in [0,1],false);
         setforegroundwindow(winhandle);
         if fOK=0 then encryptedalready:=true else
         encryptedalready:=false;
          end;
         end else //if not a new message
     form1.wpo.commandstring:='NewMail()';
      end
     else if m_nCmd = PGPGW_NEWMENU_DECRYPT then //decrypt on command
     begin
     validate;
       application.processmessages;
     setforegroundwindow(application.handle);
     form1.decryptclick(form1); //call the decryption procedure
     application.processmessages;
     form1.hide;
     end
     else if m_nCmd = PGPGW_NEWMENU_KEYTORING then //import a key
     begin
     Form1.Hide;
     Form1.Key_To_RingClick(form1); //call the key import procedure
     end
     else if m_nCmd = PGPGW_NEWMENU_MAILKEY then //maildefault key
     begin
     Form1.Hide;
     form1.wpo.commandstring:='itemmessageidfromview()';
     if form1.wpo.commandreturn <> 'X00' then
   form1.wpo.commandstring:='NewMail()';
     encryptedalready:=pgp2.mail_key(mailkeydefault); //mail default key
     form1.hide;
     end else if m_nCmd = PGPGW_NEWMENU_MULTIKEY then begin //select key to mail
        form1.wpo.commandstring:='itemmessageidfromview()';
        if form1.wpo.commandreturn <> 'X00' then
        form1.wpo.commandstring:='NewMail()';
       encryptedalready:=pgp2.mail_key(mailkeyselect);
        end
   else if m_nCmd = PGPGW_PREFSET_SIGN then begin //toggle signone option
        if not encryptedalready then
{        messagedlg(alreadydonemess,mtinformation,[mbOK],0) else}
         begin
        tempbool:=not form1.pgp.signone;
        form1.pgp.signone:=tempbool;
        signdirty:=true;
        end;
        end
         else if m_nCmd = PGPGW_NEWMENU_SHOWPREFS then begin //show pgpprefs
           form1.pgp.showprefs;
         end
        else if m_nCmd = PGPGW_PREFSET_ENCRYPT then begin //toggle encryptone option
       if not encryptedalready then
{        messagedlg(alreadydonemess,mtinformation,[mbOK],0) else}
        begin
        tempbool:=not form1.pgp.encryptone;
        form1.pgp.encryptone:=tempbool;
        encryptdirty:=true;
        end;
        end else if (m_nCmd =PGPGW_OVERRIDE_NEW) or (m_nCmd =PGPGW_OVERRIDE_REPLY) or (m_nCmd =PGPGW_OVERRIDE_FORWARD) then begin //override compose command
          replyornew:=true;
          encryptedalready:=false;
          oldopencmd.execute; //call the old compose command from GW

          {$IFDEF GW52}
          {$ELSE}
          form1.wpo.commandstring:='EventNoticeRegister ("'+extractfilepath(paramstr(0))+'sendtph.dll'+'";"GWEventNotify";2543;'+inttostr(EVT_GROUPWISE_CANCEL_ITEM)+')';
          form1.wpo.commandstring:='EventNoticeRegister ("'+extractfilepath(paramstr(0))+'sendtph.dll'+'";"GWEventNotify";2543;'+inttostr(EVT_GROUPWISE_PACKAGING_ITEM)+')';
          form1.wpo.commandstring:='EventNoticeRegister ("'+extractfilepath(paramstr(0))+'sendtph.dll'+'";"GWEventNotify";2543;'+inttostr(EVT_GROUPWISE_SEND_ITEM_COMPLETED)+')';

          {$ENDIF}
        end else
        if m_nCmd = PGPGW_OVERRIDE_OPEN then begin //auto decrypt on open command
          begin
          try
          clistate:=c3po.g_C3POManager.ClientState; //get the current message
           gwMess := clistate.CommandMessage;
               if form1.richedit then
            mess:=gwmess.bodytext.rtf
            else
            mess:=gwmess.bodytext.plaintext;
            messid:=gwmess.messageid;

            if (CompareText(messagebodyonly,Copy(mess,1,24)) = 0) then //if this was an internal message, then don't do attachments
            begin
            form1.passthrough:=true;
            if form1.pgp.decrypt(mess,status,false)=0 then begin
            setforegroundwindow(application.handle);
            messagedlg(status.mess,mtinformation,[mbOK],0);
            end;
            end;
            fOK:=0;
          if (pos('-----BEGIN PGP',mess)>0) and form1.pgp.autodecrypt and (not form1.passthrough) then begin //if this is PGP and autodecrypt is on and we are not bypassing
               application.processmessages;
               setforegroundwindow(application.handle);
               try
               if not pgp2.decrypt(gwmess) then //call the decryption handler
               oldopencmd.execute else
               begin
               form1.hide;
               fok:=1;
               end;
               except end;
                end else begin
               form1.passthrough:=false;
               try
               oldopencmd.execute; //call the GW open command
               except end;
               end; except
               oldopencmd.execute; //call the GW open command
               end; 
               end;end else
        begin
        end;
     end;

end;

{***********************************************************
   Name:       Command.Validate

   Description:  This interface is called to determine the state of a C3po
                 command. Determining the state is termed the validation.
                 The command is assumed by default to be in an enabled, unchecked,
                 visible state. The C3po provider can then modify that assumption
                 by returning flags. The available flags are:

                     eGW_CMDVAL_ALWAYS - The command is always in the same state
                                         and there is no need to validate it again.
                     eGW_CMDVAL_CHECKED - The command has a check mark.
                     eGW_CMDVAL_DISABLED - The command is disabled.


   In:           none

   Out:          none

   Comments:  Validate applies only to commands put onto the toolbar or menu by the
             C3po server. Predifined commands do not cause this method to be involked.

************************************************************}
function Command.Validate: longint;
var eline,bhandle:string;win,handle:thandle;count,test:longint;button:ttbbutton;data:pchar;temp:string;
begin
     application.processmessages;
        if not done then begin //if this is the first pass find out what message this belongs to
                form1.wpo.commandstring:='itemmessageidfromview()';
        messageid:= form1.wpo.commandreturn;
        end;
         result:=0;

        if m_nCmd=PGPGW_NEWMENU_PGP then begin
        if not done then
        form1.gwhandle:=getforegroundwindow;
        result := eGW_CMDVAL_ALWAYS;
        end else
        if m_nCmd=PGPGW_PREFSET_RICHEDIT then begin
        if form1.richedit then result:=eGW_CMDVAL_CHECKED;
        end else

          if m_nCmd=PGPGW_PREFSET_PGPISDEFAULT then begin //check if PGP Default is on
        if form1.pgpisdefault then result:=eGW_CMDVAL_CHECKED;
        end else

          if m_nCmd=PGPGW_PREFSET_IGNOREINTERNAL then begin //check if ignore internal is on
        if form1.ignoreinternal then result:=eGW_CMDVAL_CHECKED;
        if messageid <> 'X00' then result:=eGW_CMDVAL_DISABLED; //disable if not new message
        end else

        if m_nCmd = PGPGW_PREFSET_SIGN then begin //if the sign option
        if toolbar then begin //if toolbar button
        if (window=0) then begin //get the handle to the toolbar
        win:=getforegroundwindow;
        enumchildwindows(win,@enumrichedit,0);
        enumchildwindows(win,@enumproc,longint(@handle));
        window:=handle;
        end;
        end;

        if form1.pgp.signone then begin //check if signone is on

        result:=eGW_CMDVAL_CHECKED;
        end else
        if toolbar and signdirty then
        begin sendmessage(window,TB_setstate,toolbarid,longint(TBSTATE_ENABLED));
        signdirty:=false;
        end;
        if messageid <> 'X00' then begin //if not new message then disable menu item
        result:=eGW_CMDVAL_DISABLED;
        end else
        if toolbar and signdirty then begin //press the button depending on signone setting
        sendmessage(window,TB_setstate,toolbarid,longint(TBSTATE_PRESSED));
        signdirty:=false;
        end;
        end
        else if (m_nCmd = PGPGW_PREFSET_ENCRYPT) then begin //do the same thing with the encryptone option
        if toolbar then begin
        if (window=0) then begin
        win:=getforegroundwindow;
        enumchildwindows(win,@enumproc,longint(@handle));
        window:=handle;
        end;
        end;
        if (form1.pgp.encryptone) then  begin

       result:=eGW_CMDVAL_CHECKED;
           end else
          if toolbar and encryptdirty then
          begin sendmessage(window,TB_setstate,toolbarid,longint(TBSTATE_ENABLED)) ;
          encryptdirty:=false;
          end;
        if messageid <> 'X00' then begin
        result:=eGW_CMDVAL_DISABLED;
         end else
         if toolbar and encryptdirty then
        begin sendmessage(window,TB_setstate,toolbarid,longint(TBSTATE_PRESSED));
        encryptdirty:=false;
        end;

        end else if (m_nCmd = PGPGW_NEWMENU_ENCRYPT) {or (m_nCmd= PGPGW_NEWMENU_MAILKEY) or (m_nCmd= PGPGW_NEWMENU_MULTIKEY)}  then begin
        if messageid <> 'X00' then result:=eGW_CMDVAL_DISABLED;
        end else if (m_nCmd = PGPGW_NEWMENU_IGNOREDECRYPT) or (m_nCmd = PGPGW_NEWMENU_DECRYPT) or (m_nCMD=PGPGW_NEWMENU_KEYTORING) then begin
        application.processmessages;
        form1.wpo.commandstring:='envcheckcurrentwindow(624)'; //see if this is the browser window
        if form1.wpo.commandreturn='TRUE' then begin //if so
        form1.wpo.commandstring:='itemlistcreatefromcontrol(219;1;)'; //get the list of selected messages
        bhandle:=form1.wpo.commandreturn;
        if CompareText('Token',Copy(bhandle,1,5))=0 then
        result:=eGW_CMDVAL_DISABLED else begin
           form1.wpo.commandstring:='itemlistgetcount('+bhandle+')';
           eline:=form1.wpo.commandreturn;
           if eline='0' then
                   result:=eGW_CMDVAL_DISABLED;
            form1.wpo.commandstring:='itemlistdelete('+bhandle+')';
           end;
        end;
        if messageid = 'X00' then begin
        result:=eGW_CMDVAL_DISABLED;
        end;
        end else if (m_nCmd =PGPGW_NEWMENU_ENCRYPTNOW) or (m_nCmd =PGPGW_NEWMENU_SIGNNOW) or (m_nCmd =PGPGW_NEWMENU_ENCRYPTSIGNNOW) then begin
          if messageid <> 'X00' then result:=eGW_CMDVAL_DISABLED else begin
          form1.wpo.commandstring:='Envtextcurrentlineindex()';
          temp:=form1.wpo.commandreturn;
          if pos('Token failed',form1.wpo.commandreturn)>0 then
          result:=eGW_CMDVAL_DISABLED;
          end;
end else
       result := eGW_CMDVAL_ALWAYS;
        done:=true;
end;

{***********************************************************
   Name:       Command.Create

   Description: Create command object and set m_nCmd to command ID.

   In:          m_nCmd: longint - Contains the ID of the command.

   Out:         none

   Comments:

************************************************************}
Constructor Command.Create(nCmd: longint);
begin //initialize the variables associated with each command
     inherited Create;
     done:=false;
     messageid:='';
     toolbar:=false;
     m_nCmd := nCmd;                                  // save the command id
     fok:=1;
end;

{***********************************************************
   Name:       EventMonitor.Notify

   Description: This interface is passed to monitor "low level" actions that occur in GW.
                Such as:
                eGW_CMDEVTID_NEWMESAGE = Indicates that an item has been delivered
                                         to the GroupWise mailbox.
                eGW_CMDEVTID_ONREADY = This notification occurs during the GroupWise
                                       initialization procedure, just after GroupWise
                                       is initialized. The following services are
                                       running at the time this method is called:
                                       DDE server
                                       OLE objects registered and placed in the COM running object table

                eGW_CMDEVTID_ONSHUTDOWN = Simply a notification to the C3PO server
                                          that shutdown is occurring.  System services
                                          are still available when this notification
                                          is received.  Immediately after returning
                                          from this method call, however, the C3PO
                                          should assume that the calling client has
                                          shutdown.  If the calling client is the
                                          last client to use the C3PO manager, calls
                                          to the manager will fail after this call
                                          has returned.

   In:          Context: string - Class of the object

                evt: variant - Is an GWEvent. The GwEvent object defines an instance of an event.
                                It is subclassed by GWClientState. For more information see the documentation.

   Out:          none

   Comments:

************************************************************}
procedure EventMonitor.Notify(Context: string; evt: variant);
var clistate,mess:variant;persid:string;
begin
persid:=evt.PersistentID;
  if CompareText(persid,eGW_CMDEVTID_NEWMESSAGE) = 0 then   // if this is a new message
  begin
try //if the new message is one that got sent by the program, then mark it as read
  clistate:=c3po.g_C3POManager.ClientState;
  mess:=clistate.commandmessage;
    if pos(fromintro,mess.fromtext)>0 then begin
    form1.wpo.commandstring:='ItemSetAttribute("'+mess.messageid+'";206;1)';
              end;
   except end;
end;

if CompareText(persid,eGW_CMDEVTID_ONSHUTDOWN) = 0 then   // is this OnShutdown notify
  begin
   form1.close; //close main window
   application.terminate;
  end;
end;

{***********************************************************
   Name:       IconFactory.GetIcons

   Description:  This interface is used to retrieve icons that
                 represent the state of the C3po record types.

   In:           ObjClass: string - String of the object class


   Out:          pIconFile: string - Name of the file containing the icons(.dll or .exe)
                 plUnOpenIcon: longint - Index value of the unopen icon
                 plOpenIcon: longint - Index value of the open icon

   Comments: The plUnOpenIcon and plOpenIcon parameters are icon index values within
             the module (.exe or .dll) named by the pIconFile parameter.  Returning
             a value of -1 indicates that a default icon should be used.  Any other
             negative index value indicates a resource ID by taking the absolute value
             of the number.  The IconFactory object does not support inheritance.
             That is, there is no mechanism for two C3POs to both offer icons for
             the same record.  The C3PO system will simply use the first C3PO it finds.

             The icons retrieved are presumed to contain multiple image sizes.  The
             appropriate size is used by GroupWise as needed.  The current C3PO
             specification does not allow the C3PO to specify specific icon overlays (
             such as the attachment clip).

             The full path must be specified for the function to work.


************************************************************}
procedure IconFactory.GetIcons(  ObjClass: string;
                                 var pIconFile: string;
                                 var plUnOpenIcon: longint;
                                 var plOpenIcon: longint);
begin
{Empty right now}
end;

End.

