{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: Gwdll.pas,v 1.5.12.2 1999/08/27 22:00:46 build Exp $ }
{=____________________________________________________________________________ }

unit GWDLL;

interface
Uses WinTypes,Windows,sysutils,classes,shellapi,
     WinProcs,messages;



Type
MAC_COUNT = LongInt;
MAC_FUNCTIONID = Word;
MAC_TOKENID = MAC_FUNCTIONID;
MAC_MACROID = LongInt;
MAC_IPCVERSION = LongInt;

WZ = Byte;
Const
                      EVT_GROUPWISE_SEND_ITEM		      = $1;
                      EVT_GROUPWISE_CANCEL_ITEM		      = $2;
                      EVT_GROUPWISE_CLOSE_ITEM		      = $4;
                      EVT_GROUPWISE_PACKAGING_ITEM	      = $8;
                      EVT_GROUPWISE_PACKAGING_ITEM_CANCELED    = $10;
                      EVT_GROUPWISE_SEND_ITEM_COMPLETED	      = $20;


MAC_NAME_WZCOUNT = 50; {// Maximum size for a name.}

{/// ranges for the MAC_VALUE_TYPE enumeration. }
VALUE_GENERAL_TYPES = $0000; {// base range for general types}
VALUE_PARAMETER_TYPES = $0040; {// base range for types used only on parameters.}
VALUE_VARIABLE_TYPES = $0080; {// base range for types used only on parameters.}
VALUE_END_OF_TYPES = $00C0; {// end of type ranges.}


eValUndefined= VALUE_GENERAL_TYPES;
	eParmAny= VALUE_PARAMETER_TYPES;// type decided at run-time
	eParmBoolean= VALUE_PARAMETER_TYPES+1;								// 'C' BOOL type
	eParmByteSigned=VALUE_PARAMETER_TYPES+2;							// signed 8-bit value
	eParmByteUnsigned=VALUE_PARAMETER_TYPES+3;							// unsigned 8-bit value
	eParmCentimeters=VALUE_PARAMETER_TYPES+4;		  					// double
	eParmDwordSigned=VALUE_PARAMETER_TYPES+5;							// signed 32-bit value
	eParmDwordUnsigned=VALUE_PARAMETER_TYPES+6;							// unsigned 32-bit value
	eParmDWPUSigned=VALUE_PARAMETER_TYPES+7;							// signed 32-bit unit (WPU)
	eParmDWPUUnsigned=VALUE_PARAMETER_TYPES+8;							// unsigned 32-bit unit (WPU)
	eParmEnumeration=VALUE_PARAMETER_TYPES+9;							// enumeration 16-bit value
	eParmFloat=VALUE_PARAMETER_TYPES+10;									// double
	eParmInches=VALUE_PARAMETER_TYPES+11;								// double
	eParmMillimeters=VALUE_PARAMETER_TYPES+12;							// double
	eParmPoints=VALUE_PARAMETER_TYPES+13;								// double
	eParmStringAnsi=VALUE_PARAMETER_TYPES+14;							// ANSI string (zero terminated)
	eParmStringLabel=VALUE_PARAMETER_TYPES+15;							// WPCORP Word STring (zero terminated)
												//  containing a label reference.
	eParmStringOem=VALUE_PARAMETER_TYPES+16;								// OEM string (zero terminated)
	eParmStringWord=VALUE_PARAMETER_TYPES+17;							// WPCORP Word String (zero terminated)
	eParmStringVariable=VALUE_PARAMETER_TYPES+18;						// word string containing a variable name
	eParmTokenID=VALUE_PARAMETER_TYPES+19;								// unsigned 16-bit value
	eParmWordSigned=VALUE_PARAMETER_TYPES+20;							// signed 16-bit value
	eParmWordUnsigned=VALUE_PARAMETER_TYPES+21;							// unsigned 16-bit value
	eParmWPFname=VALUE_PARAMETER_TYPES+22;								// ANSI string (zero terminated)
												//  containing a file name.
	eParmWPUSigned=VALUE_PARAMETER_TYPES+23;								// signed 16-bit unit (WPU)
	eParmWPUUnsigned=VALUE_PARAMETER_TYPES+24;							// unsigned 16-bit unit (WPU)
	eParmUserDialog=VALUE_PARAMETER_TYPES+25;							// user dialog buffer (like a string)

	// variable types only
	eValArrayDefinition = VALUE_VARIABLE_TYPES;	// definition of an Array
	eValBoolean= VALUE_VARIABLE_TYPES+1;								// 'C' BOOL type
	eValCentimeters= VALUE_VARIABLE_TYPES+2;		  					// double
	eValFloat= VALUE_VARIABLE_TYPES+3;									// double
	eValInches= VALUE_VARIABLE_TYPES+4;									// double
	eValInteger= VALUE_VARIABLE_TYPES+5;								// signed 32-bit value
	eValMillimeters= VALUE_VARIABLE_TYPES+6;     							// double
	eValOLEObject= VALUE_VARIABLE_TYPES+7;								// ???
	eValPoints= VALUE_VARIABLE_TYPES+8;									// double
	eValString= VALUE_VARIABLE_TYPES+9;									// WPCORP Word String (zero terminated)
	eValStringAnsi= VALUE_VARIABLE_TYPES+10;								// ANSI string (zero terminated)
	eValStringOem= VALUE_VARIABLE_TYPES+11;								// OEM string (zero terminated)
	eValWPUnits= VALUE_VARIABLE_TYPES+12;								// signed 32-bit unit (WPU)
	eValAlias= VALUE_VARIABLE_TYPES+13;									// used for reference parameters
	eValRecord= VALUE_VARIABLE_TYPES+14;									// definition of a record
	eValDateTime= VALUE_VARIABLE_TYPES+15;								// unsigned 32-bit value
	eValRawBinary= VALUE_VARIABLE_TYPES+16;								// raw binary data type

	eValZzzzzNoMore		= VALUE_END_OF_TYPES;	// there is nothing after this.
{/// Macro IPC Parameter packet. }
Type MAC_VALUE_TYPE=VALUE_GENERAL_TYPES..VALUE_END_OF_TYPES;
type udatarec=record
                       case word of
                       1:(dwValue: LongInt);
                       2:(lpvPtr: Pointer);
                       3:(drValue: Double);
end;

Type MAC_PARAM = record
                       eType: MAC_VALUE_TYPE;
                       wFlags: Word;
                       wReserved: Word;
                       udata:udatarec;
                     end; {_tagMAC_PARAM}


 NPMAC_PARAM=^MAC_PARAM;
 LPMAC_PARAM=^MAC_PARAM;
 PMAC_PARAM=^MAC_PARAM;
{/// Macro IPC token packet. }

Type MAC_TOKEN = record
                       hszCommand: pchar;
                       Version: MAC_IPCVERSION;
                       hszRequestor: pchar;
                       dwMacroID: MAC_MACROID;
                       atomApp: TAtom;
                       wReserved: Word;
                       wTokenId: MAC_TOKENID;
                       cParam:word{ MAC_COUNT};
                       dwFlags: LongInt;
                       dwReserved: LongInt;
                       rsParam: Array[0..0] of MAC_PARAM;
{/// the end of the structure }
                     end; {_tagMAC_TOKEN}
NPMAC_TOKEN=^MAC_TOKEN;
LPMAC_TOKEN=^MAC_TOKEN;
PMAC_TOKEN=^MAC_TOKEN;

Const MAC_NO_ERROR = 0;
MAC_BASE_GENERAL_ERRORS = -99;

MAC_FUNCTION_OK = MAC_NO_ERROR;
           MAC_FUNCTION_UNKNOWN = MAC_BASE_GENERAL_ERRORS;
           MAC_FUNCTION_NOTFOUND= MAC_BASE_GENERAL_ERRORS+1;
           MAC_FUNCTION_CANCEL= MAC_BASE_GENERAL_ERRORS+2;
           MAC_FUNCTION_ERROR= MAC_BASE_GENERAL_ERRORS+3;
           MAC_FUNCTION_INVALID_PARM= MAC_BASE_GENERAL_ERRORS+4;
           MAC_FUNCTION_INVALID= MAC_BASE_GENERAL_ERRORS+5;
           MAC_FUNCTION_NOT_HANDLED= MAC_BASE_GENERAL_ERRORS+6;
           MAC_FUNCTION_RETURN_LATER= MAC_BASE_GENERAL_ERRORS+7;

type MAC_TOKENERROR=MAC_FUNCTION_RETURN_LATER..MAC_NO_ERROR;
Type AZ = Char;
Type MAC_SYMBOLNAME=array[0..MAC_NAME_WZCOUNT] of WZ;
Type VALUE_FLOAT = Double;
Type VALUE_INT = LongInt;

{/// Macro variable structure. }
{/// Used on the VariableSet requests and replys. }

type ustrrec=record
	case Word of
        1:(wzData:array[0..0] of WZ);		// First character in the string(WZ).
	2:(azData:array[0..0] of AZ);// Remaining characters follow.
        end;
type stdatarec=record
	wStrLen:WORD;		// Length of string (# of characters).
        ustr:ustrrec;
end;										// - eValString
						// First character in the string(AZ).
type uvaluerec=record
 	Case Word of

		1:(fData:BOOLean);			// eValBoolean
		2:(drData:VALUE_FLOAT);			// eValCentimeters, eValFloat, eValInches,
		3:(lData:VALUE_INT);						// eValMillimeters, eValPoints
		4:(stData:stdatarec);					// eValInteger, eValWPUnits
end;

Type MAC_VARIABLE = record
                          hszCommand: pchar;
                          Version: MAC_IPCVERSION;
                          hszRequestor: pchar;
                          dwMacroID: MAC_MACROID;
                          atomApp: TAtom;
                          wReserved: Word;
                          eType: MAC_VALUE_TYPE;
{/// between VALUE_VARIABLE_TYPES+1 and }
{/// VALUE_END_OF_TYPES }
                          wSysVarID: MAC_TOKENID;
                          wzSymbolName: MAC_SYMBOLNAME;
                          uvalue:uvaluerec;

                       end; {_tagMAC_VARIABLE}

PMAC_VARIABLE=^MAC_VARIABLE;
LPMAC_VARIABLE=^MAC_VARIABLE;
NPMAC_VARIABLE=^MAC_VARIABLE;

{/// Macro IPC return value packet. }

Type MAC_RETURNVAL = record
                           hszRequestor: pchar;
{/// sent the token. }
                           dwMacroID: MAC_MACROID;
{/// the token. }
                           eReturnCode: MAC_TOKENERROR;
                           rv: MAC_VARIABLE;
{/// - fill out the eType and uValue only }
{/// for a token return. }
{/// - all other data will be ignored. }
                         end {_tagMAC_RETURNVAL};

NPMAC_RETURNVAL=^MAC_RETURNVAL;
LPMAC_RETURNVAL=^MAC_RETURNVAL;
PMAC_RETURNVAL=^MAC_RETURNVAL;
PLPMAC_RETURNVAL=^LPMAC_RETURNVAL;		//used in TPH subsystem

Type tph_returnval = record
                           lpToken: PMAC_TOKEN;
                           lplpmacRetVal: PLPMAC_RETURNVAL;
                         end {tph_returnval_tag};
LPTPH_RETURNVAL=^tph_returnval;                         

Type dllHandlerType = (DLL_HAN_NOT_HANDLED,
                        DLL_HAN_NO_ERROR,
                        DLL_HAN_NOT_FOUND,
                        DLL_HAN_CANCEL,
                        DLL_HAN_TOKEN_ERROR,
                        DLL_HAN_PARM_ERROR  );

Type dllValidationType = (DLL_VAL_UNKNOWN_TOKEN,
                           DLL_VAL_VALIDATED,
                           DLL_VAL_UNVALIDATED,
                           DLL_VAL_UNKNOWN_TASK  );

Const WPLM_EXECUTE_TOKEN = (WM_USER + 11); {// Message from 3rd party DLL to}
{/// cause the app to execute a token. }

Const WPLM_ALLOC_MEM = (WM_USER + 25); {// Sent when a third party app}
{/// needs to allocate memory }
{/// wParam - 0, not used }
{/// lParam - Size of buffer to alloc }
{/// Return lpMem if successful }
{/// NULL if unsuccessful. }

Const WPLM_FREE_MEM = (WM_USER + 26); {// Sent when a third party app}
{/// frees memory obtained using }
{/// WPLM_ALLOC_MEM }
{/// wParam - 0, not used }
{/// lParam - lpMem to free }
{/// Return NULL if successful, }
{/// lpMem if unsuccessful }

{/// Token Definitions begin here }
Const BASE_TOKEN = 32; {// Tokens start here, see RG_TOKEN_FLOOR}
Const BFTKN_INVALID_TOKEN = 0;


Const BASE_DIALOG_TOKEN = BASE_TOKEN;

Const DTKN_FILE_OPEN_DLG = (BASE_DIALOG_TOKEN + 0); {// DTKN_FILE_OPEN_DLG}
Const DTKN_NEW_QSI_DLG = (BASE_DIALOG_TOKEN + 1); {// DTKN_NEW_QSI_DLG - Obsolete}
Const DTKN_RENAME_FOLDER = (BASE_DIALOG_TOKEN + 3); {// DTKN_RENAME_FOLDER}
Const DTKN_CREATE_FOLDER = (BASE_DIALOG_TOKEN + 4); {// DTKN_CREATE_FOLDER}
Const DTKN_IMPORT_OLDCAL = (BASE_DIALOG_TOKEN + 5); {// DTKN_IMPORT_OLDCAL}
Const DTKN_BTNBAR_OPTIONS = (BASE_DIALOG_TOKEN + 7); {// DTKN_BTNBAR_OPTIONS}
Const DTKN_BTNBAR_SELECT = (BASE_DIALOG_TOKEN + 9); {// DTKN_BTNBAR_SELECT}
Const DTKN_PRINT_CALENDAR = (BASE_DIALOG_TOKEN + 11); {// DTKN_PRINT_CALENDAR}
Const DTKN_ADDRBOOK = (BASE_DIALOG_TOKEN + 12); {// DTKN_ADDRBOOK}
Const DTKN_VIEWER_SAVE_AS = (BASE_DIALOG_TOKEN + 13); {// DTKN_VIEWER_SAVE_AS}
Const DTKN_SELECT_FOLDER = (BASE_DIALOG_TOKEN + 14); {// DTKN_SELECT_FOLDER}
Const DTKN_SEND_OPTIONS = (BASE_DIALOG_TOKEN + 15); {// DTKN_SEND_OPTIONS}
Const DTKN_QSI_PROPERTIES = (BASE_DIALOG_TOKEN + 16); {// DTKN_QSI_PROPERTIES - Obsolete}
Const DTKN_HELP_COACHES = (BASE_DIALOG_TOKEN + 17); {// DTKN_HELP_COACHES}
Const DTKN_DELETE_FOLDERS = (BASE_DIALOG_TOKEN + 18); {// DTKN_DELETE_FOLDERS}
Const DTKN_MACRO_PLAY = (BASE_DIALOG_TOKEN + 19); {// DTKN_MACRO_PLAY}
Const DTKN_CUSTOM_REPLY = (BASE_DIALOG_TOKEN + 22); {// DTKN_CUSTOM_REPLY}
Const DTKN_PRINT_SETUP = (BASE_DIALOG_TOKEN + 23); {// DTKN_PRINT_SETUP}
Const DTKN_ACCEPT_REPLY = (BASE_DIALOG_TOKEN + 24); {// DTKN_ACCEPT_REPLY}
Const DTKN_REJECT_REPLY = (BASE_DIALOG_TOKEN + 25); {// DTKN_REJECT_REPLY}
Const DTKN_FILTER_ITEMLIST = (BASE_DIALOG_TOKEN + 26); {// DTKN_FILTER_ITEMLIST}
Const DTKN_DELEGATE = (BASE_DIALOG_TOKEN + 27); {// DTKN_DELEGATE}
Const DTKN_PRESETUP = (BASE_DIALOG_TOKEN + 28); {// DTKN_PRESETUP}
Const DTKN_RULE_LIST = (BASE_DIALOG_TOKEN + 30); {// DTKN_RULE_LIST}
Const DTKN_MACRO_ASSIGN_MENU = (BASE_DIALOG_TOKEN + 31); {// DTKN_MACRO_ASSIGN_MENU}
Const DTKN_LINKS = (BASE_DIALOG_TOKEN + 32); {// DTKN_LINKS}
Const DTKN_FOLDER_SHARE = (BASE_DIALOG_TOKEN + 33); {// DTKN_FOLDER_SHARE}
Const DTKN_ABOUT = (BASE_DIALOG_TOKEN + 34); {// DTKN_ABOUT}
Const DTKN_SEARCH = (BASE_DIALOG_TOKEN + 35); {// DTKN_SEARCH}
Const DTKN_CHOOSE_FONT = (BASE_DIALOG_TOKEN + 37); {// DTKN_CHOOSE_FONT}
Const DTKN_SAVE_AS_DLG = (BASE_DIALOG_TOKEN + 38); {// DTKN_SAVE_AS_DLG}
Const DTKN_SAVE_DLG = (BASE_DIALOG_TOKEN + 39); {// DTKN_SAVE_DLG}
Const DTKN_RETRIEVE = (BASE_DIALOG_TOKEN + 40); {// DTKN_RETRIEVE}
Const DTKN_INSERT_OBJECT = (BASE_DIALOG_TOKEN + 41); {// DTKN_INSERT_OBJECT}
Const DTKN_GSET_AUTODATE = (BASE_DIALOG_TOKEN + 42); {// DTKN_GSET_AUTODATE}
Const DTKN_GSET_STARTDATE = (BASE_DIALOG_TOKEN + 43); {// DTKN_GSET_STARTDATE}
Const DTKN_GSET_STARTTIME = (BASE_DIALOG_TOKEN + 44); {// DTKN_GSET_STARTTIME}
Const DTKN_GSET_ENDTIME = (BASE_DIALOG_TOKEN + 45); {// DTKN_GSET_ENDTIME}
Const DTKN_LINK_FOLDER = (BASE_DIALOG_TOKEN + 46); {// DTKN_LINK_FOLDER}
Const DTKN_SORTCOLMAN = (BASE_DIALOG_TOKEN + 47); {// DTKN_SORTCOLMAN}
Const DTKN_PROXY = (BASE_DIALOG_TOKEN + 48); {// DTKN_PROXY}
Const DTKN_ATTACHMENTS = (BASE_DIALOG_TOKEN + 49); {// DTKN_ATTACHMENTS}
Const DTKN_BUSYSRCH = (BASE_DIALOG_TOKEN + 50); {// DTKN_BUSYSRCH}
Const DTKN_PRINT = (BASE_DIALOG_TOKEN + 51); {// DTKN_PRINT}
Const DTKN_SET_ALARM = (BASE_DIALOG_TOKEN + 52); {// DTKN_SET_ALARM}
Const DTKN_ATTACH_OBJECT = (BASE_DIALOG_TOKEN + 53); {// DTKN_ATTACH_OBJECT}
Const DTKN_CHANGE_VIEW = (BASE_DIALOG_TOKEN + 54); {// DTKN_CHANGE_VIEW}
Const DTKN_FOLDER_PROFILEREF = (BASE_DIALOG_TOKEN + 55); {// DTKN_FOLDER_PROFILEREF}
Const DTKN_ATTACH_FILE = (BASE_DIALOG_TOKEN + 56); {// DTKN_ATTACH_FILE}
Const DTKN_GOTO_DATE = (BASE_DIALOG_TOKEN + 57); {// DTKN_GOTO_DATE}
Const DTKN_DATE_DIFF = (BASE_DIALOG_TOKEN + 58); {// DTKN_DATE_DIFF}
Const DTKN_SOUNDS = (BASE_DIALOG_TOKEN + 59); {// DTKN_SOUNDS}
Const DTKN_GSET_ENDDATE = (BASE_DIALOG_TOKEN + 60); {// DTKN_GSET_ENDDATE}
Const DTKN_BTNBAR_PREF = (BASE_DIALOG_TOKEN + 61); {// DTKN_BTNBAR_PREF}
Const DTKN_ADDRESS_INFO = (BASE_DIALOG_TOKEN + 62); {// DTNK_ADDRESS_INFO}
Const DTKN_QUERY = (BASE_DIALOG_TOKEN + 65); {// DTKN_QUERY}
Const DTKN_DM_COPY = (BASE_DIALOG_TOKEN + 66); {// DTKN_DM_COPY}
Const DTKN_DM_NEW = (BASE_DIALOG_TOKEN + 67); {// DTKN_DM_NEW}
Const DTKN_QUERY_EDIT = (BASE_DIALOG_TOKEN + 68); {// DTKN_QUERY_EDIT}
Const DTKN_QUERY_SAVE_AS_FOLDER = (BASE_DIALOG_TOKEN + 69); {// DTKN_QUERY_SAVE_AS_FOLDER}
Const DTKN_REM_UPDATE = (BASE_DIALOG_TOKEN + 70); {// DTKN_REM_UPDATE}
Const DTKN_REM_SELECTEDUPDATE = (BASE_DIALOG_TOKEN + 71); {// DTKN_REM_SELECTEDUPDATE}
Const DTKN_REM_SETUP = (BASE_DIALOG_TOKEN + 72); {// DTKN_REM_SETUP}
Const DTKN_REM_UPDATE_INFO = (BASE_DIALOG_TOKEN + 73); {// DTKN_REM_UPDATE_INFO}
Const DTKN_DM_CHECKIN = (BASE_DIALOG_TOKEN + 74); {// DTKN_DM_CHECKIN}
Const DTKN_DM_CHECKOUT = (BASE_DIALOG_TOKEN + 75); {// DTKN_DM_CHECKOUT}
Const DTKN_ADDRBOOK_MODAL = (BASE_DIALOG_TOKEN + 76); {// DTKN_ADDRBOOK_MODAL}
Const DTKN_SELECT_COLUMNS = (BASE_DIALOG_TOKEN + 77); {// DTKN_SELECT_COLUMNS}
Const DTKN_DM_IMPORT = (BASE_DIALOG_TOKEN + 80); {// DTNK_DM_IMPORT}
Const DTKN_DM_SETINUSE = (BASE_DIALOG_TOKEN + 81); {// DTKN_DM_SETINUSE}
Const DTKN_DM_ARCHIVE = (BASE_DIALOG_TOKEN + 82); {// DTKN_DM_ARCHIVE}
Const DTKN_DM_EXPORT = (BASE_DIALOG_TOKEN + 83); {// DTKN_DM_EXPORT}
Const DTKN_HIT_THE_ROAD = (BASE_DIALOG_TOKEN + 85); {// DTKN_HIT_THE_ROAD}
Const DTKN_DM_NEW_VERSION = (BASE_DIALOG_TOKEN + 86); {//DTKN_DM_NEW_VERSION}
Const DTKN_UNASSIGNED_127 = (BASE_DIALOG_TOKEN + 127);
Const TOP_DIALOG_TOKEN = DTKN_UNASSIGNED_127;
Const BASE_FUNCTION_TOKEN = (TOP_DIALOG_TOKEN+1);
Const BASE_BFUNC_TOKEN = BASE_FUNCTION_TOKEN;
Const BFTKN_APP_EXIT = (BASE_BFUNC_TOKEN + 0); {// BFTKN_APP_EXIT}
Const BFTKN_MAXIMIZE_WINDOW = (BASE_BFUNC_TOKEN + 1); {// BFTKN_MAXIMIZE_WINDOW}
Const BFTKN_REM_CONNECT = (BASE_BFUNC_TOKEN + 2); {// BFTKN_REM_CONNECT}
Const BFTKN_MACRO_STOP = (BASE_BFUNC_TOKEN + 4); {// BFTKN_MACRO_STOP}
Const BFTKN_PRINT = (BASE_BFUNC_TOKEN + 5); {// BFTKN_PRINT}
Const BFTKN_ARRANGE_QSIS = (BASE_BFUNC_TOKEN + 6); {// BFTKN_ARRANGE_QSIS - Obsolete}
Const BFTKN_SEND_STDMAIL = (BASE_BFUNC_TOKEN + 7); {// BFTKN_SEND_STDMAIL}
Const BFTKN_HELP_CONTENTS = (BASE_BFUNC_TOKEN + 8); {// BFTKN_HELP_CONTENTS}
Const BFTKN_HELP_KEYBOARD = (BASE_BFUNC_TOKEN + 9); {// BFTKN_HELP_KEYBOARD}
Const BFTKN_HELP_HOWDOI = (BASE_BFUNC_TOKEN + 10); {// BFTKN_HELP_HOWDOI}
Const BFTKN_HELP_SEARCH_FOR = (BASE_BFUNC_TOKEN + 11); {// BFTKN_HELP_SEARCH_FOR}
Const BFTKN_HELP_USINGHELP = (BASE_BFUNC_TOKEN + 12); {// BFTKN_HELP_USINGHELP}
Const BFTKN_HELP_WHATIS = (BASE_BFUNC_TOKEN + 13); {// BFTKN_HELP_WHATIS}
Const BFTKN_REFRESH = (BASE_BFUNC_TOKEN + 15); {// BFTKN_REFRESH}
Const BFTKN_BTNBAR_SHOW = (BASE_BFUNC_TOKEN + 16); {// BFTKN_BTNBAR_SHOW}
Const BFTKN_MACRO_INT_EXECUTE = (BASE_BFUNC_TOKEN + 17); {// BFTKN_MACRO_INT_EXECUTE}
Const BFTKN_MACRO_EXT_EXECUTE = (BASE_BFUNC_TOKEN + 18); {// BFTKN_MACRO_EXT_EXECUTE}
Const BFTKN_RETURN = (BASE_BFUNC_TOKEN + 19); {// BFTKN_RETURN}
Const BFTKN_SEND_STDTODO = (BASE_BFUNC_TOKEN + 20); {// BFTKN_SEND_STDTODO}
Const BFTKN_SEND_STDNOTE = (BASE_BFUNC_TOKEN + 21); {// BFTKN_SEND_STDNOTE}
Const BFTKN_SEND_STDAPPT = (BASE_BFUNC_TOKEN + 22); {// BFTKN_SEND_STDAPPT}
Const BFTKN_OPEN_TRASH = (BASE_BFUNC_TOKEN + 24); {// BFTKN_OPEN_TRASH}
Const BFTKN_HELP_LOCAL = (BASE_BFUNC_TOKEN + 25); {// BFTKN_HELP_LOCAL}
Const BFTKN_PAUSEMOVIE = (BASE_BFUNC_TOKEN + 26); {// BFTKN_PAUSEMOVIE}
Const BFTKN_RESTARTMOVIE = (BASE_BFUNC_TOKEN + 27); {// BFTKN_RESTARTMOVIE}
Const BFTKN_RESUMEMOVIE = (BASE_BFUNC_TOKEN + 28); {// BFTKN_RESUMEMOVIE}
Const BFTKN_OPEN_INBOX = (BASE_BFUNC_TOKEN + 29); {// BFTKN_OPEN_INBOX}
Const BFTKN_OPEN_OUTBOX = (BASE_BFUNC_TOKEN + 30); {// BFTKN_OPEN_OUTBOX}
Const BFTKN_UNDELETE = (BASE_BFUNC_TOKEN + 31); {// BFTKN_UNDELETE}
Const BFTKN_TOGGLE_ROUTING = (BASE_BFUNC_TOKEN + 32); {// BFTKN_TOGGLE_ROUTING}
Const BFTKN_COMPLETE_ITEM = (BASE_BFUNC_TOKEN + 33); {// BFTKN_COMPLETE_ITEM}
Const BFTKN_ACCEPT = (BASE_BFUNC_TOKEN + 34); {// BFTKN_ACCEPT}
Const BFTKN_REJECT = (BASE_BFUNC_TOKEN + 35); {// BFTKN_REJECT}
Const BFTKN_SEND_STDPHON = (BASE_BFUNC_TOKEN + 36); {// BFTKN_SEND_STDPHON}
Const BFTKN_HIDE_CAPTION = (BASE_BFUNC_TOKEN + 37); {// BFTKN_HIDE_CAPTION}
Const BFTKN_ON_TOP = (BASE_BFUNC_TOKEN + 38); {// BFTKN_ON_TOP}
Const BFTKN_MACRO_PAUSE = (BASE_BFUNC_TOKEN + 39); {// BFTKN_MACRO_PAUSE}
Const BFTKN_ALLWIN_CLOSE = (BASE_BFUNC_TOKEN + 40); {// BFTKN_ALLWIN_CLOSE}
Const BFTKN_ALLWIN_MINIMIZE = (BASE_BFUNC_TOKEN + 41); {// BFTKN_ALLWIN_MINIMIZE}
Const BFTKN_CANCEL = (BASE_BFUNC_TOKEN + 42); {// BFTKN_CANCEL}
Const BFTKN_HELP_MACROS = (BASE_BFUNC_TOKEN + 43); {// BFTKN_HELP_MACROS}
Const BFTKN_HELP_TUTORIAL = (BASE_BFUNC_TOKEN + 44); {// BFTKN_HELP_TUTORIAL}
Const BFTKN_SNAP_ARRANGE_QSIS = (BASE_BFUNC_TOKEN + 45); {// BFTKN_SNAP_ARRANGE_QSIS}
Const BFTKN_OPEN_CALENDAR = (BASE_BFUNC_TOKEN + 46); {// BFTKN_OPEN_CALENDAR}
Const BFTKN_EMPTY_TRASH = (BASE_BFUNC_TOKEN + 47); {// BFTKN_EMPTY_TRASH}
Const BFTKN_OLE_EMBEDD = (BASE_BFUNC_TOKEN + 48); {// BFTKN_OLE_EMBEDD}
Const BFTKN_DELETE_OPEN_ITEM = (BASE_BFUNC_TOKEN + 49); {// BFTKN_DELETE_OPEN_ITEM}
Const BFTKN_PASTELINK = (BASE_BFUNC_TOKEN + 50); {// BFTKN_PASTELINK}
Const BFTKN_BACKSPACE = (BASE_BFUNC_TOKEN + 51); {// BFTKN_BACKSPACE}
Const BFTKN_BEGLINE = (BASE_BFUNC_TOKEN + 52); {// BFTKN_BEGLINE}
Const BFTKN_BEGTEXT = (BASE_BFUNC_TOKEN + 53); {// BFTKN_BEGTEXT}
Const BFTKN_CUT = (BASE_BFUNC_TOKEN + 54); {// BFTKN_CUT}
Const BFTKN_COPY = (BASE_BFUNC_TOKEN + 55); {// BFTKN_COPY}
Const BFTKN_DELETE = (BASE_BFUNC_TOKEN + 56); {// BFTKN_DELETE}
Const BFTKN_DELETETOEND = (BASE_BFUNC_TOKEN + 57); {// BFTKN_DELETETOEND}
Const BFTKN_DELETEWORDLEFT = (BASE_BFUNC_TOKEN + 58); {// BFTKN_DELETEWORDLEFT}
Const BFTKN_DELETEWORDRIGHT = (BASE_BFUNC_TOKEN + 59); {// BFTKN_DELETEWORDRIGHT}
Const BFTKN_DOWNARROW = (BASE_BFUNC_TOKEN + 60); {// BFTKN_DOWNARROW}
Const BFTKN_ENDLINE = (BASE_BFUNC_TOKEN + 61); {// BFTKN_ENDLINE}
Const BFTKN_ENDTEXT = (BASE_BFUNC_TOKEN + 62); {// BFTKN_ENDTEXT}
Const BFTKN_LEFTARROW = (BASE_BFUNC_TOKEN + 63); {// BFTKN_LEFTARROW}
Const BFTKN_PAGEDOWN = (BASE_BFUNC_TOKEN + 64); {// BFTKN_PAGEDOWN}
Const BFTKN_PAGELEFT = (BASE_BFUNC_TOKEN + 65); {// BFTKN_PAGELEFT}
Const BFTKN_PAGERIGHT = (BASE_BFUNC_TOKEN + 66); {// BFTKN_PAGERIGHT}
Const BFTKN_PAGEUP = (BASE_BFUNC_TOKEN + 67); {// BFTKN_PAGEUP}
Const BFTKN_PASTE = (BASE_BFUNC_TOKEN + 68); {// BFTKN_PASTE}
Const BFTKN_RENAME = (BASE_BFUNC_TOKEN + 69); {// BFTKN_RENAME}
Const BFTKN_RIGHTARROW = (BASE_BFUNC_TOKEN + 70); {// BFTKN_RIGHTARROW}
Const BFTKN_SELECTBEGLINE = (BASE_BFUNC_TOKEN + 71); {// BFTKN_SELECTBEGLINE}
Const BFTKN_SELECTBEGTEXT = (BASE_BFUNC_TOKEN + 72); {// BFTKN_SELECTBEGTEXT}
Const BFTKN_SELECTENDLINE = (BASE_BFUNC_TOKEN + 73); {// BFTKN_SELECTENDLINE}
Const BFTKN_SELECTENDTEXT = (BASE_BFUNC_TOKEN + 74); {// BFTKN_SELECTENDTEXT}
Const BFTKN_SELECTDOWN = (BASE_BFUNC_TOKEN + 75); {// BFTKN_SELECTDOWN}
Const BFTKN_SELECTLEFT = (BASE_BFUNC_TOKEN + 76); {// BFTKN_SELECTLEFT}
Const BFTKN_SELECTLEFTWORD = (BASE_BFUNC_TOKEN + 77); {// BFTKN_SELECTLEFTWORD}
Const BFTKN_SELECTPAGEDOWN = (BASE_BFUNC_TOKEN + 78); {// BFTKN_SELECTPAGEDOWN}
Const BFTKN_SELECTPAGEUP = (BASE_BFUNC_TOKEN + 79); {// BFTKN_SELECTPAGEUP}
Const BFTKN_SELECTRIGHT = (BASE_BFUNC_TOKEN + 80); {// BFTKN_SELECTRIGHT}
Const BFTKN_SELECTRIGHTWORD = (BASE_BFUNC_TOKEN + 81); {// BFTKN_SELECTRIGHTWORD}
Const BFTKN_SELECTUP = (BASE_BFUNC_TOKEN + 82); {// BFTKN_SELECTUP}
Const BFTKN_INSERT = (BASE_BFUNC_TOKEN + 83); {// BFTKN_INSERT}
Const BFTKN_UPARROW = (BASE_BFUNC_TOKEN + 85); {// BFTKN_UPARROW}
Const BFTKN_WORDLEFT = (BASE_BFUNC_TOKEN + 86); {// BFTKN_WORDLEFT}
Const BFTKN_WORDRIGHT = (BASE_BFUNC_TOKEN + 87); {// BFTKN_WORDRIGHT}
Const BFTKN_BOLD = (BASE_BFUNC_TOKEN + 88); {// BFTKN_BOLD}
Const BFTKN_UNDERLINE = (BASE_BFUNC_TOKEN + 89); {// BFTKN_UNDERLINE}
Const BFTKN_ITALIC = (BASE_BFUNC_TOKEN + 90); {// BFTKN_ITALIC}
Const BFTKN_NORMAL = (BASE_BFUNC_TOKEN + 91); {// BFTKN_NORMAL}
Const BFTKN_SPELLER = (BASE_BFUNC_TOKEN + 92); {// BFTKN_SPELLER}
Const BFTKN_THES = (BASE_BFUNC_TOKEN + 93); {// BFTKN_THES}
Const BFTKN_VIEW_TAB = (BASE_BFUNC_TOKEN + 94); {// BFTKN_VIEW_TAB}
Const BFTKN_VIEW_SHIFTTAB = (BASE_BFUNC_TOKEN + 95); {// BFTKN_VIEW_SHIFTTAB}
Const BFTKN_CTRL_TAB = (BASE_BFUNC_TOKEN + 100); {// BFTKN_CTRL_TAB}
Const BFTKN_GRAMMATIK = (BASE_BFUNC_TOKEN + 101); {// BFTKN_GRAMMATIK}
Const BFTKN_VIEWBY_CAL = (BASE_BFUNC_TOKEN + 104); {// BFTKN_VIEWBY_CAL}
Const BFTKN_ATTACH_INFO = (BASE_BFUNC_TOKEN + 105); {// BFTKN_ATTACH_INFO}
Const BFTKN_SEND = (BASE_BFUNC_TOKEN + 106); {// BFTKN_SEND}
Const BFTKN_OPEN_ATTACH = (BASE_BFUNC_TOKEN + 107); {// BFTKN_OPEN_ATTACH}
Const BFTKN_MINIMIZE_WINDOW = (BASE_BFUNC_TOKEN + 108); {// BFTKN_MINIMIZE_WINDOW}
Const BFTKN_RESTORE_WINDOW = (BASE_BFUNC_TOKEN + 109); {// BFTKN_RESTORE_WINDOW}
Const BFTKN_SELECT = (BASE_BFUNC_TOKEN + 110); {// BFTKN_SELECT}
Const BFTKN_REPLY = (BASE_BFUNC_TOKEN + 111); {// BFTKN_REPLY}
Const BFTKN_READ = (BASE_BFUNC_TOKEN + 112); {// BFTKN_READ}
Const BFTKN_INFO = (BASE_BFUNC_TOKEN + 113); {// BFTKN_INFO}
Const BFTKN_FORWARD = (BASE_BFUNC_TOKEN + 114); {// BFTKN_FORWARD}
Const BFTKN_RESEND = (BASE_BFUNC_TOKEN + 115); {// BFTKN_RESEND}
Const BFTKN_COLUMN_ADD = (BASE_BFUNC_TOKEN + 116); {// BFTKN_COLUMN_ADD}
Const BFTKN_COLUMN_DELETE = (BASE_BFUNC_TOKEN + 117); {// BFTKN_COLUMN_DELETE}
Const BFTKN_MNEMONIC_DISPLAY = (BASE_BFUNC_TOKEN + 118); {// BFTKN_MNEMONIC_DISPLAY}
Const BFTKN_STARTDATE = (BASE_BFUNC_TOKEN + 119); {// BFTKN_STARTDATE}
Const BFTKN_AUTODATE = (BASE_BFUNC_TOKEN + 120); {// BFTKN_AUTODATE}
Const BFTKN_ENDDATE = (BASE_BFUNC_TOKEN + 121); {// BFTKN_ENDDATE}
Const BFTKN_DURATION = (BASE_BFUNC_TOKEN + 122); {// BFTKN_DURATION}
Const BFTKN_NEXT_PANE = (BASE_BFUNC_TOKEN + 123); {// BFTKN_NEXT_PANE}
Const BFTKN_PREV_PANE = (BASE_BFUNC_TOKEN + 124); {// BFTKN_PREV_PANE}
Const BFTKN_AUTO_ARRANGE_QSIS = (BASE_BFUNC_TOKEN + 125); {// BFTKN_AUTO_ARRANGE_QSIS}
Const BFTKN_AUTO_SNAP_ARRANGE_QSIS = (BASE_BFUNC_TOKEN + 126); {// BFTKN_AUTO_SNAP_ARRANGE_QSIS}
Const BFTKN_SCROLL_LEFT = (BASE_BFUNC_TOKEN + 127); {// BFTKN_SCROLL_LEFT}
Const BFTKN_SCROLL_RIGHT = (BASE_BFUNC_TOKEN + 128); {// BFTKN_SCROLL_RIGHT}
Const BFTKN_SCROLL_NEXT = (BASE_BFUNC_TOKEN + 129); {// BFTKN_SCROLL_NEXT}
Const BFTKN_SCROLL_PRIOR = (BASE_BFUNC_TOKEN + 130); {// BFTKN_SCROLL_PRIOR}
Const BFTKN_PURGE = (BASE_BFUNC_TOKEN + 131); {// BFTKN_PURGE}
Const BFTKN_CLOSE_WINDOW = (BASE_BFUNC_TOKEN + 132); {// BFTKN_CLOSE_WINDOW}
Const BFTKN_ARCHIVE = (BASE_BFUNC_TOKEN + 133); {// BFTKN_ARCHIVE}
Const BFTKN_CONVERT_TOSTATIC = (BASE_BFUNC_TOKEN + 134); {// BFTKN_CONVERT_TOSTATIC}
Const BFTKN_FOLDER_EXPAND = (BASE_BFUNC_TOKEN + 135); {// BFTKN_FOLDER_EXPAND}
Const BFTKN_FOLDER_EXPANDEX = (BASE_BFUNC_TOKEN + 136); {// BFTKN_FOLDER_EXPANDEX}
Const BFTKN_FOLDER_CONTRACT = (BASE_BFUNC_TOKEN + 137); {// BFTKN_FOLDER_CONTRACT}
Const BFTKN_FOLDER_CONTRACTEX = (BASE_BFUNC_TOKEN + 138); {// BFTKN_FOLDER_CONTRACTEX}
Const BFTKN_FOLDER_EXPAND_ALL = (BASE_BFUNC_TOKEN + 139); {// BFTKN_FOLDER_EXPAND_ALL}
Const BFTKN_CLOSE_MAINWND = (BASE_BFUNC_TOKEN + 140); {// BFTKN_CLOSE_MAINWND}
Const BFTKN_OPEN_MAINWND = (BASE_BFUNC_TOKEN + 141); {// BFTKN_OPEN_MAINWND}
Const BFTKN_VERB1 = (BASE_BFUNC_TOKEN + 142); {// BFTKN_VERB1}
Const BFTKN_VERB2 = (BASE_BFUNC_TOKEN + 143); {// BFTKN_VERB2}
Const BFTKN_VERB3 = (BASE_BFUNC_TOKEN + 144); {// BFTKN_VERB3}
Const BFTKN_VERB4 = (BASE_BFUNC_TOKEN + 145); {// BFTKN_VERB4}
Const BFTKN_VERB5 = (BASE_BFUNC_TOKEN + 146); {// BFTKN_VERB5}
Const BFTKN_VERB6 = (BASE_BFUNC_TOKEN + 147); {// BFTKN_VERB6}
Const BFTKN_VERB7 = (BASE_BFUNC_TOKEN + 148); {// BFTKN_VERB7}
Const BFTKN_VERB8 = (BASE_BFUNC_TOKEN + 149); {// BFTKN_VERB8}
Const BFTKN_VERB9 = (BASE_BFUNC_TOKEN + 150); {// BFTKN_VERB9}
Const BFTKN_VERB10 = (BASE_BFUNC_TOKEN + 151); {// BFTKN_VERB10}
Const BFTKN_VERB_PRIMARY = (BASE_BFUNC_TOKEN + 152); {// BFTKN_VERB_PRIMARY}
Const BFTKN_DB_TOGGLE = (BASE_BFUNC_TOKEN + 153); {// BFTKN_DB_TOGGLE}
Const BFTKN_CHANGE_TO_ARCHIVEDB = (BASE_BFUNC_TOKEN + 154); {// BFTKN_CHANGE_TO_ARCHIVEDB}
Const BFTKN_CHANGE_TO_USERDB = (BASE_BFUNC_TOKEN + 155); {// BFTKN_CHANGE_TO_USERDB}
Const BFTKN_SEARCH_NEXT = (BASE_BFUNC_TOKEN + 156); {// BFTKN_SEARCH_NEXT}
Const BFTKN_SEARCH_PREV = (BASE_BFUNC_TOKEN + 157); {// BFTKN_SEARCH_PREV}
Const BFTKN_INFO_UPDATE = (BASE_BFUNC_TOKEN + 158); {// BFTKN_INFO_UPDATE}
Const BFTKN_SCULPTURE = (BASE_BFUNC_TOKEN + 159); {// BFTKN_SCULPTURE}
Const BFTKN_SYS_COLORS = (BASE_BFUNC_TOKEN + 160); {// BFTKN_SYS_COLORS}
Const BFTKN_ATTACH_PASTE = (BASE_BFUNC_TOKEN + 161); {// BFTKN_ATTACH_PASTE}
Const BFTKN_ATTACH_PASTELINK = (BASE_BFUNC_TOKEN + 162); {// BFTKN_ATTACH_PASTELINK}
Const BFTKN_DELETE_ATTACH = (BASE_BFUNC_TOKEN + 163); {// BFTKN_DELETE_ATTACH}
Const BFTKN_READ_NEXT = (BASE_BFUNC_TOKEN + 164); {// BFTKN_READ_NEXT}
Const BFTKN_READ_PREV = (BASE_BFUNC_TOKEN + 165); {// BFTKN_READ_PREV}
Const BFTKN_MARK_PRIVATE = (BASE_BFUNC_TOKEN + 176); {// BFTKN_MARK_PRIVATE}
Const BFTKN_GOTO_DATE = (BASE_BFUNC_TOKEN + 177); {// BFTKN_GOTO_DATE}
Const BFTKN_LVS_LARGE_ICON = (BASE_BFUNC_TOKEN + 178); {// BFTKN_LVS_LARGE_ICON}
Const BFTKN_LVS_SMALL_ICON = (BASE_BFUNC_TOKEN + 179); {// BFTKN_LVS_SMALL_ICON}
Const BFTKN_LVS_LIST = (BASE_BFUNC_TOKEN + 180); {// BFTKN_LVS_LIST}
Const BFTKN_LVS_DETAILS = (BASE_BFUNC_TOKEN + 181); {// BFTKN_LVS_DETAILS}
Const BFTKN_PWR_MY_CALENDAR = (BASE_BFUNC_TOKEN + 182); {// BFTKN_PWR_MY_CALENDAR}
Const BFTKN_PWR_SEND_MAIL = (BASE_BFUNC_TOKEN + 183); {// BFTKN_PWR_SEND_MAIL}
Const BFTKN_PWR_SCHEDULE = (BASE_BFUNC_TOKEN + 184); {// BFTKN_PWR_SCHEDULE}
Const BFTKN_PWR_ASSIGN_TASK = (BASE_BFUNC_TOKEN + 185); {// BFTKN_PWR_ASSIGN_TASK}
Const BFTKN_PWR_WRITE_NOTE = (BASE_BFUNC_TOKEN + 186); {// BFTKN_PWR_WRITE_NOTE}
Const BFTKN_PWR_PHONE_MESSAGE = (BASE_BFUNC_TOKEN + 187); {// BFTKN_PWR_PHONE_MESSAGE}
Const BFTKN_DM_ENDRETRIEVE = (BASE_BFUNC_TOKEN + 188); {// BFTKN_DM_ENDRETRIEVE}
Const BFTKN_VIEWBY_PROJECT_CAL = (BASE_BFUNC_TOKEN + 189); {// BFTKN_VIEWBY_PROJECT_CAL}
Const BFTKN_DM_VERSION_LIST = (BASE_BFUNC_TOKEN + 190); {// BFTKN_DM_VERSION_LIST}
Const BFTKN_DM_DELETE = (BASE_BFUNC_TOKEN + 191); {// BFTKN_DM_DELETE}
Const BFTKN_READ_LATER = (BASE_BFUNC_TOKEN + 192); {// BFTKN_READ_LATER}
Const BFTKN_LVS_MSG_THREAD = (BASE_BFUNC_TOKEN + 194); {// BFTKN_LVS_MSG_THREAD}
Const BFTKN_FILTER_CLEAR = (BASE_BFUNC_TOKEN + 195); {// BFTKN_FILTER_CLEAR}
Const BFTKN_PARENT = (BASE_BFUNC_TOKEN + 196); {// BFTKN_PARENT}
Const BFTKN_DROP_DEL_FOLDERSANDITEMS = (BASE_BFUNC_TOKEN + 197); {// BFTKN_DROP_DEL_FOLDERSANDITEMS}
Const BFTKN_SPLIT_BAR = (BASE_BFUNC_TOKEN + 198); {// BFTKN_SPLIT_BAR}
Const BFTKN_SEND_COPY = (BASE_BFUNC_TOKEN + 199); {// BFTKN_SEND_COPY}
Const BFTKN_VIEW_ATTACH = (BASE_BFUNC_TOKEN + 200); {// BFTKN_VIEW_ATTACH}
Const BFTKN_MAYBE_VIEW_ATTACH = (BASE_BFUNC_TOKEN + 201); {// BFTKN_MAYBE_VIEW_ATTACH}
Const BFTKN_TEXTENTRY_DELETE_CURWORD = (BASE_BFUNC_TOKEN + 202); {// BFTKN_TEXTENTRY_DELETE_CURWORD}
Const BFTKN_SELECT_FOLDERS = (BASE_BFUNC_TOKEN + 203); {// BFTKN_SELECT_FOLDERS}
Const BFTKN_SET_STATE = (BASE_BFUNC_TOKEN + 204); {// BFTKN_SET_STATE}
Const BFTKN_DROP_INTO_FOLDER = (BASE_BFUNC_TOKEN + 205); {// BFTKN_DROP_INTO_FOLDER}
Const BFTKN_DROP_ABOVE_FOLDER = (BASE_BFUNC_TOKEN + 206); {// BFTKN_DROP_ABOVE_FOLDER}
Const BFTKN_DROP_BELOW_FOLDER = (BASE_BFUNC_TOKEN + 207); {// BFTKN_DROP_BELOW_FOLDER}
Const BFTKN_WPCHAR_BOX = (BASE_BFUNC_TOKEN + 208); {// BFTKN_WPCHAR_BOX}
Const BFTKN_PLUS = (BASE_BFUNC_TOKEN + 210); {// BFTKN_PLUS}
Const BFTKN_CONTROL_PLUS = (BASE_BFUNC_TOKEN + 211); {// BFTKN_CONTROL_PLUS}
Const BFTKN_MINUS = (BASE_BFUNC_TOKEN + 212); {// BFTKN_MINUS}
Const BFTKN_CONTROL_MINUS = (BASE_BFUNC_TOKEN + 213); {// BFTKN_CONTROL_MINUS}
Const BFTKN_SET_PROMPT = (BASE_BFUNC_TOKEN + 214); {// BFTKN_SET_PROMPT}
Const BFTKN_DROP_CANCEL = (BASE_BFUNC_TOKEN + 215); {// BFTKN_DROP_CANCEL}
Const BFTKN_SELECT_ALL = (BASE_BFUNC_TOKEN + 216); {// BFTKN_SELECT_ALL}
Const BFTKN_IMEOFF = (BASE_BFUNC_TOKEN + 217); {// BFTKN_IMEOFF}
Const BFTKN_IMEON = (BASE_BFUNC_TOKEN + 218); {// BFTKN_IMEON}
Const BFTKN_TANGO_TOROKU = (BASE_BFUNC_TOKEN + 219); {// BFTKN_TANGO_TOROKU}
Const BFTKN_INBOX_FLT = (BASE_BFUNC_TOKEN + 220); {// BFTKN_INBOX_FLT}
Const BFTKN_REM_VIEWCONNECTIONLOG = (BASE_BFUNC_TOKEN + 221); {// BFTKN_REM_VIEWCONNECTIONLOG}
Const BFTKN_REM_DISCONNECT = (BASE_BFUNC_TOKEN + 222); {// BFTKN_REM_DISCONNECT}
Const BFTKN_OUTBOX_FLT = (BASE_BFUNC_TOKEN + 223); {// BFTKN_OUTBOX_FLT}
Const BFTKN_PERS_FLT = (BASE_BFUNC_TOKEN + 224); {// BFTKN_PERS_FLT}
Const BFTKN_DB_QSTNAME = (BASE_BFUNC_TOKEN + 225); {// BFTKN_DB_QSTNAME}
Const BFTKN_NULL_TOKEN = (BASE_BFUNC_TOKEN + 226); {// BFTKN_NULL_TOKEN}
Const BFTKN_DB_ENGCALLS = (BASE_BFUNC_TOKEN + 227); {// BFTKN_DB_ENGCALLS}
Const BFTKN_NEW_BROWSER = (BASE_BFUNC_TOKEN + 243); {// BFTKN_NEW_BROWSER}
Const BFTKN_DROP_DEL_ITEMS = (BASE_BFUNC_TOKEN + 244); {// BFTKN_DROP_DEL_ITEMS}
Const BFTKN_DROP_UNDEL_ITEMS = (BASE_BFUNC_TOKEN + 245); {// BFTKN_DROP_UNDEL_ITEMS}
Const BFTKN_DROP_DEL_ITEMSONLY = (BASE_BFUNC_TOKEN + 246); {// BFTKN_DROP_DEL_ITEMSONLY}
Const BFTKN_SHOW_LOOKER = (BASE_BFUNC_TOKEN + 247); {// BFTKN_SHOW_LOOKER}
Const BFTKN_SHOW_FOLDERS = (BASE_BFUNC_TOKEN + 248); {// BFTKN_SHOW_FOLDERS}
Const BFTKN_DM_VIEW = (BASE_BFUNC_TOKEN + 249); {// BFTKN_DM_VIEW}
Const BFTKN_DRAFT_FLT = (BASE_BFUNC_TOKEN + 250); {// BFTKN_DRAFT_FLT}
Const BFTKN_UNASSIGNED_343 = (BASE_BFUNC_TOKEN + 343);
Const TOP_BFUNC_TOKEN = BFTKN_UNASSIGNED_343;
Const BFUNC_TOKEN_COUNT = (TOP_BFUNC_TOKEN - BASE_BFUNC_TOKEN + 1);
Const BASE_OLE_TOKEN = (TOP_BFUNC_TOKEN + 1);
Const OLETKN_UNASSIGNED_49 = (BASE_OLE_TOKEN + 49);
Const TOP_OLE_TOKEN = OLETKN_UNASSIGNED_49;
Const OLE_TOKEN_COUNT = (TOP_OLE_TOKEN - BASE_OLE_TOKEN + 1);
Const BASE_AFUNC_TOKEN = (TOP_OLE_TOKEN + 1);
Const AFTKN_OPEN_VIEW_TYPE = (BASE_AFUNC_TOKEN + 0); {// AFTKN_OPEN_VIEW_TYPE}
Const AFTKN_OPEN_NAMED_QSI = (BASE_AFUNC_TOKEN + 1); {// AFTKN_OPEN_NAMED_QSI - Obsolete}
Const AFTKN_GOTO_DATE_ABS = (BASE_AFUNC_TOKEN + 2); {// AFTKN_GOTO_DATE_ABS}
Const AFTKN_DELETE_SHELF_ICON = (BASE_AFUNC_TOKEN + 3); {// AFTKN_DELETE_SHELF_ICON - Obsolete}
Const AFTKN_IMPORT_OLDCAL = (BASE_AFUNC_TOKEN + 4); {// AFTKN_IMPORT_OLDCAL - Obsolete}
Const AFTKN_BTNBAR_OPTIONS = (BASE_AFUNC_TOKEN + 5); {// AFTKN_BTNBAR_OPTIONS}
Const AFTKN_BTNBAR_SAVE = (BASE_AFUNC_TOKEN + 6); {// AFTKN_BTNBAR_SAVE}
Const AFTKN_BTNBAR_SELECT = (BASE_AFUNC_TOKEN + 7); {// AFTKN_BTNBAR_SELECT}
Const AFTKN_CREATE_FOLDER = (BASE_AFUNC_TOKEN + 8); {// AFTKN_CREATE_FOLDER}
Const AFTKN_SETUP = (BASE_AFUNC_TOKEN + 9); {// AFTKN_SETUP}
Const AFTKN_DELETE_FOLDER = (BASE_AFUNC_TOKEN + 10); {// AFTKN_DELETE_FOLDER}
Const AFTKN_RENAME_FOLDER = (BASE_AFUNC_TOKEN + 11); {// AFTKN_RENAME_FOLDER}
Const AFTKN_SET_TOTEXT = (BASE_AFUNC_TOKEN + 12); {// AFTKN_SET_TOTEXT}
Const AFTKN_SET_FROMTEXT = (BASE_AFUNC_TOKEN + 13); {// AFTKN_SET_FROMTEXT}
Const AFTKN_SET_CCTEXT = (BASE_AFUNC_TOKEN + 14); {// AFTKN_SET_CCTEXT}
Const AFTKN_SET_BCTEXT = (BASE_AFUNC_TOKEN + 15); {// AFTKN_SET_BCTEXT}
Const AFTKN_SET_SUBJTEXT = (BASE_AFUNC_TOKEN + 16); {// AFTKN_SET_SUBJTEXT}
Const AFTKN_SET_MSGTEXT = (BASE_AFUNC_TOKEN + 17); {// AFTKN_SET_MSGTEXT}
Const AFTKN_ADD_ATTACHMENT = (BASE_AFUNC_TOKEN + 18); {// AFTKN_ADD_ATTACHMENT}
Const AFTKN_SET_AUTHORITYTEXT = (BASE_AFUNC_TOKEN + 19); {// AFTKN_SET_AUTHORITYTEXT}
Const AFTKN_SET_PLACETEXT = (BASE_AFUNC_TOKEN + 20); {// AFTKN_SET_PLACETEXT}
Const AFTKN_SET_NAMETEXT = (BASE_AFUNC_TOKEN + 21); {// AFTKN_SET_NAMETEXT}
Const AFTKN_SET_COMPANYTEXT = (BASE_AFUNC_TOKEN + 22); {// AFTKN_SET_COMPANYTEXT}
Const AFTKN_SET_PHONETEXT = (BASE_AFUNC_TOKEN + 23); {// AFTKN_SET_PHONETEXT}
Const AFTKN_SEND_MESSAGE = (BASE_AFUNC_TOKEN + 24); {// AFTKN_SEND_MESSAGE}
Const AFTKN_SEND_NOTE = (BASE_AFUNC_TOKEN + 25); {// AFTKN_SEND_NOTE}
Const AFTKN_SEND_TODO = (BASE_AFUNC_TOKEN + 26); {// AFTKN_SEND_TODO}
Const AFTKN_SEND_APPT = (BASE_AFUNC_TOKEN + 27); {// AFTKN_SEND_APPT}
Const AFTKN_WRITE_FILE = (BASE_AFUNC_TOKEN + 28); {// AFTKN_WRITE_FILE}
Const AFTKN_SET_FONT = (BASE_AFUNC_TOKEN + 29); {// AFTKN_SET_FONT}
Const AFTKN_SET_DATETIMEDUR = (BASE_AFUNC_TOKEN + 30); {// AFTKN_SET_DATETIMEDUR}
Const AFTKN_PARSE_DATE = (BASE_AFUNC_TOKEN + 31); {// AFTKN_PARSE_DATE}
Const AFTKN_FILTER_FROM_FILE = (BASE_AFUNC_TOKEN + 32); {// AFTKN_FILTER_FROM_FILE}
Const AFTKN_OPEN_VIEW_NAMED = (BASE_AFUNC_TOKEN + 33); {// AFTKN_OPEN_VIEW_NAMED}
Const AFTKN_OPEN_VIEW_FILE = (BASE_AFUNC_TOKEN + 34); {// AFTKN_OPEN_VIEW_FILE}
Const AFTKN_SET_CAT_PRIOR = (BASE_AFUNC_TOKEN + 36); {// AFTKN_SET_CAT_PRIOR}
Const AFTKN_SAVE_AS = (BASE_AFUNC_TOKEN + 37); {// AFTKN_SAVE_AS}
Const AFTKN_GET_MAILDATA = (BASE_AFUNC_TOKEN + 38); {// AFTKN_GET_MAILDATA}
Const AFTKN_READ_FILE = (BASE_AFUNC_TOKEN + 39); {// AFTKN_READ_FILE}
Const AFTKN_SET_ADV = (BASE_AFUNC_TOKEN + 40); {// AFTKN_SET_ADV}
Const AFTKN_SET_ALARM = (BASE_AFUNC_TOKEN + 41); {// AFTKN_SET_ALARM}
Const AFTKN_SET_MESSAGE = (BASE_AFUNC_TOKEN + 42); {// AFTKN_SET_MESSAGE}
Const AFTKN_SET_APPT = (BASE_AFUNC_TOKEN + 43); {// AFTKN_SET_APPT}
Const AFTKN_SET_NOTE = (BASE_AFUNC_TOKEN + 44); {// AFTKN_SET_NOTE}
Const AFTKN_SET_TODO = (BASE_AFUNC_TOKEN + 45); {// AFTKN_SET_TODO}
Const AFTKN_SET_FOLDER = (BASE_AFUNC_TOKEN + 46); {// AFTKN_SET_FOLDER}
Const AFTKN_TYPE = (BASE_AFUNC_TOKEN + 48); {// AFTKN_TYPE}
Const AFTKN_TYPE_CHAR = (BASE_AFUNC_TOKEN + 49); {// AFTKN_TYPE_CHAR}
Const AFTKN_SEND_PHONE = (BASE_AFUNC_TOKEN + 50); {// AFTKN_SEND_PHONE}
Const AFTKN_GET_ABDATA = (BASE_AFUNC_TOKEN + 52); {// AFTKN_GET_ABDATA}
Const AFTKN_DELEGATE = (BASE_AFUNC_TOKEN + 53); {// AFTKN_DELEGATE}
Const AFTKN_SET_VEW = (BASE_AFUNC_TOKEN + 54); {// AFTKN_SET_VEW}
Const AFTKN_PRINT_CAL = (BASE_AFUNC_TOKEN + 55); {// AFTKN_PRINT_CAL}
Const AFTKN_USER_FUNCTION = (BASE_AFUNC_TOKEN + 56); {// AFTKN_USER_FUNCTION}
Const AFTKN_SET_ENV = (BASE_AFUNC_TOKEN + 57); {// AFTKN_SET_ENV}
Const AFTKN_MACRO_BTN = (BASE_AFUNC_TOKEN + 58); {// AFTKN_MACRO_BTN}
Const AFTKN_SET_DTM = (BASE_AFUNC_TOKEN + 59); {// AFTKN_SET_DTM}
Const AFTKN_DATE_PARSE_MONTH = (BASE_AFUNC_TOKEN + 60); {// AFTKN_DATE_PARSE_MONTH}
Const AFTKN_SET_SCH = (BASE_AFUNC_TOKEN + 61); {// AFTKN_SET_SCH}
Const AFTKN_SET_LOC = (BASE_AFUNC_TOKEN + 62); {// AFTKN_SET_LOC}
Const AFTKN_SETFOCUS = (BASE_AFUNC_TOKEN + 63); {// AFTKN_SETFOCUS}
Const AFTKN_INSERT_OBJECT = (BASE_AFUNC_TOKEN + 65); {// AFTKN_INSERT_OBJECT}
Const AFTKN_DOVERB = (BASE_AFUNC_TOKEN + 66); {// AFTKN_DOVERB}
Const AFTKN_MOVETO_FOLDER = (BASE_AFUNC_TOKEN + 67); {// AFTKN_MOVETO_FOLDER}
Const AFTKN_LINKTO_FOLDER = (BASE_AFUNC_TOKEN + 68); {// AFTKN_LINKTO_FOLDER}
Const AFTKN_ALTMOVETO_FOLDER = (BASE_AFUNC_TOKEN + 69); {// AFTKN_ALTMOVETO_FOLDER}
Const AFTKN_CHANGE_USER = (BASE_AFUNC_TOKEN + 70); {// AFTKN_CHANGE_USER}
Const AFTKN_DATE_PARSE_YEAR = (BASE_AFUNC_TOKEN + 71); {// AFTKN_DATE_PARSE_YEAR}
Const AFTKN_ADD_FOLDER_SELECTIONS = (BASE_AFUNC_TOKEN + 72); {// AFTKN_ADD_FOLDER_SELECTIONS - Obsolete}
Const AFTKN_SEARCH = (BASE_AFUNC_TOKEN + 73); {// AFTKN_SEARCH}
Const AFTKN_ATTACH_INSERT_OBJECT = (BASE_AFUNC_TOKEN + 74); {// AFTKN_ATTACH_INSERT_OBJECT}
Const AFTKN_CHANGE_VIEW = (BASE_AFUNC_TOKEN + 75); {// AFTKN_CHANGE_VIEW}
Const AFTKN_EXECUTE_RULE = (BASE_AFUNC_TOKEN + 76); {// AFTKN_EXECUTE_RULE}
Const AFTKN_SET_DSC = (BASE_AFUNC_TOKEN + 77); {// AFTKN_SET_DSC}
Const AFTKN_WIND_OPEN = (BASE_AFUNC_TOKEN + 78); {// AFTKN_WIND_OPEN}
Const AFTKN_SET_DEF_VIEW = (BASE_AFUNC_TOKEN + 79); {// AFTKN_SET_DEF_VIEW}
Const AFTKN_DATE_PARSE_DAY_OF_WEEK = (BASE_AFUNC_TOKEN + 80); {// AFTKN_DATE_PARSE_DAY_OF_WEEK}
Const AFTKN_BUSYSRCH = (BASE_AFUNC_TOKEN + 81); {// AFTKN_BUSYSRCH}
Const AFTKN_SEND_OPTIONS = (BASE_AFUNC_TOKEN + 82); {// AFTKN_SEND_OPTIONS}
Const AFTKN_DDE_QUERY_LAST_ERROR = (BASE_AFUNC_TOKEN + 83); {// AFTKN_DDE_QUERY_LAST_ERROR}
Const AFTKN_RULE_CREATE = (BASE_AFUNC_TOKEN + 84); {// AFTKN_RULE_CREATE}
Const AFTKN_RULE_DELETE = (BASE_AFUNC_TOKEN + 85); {// AFTKN_RULE_DELETE}
Const AFTKN_SENDOPT_ADV = (BASE_AFUNC_TOKEN + 86); {// AFTKN_SENDOPT_ADV}
Const AFTKN_SET_CHECKSTATE = (BASE_AFUNC_TOKEN + 87); {// AFTKN_SET_CHECKSTATE}
Const AFTKN_SET_ENUMVAL = (BASE_AFUNC_TOKEN + 88); {// AFTKN_SET_ENUMVAL}
Const AFTKN_RETRIEVE = (BASE_AFUNC_TOKEN + 89); {// AFTKN_RETRIEVE}
Const AFTKN_RULE_ACT_ACCEPT = (BASE_AFUNC_TOKEN + 90); {// AFTKN_RULE_ACT_ACCEPT}
Const AFTKN_RULE_ACT_DECLINE = (BASE_AFUNC_TOKEN + 91); {// AFTKN_RULE_ACT_DECLINE}
Const AFTKN_RULE_ACT_DELEGATE = (BASE_AFUNC_TOKEN + 92); {// AFTKN_RULE_ACT_DELEGATE}
Const AFTKN_RULE_ACT_EMPTYITEM = (BASE_AFUNC_TOKEN + 93); {// AFTKN_RULE_ACT_EMPTYITEM}
Const AFTKN_RULE_ACT_FORWARD = (BASE_AFUNC_TOKEN + 94); {// AFTKN_RULE_ACT_FORWARD}
Const AFTKN_RULE_ACT_LINKTOFOLDER = (BASE_AFUNC_TOKEN + 95); {// AFTKN_RULE_ACT_LINKTOFOLDER}
Const AFTKN_RULE_ACT_MARKPRIVATE = (BASE_AFUNC_TOKEN + 96); {// AFTKN_RULE_ACT_MARKPRIVATE}
Const AFTKN_RULE_ACT_MOVETOFOLDER = (BASE_AFUNC_TOKEN + 97); {// AFTKN_RULE_ACT_MOVETOFOLDER}
Const AFTKN_RULE_ACT_REPLY = (BASE_AFUNC_TOKEN + 98); {// AFTKN_RULE_ACT_REPLY}
Const AFTKN_RULE_ACT_SENDMAIL = (BASE_AFUNC_TOKEN + 99); {// AFTKN_RULE_ACT_SENDMAIL}
Const AFTKN_REM_SETPREFS = (BASE_AFUNC_TOKEN + 100); {// AFTKN_REM_SETPREFS}
Const AFTKN_ITEM_SET_ALARM = (BASE_AFUNC_TOKEN + 101); {// AFTKN_ITEM_SET_ALARM}
Const AFTKN_TEXTENTRY_LINE_CHARCOUNT = (BASE_AFUNC_TOKEN + 102); {// AFTKN_TEXTENTRY_LINE_CHARCOUNT}
Const AFTKN_TEXTENTRY_GET_LINE_COUNT = (BASE_AFUNC_TOKEN + 103); {// AFTKN_TEXTENTRY_GET_LINE_COUNT}
Const AFTKN_TEXTENTRY_GET_LINE_INDEX = (BASE_AFUNC_TOKEN + 104); {// AFTKN_TEXTENTRY_GET_LINE_INDEX}
Const AFTKN_TEXTENTRY_GET_CHAR_INDEX = (BASE_AFUNC_TOKEN + 105); {// AFTKN_TEXTENTRY_GET_CHAR_INDEX}
Const AFTKN_TEXTENTRY_GET_CURWORD = (BASE_AFUNC_TOKEN + 106); {// AFTKN_TEXTENTRY_GET_CURWORD}
Const AFTKN_TEXTENTRY_GET_LEFTCHAR = (BASE_AFUNC_TOKEN + 107); {// AFTKN_TEXTENTRY_GET_LEFTCHAR}
Const AFTKN_CURRENT_WINDOW = (BASE_AFUNC_TOKEN + 108); {// AFTKN_CURRENT_WINDOW}
Const AFTKN_ITEM_ANNOTATION_SAVE_AS = (BASE_AFUNC_TOKEN + 109); {// AFTKN_ITEM_ANNOTATION_SAVE_AS}
Const AFTKN_ITEM_ANNOTATION_COUNT = (BASE_AFUNC_TOKEN + 110); {// AFTKN_ITEM_ANNOTATION_COUNT}
Const AFTKN_ITEM_ATTACHMENT_ADD = (BASE_AFUNC_TOKEN + 111); {// AFTKN_ITEM_ATTACHMENT_ADD}
Const AFTKN_ITEM_ATTACHMENT_DELETE = (BASE_AFUNC_TOKEN + 112); {// AFTKN_ITEM_ATTACHMENT_DELETE}
Const AFTKN_ITEM_ATTACHMENT_COUNT = (BASE_AFUNC_TOKEN + 113); {// AFTKN_ITEM_ATTACHMENT_COUNT}
Const AFTKN_ITEM_ATTACHMENT_DISP_NAME = (BASE_AFUNC_TOKEN + 114); {// AFTKN_ITEM_ATTACHMENT_DISP_NAME}
Const AFTKN_ITEM_ATTACHMENT_NAME = (BASE_AFUNC_TOKEN + 115); {// AFTKN_ITEM_ATTACHMENT_NAME}
Const AFTKN_ITEM_ATTACHMENT_CLASS = (BASE_AFUNC_TOKEN + 116); {// AFTKN_ITEM_ATTACHMENT_CLASS}
Const AFTKN_ITEM_ATTACHMENT_SAVE_AS = (BASE_AFUNC_TOKEN + 117); {// AFTKN_ITEM_ATTACHMENT_SAVE_AS}
Const AFTKN_ITEM_MSGID_FROM_VIEW = (BASE_AFUNC_TOKEN + 118); {// AFTKN_ITEM_MSGID_FROM_VIEW}
Const AFTKN_ITEM_GET_ATTRIBUTE = (BASE_AFUNC_TOKEN + 119); {// AFTKN_ITEM_GET_ATTRIBUTE}
Const AFTKN_ITEM_GET_DATE = (BASE_AFUNC_TOKEN + 120); {// AFTKN_ITEM_GET_DATE}
Const AFTKN_ITEM_GET_PRIORITY = (BASE_AFUNC_TOKEN + 121); {// AFTKN_ITEM_GET_PRIORITY}
Const AFTKN_ITEM_GET_SENDERID = (BASE_AFUNC_TOKEN + 122); {// AFTKN_ITEM_GET_SENDERID}
Const AFTKN_ITEM_GET_SOURCE = (BASE_AFUNC_TOKEN + 123); {// AFTKN_ITEM_GET_SOURCE}
Const AFTKN_ITEM_GET_TEXT = (BASE_AFUNC_TOKEN + 124); {// AFTKN_ITEM_GET_TEXT}
Const AFTKN_ITEM_GET_TYPE = (BASE_AFUNC_TOKEN + 125); {// AFTKN_ITEM_GET_TYPE}
Const AFTKN_ITEM_INFO_SAVE = (BASE_AFUNC_TOKEN + 126); {// AFTKN_ITEM_INFO_SAVE}
Const AFTKN_ITEM_MSGID_ISVALID = (BASE_AFUNC_TOKEN + 127); {// AFTKN_ITEM_MSGID_ISVALID}
Const AFTKN_ITEM_OPEN = (BASE_AFUNC_TOKEN + 128); {// AFTKN_ITEM_OPEN}
Const AFTKN_ITEM_SAVE_MESSAGE = (BASE_AFUNC_TOKEN + 129); {// AFTKN_ITEM_SAVE_MESSAGE}
Const AFTKN_ITEM_SAVE_VIEW = (BASE_AFUNC_TOKEN + 130); {// AFTKN_ITEM_SAVE_VIEW}
Const AFTKN_ITEM_SET_ATTRIBUTE = (BASE_AFUNC_TOKEN + 131); {// AFTKN_ITEM_SET_ATTRIBUTE}
Const AFTKN_ITEM_SET_PRIORITY = (BASE_AFUNC_TOKEN + 132); {// AFTKN_ITEM_SET_PRIORITY}
Const AFTKN_ITEM_SET_TEXT = (BASE_AFUNC_TOKEN + 133); {// AFTKN_ITEM_SET_TEXT}
Const AFTKN_ITEM_SET_TYPE = (BASE_AFUNC_TOKEN + 134); {// AFTKN_ITEM_SET_TYPE}
Const AFTKN_AL_CREATE = (BASE_AFUNC_TOKEN + 135); {// AFTKN_AL_CREATE}
Const AFTKN_AL_DELETE = (BASE_AFUNC_TOKEN + 136); {// AFTKN_AL_DELETE}
Const AFTKN_AL_GET_ADDRESS = (BASE_AFUNC_TOKEN + 137); {// AFTKN_AL_GET_ADDRESS}
Const AFTKN_AL_GET_COUNT = (BASE_AFUNC_TOKEN + 138); {// AFTKN_AL_GET_COUNT}
Const AFTKN_AL_GET_ENTRY = (BASE_AFUNC_TOKEN + 139); {// AFTKN_AL_GET_ENTRY}
Const AFTKN_AL_GET_FIELD = (BASE_AFUNC_TOKEN + 140); {// AFTKN_AL_GET_FIELD}
Const AFTKN_ITEM_DELETE = (BASE_AFUNC_TOKEN + 141); {// AFTKN_ITEM_DELETE}
Const AFTKN_ITEMLIST_CREATE = (BASE_AFUNC_TOKEN + 142); {// AFTKN_ITEMLIST_CREATE}
Const AFTKN_ITEMLIST_CREATE_FM_CTRL = (BASE_AFUNC_TOKEN + 143); {// AFTKN_ITEMLIST_CREATE_FM_CTRL}
Const AFTKN_ITEMLIST_DELETE = (BASE_AFUNC_TOKEN + 144); {// AFTKN_ITEMLIST_DELETE}
Const AFTKN_ITEMLIST_GET_COUNT = (BASE_AFUNC_TOKEN + 145); {// AFTKN_ITEMLIST_GET_COUNT}
Const AFTKN_ITEMLIST_GET_MSGID = (BASE_AFUNC_TOKEN + 146); {// AFTKN_ITEMLIST_GET_MSGID}
Const AFTKN_ITEMLIST_SORT = (BASE_AFUNC_TOKEN + 147); {// AFTKN_ITEMLIST_SORT}
Const AFTKN_FLDRLIST_ADD = (BASE_AFUNC_TOKEN + 148); {// AFTKN_FLDRLIST_ADD}
Const AFTKN_FLDRLIST_APPLY = (BASE_AFUNC_TOKEN + 149); {// AFTKN_FLDRLIST_APPLY}
Const AFTKN_FLDRLIST_CREATE = (BASE_AFUNC_TOKEN + 150); {// AFTKN_FLDRLIST_CREATE}
Const AFTKN_FLDRLIST_CREATE_FROM_VIEW = (BASE_AFUNC_TOKEN + 151); {// AFTKN_FLDRLIST_CREATE_FROM_VIEW}
Const AFTKN_FLDRLIST_DELETE = (BASE_AFUNC_TOKEN + 152); {// AFTKN_FLDRLIST_DELETE}
Const AFTKN_FLDRLIST_GET_COUNT = (BASE_AFUNC_TOKEN + 153); {// AFTKN_FLDRLIST_GET_COUNT}
Const AFTKN_FLDRLIST_GET_NAME = (BASE_AFUNC_TOKEN + 154); {// AFTKN_FLDRLIST_GET_NAME}
Const AFTKN_FLDRLIST_SET = (BASE_AFUNC_TOKEN + 155); {// AFTKN_FLDRLIST_SET}
Const AFTKN_AL_IS_IN_SECTION = (BASE_AFUNC_TOKEN + 156); {// AFTKN_AL_IS_IN_SECTION}
Const AFTKN_PROMPT_FOR_PASSWORD = (BASE_AFUNC_TOKEN + 157); {// AFTKN_PROMPT_FOR_PASSWORD}
Const AFTKN_DATE_PARSE_DAY = (BASE_AFUNC_TOKEN + 158); {// AFTKN_DATE_PARSE_DAY}
Const AFTKN_AB_SEARCH = (BASE_AFUNC_TOKEN + 159); {// AFTKN_AB_SEARCH}
Const AFTKN_AB_SEARCH_BEGIN = (BASE_AFUNC_TOKEN + 160); {// AFTKN_AB_SEARCH_BEGIN}
Const AFTKN_AB_SEARCH_END = (BASE_AFUNC_TOKEN + 161); {// AFTKN_AB_SEARCH_END}
Const AFTKN_AB_SEARCH_NEXT = (BASE_AFUNC_TOKEN + 162); {// AFTKN_AB_SEARCH_NEXT}
Const AFTKN_AB_SEARCH_PREV = (BASE_AFUNC_TOKEN + 163); {// AFTKN_AB_SEARCH_PREV}
Const AFTKN_AB_GET_ENTRY = (BASE_AFUNC_TOKEN + 164); {// AFTKN_AB_GET_ENTRY}
Const AFTKN_AB_GET_FIELD = (BASE_AFUNC_TOKEN + 165); {// AFTKN_AB_GET_FIELD}
Const AFTKN_AL_SAVE_AS_PER_GROUP = (BASE_AFUNC_TOKEN + 166); {// AFTKN_AL_SAVE_AS_PER_GROUP}
Const AFTKN_FILTER_APPLY = (BASE_AFUNC_TOKEN + 167); {// AFTKN_FILTER_APPLY}
Const AFTKN_FILTER_CREATE = (BASE_AFUNC_TOKEN + 168); {// AFTKN_FILTER_CREATE}
Const AFTKN_FILTER_DELETE = (BASE_AFUNC_TOKEN + 169); {// AFTKN_FILTER_DELETE}
Const AFTKN_FILTER_SET_ATTACH_CLASS = (BASE_AFUNC_TOKEN + 170); {// AFTKN_FILTER_SET_ATTACH_CLASS}
Const AFTKN_FILTER_SET_ATTRIBUTE = (BASE_AFUNC_TOKEN + 171); {// AFTKN_FILTER_SET_ATTRIBUTE}
Const AFTKN_FILTER_SET_DATE_ABSOLUTE = (BASE_AFUNC_TOKEN + 172); {// AFTKN_FILTER_SET_DATE_ABSOLUTE}
Const AFTKN_FILTER_SET_DATE_RELATIVE = (BASE_AFUNC_TOKEN + 173); {// AFTKN_FILTER_SET_DATE_RELATIVE}
Const AFTKN_FILTER_SET_ITEMTYPE = (BASE_AFUNC_TOKEN + 174); {// AFTKN_FILTER_SET_ITEMTYPE}
Const AFTKN_FILTER_SET_PRIORITY = (BASE_AFUNC_TOKEN + 175); {// AFTKN_FILTER_SET_PRIORITY}
Const AFTKN_FILTER_SET_SOURCE = (BASE_AFUNC_TOKEN + 176); {// AFTKN_FILTER_SET_SOURCE}
Const AFTKN_FILTER_SET_TEXT = (BASE_AFUNC_TOKEN + 177); {// AFTKN_FILTER_SET_TEXT}
Const AFTKN_CSTMSG_INSTALL = (BASE_AFUNC_TOKEN + 178); {// AFTKN_CSTMSG_INSTALL}
Const AFTKN_BTNBAR_SETFONT = (BASE_AFUNC_TOKEN + 179); {// AFTKN_BTNBAR_SETFONT}
Const AFTKN_BTNBAR_SETLOCATION = (BASE_AFUNC_TOKEN + 180); {// AFTKN_BTNBAR_SETLOCATION}
Const AFTKN_BTNBAR_SETROWS = (BASE_AFUNC_TOKEN + 181); {// AFTKN_BTNBAR_SETROWS}
Const AFTKN_BTNBAR_SETSTYLE = (BASE_AFUNC_TOKEN + 182); {// AFTKN_BTNBAR_SETSTYLE}
Const AFTKN_CLIPBOARD_TEXT = (BASE_AFUNC_TOKEN + 183); {// AFTKN_CLIPBOARD_TEXT}
Const AFTKN_IS_REMOTE = (BASE_AFUNC_TOKEN + 184); {// AFTKN_IS_REMOTE}
Const AFTKN_NETWORK_LOGIN_ID = (BASE_AFUNC_TOKEN + 185); {// AFTKN_NETWORK_LOGIN_ID}
Const AFTKN_AL_CREATE_FROM_GROUP = (BASE_AFUNC_TOKEN + 186); {// AFTKN_AL_CREATE_FROM_GROUP}
Const AFTKN_PREF_ARCHIVE_PATH = (BASE_AFUNC_TOKEN + 187); {// AFTKN_PREF_ARCHIVE_PATH}
Const AFTKN_PREF_CUSTOM_VIEW_PATH = (BASE_AFUNC_TOKEN + 188); {// AFTKN_PREF_CUSTOM_VIEW_PATH}
Const AFTKN_PREF_FULL_NAME = (BASE_AFUNC_TOKEN + 189); {// AFTKN_PREF_FULL_NAME}
Const AFTKN_PREF_MACRO_PATH = (BASE_AFUNC_TOKEN + 190); {// AFTKN_PREF_MACRO_PATH}
Const AFTKN_PREF_POST_OFFICE_PATH = (BASE_AFUNC_TOKEN + 191); {// AFTKN_PREF_POST_OFFICE_PATH}
Const AFTKN_PREF_SAVE_PATH = (BASE_AFUNC_TOKEN + 192); {// AFTKN_PREF_SAVE_PATH}
Const AFTKN_USERID = (BASE_AFUNC_TOKEN + 193); {// AFTKN_USERID}
Const AFTKN_VERSION_NAME = (BASE_AFUNC_TOKEN + 194); {// AFTKN_VERSION_NAME}
Const AFTKN_VERSION_DATE = (BASE_AFUNC_TOKEN + 195); {// AFTKN_VERSION_DATE}
Const AFTKN_AB_DEL_PER_GROUP = (BASE_AFUNC_TOKEN + 196); {// AFTKN_AB_DEL_PER_GROUP}
Const AFTKN_AL_ADD = (BASE_AFUNC_TOKEN + 197); {// AFTKN_AL_ADD}
Const AFTKN_AL_EDIT = (BASE_AFUNC_TOKEN + 198); {// AFTKN_AL_EDIT}
Const AFTKN_ITEM_ATTACHMENT_UPDATE = (BASE_AFUNC_TOKEN + 199); {// AFTKN_ITEM_ATTACHMENT_UPDATE}
Const AFTKN_CSTCMD_DELETE = (BASE_AFUNC_TOKEN + 200); {// AFTKN_CSTCMD_DELETE}
Const AFTKN_CSTCMD_INSTALL = (BASE_AFUNC_TOKEN + 201); {// AFTKN_CSTCMD_INSTALL}
Const AFTKN_CSTCMD_EXECUTE = (BASE_AFUNC_TOKEN + 202); {// AFTKN_CSTCMD_EXECUTE}
Const AFTKN_CSTMSG_DELETE = (BASE_AFUNC_TOKEN + 203); {// AFTKN_CSTMSG_DELETE}
Const AFTKN_ITEM_ATTACHMENT_CURRENT = (BASE_AFUNC_TOKEN + 204); {// AFTKN_ITEM_ATTACHMENT_CURRENT}
Const AFTKN_MACRO_FILE_PLAY = (BASE_AFUNC_TOKEN + 205); {// AFTKN_MACRO_FILE_PLAY}
Const AFTKN_RETURNVAL_GET = (BASE_AFUNC_TOKEN + 206); {// AFTKN_RETURNVAL_GET}
Const AFTKN_PRIVATEBIF = (BASE_AFUNC_TOKEN + 207); {// AFTKN_PRIVATEBIF}
Const AFTKN_PUBLICBIF = (BASE_AFUNC_TOKEN + 208); {// AFTKN_PUBLICBIF}
Const AFTKN_SCPATH = (BASE_AFUNC_TOKEN + 209); {// AFTKN_SCPATH - Obsolete}
Const AFTKN_OFFICEID = (BASE_AFUNC_TOKEN + 210); {// AFTKN_OFFICEID}
Const AFTKN_LASTERROR = (BASE_AFUNC_TOKEN + 211); {// AFTKN_LASTERROR}
Const AFTKN_INHIBIT_INPUT = (BASE_AFUNC_TOKEN + 212); {// AFTKN_INHIBIT_INPUT}
Const AFTKN_ITEM_FOLDER_ALTMOVE = (BASE_AFUNC_TOKEN + 213); {// AFTKN_ITEM_FOLDER_ALTMOVE}
Const AFTKN_ITEM_FOLDER_LINK = (BASE_AFUNC_TOKEN + 214); {// AFTKN_ITEM_FOLDER_LINK}
Const AFTKN_ITEM_FOLDER_MOVE = (BASE_AFUNC_TOKEN + 215); {// AFTKN_ITEM_FOLDER_MOVE}
Const AFTKN_COMMAND_LINE = (BASE_AFUNC_TOKEN + 216); {// AFTKN_COMMAND_LINE}
Const AFTKN_LAST_WINDOW_CANCELED = (BASE_AFUNC_TOKEN + 217); {// AFTKN_LAST_WINDOW_CANCELED}
Const AFTKN_IS_NETWORK_USER = (BASE_AFUNC_TOKEN + 218); {// AFTKN_IS_NETWORK_USER}
Const AFTKN_ITEM_GET_RECIPIENTID = (BASE_AFUNC_TOKEN + 219); {// AFTKN_ITEM_GET_RECIPIENTID}
Const AFTKN_AB_COMPARE = (BASE_AFUNC_TOKEN + 220); {// AFTKN_AB_COMPARE}
Const AFTKN_ALLOW_EXIT = (BASE_AFUNC_TOKEN + 221); {// AFTKN_ALLOW_EXIT}
Const AFTKN_ITEM_GET_OUTBOX_MSGID = (BASE_AFUNC_TOKEN + 222); {// AFTKN_ITEM_GET_OUTBOX_MSGID}
Const AFTKN_ISREMOTECONNECTED = (BASE_AFUNC_TOKEN + 223); {// AFTKN_ISREMOTECONNECTED}
Const AFTKN_ISREMCONNECTNEEDED = (BASE_AFUNC_TOKEN + 224); {// AFTKN_ISREMCONNECTNEEDED}
Const AFTKN_ISREMCONNECTDONE = (BASE_AFUNC_TOKEN + 225); {// AFTKN_ISREMCONNECTDONE}
Const AFTKN_REM_SETPORTINFO = (BASE_AFUNC_TOKEN + 226); {// AFTKN_REM_SETPORTINFO}
Const AFTKN_REM_SETRECONCILE = (BASE_AFUNC_TOKEN + 227); {// AFTKN_REM_SETRECONCILE}
Const AFTKN_MACRO_PLAYING = (BASE_AFUNC_TOKEN + 228); {// AFTKN_MACRO_PLAYING}
Const AFTKN_ENV_ISCOMMANDVALID = (BASE_AFUNC_TOKEN + 229); {// AFTKN_ENV_ISCOMMANDVALID}
Const AFTKN_ENV_CURRENTVIEWNAME = (BASE_AFUNC_TOKEN + 230); {// AFTKN_ENV_CURRENTVIEWNAME}
Const AFTKN_ITEM_ARCHIVE = (BASE_AFUNC_TOKEN + 231); {// AFTKN_ITEM_ARCHIVE}
Const AFTKN_REM_CREATE_ASYNC_CONNECTION = (BASE_AFUNC_TOKEN + 232); {// AFTKN_REM_CREATE_ASYNC_CONNECTION}
Const AFTKN_REM_CREATE_DIRECT_CONNECTION = (BASE_AFUNC_TOKEN + 233); {// AFTKN_REM_CREATE_DIRECT_CONNECTION}
Const AFTKN_ITEM_DECLINE = (BASE_AFUNC_TOKEN + 234); {// AFTKN_ITEM_DECLINE}
Const AFTKN_ITEM_DELEGATE = (BASE_AFUNC_TOKEN + 235); {// AFTKN_ITEM_DELEGATE}
Const AFTKN_ITEM_INFO = (BASE_AFUNC_TOKEN + 236); {// AFTKN_ITEM_INFO}
Const AFTKN_ITEM_UNDELETE = (BASE_AFUNC_TOKEN + 237); {// AFTKN_ITEM_UNDELETE}
Const AFTKN_ITEM_SET_DATE = (BASE_AFUNC_TOKEN + 238); {// AFTKN_ITEM_SET_DATE}
Const AFTKN_AB_IS_GROUP_MEMBER = (BASE_AFUNC_TOKEN + 239); {// AFTKN_AB_IS_GROUP_MEMBER}
Const AFTKN_AB_RESOLVE = (BASE_AFUNC_TOKEN + 240); {// AFTKN_AB_RESOLVE}
Const AFTKN_TEXTENTRY_GET_RIGHTCHAR = (BASE_AFUNC_TOKEN + 241); {// AFTKN_TEXTENTRY_GET_RIGHTCHAR}
Const AFTKN_FILTER_EXECUTE = (BASE_AFUNC_TOKEN + 242); {// AFTKN_FILTER_EXECUTE}
Const AFTKN_REM_SELECTCONNECTION = (BASE_AFUNC_TOKEN + 243); {// AFTKN_REM_SELECTCONNECTION}
Const AFTKN_REM_GETDEFAULTCONNECTNAME = (BASE_AFUNC_TOKEN + 244); {// AFTKN_REM_GETDEFAULTCONNECTNAME}
Const AFTKN_REM_SETITEMSFILTER = (BASE_AFUNC_TOKEN + 245); {// AFTKN_REM_SETITEMSFILTER}
Const AFTKN_REM_SETITEMSFOLDERS = (BASE_AFUNC_TOKEN + 246); {// AFTKN_REM_SETITEMSFOLDERS}
Const AFTKN_REM_SET_ADDRBOOK_DNLOAD_FILTER = (BASE_AFUNC_TOKEN + 247); {// AFTKN_REM_SET_ADDRBOOK_DNLOAD_FILTER}
Const AFTKN_REM_REQUESTPGROUP = (BASE_AFUNC_TOKEN + 248); {// AFTKN_REM_REQUESTPGROUP}
Const AFTKN_RULE_ACT_ARCHIVE = (BASE_AFUNC_TOKEN + 249); {// AFTKN_RULE_ACT_ARCHIVE}
Const AFTKN_REM_DELETECONNECTION = (BASE_AFUNC_TOKEN + 250); {// AFTKN_REM_DELETECONNECTION}
Const AFTKN_EVENT_NOTIFY = (BASE_AFUNC_TOKEN + 251); {// AFTKN_EVENT_NOTIFY}
Const AFTKN_PLAY_SOUND = (BASE_AFUNC_TOKEN + 252); {// AFTKN_PLAY_SOUND}
Const AFTKN_IS_MACRO_RECORDING = (BASE_AFUNC_TOKEN + 253); {// AFTKN_IS_MACRO_RECORDING}
Const AFTKN_DATE_PARSE_HOURS = (BASE_AFUNC_TOKEN + 254); {// AFTKN_DATE_PARSE_HOURS}
Const AFTKN_DATE_PARSE_MINUTES = (BASE_AFUNC_TOKEN + 255); {// AFTKN_DATE_PARSE_MINUTES}
Const AFTKN_DATE_PARSE_DUR_HR = (BASE_AFUNC_TOKEN + 256); {// AFTKN_DATE_PARSE_DUR_HR}
Const AFTKN_DATE_PARSE_DUR_MIN = (BASE_AFUNC_TOKEN + 257); {// AFTKN_DATE_PARSE_DUR_MIN}
Const AFTKN_CSTMSG_COMPOSE = (BASE_AFUNC_TOKEN + 258); {// AFTKN_CSTMSG_COMPOSE}
Const AFTKN_TEXTENTRY_IS_INSERT_MODE = (BASE_AFUNC_TOKEN + 259); {// AFTKN_TEXTENTRY_IS_INSERT_MODE}
Const AFTKN_ITEM_GET_REPLY_MSGID = (BASE_AFUNC_TOKEN + 260); {// AFTKN_ITEM_GET_REPLY_MSGID}
Const AFTKN_AB_RESOLVE_FULLNAME = (BASE_AFUNC_TOKEN + 263); {// AFTKN_AB_RESOLVE_FULLNAME}
Const AFTKN_AB_GET_FULLNAME = (BASE_AFUNC_TOKEN + 264); {// AFTKN_AB_GET_FULLNAME}
Const AFTKN_AL_GET_FULLNAME = (BASE_AFUNC_TOKEN + 265); {// AFTKN_AL_GET_FULLNAME}
Const AFTKN_BTNBAR_COPY = (BASE_AFUNC_TOKEN + 266); {// AFTKN_BTNBAR_COPY}
Const AFTKN_APP_ACTIVATE = (BASE_AFUNC_TOKEN + 267); {// AFTKN_APP_ACTIVATE}
Const AFTKN_REM_MODEMCOMMAND = (BASE_AFUNC_TOKEN + 268); {// AFTKN_REM_MODEMCOMMAND}
Const AFTKN_REM_GETDEFAULTCONNECTNUMBER = (BASE_AFUNC_TOKEN + 269); {// AFTKN_REM_GETDEFAULTCONNECTNUMBER}
Const AFTKN_RULE_ACT_STOPRULES = (BASE_AFUNC_TOKEN + 270); {// AFTKN_RULE_ACT_STOPRULES}
Const AFTKN_BTNBAR_SETSCROLL = (BASE_AFUNC_TOKEN + 271); {// AFTKN_BTNBAR_SETSCROLL}
Const AFTKN_BTNBAR_SETTIPS = (BASE_AFUNC_TOKEN + 272); {// AFTKN_BTNBAR_SETTIPS}
Const AFTKN_FILTER_SET_SDWORD = (BASE_AFUNC_TOKEN + 273); {// AFTKN_FILTER_SET_SDWORD}
Const AFTKN_FILTER_SET_SWORD = (BASE_AFUNC_TOKEN + 274); {// AFTKN_FILTER_SET_SWORD}
Const AFTKN_SHELF_ICON_GET_COUNT = (BASE_AFUNC_TOKEN + 278); {// AFTKN_SHELF_ICON_GET_COUNT}
Const AFTKN_SHELF_ICON_GET_SELECTED = (BASE_AFUNC_TOKEN + 279); {// AFTKN_SHELF_ICON_GET_SELECTED}
Const AFTKN_SHELF_ICON_GET_INFO = (BASE_AFUNC_TOKEN + 280); {// AFTKN_SHELF_ICON_GET_INFO}
Const AFTKN_SHELF_ICON_SET_TEMP_ICON = (BASE_AFUNC_TOKEN + 281); {// AFTKN_SHELF_ICON_SET_TEMP_ICON}
Const AFTKN_RULE_ACT_LAUNCH = (BASE_AFUNC_TOKEN + 282); {// AFTKN_RULE_ACT_LAUNCH}
Const AFTKN_FILTER_SET_BYTE = (BASE_AFUNC_TOKEN + 283); {// AFTKN_FILTER_SET_BYTE}
Const AFTKN_FILTER_SET_DWORD = (BASE_AFUNC_TOKEN + 284); {// AFTKN_FILTER_SET_DWORD}
Const AFTKN_FILTER_SET_WORD = (BASE_AFUNC_TOKEN + 285); {// AFTKN_FILTER_SET_WORD}
Const AFTKN_FILTER_GROUP_BEGIN = (BASE_AFUNC_TOKEN + 286); {// AFTKN_FILTER_GROUP_BEGIN}
Const AFTKN_FILTER_GROUP_END = (BASE_AFUNC_TOKEN + 287); {// AFTKN_FILTER_GROUP_END}
Const AFTKN_FILTER_GROUP_MARKER = (BASE_AFUNC_TOKEN + 288); {// AFTKN_FILTER_GROUP_MARKER}
Const AFTKN_DISPLAY_SETTINGS_SET = (BASE_AFUNC_TOKEN + 289); {// AFTKN_DISPLAY_SETTINGS_SET}
Const AFTKN_DM_VERSION_LIST = (BASE_AFUNC_TOKEN + 290); {// AFTKN_DM_VERSION_LIST}
Const AFTKN_FILTER_SET_DATE = (BASE_AFUNC_TOKEN + 291); {// AFTKN_FILTER_SET_DATE}
Const AFTKN_SET_COLUMNS = (BASE_AFUNC_TOKEN + 292); {// AFTKN_SET_COLUMNS}
Const AFTKN_SET_SORT = (BASE_AFUNC_TOKEN + 293); {// AFTKN_SET_SORT}
Const AFTKN_QUERY_SAVE_AS_FOLDER = (BASE_AFUNC_TOKEN + 294); {// AFTKN_QUERY_SAVE_AS_FOLDER}
Const AFTKN_QUERY_EXECUTE = (BASE_AFUNC_TOKEN + 295); {// AFTKN_QUERY_EXECUTE}
Const AFTKN_RULE_ACT_MARKREAD = (BASE_AFUNC_TOKEN + 296); {// AFTKN_RULE_ACT_MARKREAD}
Const AFTKN_RULE_ACT_MARKUNREAD = (BASE_AFUNC_TOKEN + 297); {// AFTKN_RULE_ACT_MARKUNREAD}
Const AFTKN_RULE_ACT_REPLY_WITH_TEXT = (BASE_AFUNC_TOKEN + 298); {// AFTKN_RULE_ACT_REPLY_WITH_TEXT}
Const AFTKN_SHARED_FOLDER_ACCEPT = (BASE_AFUNC_TOKEN + 299); {// AFTKN_SHARED_FOLDER_ACCEPT}
Const AFTKN_DM_OPEN = (BASE_AFUNC_TOKEN + 300); {//AFTKN_DM_OPEN}
Const AFTKN_DM_CLOSE = (BASE_AFUNC_TOKEN + 301); {//AFTKN_DM_CLOSE}
Const AFTKN_DM_ENDPREVIEW = (BASE_AFUNC_TOKEN + 302); {//AFTKN_DM_ENDPREVIEW}
Const AFTKN_DM_READONLYOPEN = (BASE_AFUNC_TOKEN + 303); {//AFTKN_DM_READONLYOPEN}
Const AFTKN_DM_NEW_DOC = (BASE_AFUNC_TOKEN + 304); {//AFTKN_DM_NEW_DOC}
Const AFTKN_DM_VIEW_DOC = (BASE_AFUNC_TOKEN + 305); {//AFTKN_DM_VIEW_DOC}
Const AFTKN_DM_DISPLAY_PROFILE = (BASE_AFUNC_TOKEN + 306); {//AFTKN_DM_DISPLAY_PROFILE}
Const AFTKN_DM_IMPORT_DOC = (BASE_AFUNC_TOKEN + 307); {//AFTKN_DM_IMPORT_DOC}
Const AFTKN_DM_GETFIELD = (BASE_AFUNC_TOKEN + 308); {//AFTKN_DM_GETFIELD}
Const AFTKN_DM_DELETE = (BASE_AFUNC_TOKEN + 309); {//AFTKN_DM_DELETE}
Const AFTKN_DM_ADDVER = (BASE_AFUNC_TOKEN + 310); {//AFTKN_DM_ADDVER}
Const AFTKN_DM_COPYVER = (BASE_AFUNC_TOKEN + 311); {//AFTKN_DM_COPYVER}
Const AFTKN_DM_COPYPROFILE = (BASE_AFUNC_TOKEN + 312); {//AFTKN_DM_COPYPROFILE}
Const AFTKN_DM_SETFIELD = (BASE_AFUNC_TOKEN + 313); {//AFTKN_DM_SETFIELD}
Const AFTKN_DM_GET_OPEN_RIGHTS = (BASE_AFUNC_TOKEN + 314); {//AFTKN_DM_GET_OPEN_RIGHTS}
Const AFTKN_SET_DAY = (BASE_AFUNC_TOKEN + 315); {//AFTKN_SET_DAY}
Const AFTKN_SET_MAC = (BASE_AFUNC_TOKEN + 316); {//AFTKN_SET_MAC}
Const AFTKN_UNASSIGNED_320 = (BASE_AFUNC_TOKEN + 320); {//AFTKN_UNASSIGNED}
Const TOP_AFUNC_TOKEN = AFTKN_UNASSIGNED_320;
Const AFUNC_TOKEN_COUNT = (TOP_AFUNC_TOKEN - BASE_AFUNC_TOKEN + 1);
Const RG_MENU_FLOOR = $7F01;
Const IDM_ACTION_MENU = (RG_MENU_FLOOR + 1);
Const IDM_BTNBAR_MENU = (RG_MENU_FLOOR + 2);
Const IDM_EDIT_MENU = (RG_MENU_FLOOR + 3);
Const IDM_FILE_MENU = (RG_MENU_FLOOR + 4);
Const IDM_FONT_MENU = (RG_MENU_FLOOR + 5);
Const IDM_HELP_MENU = (RG_MENU_FLOOR + 6);
Const IDM_MACRO_MENU = (RG_MENU_FLOOR + 7);
Const IDM_OPTIONS_MENU = (RG_MENU_FLOOR + 8);
Const IDM_REMOTE_MENU = (RG_MENU_FLOOR + 9);
Const IDM_SEND_MENU = (RG_MENU_FLOOR + 10);
Const IDM_TOOLS_MENU = (RG_MENU_FLOOR + 11);
Const IDM_VIEW_MENU = (RG_MENU_FLOOR + 12);
Const IDM_WINDOW_MENU = (RG_MENU_FLOOR + 13);
Const IDM_OPEN_VIEWS_MENU = (RG_MENU_FLOOR + 14);
Const IDM_BBAR_TEMP_MENU = (RG_MENU_FLOOR + 15);
Const IDM_OTHER_MENU = (RG_MENU_FLOOR + 16);
Const IDM_BBAR_SYS_MENUA = (RG_MENU_FLOOR + 17);
Const IDM_BBAR_SYS_MENUB = (RG_MENU_FLOOR + 18);
Const IDM_BBAR_SYS_MENUM = (RG_MENU_FLOOR + 19);
Const IDM_POWER_BAR_MENU = (RG_MENU_FLOOR + 20);
Const IDM_FILTER_DLG_MENU = (RG_MENU_FLOOR + 23);
Const IDM_SYS_MENU = (RG_MENU_FLOOR + 25);



implementation


end.
