unit PFLPREFS;

interface
Uses WinTypes,PGPBase,PGPPubTypes,PFLPrefTypes,PGPClip,
     WinProcs;

     {$IFDEF PGP65}
     const prename='PGPcl';
     {$ELSE}
     const prename='PGP';
     {$ENDIF}


{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }



{-$Id: Pflprefs.pas,v 1.5.12.2 1999/08/27 22:00:46 build Exp $ }
{=____________________________________________________________________________ }




function PGPOpenPrefFile(prefFileSpec: PFLFILESPECREF;
                         var prefRef: PGPPREFREF): PGPERROR; cdecl; far;


function PGPSavePrefFile(prefRef: PGPPREFREF): PGPERROR; cdecl; far;


function PGPClosePrefFile(prefRef: PGPPREFREF): PGPERROR; cdecl; far;


function PGPGetPrefFileSpec(prefRef: PGPPREFREF; 
                            var prefFileSpec: PFLFILESPECREF): PGPERROR; cdecl; far;



function PGPGetPrefData(prefRef: PGPPREFREF;
                        prefIndex: PGPPREFINDEX;
                        var dataLength: PGPSIZE;
                        var inBuffer: Pointer): PGPERROR; cdecl; far;


function PGPSetPrefData(prefRef: PGPPREFREF;
                        prefIndex: PGPPREFINDEX; 
                        dataLength: PGPSIZE; 
                        Const outBuffer: Pointer): PGPERROR; cdecl; far;


function PGPRemovePref(prefRef: PGPPREFREF; 
                       prefIndex: PGPPREFINDEX): PGPERROR; cdecl; far;


function PGPDisposePrefData(prefRef: PGPPREFREF;
                            dataBuffer: Pointer): PGPERROR; cdecl; far;



implementation


function PGPOpenPrefFile; external {$IFDEF PGP6} pgpclfile {$ELSE} 'PGP55CD.dll' {$ENDIF};

function PGPSavePrefFile; external {$IFDEF PGP6} pgpclfile {$ELSE} 'PGP55CD.dll' {$ENDIF};

function PGPClosePrefFile; external {$IFDEF PGP6} pgpclfile {$ELSE} 'PGP55CD.dll' {$ENDIF};

function PGPGetPrefFileSpec; external {$IFDEF PGP6} pgpclfile {$ELSE} 'PGP55CD.dll' {$ENDIF};

function PGPGetPrefData; external {$IFDEF PGP6} pgpclfile name prename+'GetPrefData'{$ELSE} 'PGP55CD.dll' {$ENDIF};

function PGPSetPrefData; external {$IFDEF PGP6} pgpclfile name prename+'SetPrefData' {$ELSE} 'PGP55CD.dll' {$ENDIF};

function PGPRemovePref; external {$IFDEF PGP6} pgpclfile name prename+'RemovePref' {$ELSE} 'PGP55CD.dll' {$ENDIF};

function PGPDisposePrefData; external {$IFDEF PGP6} pgpclfile name prename+'DisposePrefData' {$ELSE} 'PGP55CD.dll' {$ENDIF};

end.
