{+//___________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: Pgp2.pas,v 1.10.12.4 1999/09/08 18:15:30 build Exp $ }
{=____________________________________________________________________________ }
unit Pgp2;

interface

uses
   Windows,Forms,SysUtils,ShellAPI,WinProcs,WinTypes,Dialogs,graphics,
   comobj,StdCtrls, Controls, Classes,inifiles, wpcom32,
messwin,pgpencodes, pgpexsdk,pgppubtypes,autoscale,c3poinc,pgpcmdlg;



const
dontshowaddressfield='dontshowaddress';
ignoreinternalfield='PGPIgnoreInternal';
richeditfield='PGPRichEdit';
isdefaultfield='PGPIsDefaultProvider';

{$IFDEF GW52}
delimiter=',';//delimiters changed between versions
{$ELSE}
delimiter=';';
{$ENDIF}

resourcestring

mailfrom='Mail From: ';
fromintro='Decrypted message from ' ;
replymess='Decrypted Message From ';
searching='Searching';
generating='Generating';
findingkeys='Searching for PGP Keys that match recipients';
chooseloc='Please choose a location and name for decrypted file - Doc # ';
chooselocmess='Please choose a location and name for decrypted message';
selectview='  Select view attachments to see any attachments.';
incomingonly='Please select an incoming item to decrypt.';
startdate='Start Date: ';
enddate='End Date: ';
duration='Duration: ';
place='Place: ';
CallerCompanyMess='CallerCompany:  ';
CallerNameMess='CallerName:  ';
CameToSeeMess='CameToSee';
PhoneNumberMess='PhoneNumber:  ';
PleaseCallMess='PleaseCall';
ReturnedCallMess='ReturnedCall';
TelephonedMess='Telephoned';
UrgentMess='Urgent';
WantsToSeeMess='WantsToSee';
WillCallMess='WillCall';
duedatemess='Due Date: ';
assigneddatemess='Assigned Date: ';
taskcategorymess='Task Category: ';
taskprioritymess='Task Priority: ';
submess='Subject: ';
noinfo='No User Information';
createddate='Message Creation Date: ';
makingmessage='Preparing Groupwise Message';
attachmentmissing='Attachment missing due to inability to decrypt.  Select PGP|Open without decrypting menu to view';
ambiguoususer=' is ambigous.  Please select the key manually.';
datehead='Date: ';


type
TFooClass = class(TControl); { needed to get at protected }
                               { font property }
  ini=class(tinifile);
  TForm1 = class(TForm)
    FileDial: TOpenDialog;
    SaveDial: TSaveDialog;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    killlist: TListBox;
    WPO: TWP;
    procedure DecryptClick(Sender: TObject);
    procedure Key_To_RingClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SaveDialTypeChange(Sender: TObject);
    procedure SaveDialCanClose(Sender: TObject; var CanClose: Boolean);

  private
    { Private declarations }
     procedure init;

  public
  passthrough:boolean;
   OK:integer;
   owneraddress:string;
   richedit:boolean;
   reply:boolean;
   ignoreinternal:boolean;
   dontshow:boolean;
   isinternal:boolean;
   allinternal:boolean;
   sendbutton:boolean;
   pgpisdefault:boolean;
   gwhandle:thandle;
   pgp:tpgp5;
   function selectusers:tstringlist;
   function getfield(fieldname:string):boolean;
   procedure setfield(fieldname:string;setting:boolean);
     procedure setupfields;
    { Public declarations }
  end;
function mail_key(selectstat:integer):boolean;
procedure processname(name:string; var fname,fpath:string);
function decryptfile(var tmpfile:string;var status:statrec):boolean;
function decrypttext(var tmpfile:string;var status:statrec):boolean;
function getaddress(address:string):string;
procedure setupmesstypes(status:statrec;oldmess:variant;messform:tmessform);

var

  Form1: TForm1;
  windir,PGPGWProg,PGPGWPath : string;
     GroupWise:variant;
   recips,tmessage,account:variant;
   sysbook,freqbook,books,defbook:variant;
   freqname,defname:string;
   counter:integer;

   function decrypt(var gwmess:variant):boolean;
procedure decryptattach(oldmess:variant; newmes:variant;modres:integer);
procedure setuptypes(var newmess,oldmess:variant);
implementation

uses  statunit,encrypt;
{$R *.DFM}
var  MessForm: TMessForm;
const //constants for Groupwise API
 eADD_DRAFT = 0;
    eADD_PERSONAL = 1;

{Field Types}
    eSTRING = 1;
    eNUMERIC = 2;
    eDATE = 3;
    eBINARY = 4;
    eRESERVED_TYPE = 5;



procedure log(const logdat:string);
var runfile:string;ini:textfile;
begin
  runfile:='c:\pgpgw.log';
{  deletefile(runfile);}
  try
  assignfile(ini,runfile);
   append(ini);
   writeln(ini,logdat);
   finally
     closefile(ini);
  end;
  end;

(*************************************

Name: parseright

Description: parses a period '.' delimited string into the rightmost token and
             the remaining token.  If no '.' is found, returns the entire string as the right token

IN: input - string containing the delimited token

OUT:  rightstring - string containing the text after the rightmost (last) '.'
      leftstring - string containing all other text
      the rightmost '.' is not returned in either parameter

RETURNS: true if there is no '.', and false otherwise

******************************************)
function parseright(input:string; var leftstring:string;var rightstring:string):boolean;
var count:integer;done:boolean;stop:integer;
begin
leftstring:='';
rightstring:='';
stop:=length(input);
result:=true;
for count:=  length(input) downto 1  do begin
if (input[count] <> '.') then
rightstring:= concat(input[count],rightstring) else begin
result:=false;
stop:=count;
break;
end;
end;
leftstring:=copy(input,1,stop-1)
end;

(*************************************

Name: parseleft

Description: parses a period '.' delimited string into the leftmost token and
             the remaining token.  If no '.' is found, returns the entire string as the left token

IN: input - string containing the delimited token

OUT:  leftstring - string containing the text before the leftmost (first) '.'
      rightstring - string containing all other text
      the leftmost '.' is not returned in either parameter

RETURNS: true if there is no '.', and false otherwise

******************************************)
function parseleft(input:string; var leftstring:string;var rightstring:string):boolean;
var count:integer;done:boolean;stop:integer;
begin
leftstring:='';
rightstring:='';
stop:=length(input);
result:=true;
for count:=  1 to length(input)  do begin
if (input[count] <> '.') then
leftstring:= concat(leftstring,input[count]) else begin
result:=false;
stop:=count;
break;
end;
end;
rightstring:=copy(input,stop+1,length(input)-stop)
end;

(*************************************

Name: parsemail

Description: utility that converts a GW5.5 address (user.com.domain) into
             a 'normal' address (user@domain.com)

IN: address - string containging address to process

OUT: NONE

RETURNS: string containing the modified address

******************************************)
function parsemail(address:string):string;
var tempout,tempstring,left1string,right1string,left2string,right2string:string;
begin
parseleft(address,left1string,right1string);
parseleft(right1string,left2string,right2string);
tempstring:=left1string+'@'+right2string+'.'+left2string;
if (tempstring[length(tempstring)]='.') then
tempstring:=copy(tempstring,1,length(tempstring)-1);
if (tempstring[length(tempstring)]='@') then
tempstring:=copy(tempstring,1,length(tempstring)-1);
result:=tempstring;
end;

(*************************************

Name: getaddress

Description: determines whether an address is a 'normal' address or a
             GW5.5 address and returns a 'normal' address

IN: address - string containing the address to check

OUT: NONE

RETURNS: string containing a normal address

******************************************)
function getaddress(address:string):string;
var tempstring:string;
begin
counter:=0;
if pos('@',address)= 0 then begin
result:=parsemail(address);
end else
result:=address;
end;


(*************************************

Name: checkbook

Description: checks a single book for a display name and if found returns the email address
             associated with the display name

IN: name - string containing the display name to check
    book - variant containing the GroupWise addressbook to check

OUT: add - variant containing the GroupWise addresses found
     eaddress - string containing the email address associated with the first address in add

RETURNS: true if displayname found, false otherwise

******************************************)
function checkbook(name:string;var add:variant;book:variant;var eaddress:string):boolean;
var entries:variant;tempname:string;
begin
try
tempname:=name;
fixquotes(tempname); //clear quotes for WP
entries:=book.addressbookentries; //get the entries
add:=unassigned;
add:=entries.find('(Name MATCHES "'+tempname+'")'); //find the name
if not (add.count=0) then begin //if a name was found
eaddress:=add.item(1).emailaddress; //get the first one
result:=true; end else
result:=false;
except result:=false; end;
end;

(*************************************

Name: checkgroup

Description: Checks whether an address is a group and returns the members
             of the group if it is

IN: add - variant containing the GroupWise addresses to check (only first address checked)
    book - variant containing the GroupWise addressbook to check

OUT: group - variant containing the GroupWise group address found
     mems- variant containing the GroupWise group member addresses found

RETURNS: true if it was a group, false otherwise

******************************************)
function checkgroup(add:variant;var group:variant;book:variant;var mems:variant):boolean;
var entries:variant; memnum:integer; temp:variant;
begin
try
entries:=book.addressbookentries;
group:=unassigned;
temp:=add.item(1);
group:=entries.item(temp); //get the first address from the book
if (not varisempty(group)) and (group.objtype=4) then begin //if it is in the book and is a group
mems:=group.members; //get the members
memnum:=mems.count;
result:=true; end else
result:=false;
except result:=false; end;
end;

(*************************************

Name: setupbooks

Description: function that retrieves all of the GroupWise addressbooks to check
             only needs to be called once per full search

IN: NONE

OUT: NONE

RETURNS: NONE

******************************************)
procedure setupbooks;
begin try
freqbook:=account.frequentcontacts;
if (not varisnull(freqbook)) and (not varisempty(freqbook)) then
freqname:=freqbook.name;
except end;
try
defbook:=account.Defaultaddressbook;
if (not varisnull(defbook)) and (not varisempty(defbook)) then
defname:=defbook.name;
except end;
{try
books:=account.addressbooks;
except end;}
try
sysbook:=account.systemaddressbook;
except end;
end;

(*************************************

Name: retrieveaddress

Description: searches groupwise for a user or groupname and adds it to a list of
             addresses

IN: name - string containing display name of user

OUT: list - tstringlist containing list of users
          will add all group members
          will not add ambiguous users

RETURNS: NONE

******************************************)
procedure retrieveaddress(name:string;var list:tstringlist);
var obj,booknum,num,members,count:integer;add,book,group,mems,mem,recip,mess,entries:variant;
done:boolean; bookname,eaddress:string;memnum:integer;
begin
done:=false;
try
if (not varisnull(freqbook)) and (not varisempty(freqbook)) then
done:=checkbook(name,add,freqbook,eaddress); //look in the frequent addresses
except done:=false; end;
if (not done) or (comparetext('',eaddress)=0) or ((comparetext(name,eaddress)=0) and (pos('@',eaddress)=0)) and (freqname<>defname) then //if it did not find an address
try
if (not varisnull(defbook)) and (not varisempty(defbook)) then
done:=checkbook(name,add,defbook,eaddress); //check the default personal book
except done:=false; end;
{if (not done) or (comparetext('',eaddress)=0) or ((comparetext(name,eaddress)=0) and (pos('@',eaddress)=0)) then begin //if it didn't find an address
done:=false;
if (not varisnull(books)) and (not varisempty(books)) then
for booknum := 1 to books.count do begin //check all the other personal books
book:=books.item(booknum);
bookname:=book.name;
obj:=book.objtype;
if (obj=1) and (not done) and (bookname<>freqname) and (bookname<>defname) then
begin
try
done:=checkbook(name,add,book,eaddress);
except done:=false; end;end;end;end;}
if (not done) or (comparetext('',eaddress)=0) or ((comparetext(name,eaddress)=0) and (pos('@',eaddress)=0)) then //if it didn't find an address
try
if (not varisnull(sysbook)) and (not varisempty(sysbook)) then
done:=checkbook(name,add,sysbook,eaddress); //check the system book
except done :=false; end;
if done and (add.count=1) then begin //if something was found in one of the books
if add.item(1).objtype=4 then begin //if it is a group
try
if (not varisnull(freqbook)) and (not varisempty(freqbook)) then
done:=checkgroup(add,group,freqbook,mems); //check the frequent contacts for the group
except done:=false; end;
if (not done) and (freqname<>defname) then //if it didn't find the group
try
if (not varisnull(defbook)) and (not varisempty(defbook)) then
done:=checkgroup(add,group,defbook,mems); //check the default book for the group
except done:=false; end;
{if not done then //if it didn't find the group
if (not varisnull(books)) and (not varisempty(books)) then
for booknum := 1 to books.count do begin //check the other personal books
book:=books.item(booknum);
bookname:=book.name;
obj:=book.objtype;
if (obj=1) and (not done) and (bookname<>freqname) and (bookname<>defname) then
try
done:=checkgroup(add,group,book,mems);
except done:=false; end;end;}
if not done then //if it didn't find the group
try
if (not varisnull(sysbook)) and (not varisempty(sysbook)) then
done:=checkgroup(add,group,sysbook,mems); //check the system book for the group
except done :=false end;
try
if done then //if it found a group anywhere
memnum:=mems.count;
for members:=1 to memnum do begin //get the members
mem:=mems.item(members);
if mem.emailaddress<>'' then
list.add(mem.emailaddress) else
list.add(mem.displayname);
end;
except end;
end else
list.add(eaddress);
end else begin
if add.count>1 then begin //if there is more than one address, warn about ambiguous address
setforegroundwindow(application.handle);
messagedlg(name+ambiguoususer,mtinformation,[mbOK],0);
end;
list.add(name);
end;
end;



(*************************************

Name: select users

Description: gets the names entered into the GroupWise message window and retrieves
             their addresses and returns a list of the addresses

IN: NONE

OUT: NONE

RETURNS: tstringlist containing a list of the addresses

******************************************)
function tform1.selectusers:tstringlist;
var messageid,temp,test,users:string;count,curr,next:integer;tempselected:tstringlist;num:integer;
begin
setupbooks; //sets up the addressbooks
curr:=1;
next:=0;
num:=0;
     setforegroundwindow(application.handle);
statform.progress.position:=0; //set up the progress bar
statform.caption:=searching;
statform.cancelbtn.hide;
statform.statlabel.caption:=findingkeys;
     statform.statlabel.Alignment:=taCenter;
if pgp.encryptone then
statform.show;
application.processmessages;
     wpo.CommandString := 'ItemMessageIDFromView()'; //get the names
     messageid:=wpo.CommandReturn;
     wpo.commandstring:='itemgettext("'+messageid+'";to!)';
     users:=wpo.commandreturn;
          wpo.commandstring:='itemgettext("'+messageid+'";cc!)';
     if wpo.commandreturn<>'' then
     users:=users+delimiter+wpo.commandreturn;
      wpo.commandstring:='itemgettext("'+messageid+'";bc!)';
     if wpo.commandreturn<>'' then
     users:=users+delimiter+wpo.commandreturn;
     tempselected:=tstringlist.create; //create a temporary list
     if length(users) > 0 then begin //if there are users
       repeat
       statform.progress.position:=statform.progress.position+15;
       next:=pos(delimiter,users);
       if next<>0 then begin
       num:=num+1;
       temp:=copy(users,1,next-1);
        users:=copy(users,next+1,length(users)-next); //get the next name
              end else
              begin
       temp:=users;
       users:='';
       end;

       while pos(' ',temp)=1 do //clear the leading spaces
       delete(temp,pos(' ',temp),1);
       retrieveaddress(temp,tempselected); //get the user's address and add it to the list - add multiple if a group
      until next =0;
      statform.progress.position:=100;
      for count:= 0 to (tempselected.count -1) do begin //if the address is quoted, pull it out of the quotes
       temp:=tempselected.strings[count];
       if pos('"',temp)>0 then
       begin
       temp:=copy(temp,pos('"',temp)+1,length(temp)-pos('"',temp));
       if pos('"',temp) >0 then
       test:=copy(temp,1,pos('"',temp)-1) else
       test:=copy(temp,1,length(temp));
       tempselected.strings[count]:=test;
      end;
      {$IFDEF GW52}
      {$ELSE}
        tempselected.strings[count]:=getaddress(tempselected.strings[count]); //if GW5.5, then fix the address format
        {$ENDIF}
       end;
       end;
        result:=tempselected; //return the list
        statform.hide;
end;


(*************************************

Name: processname

Description: utility function that separates full file name and path into name and path

IN: name - string containing the full file and path

OUT: fname - string containing filename
     fpath - string containing filepath

RETURNS: NONE

******************************************)
procedure processname(name:string; var fname,fpath:string);
begin
     fname := ExtractFileName(name);
     fpath := ExtractFilePath(name);
end;



(*************************************

Name: tform1.getfield

Description: returns the value of a field in groupwise

IN: fieldname - string containing the name of the field to check.  Constant values are:
                       ignoreinternalfield
                       richeditfield
                       isdefaultfield


OUT: NONE

RETURNS: True if the field is set, false if not set or field does not exist

******************************************)
   function tform1.getfield(fieldname:string):boolean;
    var box,fields,thefield:variant;
       begin
       result:=false;
        box:=account.mailbox;
       fields:=box.fields;
       thefield:=fields.item(fieldname,2);
       result:=boolean(thefield.value);
   end;

(*************************************

Name: tform1.setfield

Description: sets the value of a field; if field does not exist then adds it

IN: fieldname - string containing name of field; same constants as getfield
    setting - boolean of what new value

OUT: NONE

RETURNS: NONE

******************************************)

   procedure tform1.setfield(fieldname:string;setting:boolean);
   var box,fields,thefield:variant;
   begin
 try
        box:=account.mailbox;
       fields:=box.fields;
       thefield:=fields.item(fieldname,2);
       thefield.value:=word(setting);
       except fields.add(fieldname,2,word(setting)); end;   end;


(*************************************

Name: tform1.setupfields

Description: initialization procedure that: Verifies fields exist
                                            Creates them if not
                                            loads the values or default if created

IN: NONE

OUT: NONE

RETURNS: NONE

******************************************)
procedure tform1.setupfields;
var fielddefs,thedef:variant;
begin
fielddefs:=account.fielddefinitions;

try
thedef:=fielddefs.item(dontshowaddressfield,2);
dontshow:=false;
dontshow:=getfield(dontshowaddressfield);
except try thedef:=fielddefs.add(dontshowaddressfield,2); except end;
setfield(dontshowaddressfield,false);
end;

try
thedef:=fielddefs.item(ignoreinternalfield,2);
ignoreinternal:=false;
ignoreinternal:=getfield(ignoreinternalfield);
except try thedef:=fielddefs.add(ignoreinternalfield,2); except end;
setfield(ignoreinternalfield,false);
end;
ignoreinternal:=false;
//richedit is a potential addition and is thus left in
(*try
thedef:=fielddefs.item(richeditfield,2);
richedit:=getfield(richeditfield);
except thedef:=fielddefs.add(richeditfield,2);
setfield(richeditfield,false);
end;*)
richedit:=false;
try
thedef:=fielddefs.item(isdefaultfield,2);
pgpisdefault:=true;
pgpisdefault:=getfield(isdefaultfield);
except try thedef:=fielddefs.add(isdefaultfield,2);except end;
setfield(isdefaultfield,true);
end;
pgpisdefault:=true;
end;

(*************************************

Name: tform1.init

Description: key initialization procedure

IN: NONE

OUT: NONE

RETURNS: NONE

******************************************)
procedure tform1.init;
var
   tmpname,parmstr:string;
   lines : integer;
   ini:textfile;
sysdir:array[0..MAX_PATH] of char;
winpath:array[0..MAX_PATH] of char;
   keyH1,keyH2:Hkey ;
   count,cd,loaded:longint;
   lang:array[0..2] of char;
   len,err:longint;
   tpath,tprog:string;
   temppath:pchar;
inifile:tinifile;
mess:variant;
begin
(*GroupWise:=CreateOleObject('NovellGroupWareSession');
Account:=GroupWise.Login;
form1.reply:=false;
{$IFDEF GW52}
owneraddress:=account.owner.emailaddress;
{$ELSE}
owneraddress:=getaddress(account.owner.emailaddress);
{$ENDIF}*)
gwhandle:=0;
for count:=0 to 254 do begin
messforms[count] :=nil;
end;
err:=1;

   getwindowsdirectory(sysdir,MAX_PATH);
   form1.filedial.initialdir:=strpas(sysdir);
   windir:=strpas(sysdir)+'\';
   begin //sets up the initial directories
       processname(pgp.PGPPubRing,tprog,tpath);
        PGP.PGPProg:=tprog;
        gettemppath(MAX_PATH,winpath);
             temppath:=stralloc(MAX_PATH);
     PGPcomdlgGetPGPPath(temppath,MAX_PATH);
        form1.savedial.InitialDir :={form1.PGP.PGPPath}strpas(temppath);
             strdispose(temppath);
   end;
(*   if pos('$$$',owneraddress)=0 then
begin
SetupFields; //setup the fields
if not form1.dontshow then
if not pgp.checkandadd(owneraddress) then //dont show again, if requested
setfield(dontshowaddressfield,true);
end;*)
end;




(*************************************

Name: Tform1.formcreate

Description: automatically called on form creation

IN: Sender - whatever is calling the method

OUT: NONE

RETURNS: NONE

******************************************)
procedure TForm1.FormCreate(Sender: TObject);
var
  i: integer;
 const
 ScreenWidth: LongInt = 800;
  ScreenHeight: LongInt = 600;

begin

pgp:=tpgp5.create(form1);


 OK:=1;
 passthrough:=false;
{ geautoscale(self);}
init ;
end;


(*************************************

Name: decryptfile

Description: primary file decryption procedure

IN: tmpfile - string containing filename to decrypt

OUT: tmpfile - string containing filename of the decrypted file
     status - statrec with signature status of the decrypted file

RETURNS: true if no errors, false otherwise or if canceled

******************************************)
function decryptfile(var tmpfile:string;var status:statrec):boolean;
var ext:string;
begin
   ext:=ExtractFileExt(tmpfile);
   if ext='.doc' then begin
   status.checked:=false;
   result:=true;
   end else
   result:=(form1.pgp.decrypt(tmpfile,status,true)=0);
end;


(*************************************

Name: decrypttext

Description: primary text decryption procedure

IN: tmpfile - string containing text to decrypt

OUT: tmpfile - string containing decrypted text
     status - statrec with signature status of the decrypted text

RETURNS: true if no errors, false otherwise or if canceled

******************************************)
function decrypttext(var tmpfile:string;var status:statrec):boolean;
begin
result:= (form1.pgp.decrypt(tmpfile,status,false) =0);
end;

(*************************************

Name: decryptattach

Description: decrypt all attachments of a message

IN: oldmess - variant containing GroupWise message that is decrypted
    newmes - variant containing Groupwise message that will get attachment (may be nil modres<>mrYes)
    modres - type of decryption to do
             mrYes - add attachments to groupwise message
             mrNo - save attachments to disk via file dialogs

OUT: newmes - variant contains GroupWise message with attachments

RETURNS: NONE

******************************************)
procedure decryptattach(oldmess:variant; newmes:variant;modres:integer);
var
classid,messageid,dispname,fname,fpath,savefile,tempstr,tmpfile,num:string;status:statrec;
doc:integer;openold:boolean;flags:integer;fileinfo:tshfileinfo;
holdmess,att,atts,attmess:variant;
begin
messageid:=oldmess.messageid;
openold:=false;
  num:='0';
 form1.WPO.CommandString := 'ItemAttachmentGetCount("'+messageid+'")'; //count the attachments
 num := form1.WPO.CommandReturn;
if modres=mrYes then //if groupwise
if (strtoint(num)-1) >0 then begin
if form1.richedit then begin
tempstr:=newmes.bodytext.rtf +chr(13)+chr(10)+'Attachments: '+chr(13)+chr(10); //add a heading
newmes.bodytext.rtf:=tempstr;
end else begin
tempstr:=newmes.bodytext.plaintext +chr(13)+chr(10)+'Attachments: '+chr(13)+chr(10);
newmes.bodytext.plaintext:=tempstr;
end;
tempstr:='';
end;

for doc := 0 to (strtoint(num)-1) do //for each document

begin
form1.wpo.commandstring:='itemattachmentgetclass("'+messageid+'";'+inttostr(doc)+')'; //find out the type of attachment
classid:=form1.wpo.commandreturn;
form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')'; //get the attachment name
dispname:=form1.wpo.commandreturn;
{if classid='2' then begin
att:=oldmess.attachments.item(doc+1);
attmess:=account.getmessage(att.message.messageid);
atts:=newmes.attachments;
att:=atts.add(oldmess,'message');
end;}
if (pos('Token failed',dispname)=0) and (classid<>'2') then begin //if the attachment is not a message or an OLE Object
processname(dispname,fname,fpath);
if classid='1' then begin //if it is a regular file
tmpfile:=form1.pgp.pgppath+fname;
savefile:=tmpfile;
form1.WPO.CommandString := 'ItemAttachmentSaveAs ("'+messageid+'";'+inttostr(doc)+';"' + savefile+'")'; //save the file
if not decryptfile(tmpfile,status) then
tmpfile:=savefile
{form1.pgp.wipefile(savefile)}
else //decrypt the file
if comparetext(tmpfile,savefile)<>0 then //wipe the old file if there is a new file
form1.pgp.wipefile(savefile);
end;
if fileexists (tmpfile) then begin //if I have a file
if modres=mrYes then begin //if making a groupwise message
try
application.processmessages;
processname(tmpfile,fname,fpath);
newmes.attachments.add(tmpfile); // add the file as an attachment
except end;
try
statform.progress.position:=statform.progress.position+trunc(60/(strtoint(num)));
if form1.richedit then begin //add status information to the message
tempstr:=newmes.bodytext.rtf;
newmes.bodytext.rtf:=tempstr+fname+' is attached. '+status.mess+chr(13)+chr(10);
end else begin
tempstr:=newmes.bodytext.plaintext;
newmes.bodytext.plaintext:=tempstr+fname+' is attached. '+status.mess+chr(13)+chr(10);
end;
tempstr:='';
finally form1.pgp.wipefile(tmpfile); end;end; //wipe the file no matter what
if (modres=mrNo) then begin //if saving to disk
if status.mess <>'' then begin //show the signature info
setforegroundwindow(application.handle);

messagedlg(status.mess,mtinformation,[mbOK],0);
end;
form1.savedial.filename:=extractfilename(tmpfile); //show the file dialog
form1.savedial.title:= chooseloc + Inttostr(doc);
Flags:=  SHGFI_TYPENAME;
 SHGetFileInfo(pchar(tmpfile),0,FileInfo,SizeOf(FileInfo),Flags);
 form1.savedial.filterindex:=1;
 if status.key then
   form1.SaveDial.filter:='PGP Key Files (*'+extractfileext(tmpfile)+')|*'+extractfileext(tmpfile)+allfiles
 else if extractfileext(tmpfile)<>'' then
 form1.SaveDial.filter:=strpas(fileinfo.sztypename)+' (*'+extractfileext(tmpfile)+')|*'+extractfileext(tmpfile)+'|'+allfiles else
      form1.savedial.filter:=allfiles;
  form1.savedial.defaultext:='';
if form1.savedial.execute and (form1.savedial.filename <> '') then begin //save the file
      if form1.savedial.FilterIndex=1 then form1.savedial.DefaultExt:=copy(extractfileext(tmpfile),2,3)
   else form1.savedial.defaultext:='';
   form1.savedial.initialdir:=extractfilepath(form1.savedial.filename);
   if comparetext(tmpfile,form1.savedial.filename)<>0 then
   sysutils.deletefile(form1.savedial.filename);
   renamefile(tmpfile,form1.savedial.filename);
   end else
   form1.pgp.wipefile(tmpfile); //wipe on cancel

end;
end;
end else begin
if modres=mryes then begin //if a groupwise message then mark that couldn't transfer an OLE or message attachment
if form1.richedit then begin
tempstr:=newmes.bodytext.rtf;
newmes.bodytext.rtf:=tempstr+attachmentmissing+chr(13)+chr(10);
end else begin
tempstr:=newmes.bodytext.plaintext;
newmes.bodytext.plaintext:=tempstr+attachmentmissing+chr(13)+chr(10);
end;
end;
messagedlg(oleattached,mtwarning,[mbOK],0);
end;
end;
end;




(*************************************

Name: setuptypes

Description: copies type specific info from old message to new message

IN: oldmess - variant containing GroupWise message that was decrypted
    newmess - variant containing the GroupWise message to copy to

OUT: newmess - variant containing the updated GroupWise message

RETURNS: NONE

******************************************)

procedure setuptypes(var newmess,oldmess:variant);
var messtype:string;tempstring:string;
begin   try
messtype:=oldmess.classname;//what type of message?
if (CompareText('GW.MESSAGE.APPOINTMENT',Copy(messtype,1,22)) = 0) then begin //if appointment
{newmess.duration:=oldmess.duration;}
newmess.startdate:=oldmess.startdate;
newmess.enddate:=oldmess.enddate;
newmess.place:=oldmess.place;
end;

if (CompareText('GW.MESSAGE.NOTE',Copy(messtype,1,15)) = 0) then begin //if note
newmess.startdate:=oldmess.startdate;
end;
if (CompareText('GW.MESSAGE.PHONE',Copy(messtype,1,16)) = 0) then begin //if phone message
tempstring:=oldmess.CallerCompany;
newmess.CallerCompany:=tempstring;
newmess.CallerName :=oldmess.CallerName;
newmess.CameToSee :=oldmess.CameToSee;
newmess.PhoneNumber :=oldmess.PhoneNumber;
newmess.PleaseCall :=oldmess.PleaseCall;
newmess.ReturnedCall :=oldmess.ReturnedCall;
newmess.Telephoned :=oldmess.Telephoned;
newmess.Urgent :=oldmess.Urgent;
newmess.WantsToSee :=oldmess.WantsToSee;
newmess.WillCall :=oldmess.WillCall;

end;
if (CompareText('GW.MESSAGE.TASK',Copy(messtype,1,15)) = 0) then begin //if task
newmess.assigneddate:=oldmess.assigneddate;
newmess.duedate:=oldmess.duedate;
newmess.startdate:=oldmess.startdate;
newmess.taskcategory:=oldmess.taskcategory;
newmess.taskpriority:=oldmess.taskpriority;
end;
except end;
end;


function truefalse(field:boolean):string; //converts a boolean into 'Yes' or 'No' in return value
begin
if field then result:='*' else
result:=' ';
end;

(*************************************

Name: setupmesstypes

Description: puts message specific information into the decrypted message view

IN: status - statrec containing signature info
    oldmess - variant containing the GroupWise message that was decrypted

OUT: NONE

RETURNS: NONE

******************************************)
procedure setupmesstypes(status:statrec;oldmess:variant;messform:tmessform);
var messtype:string;typeinfo,temp:string;
begin
try
messtype:=oldmess.classname; //what type of message
if (CompareText('GW.MESSAGE.APPOINTMENT',Copy(messtype,1,22)) = 0) then begin //if an appointment
typeinfo:=place+oldmess.place;
messform.messmemo.lines.insert(0,'');
messform.messmemo.lines.insert(0,typeinfo);
typeinfo:=duration+copy(timetostr(oldmess.duration),1,8);
messform.messmemo.lines.insert(0,typeinfo);
datetimetostring(typeinfo,'ddd, mmm d, yyyy h:nn AM/PM'  ,oldmess.enddate);
messform.messmemo.lines.insert(0,enddate+typeinfo);
datetimetostring(typeinfo,'ddd, mmm d, yyyy h:nn AM/PM'  ,oldmess.startdate);
messform.messmemo.lines.insert(0,startdate+typeinfo);
end;

if (CompareText('GW.MESSAGE.NOTE',Copy(messtype,1,15)) = 0) then begin //if a note
typeinfo:=startdate+datetimetostr(oldmess.startdate);
messform.messmemo.lines.insert(0,'');
messform.messmemo.lines.insert(0,typeinfo);
end;
if (CompareText('GW.MESSAGE.PHONE',Copy(messtype,1,16)) = 0) then begin //if a phone message
messform.messmemo.lines.insert(0,'');
typeinfo:='['+truefalse(oldmess.WillCall)+'] '+WillCallMess;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo :='['+truefalse(oldmess.WantsToSee)+'] '+WantsToSeemess;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo :='['+truefalse(oldmess.Urgent)+'] '+UrgentMess;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo :='['+truefalse(oldmess.PleaseCall)+'] '+PleaseCallMess;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo :='['+truefalse(oldmess.CameToSee)+'] '+CameToSeeMess;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo :='['+truefalse(oldmess.ReturnedCall)+'] '+ReturnedCallMess;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo :='['+truefalse(oldmess.Telephoned)+'] '+TelephonedMess;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo:=CallerCompanyMess+oldmess.CallerCompany;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo :=PhoneNumberMess+oldmess.PhoneNumber;
messform.messmemo.lines.insert(0,typeinfo);
typeinfo :=CallerNameMess+oldmess.CallerName;
messform.messmemo.lines.insert(0,typeinfo);

end;
if (CompareText('GW.MESSAGE.TASK',Copy(messtype,1,15)) = 0) then begin //if a task
messform.messmemo.lines.insert(0,'');
typeinfo:=duedatemess+datetimetostr(oldmess.duedate);
messform.messmemo.lines.insert(0,typeinfo);
typeinfo:=startdate+datetimetostr(oldmess.startdate);
messform.messmemo.lines.insert(0,typeinfo);
typeinfo:=assigneddatemess+datetimetostr(oldmess.assigneddate);
messform.messmemo.lines.insert(0,typeinfo);
typeinfo:=taskcategorymess+oldmess.taskcategory;
typeinfo:=typeinfo+' '+taskprioritymess+inttostr(oldmess.taskpriority);
messform.messmemo.lines.insert(0,typeinfo);
end;
   except end;

end;

(*Not used - adds one to a message id - used to convert an outbox messageid into the inbox messageid*)
function receivedid(messid:string):string;
var right1,right2, left1,left2,newtoken:string;
begin
parseright(messid,left1,right1);
parseright(left1,left2,right2);
newtoken:=inttohex(strtoint('$'+right2)+1,length(right2));
result:=left2+'.'+newtoken+'.'+right1;
end;




(*************************************

Name: decrypt

Description: main decryption procdure

IN: gwmess - variant containing the GroupWise message to decrypt

OUT: NONE

RETURNS: NONE

******************************************)
function decrypt(var gwmess:variant):boolean;
var
eline,tmpfile:string;TMP:string ;status:statrec;
   fname:textfile; count:longint;
   modres:integer;
   recip,tempmes,newmes:variant;
   origmess,messid,dateinfo,subinfo,frominfo,siginfo:string;
   ok,done:boolean;

dispname,eaddress,etype,messtext,messtype:string;
begin
try
   tmpfile:=gwmess.bodytext.plaintext; //get the text
     {$ifdef debug}
     log(tmpfile+' is assigned');
     log('Text to decrypt is '+gwmess.bodytext.plaintext);
     {$endif}
   except
   {$ifdef debug}
   log('writing message failed');
   {$endif}
   end;
    for count:=0 to 254 do
     if assigned(messforms[count]) then
        if messforms[count].messageid=gwmess.messageid then begin
        setforegroundwindow(messforms[count].handle);
        application.processmessages;
        exit;
     end;

   if not decrypttext(tmpfile,status) then //decrypt the text - continue if OK
       result:=false
      else
    begin
    result:=true;
          try
          {$ifdef debug}
          log(tmpfile + ' exists');
          {$endif}
      form1.pgp.cleandecrypt;
     for count:=0 to 254 do begin
     if not assigned(messforms[count]) then
     begin
     application.createform(tmessform,messforms[count]);
     messform:=messforms[count];
     messform.winnum:=count;
     break;
     end;
     end;
     if assigned(messform) then begin
     messform.messvar:=gwmess;
     messform.messageid:=gwmess.messageid; //set up the variable to display
     messtype:=gwmess.classname;
     siginfo:=status.mess;
     messform.caption:=mailfrom+gwmess.fromtext;
     frominfo:=fromintro+ gwmess.fromtext;
     messform.fromedit.text:=gwmess.fromtext;
     messform.fromlist.text:=gwmess.sender.emailaddress{+'^'+gwmess.sender.emailtype};
     if form1.richedit then
     subinfo:=gwmess.subject.rtf
     else
     subinfo:=gwmess.subject.plaintext;
     messform.subjectedit.text:=gwmess.subject.plaintext;
     for count:=1 to gwmess.recipients.count do begin
     recip:=gwmess.recipients.item(count);
     dispname:=recip.displayname;
      eaddress:=recip.emailaddress;
      etype:=recip.emailtype;
     if recip.targettype=0
     then begin
     messform.toedit.items.add(dispname);
     if messform.toedit.items.count=1 then
     messform.tocombo.text:=messform.toedit.items[0] else
     messform.tocombo.text:=messform.tocombo.text+'; '+messform.toedit.items[(messform.toedit.items.count-1)];
     messform.tolist.items.add(eaddress{+'^'+etype});
     end;
     if recip.targettype=1
     then begin
     messform.ccedit.items.add(dispname);
     messform.cclist.items.add(eaddress{+'^'+etype});
      if messform.ccedit.items.count=1 then
     messform.cccombo.text:=messform.ccedit.items[0] else
     messform.cccombo.text:=messform.cccombo.text+'; '+messform.ccedit.items[messform.ccedit.items.count-1];

     end;
     end;
     datetimetostring(dateinfo,'ddd, mmm d, yyyy h:nn AM/PM'  ,gwmess.creationdate);
     messform.statbar.simpletext:=datehead+dateinfo;
     messform.messmemo.clear; //clear what is there now
     messform.filllist; //setup the list of attachments
     messform.messmemo.lines.text:=tmpfile; //put the decrypted text into the memo

     setupmesstypes(status,gwmess,messform); //fill in type specific information


     done:=false;

(*     repeat
     application.processmessages;*)
  try
   tmpfile:=messform.messmemo.lines.text//get the text
   except

   end;
   if (pos('-----BEGIN PGP',tmpfile)>0) then begin
   messform.decmess.enabled:=true;
   messform.DecryptVerifyMessage1.enabled:=true;
   end
   else begin
   messform.decmess.enabled:=false;
   messform.DecryptVerifyMessage1.enabled:=false;
   end;

        messform.show;
        application.title:=messform.Caption;
        messform:=nil;
      //show the decrypted message and wait until a button is clicked
end;
         except
         end;
     end;
     gwmess:=unassigned;
form1.pgp.cleandecrypt; //clean up the decrypt variables
end;

(*************************************

Name: tform1.decryptclick

Description: this is the 'META' decrypt procedure - it is called from the C3PO
             it determines whether there is a decrypted message and calls the decryption routine

IN: sender - TObject containing the calling object - can be application

OUT: NONE

RETURNS: NONE

******************************************)
procedure TForm1.DecryptClick(Sender: TObject);
var
   messageid:string;
   eline,tmpfile:string;
   fname:textfile;
   gwmess,tempmes,newmes:variant;
    handle:string;
    count:integer;

begin
form1.hide;
messageid:='X00';
wpo.commandstring:='envcheckcurrentwindow(624)'; //see if this is the browser window
if wpo.commandreturn='TRUE' then begin //if so
wpo.commandstring:='itemlistcreatefromcontrol(219;1;)'; //get the list of selected messages
handle:=wpo.commandreturn;

 if CompareText('Token',Copy(handle,1,5))<>0 then begin
   wpo.commandstring:='itemlistgetcount('+handle+')';
 eline:=wpo.commandreturn;
 for count :=0 to (strtoint(eline)-1) do begin
wpo.commandstring:='itemlistgetitem('+handle+';'+inttostr(count)+')';//get the first message
messageid:=wpo.commandreturn ;
    gwmess:=account.getmessage(messageid);
     pgp2.decrypt(gwmess);
     form1.wpo.commandstring:='Refresh()';
     end;
     wpo.commandstring:='itemlistdelete('+handle+')';
     end;
 end else begin //if not the browser, then get the message
     wpo.CommandString := 'ItemMessageIDFromView()';
     messageid:=wpo.CommandReturn;
     if messageid<>'X00' then begin //if this is new message, then decrypt
    gwmess:=account.getmessage(messageid);
     pgp2.decrypt(gwmess);
     form1.wpo.commandstring:='Refresh()';
     end else begin
     application.processmessages;
     setforegroundwindow(application.handle);
     ShowMessage(incomingonly);
    end;
      end;
     end;

(*************************************

Name: mail_key

Description: mails a key

IN: selectstat - integer to determine what type of key to mail
               mailkeyselect - user select one or more keys to mail
               mailkeydefault - mail default key

OUT: NONE - but sets up a mail message

RETURNS: true if no error, false if cancel or error

******************************************)
function mail_key(selectstat:integer):boolean;
var eline,tmpkeys:string;
efile:textfile;
begin
result:=false;
if form1.PGP.ExtractKey(selectstat,tmpkeys) then begin //if we get the key
   form1.wpo.CommandString := 'ItemSetText("X00"; Message!; "'+tmpkeys+'";Yes!)';//mail it
   result:=true;
end;
end;


(*************************************

Name: Tform1.Key_to_ringclick

Description: imports a key from the message onto the keyring

IN: sender - TObject containing the calling object - can be application

OUT: NONE

RETURNS: NONE

******************************************)
procedure TForm1.Key_To_RingClick(Sender: TObject);
var handle:string;

messageid,tmpfile,parmstr:string;
fname:textfile;
begin
messageid:='X00';
tmpfile := PGP.PGPPath + 'temppgp.asc';
wpo.commandstring:='envcheckcurrentwindow(624)'; //check if browser
if wpo.commandreturn='TRUE' then begin //if browser
wpo.commandstring:='itemlistcreatefromcontrol(219;1;)';//get list of messages
handle:=wpo.commandreturn;
wpo.commandstring:='itemlistdelete';
 if CompareText('Token',Copy(handle,1,5))<>0 then begin
wpo.commandstring:='itemlistgetitem('+handle+';0)'; //get the first message
messageid:=wpo.commandreturn ;
end;

end else begin //if not browser
     wpo.CommandString := 'ItemMessageIDFromView()'; //get the messageid
     messageid:=wpo.CommandReturn;
     end;
if messageid = 'X00' then begin //if new message then show error
application.processmessages;
setforegroundwindow(application.handle);
MessageDlg(incomingonly, mtInformation, [mbOK], 0);
end
else begin //if not a new message

tmessage:=account.getmessage(messageid); //get the message
(*try

{PGP.AddKey(tmessage.bodytext.plaintext); //import the key}
except end;*)
end;
end;



(*Automatically called on close - can be used for cleanup*)
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
{empty}
end;



procedure TForm1.FormDestroy(Sender: TObject);
begin
pgp.destroy;
end;

procedure TForm1.SaveDialTypeChange(Sender: TObject);
begin
   if form1.savedial.FilterIndex=1 then form1.savedial.DefaultExt:=copy(form1.savedial.filter,pos('|',form1.savedial.filter)+3,3)
   else form1.savedial.defaultext:='';
end;

procedure TForm1.SaveDialCanClose(Sender: TObject; var CanClose: Boolean);
begin
canclose:=true;
if(form1.savedial.filename <> '') then begin
      if form1.savedial.FilterIndex=1 then form1.savedial.DefaultExt:=copy(form1.savedial.filter,pos('|',form1.savedial.filter)+3,3)
   else form1.savedial.defaultext:='';
   {form1.savedial.filename+'.'+form1.savedial.DefaultExt;}
   end;
end;

end.
