unit PGPBASE;

interface
Uses WinTypes,
     WinProcs;
{     pgpPFLConfig;}

Type

{+//____________________________________________________________________________ }
{-pgpBase.h }

{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-This file deals with system dependencies to derive our very basic data }
{-types. It should not contain any higher level types. }

{-$Id: Pgpbase.pas,v 1.5.12.2 1999/08/27 22:00:46 build Exp $ }
{=____________________________________________________________________________ }


{+//____________________________________________________________________________ }
{-PGP basic types }
{=____________________________________________________________________________ }

PGPBoolean = Byte;{= can be TRUE or FALSE }
{+// PGPUInt8, PGPInt8 */ }
PGPUInt8 = Byte;
PGPInt8 = shortint;


{+// PGPUInt16, PGPInt16 */ }


PGPUInt16 = Word;
PGPInt16 = smallint;


{+// PGPUInt32, PGPInt32 */ }


PGPUInt32 = longword{Cardinal};
PGPInt32 = longint;

PGPUInt64 = int64;
PGPInt64 = int64;


PGPByte = PGPUINT8;

PGPError = PGPINT32;

{+// a simple value sufficient to hold any numeric or pointer type */ }
PGPUserValue = Pointer;

{+// A PGPSize refers to in memory sizes. Use PGPFileOffset for file offsets */ }
PGPSize = integer;

{+// An offset or size of a file */ }
PGPFileOffset = PGPINT32;
PGPFlags = PGPUINT32;
PGPTime = PGPUINT32;
PGPTimeInterval = PGPUINT32; {= In milliseconds }


PGPVersion = record
                 majorVersion: PGPUINT16;
                 minorVersion: PGPUINT16;
     end; {PGPVersion}
     ppgpbyte=^pgpbyte;

{+//____________________________________________________________________________ }
{-These macros should surround all C declarations in public }
{-header files which define function or data symbols. }
{=____________________________________________________________________________ }

const
{TRUE=1;
FALSE=0;}
MAX_PGPUInt8 = $ff;
MAX_PGPInt8 = 127;
MAX_PGPUInt16 = $ffff;
MAX_PGPInt16 = 32767;
MAX_PGPUInt32 = $FFFFFFFF;
MAX_PGPInt32 = 2147483647;
PGP_HAVE64 = 0;
MAX_PGPUInt64 = MAX_PGPUInt32;
MAX_PGPInt64 = MAX_PGPInt32;
kPGPEnumMaxValue = MAX_PGPUInt32;
MAX_PGPSize =   MAX_PGPUInt32;

function pgpMin(x:PGPint32;y:PGPint32):PGPint32;
function pgpMax(x:PGPint32;y:PGPint32):PGPint32;



implementation

function pgpMin(x:PGPint32;y:PGPint32):PGPint32;
begin
if x<y then result:=x else
result:=y
end;


function pgpMax(x:PGPint32;y:PGPint32):PGPint32;
begin
if x>y then result:=x else
result:=y
end;

end.
