unit PGPENCODES;

interface
Uses WinTypes,
     WinProcs,
     pgpPubTypes,
     pgpSymmetricCipher,
     pgpCipherFeedback,
     pgpHash,pgpBase,
     pgptls,
     pgputilities;


Type
PGPEventType=pgpint32;
PGPAnalyzeType=pgpint32;

PGPLineEndType=pgpint32;
PGPLocalEncodingFlags = PGPFLAGS;
{+//____________________________________________________________________________ }
{-pgpEncode.h }

{-Copyright (C) 1997 Pretty Good Privacy; Inc. }
{-All rights reserved. }

{-This file contains the prototypes for functions which build PGPOptionLists }
{-and encode/decode files and buffers. }

{-$Id: Pgpencodes.pas,v 1.4.12.2 1999/08/27 22:00:47 build Exp $ }
{=____________________________________________________________________________ }


{+// }
{-* The PGPEvent structure is used to notify clients of the encode API of }
{-* various events. }
{= }

{+// Individual event information structs; combined as a union in PGPEvent }


PGPEventNullData = record
                           bytesWritten: PGPFILEOFFSET;
                           bytesTotal: PGPFILEOFFSET;
                         end; {PGPEventNullData_}


PGPEventErrorData = record
                            error: PGPERROR;
                            errorArg: Pointer;
                          end; {PGPEventErrorData_}


PGPEventWarningData = record
                              warning: PGPERROR;
                              warningArg: Pointer;
                            end; {PGPEventWarningData_}


PGPEventEntropyData = record
                              entropyBitsNeeded: PGPUINT32;
                            end; {PGPEventEntropyData_}


PGPEventPassphraseData = record
                                 fConventional: PGPBOOLEAN;
                                 keyset: PGPKEYSETREF;
                               end; {PGPEventPassphraseData_}


PGPEventRecipientsData = record
                                 recipientSet: PGPKEYSETREF;
                                 conventionalPassphraseCount: PGPUINT32;
                                 keyCount: PGPUINT32;
                                 keyIDArray: PGPKEYIDREF;
                               end; {PGPEventRecipientsData_}


PGPEventKeyFoundData = record
                               keySet: PGPKEYSETREF;
                             end; {PGPEventKeyFoundData_}


PGPEventSignatureData = record
                                signingKeyID: PGPKEYID;
                                signingKey: PGPKEYREF;
                                checked: PGPBOOLEAN;
                                verified: PGPBOOLEAN;
                                keyRevoked: PGPBOOLEAN;
                                keyDisabled: PGPBOOLEAN;
                                keyExpired: PGPBOOLEAN;
                                keyMeetsValidity: PGPBOOLEAN;
                                keyValidity:PGPValidity;
                                creationTime: PGPTIME;
                              end; {PGPEventSignatureData_}


PGPEventAnalyzeData = record
                              sectionType: PGPANALYZETYPE;
                            end; {PGPEventAnalyzeData_}


PGPEventOutputData = record
                             messageType: PGPUINT32;
                             suggestedName: PChar;
                             forYourEyesOnly: PGPBOOLEAN;
                           end; {PGPEventOutputData_}


PGPEventBeginLexData = record
                               sectionNumber: PGPUINT32;
                               sectionOffset: PGPSIZE;
                             end; {PGPEventBeginLexData_}


PGPEventEndLexData = record
                             sectionNumber: PGPUINT32;
                           end; {PGPEventEndLexData_}


PGPEventKeyGenData = record
                             state: PGPUINT32;
                           end; {PGPEventKeyGenData_}


PGPEventKeyServerData = record
{$IFDEF PGP6}
                                keyServerRef: PGPKEYSERVERREF;
                                state: PGPUINT32;

{$ELSE}
                                state: PGPUINT32;
                                soFar: PGPUINT32;
                                total: PGPUINT32;
{$ENDIF}
                              end; {PGPEventKeyServerData_}


PGPEventKeyServerSignData = record
{$IFDEF PGP6}
                                    keyServerRef: PGPKEYSERVERREF;
{$ELSE}
                                    state: PGPUINT32;
{$ENDIF}

                                  end; {PGPEventKeyServerSignData_}

{$IFDEF PGP6}
Type PGPEventKeyServerTLSData = record
                                   keyServerRef: PGPKEYSERVERREF;
                                   state: PGPUINT32;
                                   tlsSession: PGPTLSSESSIONREF;
                                 end {PGPEventKeyServerTLSData_};

Type PGPEventKeyServerIdleData = record
                                    keyServerRef: PGPKEYSERVERREF;
                                  end {PGPEventKeyServerIdleData_};


{$ENDIF}

Type PGPEventDecryptionData = record
                        cipherAlgorithm: PGPCIPHERALGORITHM;
                               end {PGPEventDecryptionData_};



{+// }
{-* The following events have no event-specific data defined for them: }
{-* kPGPEvent_InsertKeyEvent }
{-* kPGPEvent_RecursionEvent }
{-* kPGPEvent_DetachedSignatureEvent }
{-* kPGPEvent_InitialEvent }
{-* kPGPEvent_FinalEvent }
{= }

{+// Union of all event data structures above }

PGPEventData = record
                       case Word of
{$IFDEF PGP6}
                        1: (nullData: PGPEVENTNULLDATA);
                        2: (errorData: PGPEVENTERRORDATA);
                        3: (warningData: PGPEVENTWARNINGDATA);
                        4: (entropyData: PGPEVENTENTROPYDATA);
                        5: (passphraseData: PGPEVENTPASSPHRASEDATA);
                        6: (recipientsData: PGPEVENTRECIPIENTSDATA);
                        7: (keyFoundData: PGPEVENTKEYFOUNDDATA);
                        8: (signatureData: PGPEVENTSIGNATUREDATA);
                        9: (decryptionData: PGPEVENTDECRYPTIONDATA);
                       10: (analyzeData: PGPEVENTANALYZEDATA);
                       11: (outputData: PGPEVENTOUTPUTDATA);
                       12: (beginLexData: PGPEVENTBEGINLEXDATA);
                       13: (endLexData: PGPEVENTENDLEXDATA);
                       14: (keyGenData: PGPEVENTKEYGENDATA);
                       15: (keyServerData: PGPEVENTKEYSERVERDATA;);
                       16: (keyServerSignData:PGPEventKeyServerSignData);
                       17: (keyServerTLSData: PGPEVENTKEYSERVERTLSDATA);
                       18: (keyServerIdleData:PGPEventKeyServerIdleData);

{$ELSE}
                        1: (nullData: PGPEVENTNULLDATA);
                        2: (errorData: PGPEVENTERRORDATA);
                        3: (warningData: PGPEVENTWARNINGDATA);
                        4: (entropyData: PGPEVENTENTROPYDATA);
                        5: (passphraseData: PGPEVENTPASSPHRASEDATA);
                        6: (recipientsData: PGPEVENTRECIPIENTSDATA);
                        7: (keyFoundData: PGPEVENTKEYFOUNDDATA);
                        8: (signatureData: PGPEVENTSIGNATUREDATA);
                        9: (analyzeData: PGPEVENTANALYZEDATA);
                       10: (outputData: PGPEVENTOUTPUTDATA);
                       11: (beginLexData: PGPEVENTBEGINLEXDATA);
                       12: (endLexData: PGPEVENTENDLEXDATA);
                       13: (keyGenData: PGPEVENTKEYGENDATA);
                       14: (keyServerData: PGPEVENTKEYSERVERDATA);
                       15: (PGPEventKeyServerSignData:pgpeventkeyServerSignData);

{$ENDIF}
                     end; {PGPEventData_}

{+// Refs to internal "job" structure }

PGPJobRef = pointer;
PGPConstRef=pointer;
ptrpgpevent=^pgpevent;
PGPEVENT=record
                       version: PGPVERSION;{= Version of event structure }
                       nextEvent: ptrPGPEVENT;{= Allow lists of events }
                       job: PGPJOBREF;{= Associated with what job }
                       typev: PGPEVENTTYPE;{= Type of event }
                       data: PGPEVENTDATA; {= Event specific data }
                     end; {PGPEventData_}

mimearray=array[0..KPGPMIMESEPARATORSIZE] of char;

{PGPEventHandlerProc=function(context:PGPContextRef;event:PtrPGPEvent;UserValue:PGPUservalue): PGPError;
PGPEventHandlerProcPtr=^PGPEventHandlerProc;}
PGPEventHandlerProcPtr=tfarproc;
{PGPEventHandlerProcPtr=pointer;}


const
{+// PGP Event types }
	kPGPEvent_NullEvent			=  0;		{ Nothing happened }
	kPGPEvent_InitialEvent		=  1;		{ Initial event }
	kPGPEvent_FinalEvent		=  2;		{ Final event }
	kPGPEvent_ErrorEvent		=  3;		{ An error occurred }
	kPGPEvent_WarningEvent		=  4;		{ Warning event }
	kPGPEvent_EntropyEvent		=  5;		{ More entropy is needed }
	kPGPEvent_PassphraseEvent	=  6;		{ A passphrase is needed }
	kPGPEvent_InsertKeyEvent	=  7;		{ Smart card must be inserted }
	kPGPEvent_AnalyzeEvent		=  8;		{ Initial analysis event;
											   before any output }
	kPGPEvent_RecipientsEvent	=  9;		{ Recipient list report;
											   before any output }
	kPGPEvent_KeyFoundEvent		= 10;		{ Key packet found }
	kPGPEvent_OutputEvent		= 11;		{ Output specification needed }
	kPGPEvent_SignatureEvent	= 12;		{ Signature status report }
	kPGPEvent_BeginLexEvent		= 13;		{ Initial event per lexical unit}
	kPGPEvent_EndLexEvent		= 14;		{ Final event per lexical unit }
	kPGPEvent_RecursionEvent	= 15;		{ Notification of recursive
											   job creation }
	kPGPEvent_DetachedSignatureEvent = 16;	{ Need input for verification of
											   detached signature }
	kPGPEvent_KeyGenEvent		= 17;		{ Key generation progress }
	kPGPEvent_KeyServerEvent	= 18;		{ Key Server progress }
	kPGPEvent_KeyServerSignEvent= 19;		{ Key Server passphrase }
{$IFDEF PGP6}
	kPGPEvent_KeyServerTLSEvent	= 20;// Key Server TLS event */
	kPGPEvent_KeyServerIdleEvent= 21;// Idle during keyserver call */

	kPGPEvent_SocketsIdleEvent	= 22;// Idle during sockets */
	kPGPEvent_DecryptionEvent	= 23;// Decryption data report */

{$ELSE}
{$ENDIF}


{+// PGP Analyze event callback codes }
	kPGPAnalyze_Encrypted			=  0;	{ Encrypted message }
	kPGPAnalyze_Signed				=  1;	{ Signed message }
	kPGPAnalyze_DetachedSignature	=  2;	{ Detached signature }
	kPGPAnalyze_Key					=  3;	{ Key data }
	kPGPAnalyze_Unknown				=  4;	{ Non-pgp message }





{+// }
{-* PGPOLocalEncoding options argument }
{-* Only one of Force or Auto should be used; and the other values are }
{-* modifiers. }
{= }

kPGPLocalEncoding_None = $0; { nothing on }
kPGPLocalEncoding_Force = $01;
kPGPLocalEncoding_Auto = $02;
kPGPLocalEncoding_NoMacBinCRCOkay = $04;



{+// }
{-** Functions to encode and decode. The variable parameters are one or more }
{-** PGPOptionListRef's which describe the inputs; outputs; and options. }
{= }


function PGPEncode(context: PGPCONTEXTREF;
                   firstOption,lastoption:PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPDecode(context: PGPCONTEXTREF;
                   firstOption,lastoption:PGPOPTIONLISTREF): PGPERROR; cdecl;


function PGPNewOptionList(context: PGPCONTEXTREF;
                          var outList: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPAppendOptionList({$IFDEF PGP6}
                             {$ELSE}
                             context: PGPCONTEXTREF;
                             {$ENDIF}
                             optionList: PGPOPTIONLISTREF;
                             firstOption,lastoption: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPBuildOptionList(context: PGPCONTEXTREF;
                            var outList: PGPOPTIONLISTREF;
                            firstOption,lastoption:PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPCopyOptionList(optionList: PGPCONSTOPTIONLISTREF;
                           var outList: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPFreeOptionList(optionList: PGPOPTIONLISTREF): PGPERROR; cdecl;

function PGPAddJobOptions(job: PGPJOBREF;
                          firstOption,lastoption: PGPOPTIONLISTREF): PGPERROR; cdecl;


{+// }
{-** The following functions are used to create PGPOptionListRef's for }
{-** specifying the various options to PGPEncode() and PGPEncode(). The }
{-** functions can be used as inline parameters in a temporary manner or }
{-** used with PGPBuildOptionList() to create persistent lists. }
{= }

{+// }
{-** Special PGPOptionListRef to mark last option passed to those functions }
{-** which take variable lists of PGPOptionListRef's: }
{= }


function PGPOLastOption(context: PGPCONTEXTREF): PGPOPTIONLISTREF; cdecl;

{+// }
{-** Special PGPOptionListRef which is always ignored: }
{= }


function PGPONullOption(context: PGPCONTEXTREF): PGPOPTIONLISTREF; cdecl;

{+// Data input (required): } 


function PGPOInputFile(context: PGPCONTEXTREF; 
                       fileRef: PGPCONSTFILESPECREF): PGPOPTIONLISTREF; cdecl;

function PGPOInputBuffer(context: PGPCONTEXTREF; 
                         Const buffer: Pointer;
                         bufferSize: PGPSIZE): PGPOPTIONLISTREF; cdecl;

{+// Data output (optional; generates event if missing): }


function PGPOOutputFile(context: PGPCONTEXTREF;
                        fileRef: PGPCONSTFILESPECREF): PGPOPTIONLISTREF; cdecl;

function PGPOOutputBuffer(context: PGPCONTEXTREF; 
                          buffer: Pointer; 
                          bufferSize: PGPSIZE; 
                          var outputDataLength: PGPSIZE): PGPOPTIONLISTREF; cdecl;

{+// '*buffer' must be disposed of via PGPFreeData() }
{+// maximum memory usage will be no more than maximumBufferSize }

function PGPOAllocatedOutputBuffer(context: PGPCONTEXTREF;
                                   var buffer: pointer{PCHAR};
                                   maximumBufferSize: PGPSIZE;
                                   var actualBufferSize: PGPSIZE): PGPOPTIONLISTREF; cdecl;

function PGPOAppendOutput(context: PGPCONTEXTREF;
                          appendOutput: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPODiscardOutput(context: PGPCONTEXTREF;
                           discardOutput: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;
{$IFDEF PGP6}
function PGPOPassThroughClearSigned(context: PGPCONTEXTREF;
                                    passThroughClearSigned: PGPBOOLEAN): PGPOPTIONLISTREF;cdecl;

function PGPOPassThroughKeys(context: PGPCONTEXTREF;
                             passThroughKeys: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;


function PGPOPasskeyBuffer(context: PGPCONTEXTREF;
                           Const passkey: Pointer;
                           passkeyLength: PGPSIZE): PGPOPTIONLISTREF;cdecl;

function PGPOX509Encoding(context: PGPCONTEXTREF;
                          x509Encoding: PGPBOOLEAN): PGPOPTIONLISTREF;cdecl;

function PGPOCreationDate(context: PGPCONTEXTREF;
                          creationDate: PGPTIME): PGPOPTIONLISTREF;cdecl;

function PGPORevocationKeySet(context: PGPCONTEXTREF;
                              raKeySetRef: PGPKEYSETREF): PGPOPTIONLISTREF;cdecl;
{$ELSE}
function PGPOAskUserForOutput(context: PGPCONTEXTREF;
                              askUserForOutput: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

{$ENDIF}

{+// Encrypting and signing }


function PGPOEncryptToKey(context: PGPCONTEXTREF;
                          keyRef: PGPKEYREF): PGPOPTIONLISTREF; cdecl;

function PGPOEncryptToKeySet(context: PGPCONTEXTREF;
                             keySetRef: PGPKEYSETREF): PGPOPTIONLISTREF; cdecl;

function PGPOEncryptToUserID(context: PGPCONTEXTREF;
                             userIDRef: PGPUSERIDREF): PGPOPTIONLISTREF; cdecl;

function PGPOSignWithKey(context: PGPCONTEXTREF;
                         keyRef: PGPKEYREF;
                         firstOption,lastoption: PGPOPTIONLISTREF): PGPOPTIONLISTREF; cdecl;

function PGPOConventionalEncrypt(context: PGPCONTEXTREF;
                                 firstOption,lastoption:PGPOPTIONLISTREF): PGPOPTIONLISTREF; cdecl;


function PGPOPassphraseBuffer(context: PGPCONTEXTREF;
                              Const passphrase: Pointer;
                              passphraseLength: PGPSIZE): PGPOPTIONLISTREF; cdecl;

function PGPOPassphrase(context: PGPCONTEXTREF;
                        Const passphrase: PChar): PGPOPTIONLISTREF; cdecl;

function PGPOAskUserForPassphrase(context: PGPCONTEXTREF;
                                  askUserForPassphrase: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPOAskUserForEntropy(context: PGPCONTEXTREF;
                               askUserForEntropy: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPORawPGPInput(context: PGPCONTEXTREF;
                         rawPGPInput: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPOCompression(context: PGPCONTEXTREF;
                         compression: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;


function PGPOLocalEncoding(context: PGPCONTEXTREF;
                           localEncode: PGPLOCALENCODINGFLAGS): PGPOPTIONLISTREF; cdecl;

function PGPOOutputLineEndType(context: PGPCONTEXTREF;
                               lineEnd: PGPLINEENDTYPE): PGPOPTIONLISTREF; cdecl;

function PGPOPGPMIMEEncoding(context: PGPCONTEXTREF;
                             mimeEncoding: PGPBOOLEAN;
                             var mimeBodyOffset: PGPSIZE;
                              MIMESEPARATOR:mimearray): PGPOPTIONLISTREF; cdecl;

function PGPOOmitMIMEVersion(context: PGPCONTEXTREF;
                             omitVersion: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;


function PGPODetachedSig(context: PGPCONTEXTREF;
                         firstOption,lastoption:PGPOPTIONLISTREF): PGPOPTIONLISTREF; cdecl;

function PGPOMailHeaders(context: PGPCONTEXTREF;
                         firstOption,lastoption:PGPOPTIONLISTREF): PGPOPTIONLISTREF; cdecl;


function PGPOCipherAlgorithm(context: PGPCONTEXTREF;
                             algorithm: PGPCIPHERALGORITHM): PGPOPTIONLISTREF; cdecl;

function PGPOHashAlgorithm(context: PGPCONTEXTREF;
                           algorithm: PGPHASHALGORITHM): PGPOPTIONLISTREF; cdecl;


function PGPOFailBelowValidity(context: PGPCONTEXTREF; 
                               minValidity: PGPVALIDITY): PGPOPTIONLISTREF; cdecl;

function PGPOWarnBelowValidity(context: PGPCONTEXTREF; 
                               minValidity: PGPVALIDITY): PGPOPTIONLISTREF; cdecl;



function PGPOEventHandler(context: PGPCONTEXTREF;
                          handler: PGPEVENTHANDLERPROCPTR;
                          userValue: PGPUSERVALUE): PGPOPTIONLISTREF; cdecl;

function PGPOSendNullEvents(context: PGPCONTEXTREF; 
                            approxInterval: PGPTIMEINTERVAL): PGPOPTIONLISTREF; cdecl;


function PGPOArmorOutput(context: PGPCONTEXTREF;
                         armorOutput: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPODataIsASCII(context: PGPCONTEXTREF; 
                         dataIsASCII: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPOClearSign(context: PGPCONTEXTREF;
                       clearSign: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPOForYourEyesOnly(context: PGPCONTEXTREF; 
                             forYourEyesOnly: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPOKeySetRef(context: PGPCONTEXTREF;
                       keysetRef: PGPKEYSETREF): PGPOPTIONLISTREF; cdecl;


function PGPOImportKeysTo(context: PGPCONTEXTREF;
                          keysetRef: PGPKEYSETREF): PGPOPTIONLISTREF; cdecl;

function PGPOSendEventIfKeyFound(context: PGPCONTEXTREF;
                                 sendEventIfKeyFound: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;

function PGPOPassThroughIfUnrecognized(context: PGPCONTEXTREF; 
                                       passThroughIfUnrecognized: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;


function PGPOKeyGenParams(context: PGPCONTEXTREF; 
                          pubKeyAlg: PGPPUBLICKEYALGORITHM; 
                          bits: PGPUINT32): PGPOPTIONLISTREF; cdecl;


function PGPOKeyGenName(context: PGPCONTEXTREF;
                        Const name: Pointer;
                        nameLength: PGPSIZE): PGPOPTIONLISTREF; cdecl;


function PGPOExpiration(context: PGPCONTEXTREF;
                        expiration: PGPUINT32): PGPOPTIONLISTREF; cdecl;


function PGPOKeyGenMessageRecoveryKeySet(context: PGPCONTEXTREF;
                                         mrKeySetRef: PGPKEYSETREF; 
                                         mrkClass: PGPBYTE): PGPOPTIONLISTREF; cdecl;


function PGPOKeyGenMasterKey(context: PGPCONTEXTREF;
                             masterKeyRef: PGPKEYREF): PGPOPTIONLISTREF; cdecl;


function PGPOKeyGenPreferredAlgorithms(context: PGPCONTEXTREF; 
                                       var prefAlg: PGPCIPHERALGORITHM; 
                                       prefAlgLength: PGPSIZE): PGPOPTIONLISTREF; cdecl;


function PGPOKeyGenFast(context: PGPCONTEXTREF;
                        fastGen: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;


function PGPOCommentString(context: PGPCONTEXTREF;
                           Const comment: PChar): PGPOPTIONLISTREF; cdecl;


function PGPOVersionString(context: PGPCONTEXTREF;
                           Const version: PChar): PGPOPTIONLISTREF; cdecl;


function PGPOSigRegularExpression(context: PGPCONTEXTREF; 
                                  Const regularExpression: PChar): PGPOPTIONLISTREF; cdecl;


function PGPOExportPrivateKeys(context: PGPCONTEXTREF;
                               exportPrivate: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;


function PGPOExportable(context: PGPCONTEXTREF;
                        exportable: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl;


function PGPOSigTrust(context: PGPCONTEXTREF; 
                      trustLevel: PGPUINT32;
                      trustValue: PGPUINT32): PGPOPTIONLISTREF; cdecl;


function PGPOCertificateTrust(context: PGPCONTEXTREF; 
                              trustLevel: PGPUINT32; 
                              trustValue: PGPUINT32): PGPOPTIONLISTREF; cdecl;


function PGPOCertificateRegularExpression(context: PGPCONTEXTREF;
                                          Const regExp: PChar): PGPOPTIONLISTREF; cdecl;





implementation
function PGPEncode; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPDecode; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPNewOptionList; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPAppendOptionList; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPBuildOptionList; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPCopyOptionList; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPFreeOptionList; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPAddJobOptions; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOLastOption; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPONullOption; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOInputFile; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOInputBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOOutputFile; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOOutputBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOAllocatedOutputBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOAppendOutput; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPODiscardOutput; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

{$IFDEF PGP6}
function PGPOX509Encoding; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOPasskeyBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOPassThroughClearSigned; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOPassThroughKeys; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOCreationDate; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPORevocationKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

{$ELSE}
function PGPOAskUserForOutput; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};
{$ENDIF}


function PGPOEncryptToKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOEncryptToKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOEncryptToUserID; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOSignWithKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOConventionalEncrypt; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOPassphraseBuffer; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOPassphrase; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOAskUserForPassphrase; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOAskUserForEntropy; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPORawPGPInput; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOCompression; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOLocalEncoding; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOOutputLineEndType; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOPGPMIMEEncoding; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOOmitMIMEVersion; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPODetachedSig; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOMailHeaders; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOCipherAlgorithm; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOHashAlgorithm; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOFailBelowValidity; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOWarnBelowValidity; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOEventHandler; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOSendNullEvents; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOArmorOutput; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPODataIsASCII; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOClearSign; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOForYourEyesOnly; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOKeySetRef; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOImportKeysTo; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOSendEventIfKeyFound; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOPassThroughIfUnrecognized; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOKeyGenParams; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOKeyGenName; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOExpiration; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOKeyGenMessageRecoveryKeySet; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOKeyGenMasterKey; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOKeyGenPreferredAlgorithms; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOKeyGenFast; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOCommentString; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOVersionString; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOSigRegularExpression; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOExportPrivateKeys; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOExportable; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOSigTrust; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOCertificateTrust; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};

function PGPOCertificateRegularExpression; external {$IFDEF PGP6}  'pgp_sdk.dll' {$ELSE} 'pgpsdk.dll' {$ENDIF};


end.
