unit PGPKM;

interface
Uses WinTypes,messages,pgpPubtypes,pgpbase,pgptls,
     WinProcs;


{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-PGPkm.h - include file for PGP key manager DLL }


{-$Id: Pgpkm.pas,v 1.5.12.2 1999/08/27 22:00:48 build Exp $ }
{=____________________________________________________________________________ }

{/// synchronization message }
Const KM_M_REQUESTSDKACCESS = WM_APP+222;
Const KM_M_UPDATEKEYINTREE = WM_APP+223;

{/// options bits }
Const KMF_READONLY = $0001;
Const KMF_ENABLECOMMITS = $0002;
Const KMF_NOVICEMODE = $0004;
Const KMF_ONLYSELECTKEYS = $0008;
Const KMF_ENABLEDROPIN = $0010;
Const KMF_ENABLEDRAGOUT = $0020;
Const KMF_MODALPROPERTIES = $0040;
Const KMF_ENABLERELOADS = $0080;
Const KMF_PENDINGBUCKET = $0100;
Const KMF_DISABLEKEYPROPS = $0200;
Const KMF_DISABLERSAOPS = $0400;
Const KMF_MARGASINVALID = $0800;

{/// action codes }
Const KM_COPY = $00000001;
Const KM_PASTE = $00000002;
Const KM_DELETE = $00000004;
Const KM_SELECTALL = $00000008;
Const KM_COLLAPSEALL = $00000010;
Const KM_COLLAPSESEL = $00000020;
Const KM_EXPANDALL = $00000040;
Const KM_EXPANDSEL = $00000080;
Const KM_CERTIFY = $00000100;
Const KM_ENABLE = $00000200;
Const KM_DISABLE = $00000400;
Const KM_ADDUSERID = $00000800;
Const KM_REVOKE = $00001000;
Const KM_SETASDEFAULT = $00002000;
Const KM_SETASPRIMARY = $00004000;
Const KM_IMPORT = $00008000;
Const KM_EXPORT = $00010000;
Const KM_PROPERTIES = $00020000;
Const KM_SENDTOSERVER = $00040000;
Const KM_GETFROMSERVER = $00080000;
Const KM_DELETEFROMSERVER = $00100000;
Const KM_DISABLEONSERVER = $00200000;
Const KM_ADDTOMAIN = $10000000;
Const KM_UNSELECTALL = $20000000;

Const KM_MAINACTIONS = $000FFFF;
Const KM_ALLACTIONS = $300FFFF;

{/// column codes }
Const KM_VALIDITY = $00000001;
Const KM_SIZE = $00000002;
Const KM_DESCRIPTION = $00000004;
Const KM_KEYID = $00000008;
Const KM_TRUST = $00000010;
Const KM_CREATION = $00000020;
Const KM_EXPIRATION = $00000040;
Const KM_ADK = $00000080;

{/// selection bits set in TLN_CONTEXTMENU notification }
Const PGPKM_KEYFLAG = $01;
Const PGPKM_UIDFLAG = $02;
Const PGPKM_CERTFLAG = $04;

Const PGPKM_HELPFILE = $0001;
Const PGPKM_KEYSERVER = $0002;
Const PGPKM_OPTIONS = $0004;
Const PGPKM_DISABLEFLAGS = $0008;
Const PGPKM_COLUMNFLAGS = $0010;
Const PGPKM_STATUSBAR = $0020;
Const PGPKM_ALLITEMS = $003;

{/// typedefs }

Type HKEYMAN=pointer;
type Kmconfig=record

		ulMask:cardinal;				//  mask bits specifying things to configure
		lpszHelpFile:pchar;		//  name of help file
		lpszPutKeyserver:pchar;	//  server to send keys to
		ulOptionFlags:cardinal;		//	logical OR of option bits (above)
		ulDisableActions:cardinal;	//  logical OR of actions (above) to disable
		ulShowColumns:cardinal;		//  logical OR of columns to always show
		ulHideColumns:cardinal;		//  logical OR of columns to always hide
		hWndStatusBar:hwnd;		//  handle of status bar window
        end;
        lpkmconfig=^kmconfig;



{///________________________________________________ }
{/// }
{/// PGPkmCreateKeyManager - }
{/// Creates empty keymanager window }
{/// }
{/// Entry parameters : }
{/// Context - PGP library context }
{/// hWndParent - handle of parent window }
{/// id - window ID to assign to manager (used in notifications) }
{/// x - x coordinate of manager window relative to parent }
{/// y - y coordinate of manager window relative to parent }
{/// nWidth - width of manager window }
{/// nHeight - height of manager window }
{/// }
{/// Returns handle to keymanager }
{/// }


function PGPkmCreateKeyManager(Context: PGPCONTEXTREF;
                               hWndParent: HWND;
                               Id: Integer;
                               x: Integer;
                               y: Integer;
                               nWidth: Integer;
                               nHeight: Integer): HKEYMAN; cdecl; far;

{///________________________________________________ }
{/// }
{/// PGPkmSetConfiguration - }
{/// Configures keymanager window }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager to configure }
{/// pKMConfig - pointer to KMCONFIG struct }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }

type PKMCONFIG=pointer;
function PGPkmConfigure(hKeyMan: HKEYMAN;
                        pKMConfig: PKMCONFIG): PGPERROR; cdecl; far;

{///________________________________________________ }
{/// }
{/// PGPkmDestroyKeyManager - }
{/// Destroys keymanager window }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager to destroy }
{/// bSaveColumnInfo - TRUE => save column info to pref file }
{/// }
{/// Returns kPGPError_NoErr if successful }
{/// }


function PGPkmDestroyKeyManager(hKeyMan: HKEYMAN;
                                bSaveColumnInfo: Bool): PGPERROR; cdecl; far;

{///________________________________________________ }
{/// }
{/// PGPkmDefaultNotificationProc - }
{/// Handles default behavior for TreeList notifications }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// lParam - LPARAM from WM_NOTIFY message }
{/// }
{/// Returns kPGPError_NoErr }
{/// }


function PGPkmDefaultNotificationProc(hKeyMan: HKEYMAN;
                                      lParam: lPARAM): PGPERROR ; cdecl; far;

{///________________________________________________ }
{/// }
{/// PGPkmSynchronizeThreadAccessToSDK - }
{/// synchronizes }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// }
{/// Returns kPGPError_NoErr }
{/// }


function PGPkmSynchronizeThreadAccessToSDK(hKeyMan: HKEYMAN):PGPError; cdecl; far;


{///________________________________________________ }
{/// }
{/// PGPkmUpdateKeyInTree - }
{/// update key following properties change }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// key - key to update }
{/// }
{/// Returns kPGPError_NoErr }
{/// }


function PGPkmUpdateKeyInTree(hKeyMan: HKEYMAN;
                              key: PGPKEYREF):PGPError; cdecl; far;


{///________________________________________________ }
{/// }
{/// PGPkmIsActionEnabled - }
{/// reports if specified action is enabled or not }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// uAction - action constant from above list }
{/// }
{/// Returns TRUE if enabled, FALSE if not }
{/// }


function PGPkmIsActionEnabled(hKeyMan: HKEYMAN;
                              uAction: ULONG): Bool; cdecl; far;

{///________________________________________________ }
{/// }
{/// PGPkmPerformAction - }
{/// requests that specified action be performed on }
{/// currently selected objects }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// uAction - action constant from above list }
{/// }
{/// Returns kPGPError_NoErr if successful }
{/// }


function PGPkmPerformAction(hKeyMan: HKEYMAN;
                            uAction: ULONG): PGPERROR; cdecl; far;

{///________________________________________________ }
{/// }
{/// PGPkmGetManagerWindow - }
{/// returns HWND of keymanager window }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// }
{/// Returns HWND if successful, NULL if error. }
{/// }


function PGPkmGetManagerWindow(hKeyMan: HKEYMAN): HWND; cdecl; far;

{///________________________________________________ }
{/// }
{/// PGPkmLoadKeySets - }
{/// load keyset into manager }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// pKeySetDisp - keyset to display in window }
{/// pKeySetMain - main keyset used for commits and trust calcs }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPkmLoadKeySet(hKeyMan: HKEYMAN; 
                         KeySetDisp: PGPKEYSETREF; 
                         KeySetMain: PGPKEYSETREF): PGPERROR ; cdecl; far;

{///________________________________________________ }
{/// }
{/// PGPkmReLoadKeySet - }
{/// reload keyset into manager }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// bExpandNew - TRUE => expand any newly-found objects }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPkmReLoadKeySet(hKeyMan: HKEYMAN;
                           bExpandNew: Bool): PGPERROR ; cdecl; far;


{///________________________________________________ }
{/// }
{/// PGPkmSelectColumns - }
{/// post dialog which allows user to select columns to display }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// bDialog - TRUE => display dialog to allow user to select }
{/// FALSE => save current settings only }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPkmSelectColumns(hKeyMan: HKEYMAN;
                            bDialog: Bool): PGPERROR; cdecl; far;


{///________________________________________________ }
{/// }
{/// PGPkmSelectKey - }
{/// select the specified key }
{/// }
{/// Entry parameters : }
{/// hKeyMan - handle of key manager }
{/// key - key to select }
{/// bDeselect - TRUE => deselect all keys before selecting }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPkmSelectKey(hKeyMan: HKEYMAN;
                        key: PGPKEYREF;
                        bDeselect: Bool): PGPERROR; cdecl; far;


{///________________________________________________ }
{/// }
{/// PGPkmQueryAddKeys - }
{/// displays and handles selective key import dialog }
{/// }
{/// Entry parameters : }
{/// Context - PGP library context }
{/// hWndParent - handle of parent window }
{/// pKeySetToAdd - keyset containing keys to add }
{/// pKeySetMain - keyset to which keys will be added }
{/// }
{/// Returns kPGPError_NoErr if no error }
{/// }


function PGPkmQueryAddKeys(Context: PGPCONTEXTREF;
                           {$IFDEF PGP6}
                           tlscontext:pgptlscontextref;
                           {$ENDIF}

                           hWndParent: HWND;
                           KeySetToAdd: PGPKEYSETREF;
                           KeySetMain: PGPKEYSETREF): PGPERROR; cdecl; far;



implementation

function PGPkmCreateKeyManager; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmConfigure; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmDestroyKeyManager; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmDefaultNotificationProc; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmSynchronizeThreadAccessToSDK; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmUpdateKeyInTree; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmIsActionEnabled; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmPerformAction; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmGetManagerWindow; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmLoadKeySet; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmReLoadKeySet; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmSelectColumns; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmSelectKey; external {$IFDEF PGP6}  'pgpsdkui.dll' {$ELSE} 'pgp55km.dll' {$ENDIF};

function PGPkmQueryAddKeys; external {$IFDEF PGP6}  pgpclfile name 'PGPclQueryAddKeys' {$ELSE} 'pgp55km.dll' {$ENDIF};

end.
