unit PGPPUBTYPES;

interface
Uses WinTypes,
     WinProcs,
     {pgpConfig;}
     pgpBase;

   const
   {$IFDEF PGP65}
pgpclfile='pgpcl.dll';
{$ELSE}
pgpclfile='pgp60cl.dll';
{$ENDIF}

{+//____________________________________________________________________________ }
{-pgpPubTypes.h }

{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-Opaque types for various modules go in this file. }

{-$Id: Pgppubtypes.pas,v 1.2.12.2 1999/08/27 22:00:48 build Exp $ }
{=____________________________________________________________________________ }



{+//____________________________________________________________________________ }
{-General data types used by PGPsdk }
{=____________________________________________________________________________ }
const
kPGPMimeSeparatorSize = 81;

	kPGPHashAlgorithm_Invalid	= 0;
	kPGPHashAlgorithm_MD5		= 1;
	kPGPHashAlgorithm_SHA		= 2;
	kPGPHashAlgorithm_RIPEMD160	= 3;
	kPGPHashAlgorithm_HAVAL		= 4;
	kPGPHashAlgorithm_MD2		= 5;
	kPGPHashAlgorithm_SHADouble	= 100;

 {+// Trust values; used to set validity values }
kPGPKeyTrust_Mask = $7;
kPGPKeyTrust_Undefined = $0;
kPGPKeyTrust_Unknown = $1;
kPGPKeyTrust_Never = $2;
kPGPKeyTrust_Marginal = $5;
kPGPKeyTrust_Complete = $6;
kPGPKeyTrust_Ultimate = $7;
kPGPNameTrust_Mask = $3;
kPGPNameTrust_Unknown = $0;
kPGPNameTrust_Untrusted = $1;
kPGPNameTrust_Marginal = $2;
kPGPNameTrust_Complete = $3;
{+// Validity levels; used for thresholds in options }
  	kPGPValidity_Unknown	= kPGPNameTrust_Unknown;
	kPGPValidity_Invalid	= kPGPNameTrust_Untrusted;
	kPGPValidity_Marginal	= kPGPNameTrust_Marginal;
	kPGPValidity_Complete	= kPGPNameTrust_Complete;
	kPGPValidity_UNTRUSTED	= kPGPValidity_Invalid;
{+// Size of buffer for PGP-MIME separator (null terminated) }




{+// Line endings for PGPOOutputLineEndType }
kPGPLineEnd_Default = 0;
kPGPLineEnd_LF = 1;
kPGPLineEnd_CR = 2;
kPGPLineEnd_CRLF = kPGPLineEnd_LF + kPGPLineEnd_CR;


Type
PGPValidity=pgpint32;
PGPHashAlgorithm=integer;
PPChar=^pchar;
PGPContextRef = pointer{^PGPContext};
PGPConstContextRef=pointer{^PGPContext};
PGPOptionListRef=pointer{^PGPOptionList};
PGPConstOptionListRef=pointer{^PGPOptionList};
PGPFileSpecRef=pointer{ ^PGPFileSpec};
PGPConstFileSpecRef= pointer{^PGPFileSpec};
PGPKeyDBRef=pointer{^PGPKeyDB} ;
PGPConstKeyDBRef=pointer{^PGPKeyDB };
PGPKeyRef=pointer{^PGPKey};
PGPConstKeyRef=pointer{^PGPKey};
PGPSubKeyRef=pointer{^PGPSubKey};
PGPConstSubKeyRef=pointer{^PGPSubKey};

PGPUserIDRef=pointer{^PGPUserID};
PGPConstUserIDRef=pointer{^PGPUserID};

PGPSigRef=pointer{^PGPSig};
PGPConstSigRef=pointer{^PGPSig};

PGPKeySetRef=pointer{^PGPKeySet};
PGPConstKeySetRef=pointer{^PGPKeySet};

PGPKeyListRef=pointer{^PGPKeylist};
PGPConstKeyListRef=pointer{^PGPKeyList};

PGPKeyIterRef=pointer{^PGPKeyIter};
PGPConstKeyIterRef=pointer{^PGPKeyIter};
ppgpboolean=^PGPBoolean;
PGPFilterRef=pointer{^PGPFilter};
PGPConstFilterRef=pointer{^PGPFilter};


Type PGPPrefRef= pointer;
const kInvalidPGPPrefRef=nil;
function PGPPrefRefIsValid(ref:pointer):boolean;
type


pgpkeyid=record
opaquebytes:array[0..33]of PGPbyte;
end;
PGPKeyIDRef=^PGPKeyID;
PGPConstKeyIDRef=^PGPKeyID;

PGPHashContextRef=pointer{^PGPHashContext};
PGPConstHashContextRef=pointer{^PGPHashContext};
PGPCipherFeedbackContextRef=pointer{^PGPCipherFeedbackContext};
PGPConstCipherFeedbackContextRef=pointer{^PGPCipherFeedbackContext};
PGPSymmetricCipherContextRef=pointer{^PGPSymmetricCipherContext};
PGPConstSymmetricCipherContextRef=pointer{^PGPSymmetricCipherContext};
PGPHMACContextRef=pointer;
PGPConstHMACContextRef=pointer;
PGPKeyServerRef=pointer;

pflfilespecref=pointer;

PGPCipherAlgorithm=PGPInt32;
PGPPublicKeyAlgorithm =PGPInt32;



Const
        kPGPInvalidRef = nil;
	kPGPCipherAlgorithm_None	= 0;
	kPGPCipherAlgorithm_IDEA	= 1;
	kPGPCipherAlgorithm_3DES	= 2;
	kPGPCipherAlgorithm_CAST5	= 3;

    	kPGPPublicKeyAlgorithm_Invalid= $FFFFFFFF;
	kPGPPublicKeyAlgorithm_RSA= 1;
	kPGPPublicKeyAlgorithm_RSAEncryptOnly= 2;
	kPGPPublicKeyAlgorithm_RSASignOnly   = 3;
	kPGPPublicKeyAlgorithm_ElGamal	 = $10; { A.K.A.Diffie-Hellman }
	kPGPPublicKeyAlgorithm_DSA=$11;

	kPGPPublicKeyAlgorithm_First= kPGPPublicKeyAlgorithm_RSA;
	kPGPPublicKeyAlgorithm_Last = kPGPPublicKeyAlgorithm_DSA;


function PGPRefIsValid(ref:pgpcontextref ):boolean;


implementation


function PGPPrefRefIsValid(ref:pointer):boolean;
begin
 result:= ref <> kInvalidPGPPrefRef ;
end;


function PGPRefIsValid(ref:pgpcontextref ):boolean;
begin
result:= ( (ref) <> kPGPInvalidRef );
end;

end.

