{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: mainunit.pas,v 1.6.12.4 1999/09/27 23:12:47 build Exp $ }
{=____________________________________________________________________________ }

unit mainunit;

interface
uses gwdll,wintypes,winprocs,windows,sysutils,dialogs,classes,controls,comobj;

(*function LibMain(hInstance:THANDLE ;  wDataSeg:WORD;
						  wHeapSize:WORD;
						  lpszCmdLine:Pchar):integer;{$IFDEF GW52}stdcall {cdecl}  {$ELSE} stdcall; {$ENDIF}*)


function TPHVersion:DWORD;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
function Compatibility( AppAtom:ATOM ;AppVersion:WORD):DWORD;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
function TimeStamp:DWORD;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
function Entry ( wLanguage:WORD):WORD;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
function Exit:word;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
function HandleToken ( lpTokenData:LPTPH_RETURNVAL; // received token
							 hLinkWnd:HWND;	  // link window
							    msg:WORD ):dllhandlertype;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
function ValidateToken( lpTokenData:LPMAC_TOKEN;lpDataTypeInfo:pointer):dllvalidationtype;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
function GWEventNotify (dwID : Cardinal; dwNotification : Cardinal): longint;  stdcall;

implementation
const   PGPGW_NEWMENU_ENCRYPT = 101;
        PGPGW_OVERRIDE_OPEN=110;
var
cancelcmd,factory,c3po,opencmd,cmd:variant;first:integer;doneone:boolean;
//----------------------------------------------------------------------------
// Name:		LibMain
// Descrip: Standard entry function for a Windows DLL.  Must be included;
// 			Nothing really specific to a GroupWise Third Party DLL.
// Returns:	return a value of 1.
//----------------------------------------------------------------------------
(*function LibMain(hInstance:THANDLE ;  wDataSeg:WORD;
						  wHeapSize:WORD;
						  lpszCmdLine:Pchar):integer;{$IFDEF GW52}stdcall {cdecl}  {$ELSE} stdcall {$ENDIF};

begin
        {$IFDEF DEBUG}
showmessage('libmain');
{$ENDIF}
	result:= 1;
end;*)


//----------------------------------------------------------------------------
// Name:		TPHVersion
// Descrip:	This function is reserved for later use.  It must be included, as
//				all the TPH functions must be included, and in the this order as
// 			they are defined in this file.  Write this function as follows,
//				having it return a (DWORD) 1.
// Returns: (DWORD) 1
//----------------------------------------------------------------------------
function TPHVersion:DWORD;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
begin
{$IFDEF DEBUG}
showmessage('tphversion');
{$ENDIF}
  result:=dword(1);
end;


//----------------------------------------------------------------------------
// Name:		Compatibility
// Descrip:	Your TPH DLL may work with this version of GroupWise, but it is
// 			possible it won't work with other versions as changes are made.
//				The compatibility function allows you to check the version of
//				GroupWise it will be running under, and then indicate to GroupWise
//				whether you want your third party DLL to still be loaded.
//
//				To indicate that you want the DLL to still be loaded, return a
//				a value of (DWORD) 1.  To indicate that you don't want it to be
//				loaded, return a value of (DWORD)0.
//
//				Assume this version of GroupWise is 5.0.  The LOBYTE of AppVersion
//				will be 5, and the HIBYTE will 0, respectively.  You can check
//				these values to see which version you are running with.  The
//				AppAtom parameter is a reserved parameter which you may ignore.
//
// Returns: See above
//----------------------------------------------------------------------------
function Compatibility( AppAtom:ATOM ;AppVersion:WORD):DWORD;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
begin

{$IFDEF DEBUG}
showmessage('compat');
{$ENDIF}
//	  if (5 == LOBYTE(AppVersion) && 0 == HIBYTE(AppVersion)) {
result:=dword(1);
end;


//----------------------------------------------------------------------------
// Name:		TimeStamp
// Descrip:	This function is reserved for later use.  It must be included, as
//				all the TPH functions must be included, and in the this order as
// 			they are defined in this file.  Write this function as follows,
//				having it return a (DWORD) 0.
// Returns: (DWORD) 0
//----------------------------------------------------------------------------
function TimeStamp:DWORD;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
begin
{$IFDEF DEBUG}
showmessage('timestamp');
{$ENDIF}
result:=dword(0);
end;



//----------------------------------------------------------------------------
// Name:		Entry
// Descrip:	The entry function is where your third party DLL sets up its
//				necessary data structures, memory allocations, initializations,
//				etc.  Also, it tells you the language under which GroupWise
//				is running.  If your DLL does not support this language, you
//				have the ability to prevent this DLL from being loaded.
//
//				If, after examining the language code, you wish to load your DLL,
//				return a (DWORD)1.  If not, return (DWORD) 0.
//
//				For example, if your DLL supports the language in the US, the
//				LOBYTE will be 'U', and HIBYTE will be 'S'.
//
// Returns: See above
//----------------------------------------------------------------------------
function Entry ( wLanguage:WORD):WORD;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
begin
{$IFDEF DEBUG}
showmessage('entry');
{$ENDIF}
result:=dword(1);
try
doneone:=false;
   c3po:=createoleobject('pgpgw.c3po');
      factory:=c3po.commandfactory;
{      cmd:=Factory.BuildCommand('','GW#C#ENCRYPT',varnull,varnull);}
     { opencmd:=Factory.BuildCommand('','GW#C#AUTODECRYPT',varnull,varnull);}
      cancelcmd:=factory.buildcommand('','GW#C#PGPCANCEL',varnull,varnull);
                   except result:=0; end;
                   first:=0;

       end;


//----------------------------------------------------------------------------
// Name:		Exit
// Descrip:	The exit function is where your third party DLL frees up memory,
//				closes files, or does any other activities to prepare for
//				closing down.  Simply return a (WORD) 1 when finished.
//
// Returns: (DWORD) 1
//----------------------------------------------------------------------------
function Exit:word;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
begin
                  {$IFDEF DEBUG}
showmessage('exit');
{$ENDIF}
        c3po:=unassigned;
	  result:= dword(1);
end;


//----------------------------------------------------------------------------
// Name:		HandleToken
// Descrip:	The HandleToken function is where GroupWise tokens are routed
//				to your DLL for processing.  You have the ability to process
//				the token and have GroupWise process it, or prevent GroupWise
//				from processing, or even create new tokens to be routed through
//				to GroupWise.
//
//				In this example, we will demonstrate two of these concepts
//				by capturing the token associated with bring up the About Dialog
//				Box (Select Help | About GroupWise, from the menu).
//
//				A dialog box will come up allowing you to either ignore the token
//				and let GroupWise process it, or process it instead of GroupWise.
//				Thus, you'll be able to see how your DLL can interact with and
//				influence how GroupWise processes requests.
//
//
// Returns: The following return values are possible:
//
//									DLL_HAN_NOT_HANDLED
//									DLL_HAN_NO_ERROR
//									DLL_HAN_NOT_FOUND
//									DLL_HAN_CANCEL
//									DLL_HAN_TOKEN_ERROR
//									DLL_HAN_PARM_ERROR
//
//----------------------------------------------------------------------------


function HandleToken ( lpTokenData:LPTPH_RETURNVAL; // received token
							 hLinkWnd:HWND;	  // link window
							    msg:WORD ):dllhandlertype;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};

var	 lpNewToken: LPMAC_TOKEN;		// The new token we will create
OK:variant;
   begin      // msg to use to send
		 {$IFDEF DEBUG}
showmessage('handletok');
{$ENDIF}

  result:= DLL_HAN_NOT_HANDLED;
  {$IFDEF GW52}
         if (lpTokenData^.lpToken^.wTokenId=BFTKN_SEND) then begin
                                      cmd:=Factory.BuildCommand('','GW#C#ENCRYPT',varnull,varnull);
                                result:= DLL_HAN_NO_ERROR;
                                OK:=1;
                                cmd.execute;
                                OK:=cmd.getok;
                                if OK=0 then begin
				result:= DLL_HAN_NOT_HANDLED;
                                doneone:=true;
                                end;
                                cmd:=unassigned;

                       end else

                    if (lpTokenData^.lpToken^.wTokenId=BFTKN_CLOSE_WINDOW) then begin
                                cancelcmd.execute;
                                doneone:=false;
                                result:= DLL_HAN_NOT_HANDLED;
                       end
        	 else
		  result:= DLL_HAN_NOT_HANDLED;

                  {$ENDIF}
            end;

function ValidateToken( lpTokenData:LPMAC_TOKEN;lpDataTypeInfo:pointer):dllvalidationtype;{$IFDEF GW52} stdcall {cdecl} {$ELSE} stdcall {$ENDIF};
begin
                      {$IFDEF DEBUG}
showmessage('validatetok');
{$ENDIF}
	result:= DLL_VAL_UNKNOWN_TOKEN;
end;

{***********************************************************
   Name:       GWEventNotify

   Description:  This procedure is exported, and is used by the
                 client in response to events requested by this
                 C3PO for a compose view.

   In:           dwID:  32 bit value passed to the GW client as part
                 of the EventNoticeRegister token.  This can be an ID
                 or a pointer to memory needed by this routine.

                 dwNotification: Flag indicating which event has taken place.
                      EVT_GROUPWISE_SEND_ITEM		      = $1;
                      EVT_GROUPWISE_CANCEL_ITEM		      = $2;
                      EVT_GROUPWISE_CLOSE_ITEM		      = $4;
                      EVT_GROUPWISE_PACKAGING_ITEM	      = $8;
                      EVT_GROUPWISE_PACKAGING_ITEM_CANCELED    = $10;
                      EVT_GROUPWISE_SEND_ITEM_COMPLETED	      = $20;


   Out:          None

   Comments:

************************************************************}
function GWEventNotify (dwID : Cardinal; dwNotification : Cardinal): longint; stdcall;
var
   iDDEReturn : integer;
   sReturn    : string;
   OK:integer;
begin
     // Register the notify event procedure here.
     GWEventNotify := 1;
       case dwNotification of
            EVT_GROUPWISE_SEND_ITEM:
            begin
                 sReturn := 'EVT_GROUPWISE_SEND_ITEM received';
            end;
            EVT_GROUPWISE_CANCEL_ITEM:
            begin
               cancelcmd.execute;
            end;
            EVT_GROUPWISE_CLOSE_ITEM:
            begin
                 cancelcmd.execute;
            end;
            EVT_GROUPWISE_PACKAGING_ITEM:
            begin
                             OK:=1;
                   try
                  cmd:=Factory.BuildCommand('','GW#C#ENCRYPT',varnull,varnull);
                  cmd.execute;
                   OK:=cmd.getok;
                   except OK:=1; end;
                     if OK<>0 then
                      GWEventNotify := -1 else
                      gweventnotify:=1;
            end;
            EVT_GROUPWISE_PACKAGING_ITEM_CANCELED:
            begin
             end;
            EVT_GROUPWISE_SEND_ITEM_COMPLETED:
            begin
                 cancelcmd.execute;
            end;
       end;


end;

{$IFDEF GW52}
{$ELSE}
initialization
entry(0);


finalization
begin
exit;

end;

{$ENDIF}

end.
