{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: messwin.pas,v 1.12.12.4 1999/09/03 18:25:01 build Exp $ }
{=____________________________________________________________________________ }
unit messwin;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,oleauto,ole2,
  Buttons, ComCtrls, ExtCtrls, Dialogs, checklst, Grids,printers, Menus,
  userid,ImgList, ToolWin, encrypt, OleCtrls, FileCtrl,registry,shlobj,shellapi,commctrl,pgputilities;

resourcestring
executables='Executable Files (*.exe)|*.exe|All Files (*.*)|*.*';
allfiles='All Files (*.*)|*.*';
selectexecutable='Open With';
openorsave='Click ''Open'' to open the decrypted file and click ''Save'' to save the file to disk';
cantclose='You cannot close this window until all processing is completed';
otherwin='At least one document reference, mail message, or other non-PGP object was attached.  It is indicated by the globe icon in the decrypted message view.';
dateheader='Date: ';
fromheader='From: ';
toheader='To: ';
CCheader='CC: ';
subjectheader='Subject: ';
reptext='Re: ';
mailfrom='Mail From: ';
fromintro='Decrypted message from ' ;

type

  TMessForm = class(TForm)
    Panel1: TPanel;
    List: TImageList;
    PrintDial: TPrintDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    SaveAlltoGroupwise1: TMenuItem;
    SaveAlltoDisk1: TMenuItem;
    Actions1: TMenuItem;
    ReplyAll1: TMenuItem;
    ReplytoSender1: TMenuItem;
    Print2: TMenuItem;
    Close1: TMenuItem;
    ToolBar1: TToolBar;
    Panel11: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    fromedit: TEdit;
    Subjectedit: TEdit;
    Delete1: TMenuItem;
    toedit: TListBox;
    tocombo: TEdit;
    cccombo: TEdit;
    ccedit: TListBox;
    statbar: TStatusBar;
    PopupMenu1: TPopupMenu;
    Copy1: TMenuItem;
    PopupMenu2: TPopupMenu;
    SaveSelected1: TMenuItem;
    tolist: TListBox;
    fromlist: TEdit;
    cclist: TListBox;
    Panel2: TPanel;
    MessMemo: TRichEdit;
    Panel3: TPanel;
    filelist: TListView;
    SaveAll: TToolButton;
    buttonlist: TImageList;
    ref: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ViewSelected1: TMenuItem;
    OpenDocument1: TMenuItem;
    Decmess: TToolButton;
    DecryptVerifyMessage1: TMenuItem;
    ToolButton9: TToolButton;
    N1: TMenuItem;
    ForwardOriginal1: TMenuItem;
    ForwardTextOnly1: TMenuItem;
    ForwardDecryptedMessage1: TMenuItem;
    N2: TMenuItem;
    ReadPrevious1: TMenuItem;
    ReadNext1: TMenuItem;
    delbox: TListBox;
    procedure SaveSelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sigheadDrawSection(HeaderControl: THeaderControl;
      Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
    procedure PrintClick(Sender: TObject);
    procedure CopyClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ReplyAll1Click(Sender: TObject);
    procedure ReplytoSender1Click(Sender: TObject);
    procedure SaveAlltoDisk1Click(Sender: TObject);
    procedure SaveAlltoGroupwise1Click(Sender: TObject);
    procedure SaveSelMenuClick(Sender: TObject);
    procedure Print2Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure toeditChange(Sender: TObject);
    procedure tocomboClick(Sender: TObject);
    procedure cccomboClick(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure filelistChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure Copy1Click(Sender: TObject);
    procedure SaveSelected1Click(Sender: TObject);
    procedure MessMemoMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ViewSelClick(Sender: TObject);
    procedure PopupMenu2Popup(Sender: TObject);
    procedure OpenDocument1Click(Sender: TObject);
    procedure filelistMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure DecryptVerifyMessage1Click(Sender: TObject);
    procedure ForwardTextOnly1Click(Sender: TObject);
    procedure ForwardOriginal1Click(Sender: TObject);
    procedure ForwardDecryptedMessage1Click(Sender: TObject);
    procedure ReadPrevious1Click(Sender: TObject);
    procedure ReadNext1Click(Sender: TObject);
  private

    { Private declarations }
  public
        attachmentopened:boolean;
        messvar:variant;
        winnum:integer;
        processing:boolean;
        messageid:string;
        listhandle:thandle;
        procedure filllist;
        procedure replyproc;
    { Public declarations }
  end;
messarray=array[0..254] of tmessform;

var

  startheight,startwidth:integer;
 messforms:messarray;
  resourcestring
  oleattached='Cannot process an attachment.'+chr(13)+'Open the original encrypted message without decrypting it.';
  oleatt2='Cannot decrypt'+chr(13)+'See Groupwise view';
implementation
 {$R *.DFM}
 uses pgpexsdk, autoscale,pgp2, statunit;


 function geticon(ext:string):thandle;
var
  FileInfo: TSHFileInfo;
  Flags: Integer;
  ok:boolean;
  data:string;
  temp:file;
begin
  FillChar(FileInfo, SizeOf(FileInfo), #0);
    Flags := SHGFI_SYSICONINDEX or SHGFI_ICON or SHGFI_LARGEICON;
    begin
  assignfile(temp,'temp'+ext);
  rewrite(temp);
  closefile(temp);
  data:='temp'+ext;
  end;
  SHGetFileInfo(pchar(data),0,FileInfo,SizeOf(FileInfo),Flags);
  Result := FileInfo.iIcon;
  deletefile('temp'+ext);
end;

function getgwicon:thandle;
var
  FileInfo: TSHFileInfo;
  Flags: Integer;
  reg:tregistry;
  ok:boolean;
  data:string;
begin
  FillChar(FileInfo, SizeOf(FileInfo), #0);
  Flags := SHGFI_SYSICONINDEX or SHGFI_ICON or SHGFI_LARGEICON;
  reg:=tregistry.create;
  reg.rootkey:=HKEY_CLASSES_ROOT;
ok:=  reg.OpenKey('GroupWise5\shell\Open\Command',false);
ok:=reg.valueexists('');
data:=reg.ReadString('');
reg.closekey;
reg.free;
data:=copy(data,1,pos(' ',data));
  SHGetFileInfo(pchar(data),0,FileInfo,SizeOf(FileInfo),Flags);
  Result := FileInfo.iIcon;
end;




procedure tmessform.Filllist;
var ext,classid,fname,fpath,num:string;
    doc:integer;dispname:widestring;
    listitem:tlistitem;
   atts, ver,attachmess:variant;
    openold:boolean;
begin
processing:=true;
     num:='0';
     form1.WPO.CommandString := 'ItemAttachmentGetCount("'+messageid+'")';
     num := form1.WPO.CommandReturn;
     filelist.items.beginupdate;
for doc := 0 to (strtoint(num)-1) do
begin
form1.WPO.CommandString:='itemattachmentgetclass("'+messageid+'";'+inttostr(doc)+')';
classid:=form1.WPO.commandreturn;
form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')';
dispname:=form1.wpo.commandreturn;
if classid ='1' then begin
processname(dispname,fname,fpath);
if pos('Static',dispname)=0 then begin
listitem:=filelist.items.add;
ext:=ExtractFileExt(fname);
{fname:=copy(fname,1,12)+'...';}
listitem.caption:=fname;
listitem.imageindex:={43} geticon(ext);
end else
begin
listitem:=filelist.items.add;
listitem.caption:='';
listitem.imageindex:=imageList_GetImageCount(listhandle)+1;
end;
end
else
begin
listitem:=filelist.items.add;
attachmess :=unassigned;
try
atts:=messvar.attachments.item(doc+1);
attachmess:=atts.message;
except end;
{try attachmess:=account.getmessage(widestring(dispname));//get the attachment message
except try attachmess:=account.getmessage(dispname);
except try attachmess:=account.getmessage(ansistring(dispname));except end; end; end;}
if (not varisnull(attachmess)) and (not varisempty(attachmess)) then begin
openold:=true;
dispname:=attachmess.subject.plaintext ;
{fname:=copy(dispname,1,12)+'...';}
fname:=dispname;
listitem.caption:=fname;
listitem.imageindex:= getgwicon;
end else begin
listitem.caption:='';
listitem.imageindex:=imageList_GetImageCount(listhandle)+1;
end;

end;
end;
filelist.items.EndUpdate;
if openold then begin
messagedlg(otherwin,mtInformation,[mbOK],0);
end;
processing:=false;
end;


procedure TMessForm.SaveSelClick(Sender: TObject);
var doc:integer;savefile,tmpfile,dispname,fname,fpath:string;status:statrec;dofile:boolean;
begin
processing:=true;
for doc := 0 to (filelist.items.count-1) do

begin
if filelist.items[doc].selected then begin
form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')';
dispname:=form1.wpo.commandreturn;
if pos('Token failed',dispname)=0 then begin
processname(dispname,fname,fpath);
{tmpfile := form1.PGP.PGPPath+'doc'+inttostr(doc);}
tmpfile:=form1.pgp.pgppath+fname{changefileext(form1.pgp.pgppath+fname,'.')};
{tmpfile := form1.PGP.PGPPath+'doc'+inttostr(doc);}
savefile:=tmpfile{changefileext(tmpfile,'.asc')};
form1.WPO.CommandString := 'ItemAttachmentSaveAs ("'+messageid+'";'+inttostr(doc)+';"' + savefile+'")';

if not decryptfile(tmpfile,status) then
tmpfile:=savefile;
begin
if status.mess<>'' then begin
setforegroundwindow(application.handle);
sendPGPlogmsg(application.handle,pchar(status.logmess));
{messagedlg(status.mess,mtinformation,[mbOK],0);}
end;
if comparetext(tmpfile,savefile)<>0 then
form1.pgp.wipefile(savefile);
form1.savedial.filename:=extractfilename(tmpfile);
form1.savedial.title:= chooseloc + Inttostr(doc);
if form1.savedial.execute and (form1.savedial.filename <> '') then begin
   form1.savedial.initialdir:=extractfilepath(form1.savedial.filename);
   if comparetext(tmpfile,form1.savedial.filename)<>0 then
   sysutils.deletefile(form1.savedial.filename);
   renamefile(tmpfile,form1.savedial.filename);
   end else
   form1.pgp.wipefile(tmpfile);
   end;{  else
  form1.pgp.wipefile(savefile);}
  end else
messagedlg(oleattached,mtWarning,[mbOK],0);

  end;
   end;
   form1.pgp.cleandecrypt;
   processing:=false;
end;


procedure TMessForm.FormCreate(Sender: TObject);
var fileinfo:tshfileinfo;
begin
attachmentopened:=false;
geautoscale(self);
processing:=false;
try
  ListHandle := SHGetFileInfo('C:\',0,FileInfo,SizeOf(FileInfo),SHGFI_SYSICONINDEX or SHGFI_LARGEICON);
  ListView_SetImageList(filelist.handle,listhandle,LVSIL_NORMAL);
  except end;
end;



procedure TMessForm.sigheadDrawSection(HeaderControl: THeaderControl;
  Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
begin
startheight:=height;
startwidth:=width;
if (Screen.PixelsPerInch <> cPixelsPerInch) then
     begin
    section.width:=trunc(section.width* Screen.PixelsPerInch/cPixelsPerInch);
end; end;




procedure TMessForm.PrintClick(Sender: TObject);
var count:integer;
begin
processing:=true;
if printdial.execute then
for count := 1 to printdial.copies do
messmemo.print('PGP Decrypted Message');
processing:=false;
end;

procedure TMessForm.CopyClick(Sender: TObject);
begin
  messmemo.copytoclipboard;
end;

procedure TMessForm.FormDestroy(Sender: TObject);
begin
messforms[winnum]:=nil;
end;

procedure TMessForm.FormClose(Sender: TObject; var Action: TCloseAction);
var count:integer;
begin
for count:=0 to (delbox.Items.count-1) do begin
form1.pgp.wipefile(delbox.items[count]);
end;
messforms[winnum].release;
action:=cafree;
end;


procedure tmessform.replyproc;
var subtext,messtext,messtype:string;
 origmess,messid,dateinfo,subinfo,frominfo,siginfo:string;
begin
     if form1.richedit then
     messmemo.plaintext:=false else //put the text into the new message
     messmemo.plaintext:=true;
     messtext:=messmemo.text;

     encrypt.fixquotes(messtext);
     subtext:=subjectedit.text;
     encrypt.fixquotes(subtext);
     form1.wpo.commandstring:='itemsettext("X00";Subject!;"'+reptext+subtext+'";No!)';
     form1.wpo.commandstring:='ItemSetText("X00"; Message!;"'+chr(13)+chr(10)+chr(13)+chr(10)+'>>>> '+
     fromedit.text+' '+statbar.simpletext+'>>>>'+chr(13)+chr(10)+widestring(messtext)+'";No! )';
     messmemo.plaintext:=false;
end;

procedure TMessForm.ReplyAll1Click(Sender: TObject);
var count:integer;temp:string;
begin
processing:=true;
toedit.visible:=false;
ccedit.visible:=false;
if form1.gwhandle<>0 then
setforegroundwindow(form1.gwhandle);
application.processmessages;
form1.passthrough:=true;
form1.wpo.commandstring:='ItemOpen("'+messageid+'")';
application.processmessages;
  form1.wpo.commandstring:='ItemReply(All!;No!)';
  application.processmessages;

{  form1.wpo.commandstring:='NewMail()';
  application.processmessages;
  temp:=fromlist.text;
  encrypt.fixquotes(temp);
  form1.wpo.commandstring:='itemsettext("X00";To!;"'+temp+'";No!)';
for count :=0 to tolist.items.count-1 do begin
if comparetext(form1.owneraddress,tolist.items[count])<> 0 then begin
temp:=tolist.items[count];
 encrypt.fixquotes(temp);
  form1.wpo.commandstring:='itemsettext("X00";To!;"'+temp+'";No!)';
  end;
end;
for count :=0 to cclist.items.count-1 do begin
if comparetext(form1.owneraddress,cclist.items[count])<> 0 then
temp:=cclist.items[count];
 encrypt.fixquotes(temp);
  form1.wpo.commandstring:='itemsettext("X00";cc!;"'+temp+'";No!)';
end;}
  Replyproc;
  processing:=false;
end;

procedure TMessForm.ReplytoSender1Click(Sender: TObject);
var temp:string;
begin
processing:=true;
toedit.visible:=false;
ccedit.visible:=false;
if form1.gwhandle<>0 then
setforegroundwindow(form1.gwhandle);
application.processmessages;
form1.passthrough:=true;
form1.wpo.commandstring:='ItemOpen("'+messageid+'")';
{  form1.wpo.commandstring:='NewMail()';}
  form1.wpo.commandstring:='ItemReply(Sender!;No!)';
  application.processmessages;
{  temp:=fromlist.text;
  encrypt.fixquotes(temp);
  form1.wpo.commandstring:='itemsettext("X00";To!;"'+temp+'";No!)';}
replyproc;
processing:=false;
end;

procedure TMessForm.SaveAlltoDisk1Click(Sender: TObject);
var newmes:variant;fileinfo:tshfileinfo;flags:integer;
eline,tmpfile:string;TMP:string ;status:statrec;
begin
processing:=true;
toedit.visible:=false;
ccedit.visible:=false;
     form1.savedial.filename:='Message.txt';
     form1.savedial.title:= chooselocmess;
      if (form1.savedial.execute) and (form1.savedial.filename <> '') then begin //show the dialog to save the message
             form1.savedial.initialdir:=extractfilepath(form1.savedial.filename);
               if comparetext(form1.savedial.filename,tmpfile)<>0 then
              sysutils.deletefile(form1.savedial.filename);
              messmemo.plaintext:=true;
              messmemo.lines.SaveToFile(form1.savedial.filename);
              messmemo.plaintext:=false;
              pgp2.decryptattach(messvar,newmes,mrNo); //save attachments to disk

        end;
        form1.pgp.cleandecrypt;
        processing:=false;

end;

procedure TMessForm.SaveAlltoGroupwise1Click(Sender: TObject);
var tempmes,newmes:variant;
eline,tmpfile:string;TMP:string ;status:statrec;
messtext,messtype:string;
   origmess,messid,dateinfo,subinfo,frominfo,siginfo:string;
begin
processing:=true;
toedit.visible:=false;
ccedit.visible:=false;
     setforegroundwindow(application.handle);
     statform.progress.position:=0; //setup the status window
     statform.caption:=Generating;
     statform.cancelbtn.hide;
     statform.statlabel.caption:=makingmessage;
     statform.statlabel.Alignment:=taCenter;
     statform.show;
     application.processmessages;

     messtype:=messvar.classname;//create a new message and set up addresses
     newmes:=account.mailbox.messages.add(messtype);
     newmes.recipients.add(account.owner);
     newmes.fromtext:=fromedit.text;
    newmes.subject.plaintext:=subjectedit.text;
    statform.progress.position:=statform.progress.position+10;
    application.processmessages;
    messmemo.plaintext:=true;
     newmes.bodytext:={siginfo+selectview +chr(13)+chr(10)+chr(13)+chr(10)+'Message follows below:'+chr(13)+chr(10)+chr(13)+chr(10)+tmpfile}messmemo.lines.text+chr(13)+chr(10);
     statform.progress.position:=statform.progress.position+10;
     application.processmessages;
     setforegroundwindow(application.handle);
    decryptattach(messvar,newmes,mrYes); //add attachments to the new message
     setuptypes(newmes,messvar);//copy other data to the new message
     application.processmessages;
     tempmes:=newmes.send; //send the new message
          statform.progress.position:=statform.progress.position+10;
     application.processmessages;
     messid:=tempmes.messageid;
     form1.passthrough:=true;
     statform.progress.position:=statform.progress.position+10;
     application.processmessages;
     newmes:=unassigned;//cleanup
     tempmes:=unassigned;
     application.processmessages;
     form1.wpo.commandstring:='ItemOpen("'+messid+'")';//show the new message
     statform.hide;
     form1.passthrough:=false;
   form1.pgp.cleandecrypt;
   processing:=false;
end;

procedure TMessForm.SaveSelMenuClick(Sender: TObject);
var doc:integer;
savefile,tmpfile,fname,fpath,dispname:string;
status:statrec;
begin
processing:=true;
for doc := 0 to (filelist.items.count-1) do

begin
if filelist.items[doc].selected then begin
form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')';
dispname:=form1.wpo.commandreturn;
if pos('Token failed',dispname)=0 then begin
processname(dispname,fname,fpath);
{tmpfile := form1.PGP.PGPPath+'doc'+inttostr(doc);}
tmpfile:=form1.pgp.pgppath+fname{changefileext(form1.pgp.pgppath+fname,'.')};
{tmpfile := form1.PGP.PGPPath+'doc'+inttostr(doc);}
savefile:=tmpfile{changefileext(tmpfile,'.asc')};
form1.WPO.CommandString := 'ItemAttachmentSaveAs ("'+messageid+'";'+inttostr(doc)+';"' + savefile+'")';
if not decryptfile(tmpfile,status) then
tmpfile:=savefile;
begin
if status.mess<>'' then begin
setforegroundwindow(application.handle);
sendPGPlogmsg(application.handle,pchar(status.logmess));
{messagedlg(status.mess,mtinformation,[mbOK],0);}
end;
if comparetext(tmpfile,savefile)<>0 then
form1.pgp.wipefile(savefile);
form1.savedial.filename:=extractfilename(tmpfile);
form1.savedial.title:= chooseloc + Inttostr(doc);
if form1.savedial.execute and (form1.savedial.filename <> '') then begin
   form1.savedial.initialdir:=extractfilepath(form1.savedial.filename);
   if comparetext(tmpfile,form1.savedial.filename)<>0 then
   sysutils.deletefile(form1.savedial.filename);
   renamefile(tmpfile,form1.savedial.filename);
   end else
   form1.pgp.wipefile(tmpfile);
  end;{
  else
   form1.pgp.wipefile(savefile);}
 end else
messagedlg(oleattached,mtWarning,[mbOK],0);
  end;
   end;
 form1.pgp.cleandecrypt;
processing:=false;
end;

procedure TMessForm.Print2Click(Sender: TObject);
var tl,found,pixelsleft,count:integer;F:textfile;tempfull,temp:string;messlen:integer;done:boolean;
begin
processing:=true;
toedit.visible:=false;
ccedit.visible:=false;
if printdial.execute then begin
assignprn(f);
try
rewrite(f);
except closefile(f);end;
try
for count := 1 to printdial.copies do begin
printer.canvas.font.style:=[fsbold];
write(F,Fromheader);
printer.canvas.font.style:=[];
writeln(F,fromedit.text);
printer.canvas.font.style:=[fsbold];
write(F,toheader);
printer.canvas.font.style:=[];
writeln(F,tocombo.text);
printer.canvas.font.style:=[fsbold];
write(F,ccheader);
printer.canvas.font.style:=[];
writeln(F,cccombo.text);
printer.canvas.font.style:=[fsbold];
write(F,dateheader);
printer.canvas.font.style:=[];
writeln(F,copy(statbar.simpletext,6,length(statbar.simpletext)));
printer.canvas.font.style:=[fsbold];
write(F,subjectheader);
printer.canvas.font.style:=[];
writeln(F,subjectedit.text);
writeln(f);
writeln(f);
pixelsleft:=printer.pagewidth;
messlen:=1;
found:=0;
done:=false;
while not done do begin
found:=messmemo.findtext(' ',messlen,length(messmemo.text),[]);
if found>-1 then begin
tl:=printer.canvas.textwidth(copy(messmemo.text,messlen,found-messlen+2));
if tl>printer.pagewidth then begin
write(f,copy(messmemo.text,messlen,found-messlen+2));
pixelsleft:=printer.pagewidth-(tl mod printer.pagewidth);
end else
if tl<pixelsleft then begin
write(f,copy(messmemo.text,messlen,found-messlen+2));
pixelsleft:=pixelsleft-tl;
end else begin
if found<>messlen then begin
writeln(f);
pixelsleft:=printer.pagewidth-tl;
write(f,copy(messmemo.text,messlen,found-messlen+2));
end;
end;
end else begin
writeln(f,copy(messmemo.text,messlen,length(messmemo.text)));
done:=true;
end;
messlen:=found+2;
end;
{for messlen :=0 to messmemo.Lines.count-1 do
writeln(f,messmemo.lines[messlen]);}
printer.newpage;
end;
finally closefile(f); end;
end;
processing:=false;
end;

procedure TMessForm.Close1Click(Sender: TObject);
begin
messforms[winnum].release;
end;

procedure TMessForm.toeditChange(Sender: TObject);
var num:integer;
begin
end;

procedure TMessForm.tocomboClick(Sender: TObject);
begin
toedit.visible:=not toedit.visible;
ccedit.visible:=false;
end;

procedure TMessForm.cccomboClick(Sender: TObject);
begin
ccedit.visible:=not ccedit.visible;
toedit.visible:=false;
end;

procedure TMessForm.FormClick(Sender: TObject);
begin
toedit.visible:=false;
ccedit.visible:=false;
end;

procedure TMessForm.Delete1Click(Sender: TObject);
begin
toedit.visible:=false;
ccedit.visible:=false;
  form1.wpo.commandstring:='ItemDelete("'+widestring(messageid) +'";0;;0;)';
  close;
end;

procedure TMessForm.filelistChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
filelist.hint:=item.caption;
end;

procedure TMessForm.Copy1Click(Sender: TObject);
begin
messmemo.copytoclipboard;
end;



procedure TMessForm.SaveSelected1Click(Sender: TObject);
var flags,doc:integer;savefile,tmpfile,dispname,fname,fpath:string;status:statrec;classid:string;
useridform:tuseridform;res2,modres:integer;filepath:pchar;res,dontopen:boolean;fileinfo:tshfileinfo;
begin
processing:=true;
for doc := 0 to (filelist.items.count-1) do
if filelist.items[doc].selected then begin
form1.WPO.CommandString:='itemattachmentgetclass("'+messageid+'";'+inttostr(doc)+')';
classid:=form1.WPO.commandreturn;
if classid <>'1' then begin
  ViewSelClick(Sender);
end else
begin
{if modres<>mrcancel then} begin
form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')';
dispname:=form1.wpo.commandreturn;

if pos('Token failed',dispname)=0 then

begin
processname(dispname,fname,fpath);
{tmpfile := form1.PGP.PGPPath+'doc'+inttostr(doc);}
tmpfile:=form1.pgp.pgppath+fname{changefileext(form1.pgp.pgppath+fname,'.')};
{tmpfile := form1.PGP.PGPPath+'doc'+inttostr(doc);}
savefile:=tmpfile{changefileext(tmpfile,'.asc')};
form1.WPO.CommandString := 'ItemAttachmentSaveAs ("'+messageid+'";'+inttostr(doc)+';"' + savefile+'")';
dontopen:=false;
if not decryptfile(tmpfile,status) then begin
dontopen:=true;
tmpfile:=savefile;
end;
begin
if status.mess<>'' then begin
setforegroundwindow(application.handle);
sendPGPlogmsg(application.handle,pchar(status.logmess));

{messagedlg(status.mess,mtinformation,[mbOK],0);}
end;
if comparetext(tmpfile,savefile)<>0 then
form1.pgp.wipefile(savefile);
if {modres=mrretry} (sender as tComponent).tag=1 then begin
if (not dontopen) or status.key then begin
form1.savedial.filename:=extractfilename(tmpfile);
Flags:=  SHGFI_TYPENAME;
 SHGetFileInfo(pchar(tmpfile),0,FileInfo,SizeOf(FileInfo),Flags);
 form1.savedial.filterindex:=1;
 if status.key then
   form1.SaveDial.filter:='PGP Key Files (*'+extractfileext(tmpfile)+')|*'+extractfileext(tmpfile)+'|'+allfiles
 else if extractfileext(tmpfile)<>'' then
 form1.SaveDial.filter:=strpas(fileinfo.sztypename)+' (*'+extractfileext(tmpfile)+')|*'+extractfileext(tmpfile)+'|'+allfiles else
      form1.savedial.filter:=allfiles;
  form1.savedial.defaultext:='';
 form1.savedial.title:= chooseloc + Inttostr(doc);

if form1.savedial.execute and (form1.savedial.filename <> '') then begin
      if form1.savedial.FilterIndex=1 then form1.savedial.DefaultExt:=copy(extractfileext(tmpfile),2,3)
   else form1.savedial.defaultext:='';
    form1.savedial.filename:=form1.savedial.filename+'.'+form1.savedial.DefaultExt;
   form1.savedial.initialdir:=extractfilepath(form1.savedial.filename);
   if comparetext(tmpfile,form1.savedial.filename)<>0 then
   sysutils.deletefile(form1.savedial.filename);
   renamefile(tmpfile,form1.savedial.filename);
   end else
   form1.pgp.wipefile(tmpfile);
   end else
   form1.pgp.wipefile(tmpfile)
   end;
if {modres=mryes} (sender as tComponent).tag=0 then begin
if not dontopen then begin
   delbox.Items.add(tmpfile);
res2:=ShellExecute(application.handle,nil,pchar(tmpfile),nil,nil,SW_SHOWDEFAULT);
if res2= SE_ERR_NOASSOC then begin

form1.filedial.title:=selectexecutable;
form1.filedial.filter:=executables;
if form1.FileDial.Execute and (form1.filedial.filename <> '')  then
res2:=ShellExecute(application.handle,nil,pchar(form1.filedial.filename),pchar('"'+tmpfile+'"'),nil,SW_SHOWDEFAULT);
end;
end;
end;

 end;{ else
   form1.pgp.wipefile(savefile);} end else begin
 messagedlg(oleattached,mtWarning,[mbOK],0);
 end;
 end;
  end;
   end;
form1.pgp.cleandecrypt;
processing:=false;
end;

procedure TMessForm.MessMemoMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
toedit.visible:=false;
ccedit.visible:=false;
end;

function stripspace(original:string):string;//strip spaces from a string
begin
  while Pos(' ', original) > 0 do
    original:=copy(original,0,Pos(' ', original)-1)+copy(original,pos(' ',original)+1,length(original));
      while Pos(':', original) > 0 do
    original:=copy(original,0,Pos(':', original)-1)+copy(original,pos(':',original)+1,length(original));
   result:=original;
  end;


procedure TMessForm.ViewSelClick(Sender: TObject);//view,save or open a groupwise attachment
var doc:integer;savefile,tmpfile,dispname,fname,fpath,err:string;status:statrec;classid:string;
attachmess,ver,atts:variant;
begin
processing:=true;

for doc := 0 to (filelist.items.count-1) do
if filelist.items[doc].selected then begin
 form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')';
dispname:=form1.wpo.commandreturn;


if (sender as tcomponent).tag=0 then begin
if form1.gwhandle<>0 then
setforegroundwindow(form1.gwhandle);
application.processmessages;
form1.passthrough:=true;
form1.wpo.commandstring:='ItemOpen("'+dispname+'")';
err:=form1.wpo.commanderror;
end;
if (sender as tcomponent).tag=1 then begin
attachmess :=unassigned;
try
atts:=messvar.attachments.item(doc+1);
attachmess:=atts.message;
except end;
{try
attachmess:=account.getmessage(widestring(dispname));//get the attachment message
except end;}
if (not varisnull(attachmess)) and (not varisempty(attachmess)) then begin
ver:=attachmess.documentversion;
dispname:=stripspace(attachmess.subject.plaintext)+'.'+ver.originalfiletype;
{processname(dispname,fname,fpath);}
tmpfile:=form1.pgp.pgppath+dispname;
form1.savedial.filename:=extractfilename(tmpfile);
form1.savedial.title:= chooseloc + Inttostr(doc);
if form1.savedial.execute and (form1.savedial.filename <> '') then begin
   form1.savedial.initialdir:=extractfilepath(form1.savedial.filename);
   form1.pgp.wipefile(tmpfile);
   ver.copyout(tmpfile);
end;
end;
end;
if (sender as tcomponent).tag=2 then begin
if form1.gwhandle<>0 then
setforegroundwindow(form1.gwhandle);
application.processmessages;
form1.wpo.commandstring:='ItemOpen("'+messageid+'")';
form1.wpo.commandstring:='AttachmentView(;'+inttostr(doc)+')';
if (pos('Token failed',form1.wpo.commandreturn)>0) and (doc>0) then
form1.wpo.commandstring:='AttachmentView(;'+inttostr(doc-1)+')';
end;
end;
processing:=false;
end;

procedure TMessForm.PopupMenu2Popup(Sender: TObject);
var ext,classid,dispname,fname,fpath,num:string;attachmess,atts:variant;
    doc:integer;
    listitem:tlistitem;
    openold:boolean;
begin
     num:='0';
     form1.WPO.CommandString := 'ItemAttachmentGetCount("'+messageid+'")';
     num := form1.WPO.CommandReturn;
     opendocument1.visible:=false;
viewselected1.visible:=false;
saveselected1.visible:=false;
if filelist.selcount>0 then
for doc := 0 to (strtoint(num)-1) do
begin
if filelist.items[doc].selected then begin
form1.WPO.CommandString:='itemattachmentgetclass("'+messageid+'";'+inttostr(doc)+')';
classid:=form1.WPO.commandreturn;
form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')';
dispname:=form1.wpo.commandreturn;
ext:=ExtractFileExt(dispname);
if classid ='1' then begin
if pos('Static',dispname)=0 then begin
saveselected1.visible:=true;
if (ext='.pgp') or (ext='.asc') then begin
saveselected1.caption:='Decrypt/Verify and &Save';
opendocument1.caption:='Decrypt/Verify and &Open'; end else
begin
saveselected1.caption:='&Save As...';
opendocument1.caption:='&Open';
end;
opendocument1.visible:=true;
viewselected1.visible:=true;
end else
begin
saveselected1.visible:=false;
opendocument1.visible:=false;
viewselected1.visible:=true;
end;
end
else
begin
attachmess :=unassigned;
try
atts:=messvar.attachments.item(doc+1);
attachmess:=atts.message;
except end;
{try
attachmess:=account.getmessage(widestring(dispname));//get the attachment message
except end;}
if (not varisnull(attachmess)) and (not varisempty(attachmess)) then
if (comparetext(copy(attachmess.classname,1,28),'GW.MESSAGE.DOCUMENTREFERENCE')=0) then//see if the attachment is a document reference
begin
viewselected1.visible:=true;
saveselected1.visible:=true;
saveselected1.caption:='&Save As...';
end else begin
saveselected1.visible:=false;
viewselected1.visible:=true;
end;
opendocument1.caption:='&Open';
opendocument1.visible:=true;

end;
end;
end;
end;

procedure TMessForm.OpenDocument1Click(Sender: TObject);
var doc:integer;dispname:string;
begin
form1.wpo.commandstring:='itemattachmentgetname("'+messageid+'";'+inttostr(doc)+')';
dispname:=form1.wpo.commandreturn;
form1.wpo.commandstring:='OpenDocument("'+dispname+'";)';       {199}
processing:=false;
end;

procedure TMessForm.filelistMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 if button=mbRight then popupmenu2.popup(x,y);
end;

procedure TMessForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
if processing then begin
messagedlg(cantclose,mtwarning,[mbOK],0);
canclose:=false;
end else
canclose:=true;
end;

procedure TMessForm.DecryptVerifyMessage1Click(Sender: TObject);
var
eline,tmpfile:string;TMP:string ;status:statrec;
   fname:textfile; count:longint;
   modres:integer;
   recip,tempmes,newmes:variant;
   origmess,messid,dateinfo,subinfo,frominfo,siginfo:string;
   ok,done:boolean;newmessform:tmessform;

dispname,eaddress,etype,messtext,messtype:string;
begin
try
   tmpfile:=messmemo.lines.text//get the text
   except

   end;

   if pgp2.decrypttext(tmpfile,status) then //decrypt the text - continue if OK

    begin
          try
          form1.pgp.cleandecrypt;
     for count:=0 to 254 do begin
     if not assigned(messforms[count]) then
     begin
     application.createform(tmessform,messforms[count]);
     newmessform:=messforms[count];
     newmessform.winnum:=count;
     break;
     end;
     end;
     if assigned(newmessform) then begin
     newmessform.messvar:=messvar;
     newmessform.messageid:=messageid; //set up the variable to display

     siginfo:=status.mess;
     newmessform.caption:=caption;
     newmessform.fromedit.text:=fromedit.text;
     newmessform.fromlist.text:=fromlist.text{+'^'+gwmess.sender.emailtype};
     newmessform.subjectedit.text:=subjectedit.text;
     for count:=1 to messvar.recipients.count do begin
     recip:=messvar.recipients.item(count);
     dispname:=recip.displayname;
      eaddress:=recip.emailaddress;
      etype:=recip.emailtype;
     if recip.targettype=0
     then begin
     newmessform.toedit.items.add(dispname);
     if newmessform.toedit.items.count=1 then
     newmessform.tocombo.text:=newmessform.toedit.items[0] else
     newmessform.tocombo.text:=newmessform.tocombo.text+'; '+newmessform.toedit.items[(newmessform.toedit.items.count-1)];
     newmessform.tolist.items.add(eaddress{+'^'+etype});
     end;
     if recip.targettype=1
     then begin
     newmessform.ccedit.items.add(dispname);
     newmessform.cclist.items.add(eaddress{+'^'+etype});
      if newmessform.ccedit.items.count=1 then
     newmessform.cccombo.text:=newmessform.ccedit.items[0] else
     newmessform.cccombo.text:=newmessform.cccombo.text+'; '+newmessform.ccedit.items[newmessform.ccedit.items.count-1];

     end;
     end;
{     datetimetostring(dateinfo,'ddd, mmm d, yyyy h:nn AM/PM'  ,gwmess.creationdate);}
     newmessform.statbar.simpletext:=statbar.simpletext;
     newmessform.messmemo.clear; //clear what is there now
    newmessform.filllist; //setup the list of attachments
     newmessform.messmemo.lines.text:=tmpfile; //put the decrypted text into the memo

     done:=false;
{     setupmesstypes(status,newmessform.messvar,newmessform);}
  try
   tmpfile:=newmessform.messmemo.lines.text//get the text
   except

   end;
   if (pos('-----BEGIN PGP',tmpfile)>0) then begin
   newmessform.decmess.enabled:=true;
   newmessform.DecryptVerifyMessage1.enabled:=true;
   end
   else
   begin
   newmessform.decmess.enabled:=false;
      newmessform.DecryptVerifyMessage1.enabled:=false;
   end;
        newmessform.show;
        newmessform:=nil;
      //show the decrypted message and wait until a button is clicked
end;
         except
         end;
     end;
form1.pgp.cleandecrypt; //clean up the decrypt variables
   release;
end;



procedure TMessForm.ForwardTextOnly1Click(Sender: TObject);
begin
processing:=true;
if form1.gwhandle<>0 then
setforegroundwindow(form1.gwhandle);
application.processmessages;
form1.passthrough:=true;
  form1.wpo.commandstring:='NewMail()';
  application.processmessages;
  replyproc;
 processing:=false;
end;

procedure TMessForm.ForwardOriginal1Click(Sender: TObject);
begin
processing:=true;
if form1.gwhandle<>0 then
setforegroundwindow(form1.gwhandle);
application.processmessages;
form1.passthrough:=true;
form1.wpo.commandstring:='ItemOpen("'+messageid+'")';
  form1.wpo.commandstring:='ItemForward()';
  application.processmessages;
processing:=false;
end;

procedure TMessForm.ForwardDecryptedMessage1Click(Sender: TObject);
begin
processing:=true;
savealltogroupwise1click(sender);
application.processmessages;
  form1.wpo.commandstring:='ItemForward()';
  application.processmessages;
  processing:=false;
end;

procedure TMessForm.ReadPrevious1Click(Sender: TObject);
begin
if form1.gwhandle<>0 then
setforegroundwindow(form1.gwhandle);
application.processmessages;
form1.passthrough:=true;
form1.wpo.commandstring:='ItemOpen("'+messageid+'")';
  form1.wpo.commandstring:='ItemReadPrevious()';
  application.processmessages;
  free;

end;

procedure TMessForm.ReadNext1Click(Sender: TObject);
begin
if form1.gwhandle<>0 then
setforegroundwindow(form1.gwhandle);
application.processmessages;
form1.passthrough:=true;
form1.wpo.commandstring:='ItemOpen("'+messageid+'")';
  form1.wpo.commandstring:='ItemReadNext()';
  application.processmessages;
  free;

end;

end.
