
{+//____________________________________________________________________________ }
{-Copyright (C) 1996-1998 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-$Id: pgpexsdk.PAS,v 1.11.12.7 1999/10/01 18:45:34 build Exp $ }
{=____________________________________________________________________________ }
unit pgpexsdk;

interface

uses
  SysUtils, Windows,WinTypes, WinProcs, Messages, Classes, Graphics, Controls,extctrls,
  Forms, Dialogs, StdCtrls,registry,pgpsdkprefs,pflpreftypes,pgpclip,pflprefs,
  pgputilities,pgpbase,pgpkeys,pgppubtypes,pgperrors, pgppflerrors,pgpencodes,   pgprecip,pgpcmdlg,pgpkm,userid
  {$IFDEF PGP6}
  ,pgptls,pgpmemory{,pgpui};
  {$ELSE}
  ;
  {$ENDIF}




resourcestring
invalidlog=' (Invalid)';
disabledlog=' (Disabled)';
expiredlog=' (Expired)';
revokedlog=' (Revoked)';
enterphrase='Enter Passphrase';
toosmall='Message is too large for PGP GroupWise to process.';
phrasetooshort='Passphrase is not of sufficient length.  Please choose another.';
sigstatstart='*** PGP Signature Status: ';
unknownkey='unknown';
unknownsig='good; key validity unknown';
goodsig='good';
badsig='bad';
keyinvalid='key is invalid';
keyunknown='Unknown, Key ID = ';
sigstatsigner='*** Signer: ';
sigstatdatesigned='*** Signed: ';
sigstatdateverified='*** Verified: ';
sigstatvalidity='***Validity: ';
sigstatbeginver='*** BEGIN PGP VERIFIED MESSAGE ***'+chr(13)+chr(10);
sigstatendver=chr(13)+chr(10)+'*** END PGP VERIFIED MESSAGE ***';
sigstatbegindec='*** BEGIN PGP DECRYPTED MESSAGE ***'+chr(13)+chr(10);
sigstatbegindecver='*** BEGIN PGP DECRYPTED/VERIFIED MESSAGE ***'+chr(13)+chr(10);
sigstatenddec=chr(13)+chr(10)+'*** END PGP DECRYPTED MESSAGE ***';
sigstatenddecver=chr(13)+chr(10)+'*** END PGP DECRYPTED/VERIFIED MESSAGE ***';
newkeys='You have added keys from a key server.  Select the keys you want to add to your keyring.';
multiplekeys='Multiple keys for userid.  Selecting first one.';
nokeys='No keys match userid.';
messagesignedby='The message is signed by ';
messagechecked='  The message is: checked';
messageverified='The Signature is Good.';
messagevalid='; valid above the minimum threshhold';
messagedisabled='; disabled!';
messageexpired='; expired!';
messagerevoked='; revoked!';
messagenotvalid='The key does not meet minimum validity.';
messagenotverified='  The Signature is Bad.';
messagenotchecked='  The key could not be checked.';
validityunknown='  Key validity is unknown.';
keyisinvalid='  Key is invalid or untrusted.';
keymarginal='  Key validity is marginal.';
keytrusted='  Key validity is axiomatic.';
defkeymess='You need to create and select a default key';
keyincluded='  A key was included in the message.  If the key was the only data, there may be no decoded data.';
wiping='Wiping ';
selectrecips='Select the recipients of the message.';
fileprocessing='File processing status';
selectkeys='Select the keys you wish to mail.';
processing='Processing';
currentfile='Progress on current file';
youshouldaddmess='Your Groupwise address is: %s which differs from the address on your default key.  You may want to add your Groupwise address as a userid to your private key to facilitate autoselection of recipients.  ';
seeagain='Click ''YES'' if you want to be reminded next time you start Groupwise and click ''NO'' if you do not wish to see this message again.';
checkandaddmess='PGP will add your Groupwise address: %s to your default key: %s.  This will make it easier for internal users to encrypt to your key.  After this first addition, you will have to add manually with PGPKeys.';
checkgoodmess='It appears that %d key(s) have your Groupwise address %s as a UserID.  If these keys are not the ones you give to others to use, you should add your Groupwise address to that key.';
nopgpkeys='PGPKeys must be closed in order to update the UserID.  Please close PGPKeys and press OK.';
decryptphrase='Please enter your passphrase:';
adduserphrase='Select a key to add %s to.';
selectandenter='Select the private key and enter passphrase.';
convencphrase='Enter conventional passphrase.';
decryptphrasewrong='Incorrect passphrase.  Please re-enter.';

const maxmesslen=32767;
var
pgpversionheaderstring:string;


type
  ptrpgpbyte=^pgpbyte;
  forcetype = (Force,NoForce);
  ENoFile=class(exception);
  registry=class(tregistry);

(*----------------------------------
Name: Statrec

Description: Record to hold PGP Status motion


-------------------------------------------*)
statrec=record
signer:string; //userid of the person who signed the message
validity:integer; //validity level
mess:string; //text message to be displayed to recipient
checked:boolean; //true if signature successfully checked
verified:boolean;//true if signature could be verified;
bad:boolean; //true if signature check fails
unknown:boolean;//true if key validity is unknown
date:string; //date of the signature
key:boolean;//key attached
logmess:string;

end;

(*----------------------------------
Name: decblock

Description: data record to hold information from each decrypted block
Linked list


-------------------------------------------*)
pdecblock=^decblock;
decblock=record
next:pdecblock;
previous:pdecblock;
output:pointer;
outputsize:integer;
sighead:pointer;
encrypted:boolean;
checked:boolean;
FYEO:boolean;
end;

(*----------------------------------
Name: mydata

Description: data record to hold information passed into PGPEncode and PGPDecode.
Holds a variety of information


-------------------------------------------*)
  Mydata=record
  ispgp:boolean; //true if it is a pgp message
  status:statrec; //status record
  password:pointer; //pointer to buffer holding password
  passkeylen:pgpuint32;
  handle:thandle; //handle to the application
  recipkeys:pgpkeysetref; //key list of all recipients
  keyids:pgpkeyidref; //key ids for recipients
  keycount:integer; //number of keys encrypted to
  passonce:boolean; //boolean check for cached passwords
  attach:boolean; //boolean for whether this is a file or buffer- true if file
  filename:string; //filename of the file
  oldfile:string; //temporary variable
  pgppath:string; //path to the pgp files
  outfilespec:PGPFilespecref; //spec to the output file
  currentblock:pdecblock;
  decryptedblock:pdecblock;
  outputwanted:boolean;
  end;

(*----------------------------------
Name: TPGP5List

Description: Remnant component from previous versions.  Loads key list into
scroll list.

-------------------------------------------*)

  TPGP5List = class(tlistbox)
  private
      ffilename : string;
      ftype:string;
      FSelectedItems:tstringlist;
    { Private declarations }
  protected
    { Protected declarations }
    procedure Click; override;
    procedure fnamewrite(fname:string);
  public
    { Public declarations }
    constructor Create(Aowner:Tcomponent); override;
    procedure Load;
    destructor destroy; override;
    function GetSelected:tstringlist;
    function GetUser(num:integer): string;
    property SelectedItems:Tstringlist read FSelectedItems write FSelectedItems;
  published
  property Filename: string read ffilename write fnamewrite;
  property Listtype:string read ftype write ftype;
    { Published declarations }
  end;

  (*----------------------------------
  Name: TPGP5DropList

  Description: remnant component from prior version.  loads key list into drop
  down list.

  -------------------------------------------*)
  TPGP5DropList = class(tcombobox)
  private
      ffilename : string;
      ftype:string;
      FSelectedItems:tstringlist;
{      fkeyset:pgpkeysetref;}
{}
    { Private declarations }
  protected
    { Protected declarations }
    procedure Click; override;
    procedure fnamewrite(fname:string);
  public
    { Public declarations }
    constructor Create(Aowner:Tcomponent); override;
    procedure Load;
    destructor destroy; override;
    function GetSelected:tstringlist;
    function GetUser(num:integer): string;
    property SelectedItems:Tstringlist read FSelectedItems write FSelectedItems;
  published
  property Filename: string read ffilename write fnamewrite;
  property Listtype:string read ftype write ftype;

    { Published declarations }
  end;

(*----------------------------------
Name: TPGP5

Description: Main component for PGP functions.


-------------------------------------------*)

  TPGP5 = class(TComponent)
  private
  fver:integer;
   FPGPPath:string;
   FPGPProg:string;
   FForcecheck:forcetype; //remnant - not used
   fPubring:string;
   fsecring:string;
   fsign,fsignone:boolean;
   fencrypt,fencryptone:boolean;
   fautodecrypt:boolean;
   fwrap:integer;
   err:pgperror;
   prefalg:PGPUInt32;
   allowedalgs:array[1..3] of PGPCipheralgorithm;
   numalgs:integer;
  function getkeylistfromid(id:string;kset:PGPKeysetRef):PGPkeysetRef;
  function getkeyfromid(id:string;kset:PGPKeysetRef):PGPkeyRef;
  protected
  procedure clean(filename:string);
  function GetAlgorithms:PGPError;
  public
  constructor create(Aowner:TComponent); override;
  destructor destroy; override;
  function Encrypt(var filename:string;useropt:integer;attach:boolean;isinternal:boolean):longint;virtual;
  function decrypt(var filename:string;var status:statrec;attach:boolean):pgperror;virtual;
  procedure cleandecrypt;virtual;
  function wipefile(filename:string):boolean;virtual;
  function ExtractKey(selectstat:integer;var output:string):boolean;virtual;
  procedure CleanEncrypt;virtual;
  procedure AddKey(fileref:pgpfilespecref);virtual;
  procedure setupKeyList;virtual;
  function getkeyringfiles:integer;virtual;
  procedure setkeyringfiles(pubring,secring:string);virtual;
  function ShowEncryptform(users:tstringlist):Boolean;virtual;
  procedure updatecache(Sender:Tobject);virtual;
  procedure showprefs;virtual;
  function getsignmsg:boolean;virtual;
  function getencryptmsg:boolean;virtual;
  function getautodecrypt:boolean;virtual;
  function getwrapbuffer:integer;virtual;
  procedure setpgppath(path:string);virtual;
  function getpgppath:string;virtual;
  procedure about;virtual;
  function checkandadd(address:string):boolean;virtual;
  procedure cleanup;virtual;
  published
  property PGPPath: string read getPGPPath write fpgppath;
  property PGPProg: string read FPGPProg write FPGPProg;
  property Forcecheck: forcetype read fforcecheck write fforcecheck; //remnant
  Property PGPPubring: string read fpubring write fpubring; //remnant
  Property PGPSecring: string read fsecring write fsecring; //remnant
  property signmsg:boolean read getsignmsg write fsign{setsignmsg};
  property signone:boolean read fsignone write fsignone;
  property encryptmsg:boolean read getencryptmsg write fencrypt{setencryptmsg};
  property encryptone:boolean read fencryptone write fencryptone;
  property autodecrypt:boolean read getautodecrypt write fautodecrypt;
  property wrapbuffer:integer read getwrapbuffer write fwrap;
  property pgpver:integer read fver write fver;
  end;



  function myEvents(fcontext:PGPContextRef;event:ptrPGPEvent;userValue:PGPUserValue):PGPError;cdecl;far;
  function getcachedpassphrase(phrasetype:integer;var password:pointer;force:boolean;keys:PGPKeysetref;keyids:pgpkeyidRef;numkeys:pgpuint32{$IFDEF PGP6} ;var passkeylen:pgpuint32 {$ENDIF}):Pgperror;



  const
//constants for mailing keys procedure
     mailkeydefault=0;
     mailkeyselect=1;
//constants for phrase caching procedure
     phrasetypesign=0;
     phrasetypedecrypt=1;
     phrasetypeconvenc=2;
     phrasetypeconvdec=3;


var
{$IFDEF PGP6}
ftlscontext:pgptlscontextref;
fmemmgr:PGPMEMORYMGRREF;
signcachekey,decryptcachekey:ppgpbyte;
signcachekeylen,decryptcachekeylen:PGPUInt32;
{$ENDIF}

 fcontext:pgpcontextref; //main context var
       cachetimer:ttimer; //cache timer var
       fkeyset:pgpkeysetref; //main keyset var
       pubfilename,secfilename:string; //remnant key file names
       globalstatus:mydata; //main var for PGPEncode and PGPDecode data
       recipinfo:recipientdialogstruct; //main var for recipients list
       signcacheactive,decryptcacheactive:boolean;//true if a password is cached
       signcachephrase,decryptcachephrase:Pchar;//cached phrase vars
       sendkey:pgpkeyref; //cached sending key var
       signcachetime,decryptcachetime:integer;    //time remaining in cache
       passwd:pointer;
       thepasskeylen:pgpuint32;


{procedure Register;}
function loadbothkeyrings:integer;
function reloadkeyrings:integer;
function closekeyrings:integer;

implementation
uses statunit;

(*************************************

Name: ErrorHandle

Description: General handler of errors.  Displays any error if necessary.

IN: ecode - PGPError that is the error to test

OUT: NONE

RETURNS: PGPError that was passed in.  This is a passthrough so that function results can be tested in code
         without using a temp variable

******************************************)
function ErrorHandle(ecode:PGPError):PGPError;
begin
result:=ecode;
if ecode=kPGPError_OutputBufferTooSmall then
messagedlg(toosmall,mterror,[mbOK],0) else
{$IFDEF PGP6}
PGPComdlgErrorMessage(application.handle,ecode);
{$ELSE}
PGPComdlgErrorMessage(ecode);
{$ENDIF}
end;





(*----------------------------------
Name: tpgp5.getpgppath

Description: retrieve PGPPath property

In: NONE

Out: NONE

Returns: Path to PGP - string

-------------------------------------------*)
function tpgp5.getpgppath:string;
var temppath:pchar;
begin
if fpgppath='' then begin
temppath:=stralloc(MAX_PATH);
         gettemppath(MAX_PATH,temppath);
{errorhandle(PGPcomdlgGetPGPPath(temppath,MAX_PATH));}


result:=strpas(temppath);
fpgppath:=strpas(temppath);
strdispose(temppath);
end else
result:=fpgppath;
end;

(*----------------------------------
Name: tpgpg5.about

Description: shows PGP about box

In: NONE

Out: NONE

Returns: NONE

-------------------------------------------*)
procedure tpgp5.about;
begin
application.processmessages;
setforegroundwindow(application.handle);
{$IFDEF PGP6}
PGPcomdlgHelpAbout(fcontext,application.handle,nil,nil,nil);
{$ELSE}
PGPcomdlgHelpAbout(application.handle,'',nil,nil);
{$ENDIF}

end;
procedure tpgp5.showprefs;
begin
           application.processmessages;
           setforegroundwindow(application.handle);
           {$IFDEF PGP6}
           errorhandle(PGPcomdlgPreferences(fContext,
                              application.handle,0,fkeyset));
           {$ELSE}
           errorhandle(PGPcomdlgPreferences(fContext,
                              application.handle,0));
           {$ENDIF}

end;

(*----------------------------------
Name: tpgp5.setpgppath

Description: CURRENTLY UNUSED - set the path to PGP files


In: path - string holding full path name

Out: NONE

Returns: NONE

-------------------------------------------*)
procedure tpgp5.setpgppath(path:string);
begin
fpgppath:=path;
end;


(*----------------------------------
Name: isntnull

Description:  utility to check whether pointer is null

In: ptr - pointer value

Out: NONE

Returns: boolean - true if not null, false otherwise

-------------------------------------------*)
  function isntnull(ptr:pointer):boolean;
begin
if ptr <> nil then result:=true else
result:=false;
end;

(*----------------------------------
Name: signcacheOK

Description: determines whether the signing cache is on

In: NONE

Out: NONE

Returns: true if caching is on false otherwise

-------------------------------------------*)
  function signcacheok:boolean;
    var prefs:pgpprefref;
  res:integer;
  data:PGPBOOLEAN;

  begin
     result:=false;
     {$IFDEF PGP6}
       	res:= errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
                   {$ELSE}
      	res:= errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
                   {$ENDIF}


        if res =kpgperror_noerr then begin
        res :=PGPGetPrefBoolean(prefs, kPGPPrefSignCacheEnable,data);
        errorhandle(res);
         if res=kpgperror_noerr then
         result:=boolean(data);

        errorhandle(PGPcomdlgCloseclientPrefs(Prefs,false));
         end;

  end;

  (*----------------------------------
  Name: decryptcacheok

  Description: function to check whether the decrypt caching is turned on

  In: NONE

  Out: NONE

  Returns: true if pref is on, false otherwise

  -------------------------------------------*)
  function decryptcacheok:boolean;
    var prefs:pgpprefref;
  res:integer;
  data:PGPBOOLEAN;

    begin
       result:=false;
       {$IFDEF PGP6}
         	res:=errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
       {$ELSE}
         	res:=errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
       {$ENDIF}

        if res =kpgperror_noerr then begin
        res :=PGPGetPrefBoolean(prefs, kPGPPrefDecryptCacheEnable,data);
        errorhandle(res);
         if res=kpgperror_noerr then
         result:=boolean(data);

        errorhandle(PGPcomdlgCloseclientPrefs(Prefs,false));
         end;

  end;

  (*----------------------------------
Name: commentblock

Description: determines whether the signing cache is on

In: NONE

Out: NONE

Returns: true if caching is on false otherwise

-------------------------------------------*)
  function commentblock:string;
    var prefs:pgpprefref;
  res:integer;
  data:PChar;

  begin
  result:='';

data:=stralloc(512);
     result:='';
     try
     {$IFDEF PGP6}
       	res:= errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
                   {$ELSE}
      	res:= errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
                   {$ENDIF}
       if res =kpgperror_noerr then begin
        res :=PGPGetPrefStringBuffer(prefs,KPGPPrefComment,512,data);
        errorhandle(res);
        if res=kpgperror_noerr then
        if strcomp(data,'')<>0 then
         result:=strpas(data);
        errorhandle(PGPcomdlgCloseclientPrefs(Prefs,false));
         end;
         finally
strdispose(data);end;
  end;



(*************************************

Name: passmove

Description: copies a passkey from one location to another

IN: inkey - pointer to a pgpbyte containing the source passkey
    outkey - pointer to contain the destination passkey, memory must be allocated already
    keylen - integer that is the length of the inkey in bytes

OUT: outkey - pointer now contains the same data as inkey
            if inkey is nil, outkey will be unchanged

RETURNS: NONE

******************************************)

procedure passmove(inkey:ppgpbyte;var outkey:pointer;keylen:integer);
var tempptr:ppgpbyte;count:integer;
begin
if inkey<> nil then
begin
tempptr:=outkey;
for count :=1 to keylen do
begin
pgpbyte(tempptr^):=inkey^;
inc(tempptr);
inc(inkey);
end;
end;
end;

(*----------------------------------
Name: cleanpasskey

Description:   cleans up a passkey buffer.  Empties and frees memory

In: Passkey - pointer to the buffer
    passkeylen - length of the buffer

Out: passkey - null pointer
     passkeylen - 0

Returns: NONE

-------------------------------------------*)

procedure cleanpasskey(var passkey:ppgpbyte;var passkeylen:pgpuint32);
var tempptr:ppgpbyte;count:integer;
begin
if passkey<> nil then
begin
tempptr:=passkey;
for count :=1 to passkeylen do
begin
pgpbyte(tempptr^):=$00;
inc(tempptr);
end;
PGPFreeData(passkey);
passkey:=nil;
end;
passkeylen:=0;
end;


(*----------------------------------
Name: cleanpass

Description:   cleans up a password buffer.  Empties and frees memory

In: Password - pointer to the buffer

Out: password - null pointer

Returns: NONE

-------------------------------------------*)

procedure cleanpass(var password:pointer);
begin
if password<> nil then
begin
pgpcomdlgfreephrase(password);
{pgpfreedata(password);}
password:=nil;
end;
end;

  (*----------------------------------
  Name: tpgpg5.checkandadd

  Description: checks for an address on the keyring, and adds it to the
  default key if the userid is not present on any key in the keyring.  This
  is used by the init sequence to add the GroupWise address to the
  default key in order to allow for autoselection where the Grouwise address
  is different than the external internet address.

  In: address - string containing an address

  Out: NONE

  Returns: true if want to show this message each time, false if not.

  -------------------------------------------*)
 function tpgp5.checkandadd(address:string):boolean;
 var
 options:PGPOptionlistref;
 opts:pword;
name:pchar;bufsize:pgpsize;
tempkey,defkey:pgpkeyref;res:word;
outbuf:pointer;
nilkey:pgpkeyref;
addpasskey:ppgpbyte;
addpasskeylen:integer;
addkeyset,mutkeyset,signkeyset:pgpkeysetref;
numkeys:pgpuint32;
newadd,addpass:pchar;
 begin
 addpasskey:=nil;
 addpasskeylen:=0;
opts:=nil;
tempkey:=nil;
nilkey:=nil;
addkeyset:=nil;
if fkeyset<>nil then begin
signkeyset:=getkeylistfromid(address,fkeyset);
PGPCountKeys(signkeySet, numKeys);
if isntnull(signkeyset) then begin
pgpfreekeyset(signkeyset);
signkeyset:=nil;
if( numKeys < 1 ) then begin

tempkey:=nil;

end;
application.createform(tuseridform,useridform);
useridform.dontshowbox.Visible:=true;
useridform.OKBtn.visible:=true;
useridform.caption:='Information';
useridform.Open.visible:=false;
useridform.Save.visible:=false;
useridform.Cancel.visible:=false;
useridform.label1.caption:=format(youshouldaddmess,[address]);
setforegroundwindow(application.handle);
useridform.showmodal;
{if messagedlg(format(youshouldaddmess+seeagain,[address]),mtinformation,[mbYes,mbNo],0) =mrYes then}
if useridform.dontshowbox.checked then
result:=false
else
result:=true;
useridform.Release;
useridform:=nil;
end;
end;
end;

(*----------------------------------
Name: tpgp5.wipefile

Description: wipes a file from the disk

In: filename - string containing a full path and filename

Out: NONE

Returns: UNUSED CURRENTLY - value uninitialized

-------------------------------------------*)
  function tpgp5.wipefile(filename:string):boolean;
  var infile:file;filesize,numwrite:integer;tempchar:char;filehandle,maphandle:thandle;
  data,tempdata:pByte;filedata:pchar;
  begin
  if (FileGetAttr(FileName) and fareadonly)<>0 then
   showmessage('Could not wipe file '+filename+'.  This file must be manually wiped at a later time.');
  if fileexists(filename) then begin
try
try
randomize;
filehandle:=fileopen(filename,fmOpenReadWrite);
filesize:=getfilesize(filehandle,nil);
maphandle:=createfilemapping(filehandle,nil,PAGE_READWRITE,0,filesize,'wipe');
except showmessage('Could not wipe file '+filename+'.  This file must be manually wiped at a later time.'); end;
finally closehandle (filehandle); end;
try
try
data:=mapviewoffile(maphandle,FILE_MAP_WRITE,0,0,0);
except showmessage('Could not wipe file '+filename+'.  This file must be manually wiped at a later time.');end;
finally closehandle(maphandle);end;
try
try
if data<>nil then begin
tempdata:=data;

statform.progress.position:=0;
statform.caption:=wiping+filename;
statform.cancelbtn.hide;
for numwrite:= 1 to filesize do begin
if numwrite mod 100000 = 0 then
begin
statform.statlabel.caption:=currentfile;
     statform.statlabel.Alignment:=taCenter;
statform.show;
statform.progress.position:=trunc(numwrite/filesize*100);
application.processmessages;
end;
tempdata^:=byte(trunc(random(255)));
inc(tempdata);
end;
end;
except showmessage('Could not wipe file '+filename+'.  This file must be manually wiped at a later time.');end;
finally unmapviewoffile(data); statform.cancelbtn.show;statform.hide; end;
 sysutils.deletefile(filename);
 if fileexists(filename) then
 showmessage('Could not wipe file '+filename+'.  This file must be manually wiped at a later time.')
  end;
  end;

(*----------------------------------
Name: signcachemax

Description: function to determine the maximum time allowed in the signing
phrase cache

In: NONE

Out: NONE

Returns: time in seconds that a signing phrase will be cached

-------------------------------------------*)

  function signcachemax:PGPUInt32;
    var prefs:pgpprefref;
  res:integer;
  data:PGPUINT32;
    begin
         result:=0;
         {$IFDEF PGP6}
           	res:=errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
         {$ELSE}
           	res:=errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
         {$ENDIF}


        if res =kpgperror_noerr then begin
        res :=PGPGetPrefnumber(prefs, kPGPPrefSignCacheSeconds,data);
        errorhandle(res);
         if res=kpgperror_noerr then
         result:=data;

        errorhandle(PGPcomdlgCloseclientPrefs(Prefs,false));
         end;

  end;

(*----------------------------------
Name: decryptcachemax

Description: function to determine the maximum time allowed in the decrypt
phrase cache

In: NONE

Out: NONE

Returns: time in seconds that a decrypt phrase will be cached

-------------------------------------------*)

  function decryptcachemax:PGPUINT32;
    var prefs:pgpprefref;
  res:integer;
  data:PGPUINT32;

    begin
             result:=0;
             {$IFDEF PGP6}
               	res:=errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
             {$ELSE}
               	res:=errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
             {$ENDIF}

        if res =kpgperror_noerr then begin
        res :=PGPGetPrefnumber(prefs, kPGPPrefDecryptCacheSeconds,data);
        errorhandle(res);
         if res=kpgperror_noerr then
         result:=data;

        errorhandle(PGPcomdlgCloseclientPrefs(Prefs,false));
         end;

  end;




(*----------------------------------
Name: tpgp5.getautodecrypt

Description: function to retrieve autodecrypt property.  Determines if mail
is decrypted automatically upon opening

In: NONE

Out: NONE

Returns: true if preference is set, false otherwise

-------------------------------------------*)
  function tpgp5.getautodecrypt:boolean;
    var prefs:pgpprefref;
  res:integer;
  data:PGPBOOLEAN;
  begin
   result:=false;
   {$IFDEF PGP6}
     	res:=errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
   {$ELSE}
     	res:=errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
   {$ENDIF}

        if res =kpgperror_noerr then begin
        res :=PGPGetPrefBoolean(prefs, kPGPPrefAutoDecrypt,data);
        errorhandle(res);
         if res=kpgperror_noerr then
         result:=boolean(data);

        errorhandle(PGPcomdlgCloseclientPrefs(Prefs,false));
         end;

  end;

  (*----------------------------------
  Name: tpgp5.getwrapbuffer

  Description: function to retrieve wrap buffer length from PGP preferences

  In: NONE

  Out: NONE

  Returns: 0 if wrapping is off; length of buffer otherwise

  -------------------------------------------*)
  function tpgp5.getwrapbuffer:integer;
var   res:integer;data:pgpboolean;cols:pgpuint32;prefs:pgpprefref;
  begin
  result:=0;
  {$IFDEF PGP6}
  	res:=errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
  {$ELSE}
  	res:=errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
  {$ENDIF}

        if res =kpgperror_noerr then begin
        res :=PGPGetPrefBoolean(prefs,kPGPPrefWordWrapEnable,data);
        errorhandle(res);
         if res=kpgperror_noerr then
          if boolean(data) then begin
           res :=PGPGetPrefnumber(prefs,kPGPPrefWordWrapWidth,cols);
           if res=kpgperror_noerr then result:=cols;
           errorhandle(res);
          end;

        errorhandle(PGPcomdlgCloseClientPrefs(Prefs,false));
  end;
  end;


(*----------------------------------
Name: axiomatic

Description:   function to determine if a key is axiomatic

In: NONE

Out:    NONE

Returns:    true if axiomatic, false otherwise

-------------------------------------------*)
  function axiomatic(key:pgpkeyref):boolean;
var  ax:PGPBoolean;res:PGPError;
  begin
  result:=false;
 res:= PGPGetKeyBoolean(key,  kPGPKeyPropIsAxiomatic,ax);
 errorhandle(res);
 if res=kpgperror_noerr then
    result :=boolean(ax);
  end;


(*----------------------------------
Name: marginalinvalid

Description: function to retrieve setting from PGP prefs.  Determines how to
treat marginally valid keys

In: NONE

Out: NONE

Returns: true if treat as invalid, false otherwise

-------------------------------------------*)
  function marginalinvalid:boolean;
  var prefs:pgpprefref;
  res:integer;
  data:PGPBOOLEAN;
  begin
       result:=false;
       {$IFDEF PGP6}
       	res:=errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
       {$ELSE}
       	res:=errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
       {$ENDIF}

        if res =kpgperror_noerr then begin
        res :=PGPGetPrefBoolean(prefs,kPGPPrefMarginalIsInvalid,data);
        errorhandle(res);
         if res=kpgperror_noerr then
         result:=boolean(data);
        errorhandle(PGPcomdlgCloseClientPrefs(Prefs,false));
         end;
  end;

(*----------------------------------
Name: tpgp5.getsignmsg

Description: retrieve the signmsg property.  Determines the auto sign mail
in the PGP prefs

In: NONE

Out: NONE

Returns: true if pref is set, false otherwise

-------------------------------------------*)
  function tpgp5.getsignmsg:boolean;
  var prefs:pgpprefref;
  res:integer;
  data:PGPBOOLEAN;
  begin
       result:=false;
       {$IFDEF PGP6}
       	res:=errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
       {$ELSE}
       	res:=errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
       {$ENDIF}

        if res =kpgperror_noerr then begin
        res :=PGPGetPrefBoolean(prefs,kPGPPrefMailSignDefault,data);
        errorhandle(res);
         if res=kpgperror_noerr then
         result:=boolean(data);

        errorhandle(PGPcomdlgCloseClientPrefs(Prefs,false));
         end;
    end;


  (*----------------------------------
Name: tpgp5.getencryptmsg

Description: retrieve the encryptmsg property.  Determines the auto encrypt mail
in the PGP prefs

In: NONE

Out: NONE

Returns: true if pref is set, false otherwise

-------------------------------------------*)
  function tpgp5.getencryptmsg:boolean;
  var prefs:pgpprefref;
  res:integer;
  data:PGPBOOLEAN;

  begin
       result:=false;
{$IFDEF PGP6}
  	res:=errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
{$ELSE}
  	res:=errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
{$ENDIF}
        if res =kpgperror_noerr then begin
        res :=PGPGetPrefBoolean(prefs,kPGPPrefMailEncryptDefault,data);
        errorhandle(res);
         if res=kpgperror_noerr then
         result:=boolean(data);
        errorhandle(PGPcomdlgCloseClientPrefs(Prefs,false));
         end;
  end;

  (*----------------------------------
  Name: tpgp5.showencryptform

  Description: shows the recipients dialog

  In: users - tstringlist containing the UserID's of the recipients.  If this
  is not empty, those UserID's will be sent to the dialog for autoselection

  Out: NONE

  Returns: true if no error, false if error or cancel

  -------------------------------------------*)
function tpgp5.ShowEncryptform(users:tstringlist):boolean;
      var res:integer;
title,name:pchar;bufsize:pgpsize;
numadd:pgpuint32;
temparray:ppchar;
num:integer;
flags,opts,disableflags:dword;
begin

reloadkeyrings;
with recipinfo do begin

getmem(temparray,sizeof(pchar)*users.count);
szrecipientarray:=temparray;
for num := 0 to (users.count-1) do begin
temparray^:=pchar(users.strings[num]);
inc(temparray);
end;

  Version:=ord(curver[1]) shl 24 + ord(curver[2]) shl 16+ord(curver[3]) shl 8+ord(curver[4]);//Curver is a constant for recipient - currently 'DUKE'
    hwndParent:= application.handle;
    title:=strnew(pchar(selectrecips));
    szTitle:=title;
    context:=fcontext;
    OriginalKeySetRef:= fkeyset;
    SelectedKeySetRef:=nil;
    opts:=PGPCOMDLG_ASCIIARMOR;
    dwOptions:=opts;
    dwnumrecipients:=users.count;
    flags:=0;
    dwFlags:=flags;
    if users.count=0 then
        disableflags:=PGPCOMDLG_DISABLE_ASCIIARMOR+PGPCOMDLG_DISABLE_WIPEORIG +PGPCOMDLG_DISABLE_AUTOMODE+PGPCL_DISABLE_FYEO{$IFDEF PGP65}+ PGPCL_DISABLE_SDA{$ENDIF}
    else
    disableflags:=PGPCOMDLG_DISABLE_ASCIIARMOR+PGPCOMDLG_DISABLE_WIPEORIG+PGPCOMDLG_DISABLE_AUTOMODE+PGPCL_DISABLE_FYEO{$IFDEF PGP65}+ PGPCL_DISABLE_SDA{$ENDIF};
    dwDisableFlags:=disableflags;
    {$IFDEF PGP6}
    tlsContext:=ftlscontext;
    addedkeys:=nil;
    {$ENDIF}
end;
result:=false;
{$IFDEF PGP6}
res:=PGPclRecipientDialog(@recipinfo);
{$ELSE}
res:=PGPRecipientDialog(@recipinfo);
{$ENDIF}

if res<>0 then
begin
{$IFDEF PGP6}
if recipinfo.addedkeys<>nil then begin
PGPCountKeys(recipinfo.addedkeys,numAdd);
if numadd>0 then begin
messagedlg(newkeys,mtconfirmation,[mbOK],0);
errorhandle(PGPkmQueryAddKeys(fcontext,ftlscontext,
                                         application.handle,
                                         recipinfo.AddedKeys,nil));
end;
end;
strdispose(title);
{$ENDIF}
result:=true;
 end;
end;

(*Get a keyid string from a keyid*)
function getkeystr(keyid:pgpkeyid):string;
var ret:pgpidstringarray;
begin

PGPGetKeyIDString (@KeyID, kPGPKeyIDString_Abbreviated, ret);
result:=strpas(ret);
end;

(* UNUSED CURRENTLY*)
procedure tpgp5droplist.fnamewrite(fname:string);
begin
ffilename:=fname;
if ftype='public' then
pubfilename:=fname else
secfilename:=fname;
end;

(*----------------------------------
Name: myevents

Description:  callback handler for PGPDecode and PGPEncode

In: fcontext - the main context
    event - pointer to the event record
    uservalue - pointer to a record of mydata

Out: NONE

Returns: varies by event, but always a PGPError.  kPGPError_noerr is default;

-------------------------------------------*)
function myEvents(fcontext:PGPContextRef;event:ptrPGPEvent;userValue:PGPUserValue):PGPError;cdecl;far;
var temptimestring:string;tempsighead:pointer;doblock:boolean;tempblock:pdecblock;opts:pword;passphrase:pointer;name:pchar;size:integer;bufsize:pgpsize;localstatus:mydata;
nilkeyset:pgpkeysetref;nilkey:pgpkeyref;res:integer;numkeys,count:pgpuint32;idarray1,idarray2:PGPKeyidref;test:pchar;
temptime:PGPTime;year,month,day:PGPUint16;thepasskeylen:integer;tempkeyids,tempmykeyids:pgpkeyidref;tempptr:pointer;
timezone:ttimezoneinformation;vtime:tdatetime; pgptimestring:string;vtimetemp1,vtimetemp2:int64;daylight:integer;cansign:pgpboolean;
begin
result:=kpgperror_NoErr;
if  event.typev=kPGPEvent_EndLexEvent then begin //last lex event
  if mydata(uservalue^).recipkeys <>nil then begin
  PGPFreeKeySet(mydata(uservalue^).recipkeys); //clean up any recipient keys, as we don't want them to effect the next PGP block
  mydata(uservalue^).recipkeys:=nil;
   end;
end;

if event.typev=kPGPEvent_BeginLexEvent then begin //first lex event
mydata(uservalue^).ispgp:=true; //notify future events that this is a PGP message
end;
if event.typev=kPGPEvent_NullEvent then begin //for status updates - doesn't really get used but is there just in case
if statform.cancelbtn.tag=1 then begin
   result:=kPGPError_UserAbort;
   statform.Hide;
   end;
if event.data.nulldata.bytesTotal>0 then  begin
statform.caption:=fileprocessing;
statform.statlabel.caption:=currentfile;
     statform.statlabel.Alignment:=taCenter;
statform.show;
statform.progress.position:=trunc(event.data.nulldata.bytesWritten/event.data.nulldata.bytesTotal*100);
application.processmessages;
end;
end else
if event.typev=kPGPEvent_analyzeevent then begin
if not mydata(uservalue^).attach then begin
if event.data.analyzedata.sectiontype=kPGPAnalyze_Encrypted then
mydata(uservalue^).currentblock^.encrypted:=true else
mydata(uservalue^).currentblock^.encrypted:=false;
end;
if event.data.analyzedata.sectiontype=kPGPAnalyze_Unknown then
   result:=kPGPError_SkipSection;
end else
if event.typev=kPGPEvent_Outputevent then begin //Output event
tempblock:=nil;
if not mydata(uservalue^).attach then begin
pgpaddjoboptions(event.job,PGPOAllocatedOutputBuffer(fcontext,mydata(uservalue^).currentblock^.output,maxmesslen,mydata(uservalue^).currentblock^.outputsize),PGPOLastOption(fcontext)); //add the outfilespec to the job
{$IFDEF PGP6}
tempblock:=PGPNewData(fmemMgr,sizeof(decBlock),kPGPMemoryMgrFlags_Clear);
{$ELSE}
tempblock:=PGPNewData(fcontext,sizeof(decBlock));
{$ENDIF}
tempblock.output:=nil;
tempblock.outputsize:=0;
tempblock.sighead:=nil;
tempblock.checked:=false;
mydata(uservalue^).currentblock^.next:=tempblock;
mydata(uservalue^).currentblock^.next^.previous:=mydata(uservalue^).currentblock;
mydata(uservalue^).currentblock^.next^.previous^.sighead:=nil;
mydata(uservalue^).currentblock:=tempblock;
end
else begin
mydata(uservalue^).outputwanted:=true;
if event.data.outputdata.suggestedName <> '' then //if there is a suggested name, then use it - uses pgppath as temp directory
mydata(uservalue^).filename:=mydata(uservalue^).pgppath+strpas(event.data.outputdata.suggestedName) else
mydata(uservalue^).filename:=mydata(uservalue^).oldfile; //if no suggested name, use the default
errorhandle(PGPNewFilespecFromFullPath(fcontext,pchar(mydata(uservalue^).filename),mydata(uservalue^).outfilespec));
pgpaddjoboptions(event.job,PGPOoutputFile(fcontext,mydata(uservalue^).outfilespec),PGPOLastOption(fcontext)); //add the outfilespec to the job
end;
end else
if event.typev=kPGPEvent_PassphraseEvent then begin //passphrase event
opts:=nil;
nilkeyset:=nil;
nilkey:=nil;
if mydata(uservalue^).password <> nil then //free any existing password
cleanpass(mydata(uservalue^).password);
if boolean(event.data.passphrasedata.fconventional) then //if conventional, then get a conventional password
res:=getcachedpassphrase(phrasetypeconvdec,passphrase,mydata(uservalue^).passonce,nil,nil,0{$IFDEF PGP6} ,mydata(uservalue^).passkeylen {$ENDIF})
else begin
res:= getcachedpassphrase(phrasetypedecrypt,passphrase,mydata(uservalue^).passonce,mydata(uservalue^).recipkeys,mydata(uservalue^).keyids,mydata(uservalue^).keycount{$IFDEF PGP6} ,mydata(uservalue^).passkeylen {$ENDIF}); //if decrypt, then get a decrypt password
end;
mydata(uservalue^).passonce:=true; //set a flag that we got this event once to keep from an unending cache loop if cache password is wrong
if res=kpgperror_noerr then begin
mydata(uservalue^).password:=passphrase;
{$IFDEF PGP6}
if mydata(uservalue^).passkeylen =0 then
pgpaddjoboptions(event.job,PGPOPassphrasebuffer(fcontext,mydata(uservalue^).password,strlen(passphrase)),PGPOLastOption(fcontext)) //send the new password
else
pgpaddjoboptions(event.job,PGPOPassKeybuffer(fcontext,mydata(uservalue^).password,mydata(uservalue^).passkeylen),PGPOLastOption(fcontext)) //send the new passkey
{$ELSE}
pgpaddjoboptions(event.job,PGPOPassphrasebuffer(fcontext,mydata(uservalue^).password,strlen(passphrase)),PGPOLastOption(fcontext)); //send the new password
{$ENDIF}


end
else
   result:=kPGPError_UserAbort; //userabort event
end;
if event.typev=kPGPEvent_SignatureEvent then //signature event
begin
doblock:=not mydata(uservalue^).attach;
if doblock then
if mydata(uservalue^).currentblock^.previous= nil then begin
{$IFDEF PGP6}
tempblock:=PGPNewData(fmemMgr,sizeof(decBlock),kPGPMemoryMgrFlags_Clear);
{$ELSE}
tempblock:=PGPNewData(fcontext,sizeof(decBlock));
{$ENDIF}
tempblock.output:=nil;
tempblock.outputsize:=0;
tempblock.sighead:=nil;
tempblock.checked:=false;
mydata(uservalue^).currentblock^.next:=tempblock;
mydata(uservalue^).currentblock^.next^.previous:=mydata(uservalue^).currentblock;
mydata(uservalue^).currentblock^.next^.previous^.sighead:=nil;
mydata(uservalue^).currentblock:=tempblock;
end;
daylight:=gettimezoneinformation(timezone);
temptime:=event.data.signaturedata.creationTime-((timezone.standardbias+timezone.bias)*60) -(integer(daylight=TIME_ZONE_ID_DAYLIGHT)*timezone.daylightbias*60); //get the signature date
try
{vtimetemp2:=PGPGetStdTimeFromPGPTime(temptime); }
vtime:=(temptime/86400)+25569;
datetimetostring(PGPtimestring,'m/d/yy h:nn:ss AMPM',vtime);
except end;
mydata(uservalue^).status.date:=PGPtimestring;
mydata(uservalue^).status.mess:='';
mydata(uservalue^).status.signer:='';
mydata(uservalue^).status.validity:=0;
mydata(uservalue^).status.bad:=false;
mydata(uservalue^).status.unknown:=false;
bufsize:=512;
name:=stralloc(bufsize);
if event.data.signaturedata.signingKey<>nil then
pgpgetprimaryuseridnamebuffer(event.data.signaturedata.signingKey,512,name,bufsize) else
strpcopy(name,'');
mydata(uservalue^).status.signer:=strpas(name);
mydata(uservalue^).status.verified:=boolean(event.data.signaturedata.verified);
if mydata(uservalue^).status.verified then mydata(uservalue^).status.logmess:='Good Signature'+chr(10) else
mydata(uservalue^).status.logmess:='Bad Signature'+chr(10);
mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+Extractfilename(mydata(uservalue^).filename)+chr(10);
if event.data.signaturedata.signingKey=nil then
mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+'(Unknown, KeyID='+getkeystr(event.data.signaturedata.signingkeyid)+')'+chr(10) else
mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+mydata(uservalue^).status.signer+chr(10);

 //get the signer
if mydata(uservalue^).status.signer <>'' then
mydata(uservalue^).status.mess:=messagesignedby+ strpas(name)+'.';
   if event.data.signaturedata.signingKey=nil then begin
    mydata(uservalue^).status.validity:=kPGPValidity_Unknown;
    end
    else begin
    PGPGetKeyNumber(event.data.signaturedata.signingKey,kPGPKeyPropValidity,mydata(uservalue^).status.validity);
{    PGPGetPrimaryUserIDValidity(event.data.signaturedata.signingKey,mydata(uservalue^).status.validity);}
    end;
    Case mydata(uservalue^).status.validity of
    kPGPValidity_Unknown:begin
    mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+'Invalid Key'+chr(10);
    mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+validityunknown;
        mydata(uservalue^).status.unknown:=true;
    end;
    kPGPValidity_Invalid:begin
    mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+'Invalid Key'+chr(10);
    mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+keyinvalid;
    mydata(uservalue^).status.signer:=mydata(uservalue^).status.signer+' '+invalidlog;
    mydata(uservalue^).status.unknown:=false;
    end;
    kPGPValidity_Marginal:begin
    mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+'Marginal Key'+chr(10);
    if marginalinvalid then begin
    mydata(uservalue^).status.validity:=kPGPValidity_Invalid;
        mydata(uservalue^).status.signer:=mydata(uservalue^).status.signer+' '+invalidlog;
    mydata(uservalue^).status.unknown:=false;
    end;
    mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+keymarginal;
    end;
    kPGPValidity_Complete:begin
    if not axiomatic(event.data.signaturedata.signingKey)
    then begin
    mydata(uservalue^).status.validity:=kPGPValidity_Marginal;
    mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+'Valid Key'+chr(10);
    end else begin
    mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+'Implicit Trust'+chr(10);
    mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+keytrusted;
    end;
    end;
   end;
if event.data.signaturedata.signingKey <> nil then
PGPGetKeyBoolean(event.data.signaturedata.signingKey, kPGPKeyPropIsSigningKey,CanSign)
else
cansign:=1;
if not boolean(cansign) then
    mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+'Signing algorithm not supported' else
if ((not boolean(event.data.signaturedata.verified)) and (event.data.signaturedata.signingKey <> nil)) then
mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+'Bad Signature'+chr(10) else begin
mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+mydata(uservalue^).status.date;



if doblock then
mydata(uservalue^).currentblock^.previous^.checked:=true;
          mydata(uservalue^).status.checked:=true{boolean(event.data.signaturedata.checked)};
   if event.data.signaturedata.signingkey=nil then
         mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+' (Unknown Key)' else
 if event.data.signaturedata.checked=1 then begin //fill out the status message with key validity info
     mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+messagechecked;
      begin
                   if event.data.signaturedata.verified=0 then begin
                         mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+messagenotverified;
                         mydata(uservalue^).status.bad:=true;
                          end else
                          mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+messageverified;

                   if event.data.signaturedata.keyDisabled=1 then begin
                   mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+disabledlog;
                      mydata(uservalue^).status.signer:=mydata(uservalue^).status.signer+' '+disabledlog;
                        mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+messagedisabled;
                        mydata(uservalue^).status.unknown:=true;
                          end else
                   if event.data.signaturedata.keyExpired=1 then begin
                        mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+messageexpired;
                        mydata(uservalue^).status.unknown:=true;
                   mydata(uservalue^).status.signer:=mydata(uservalue^).status.signer+' '+expiredlog;
                        mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+expiredlog;
                          end else
                   if event.data.signaturedata.keyrevoked=1 then begin
                   mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+revokedlog;
                   mydata(uservalue^).status.signer:=mydata(uservalue^).status.signer+' '+revokedlog;
                    mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+messagerevoked;
                        mydata(uservalue^).status.unknown:=true;
                          end else
                 if event.data.signaturedata.keymeetsvalidity=1 then begin
                   mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+messagevalid;
                   mydata(uservalue^).status.bad:=false;
                     end else begin
                   mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+'.  '+messagenotvalid;
                   mydata(uservalue^).status.logmess:=mydata(uservalue^).status.logmess+invalidlog;
                    mydata(uservalue^).status.signer:=mydata(uservalue^).status.signer+' '+invalidlog;
                    mydata(uservalue^).status.unknown:=true;
                       end;

                   end;
  end else begin
    mydata(uservalue^).status.mess:=mydata(uservalue^).status.mess+messagenotchecked;
    end;
    end;

   strdispose(name);
   if doblock then begin
   mydata(uservalue^).currentblock^.previous^.sighead:=nil;

   {$IFDEF PGP6}
   tempsighead:=PGPNewData(fmemMgr,1024,kPGPMemoryMgrFlags_Clear);
   {$ELSE}
   tempsighead:=PGPNewData(fcontext,1024);
   {$ENDIF}

   strcopy(pchar(tempsighead),'');
   {if mydata(uservalue^).status.checked then} begin
   strcat(pchar(tempsighead),pchar(sigstatstart));
   {if not mydata(uservalue^).status.verified then
      strcat(pchar(tempsighead),pchar(messagenotverified+chr(13)+chr(10)))

else} begin
 if mydata(uservalue^).status.verified then
strcat(pchar(tempsighead),pchar(goodsig+chr(13)+chr(10))) else
if event.data.signaturedata.checked=1 then
strcat(pchar(tempsighead),pchar(badsig+chr(13)+chr(10))) else
 if event.data.signaturedata.signingKey=nil then begin
{ strcat(pchar(tempsighead),pchar(unknownsig+chr(13)+chr(10)));}
 strcat(pchar(tempsighead),pchar(unknownkey+chr(13)+chr(10)));
 mydata(uservalue^).status.signer:=keyunknown+getkeystr(event.data.signaturedata.signingkeyid)
end;
end;
                          
{if event.data.signaturedata.signingKey<>nil then}
strcat(pchar(tempsighead),pchar(sigstatsigner+mydata(uservalue^).status.signer+chr(13)+chr(10)));
strcat(pchar(tempsighead),pchar(sigstatdatesigned+mydata(uservalue^).status.date+chr(13)+chr(10)));
datetimetostring(temptimestring,'m/d/yy h:nn:ss AMPM',now);
strcat(pchar(tempsighead),pchar(sigstatdateverified+temptimestring+chr(13)+chr(10)));
if mydata(uservalue^).currentblock^.previous<> nil then begin
if mydata(uservalue^).currentblock^.previous^.encrypted then
strcat(pchar(tempsighead),pchar(sigstatbegindecver+chr(13)+chr(10)))
else
strcat(pchar(tempsighead),pchar(sigstatbeginver+chr(13)+chr(10)));
end
else
begin
if mydata(uservalue^).currentblock^.previous^.encrypted then
strcat(pchar(tempsighead),pchar(sigstatbegindec+chr(13)+chr(10)))
else
strcat(pchar(tempsighead),pchar(sigstatbeginver+chr(13)+chr(10)));
end;
mydata(uservalue^).currentblock^.previous^.sighead:=tempsighead;
end;
end;
end;
if event.typev=kPGPEvent_EntropyEvent then begin //entropy event - get some entropy
	PGPcomdlgRandom(fcontext,mydata(uservalue^).handle,event.data.entropyData.entropyBitsNeeded);
end;

if event.typev=kPGPEvent_RecipientsEvent then begin //recipients event
         PGPCountKeys(event.data.recipientsdata.recipientSet, numKeys );
        { if numkeys>0 then} begin //set up the recipient key set and keyids for later decrypt phrase action
          PGPIncKeySetRefCount(event.data.recipientsdata.recipientSet);
          mydata(uservalue^).recipkeys:=event.data.recipientsdata.recipientSet;

          end;
        tempptr:=pointer(mydata(uservalue^).keyids);
        mydata(uservalue^).keycount:=event.data.recipientsdata.keyCount;
      if event.data.recipientsdata.keyCount>0 then begin
      mydata(uservalue^).keyids:=event.data.recipientsdata.keyIDArray;
(*        getmem(tempptr,sizeof(PGPKEYid)*event.data.recipientsdata.keycount);
        mydata(uservalue^).keyids:=pgpkeyidref(tempptr);
         { fillchar(mydata(uservalue^).keyids,sizeof(pgpkeyid)*event.data.recipientsdata.keycount,$00);}
          tempkeyids:=event.data.recipientsdata.keyidarray;
          tempmykeyids:=mydata(uservalue^).keyids;
         for count:=1 to mydata(uservalue^).keycount do begin
         if tempkeyids<>nil then
         tempmykeyids^:=tempkeyids^;
{        errorhandle(PGPCopyKeyID(tempkeyids,tempmykeyids));}
         inc(tempmykeyids,sizeof(tempmykeyids^));
         inc(tempkeyids,sizeof(tempkeyids^));
         end;*)
         end;

         end;
end;

(*----------------------------------
Name: processname

Description: separate a full filename into the name and path

In: name - string with the full file and path name

Out: fname - string with the filename
     fpath - string with the file path

Returns: NONE

-------------------------------------------*)
procedure processname(name:string; var fname,fpath:string);
begin
     fname := ExtractFileName(name);
     fpath := ExtractFilePath(name);
end;


(* UNUSED CURRENTLY*)
procedure tpgp5list.fnamewrite(fname:string);
begin
ffilename:=fname;
if ftype='public' then
pubfilename:=fname else
secfilename:=fname;

end;



(*Debugging function*)
procedure log(const logdat:string);
var runfile:string;ini:textfile;
begin
  runfile:='c:\pgpgw.log';
  try
  assignfile(ini,runfile);
   append(ini);
   writeln(ini,logdat);
   finally
     closefile(ini);
  end;
  end;

(*Register Delphi Components*)
(*procedure Register;
begin
  RegisterComponents('Samples', [TPGP5DropList]);
  RegisterComponents('Samples', [TPGP5List]);
  RegisterComponents('Samples',[TPGP5]);
 end;*)


(*----------------------------------
Name: reloadkeyrings

Description: reloads the keyrings into fkeyset

In: NONE

Out: NONE

Returns: PGPError - kPGPError_noerr if no errors

-------------------------------------------*)
function reloadkeyrings:integer;
var err:integer;getsend:boolean;count:integer;
tempid:pgpkeyid;

(*tempid:pchar;*)

begin

getsend:=false;
if sendkey<>nil then begin
getsend:=true;
errorhandle(PGPGetKeyIDFromKey(sendkey,tempid));
(*tempid:=nil;
tempid:=stralloc(20);
errorhandle(PGPcomdlgGetKeyIDFromKey(sendkey,true,tempid,20));*)


end;
closekeyrings;
sendkey:=nil;
result:=1;
result:=errorhandle(PGPOpenDefaultKeyRings(fcontext,0,fkeyset));
if getsend then begin
(*errorhandle(PGPcomdlgGetKeyFromKeyID (fcontext, fkeyset, tempid, kPGPPublicKeyAlgorithm_Invalid,sendkey));*)
PGPGetKeyByKeyID(fkeyset,@tempid,kPGPPublicKeyAlgorithm_Invalid,sendkey);
for count:=0 to 33 do
tempid.opaquebytes[count]:=$00;
(*
if tempid<> nil then begin
for count :=1 to strlen(tempid) do
   tempid[count]:='a';
strdispose(tempid);
end;*)
end;
end;

(*----------------------------------
Name: loadbothkeyrings

Description: loads both key rings into fkeyset

In: NONE

Out: NONE

Returns: PGPError - kPGPError_noerr if no errors

-------------------------------------------*)
function loadbothkeyrings:integer;
var
pubfileref,secfileref:pgpfilespecref;
err:integer;
tempkeyset:pgpkeysetref;
begin

if isntnull(fkeyset) then errorhandle(PGPCommitKeyRingChanges(fkeyset));
if isntnull(fkeyset) then errorhandle(PGPFreekeyset(fkeyset));
result:=1;
err:=PGPOpenDefaultKeyRings(fcontext,0,fkeyset);
errorhandle(err);
result:=err;
end;


(*----------------------------------
Name: closekeyrings

Description: closes both keyrings and sets fkeyset to nil

In: NONE

Out: NONE

Returns: PGPError - kPGPError_noerr if no error

-------------------------------------------*)
function closekeyrings:integer;
var err:integer;
begin

if isntnull(fkeyset) then begin
pgpcommitkeyringchanges(fkeyset);
err:=PGPFreekeyset(fkeyset);
errorhandle(err);
fkeyset:=nil;
end;
result:=err;
end;


(*EMPTY PROCEDURE - REMNANT OF PRIOR VERSIONS THAT COULD BE RESURRECTED*)
procedure tpgp5.setupKeyList;
  begin
{empty}
  end;


(*----------------------------------
Name: tpgp5.getkeylistfromid

Description: iterates a keyset to return a sub-keyset of keys containing the UserID

In: id -string containing userid
    kset - keyset to select from

Out: NONE

Returns: keyset containing keys with the UserID sent in by id

-------------------------------------------*)
function tpgp5.getkeylistfromid(id:string;kset:PGPKeysetRef):PGPkeysetRef;
var numKeys:PGPUInt32;
filter:PGPFilterRef;
signkeyset,tempkeyset,encryptkeyset,signkeys:pgpkeysetref;
klist:PGPKeyListRef;
signkey:PGPKeyRef;
kiter:PGPKeyIterRef;
options:pgpoptionlistref;
outfilespec,filespec:PGPFilespecref;
tempptr:pgpuservalue;
temp:integer;

begin
errorhandle(PGPNewUserIDStringFilter(fcontext,pchar(id),kPGPMatchSubString,filter));
errorhandle(PGPFilterKeySet(kset, filter, signkeyset));
PGPFreeFilter( filter );
result:=signkeyset;
filter	:= Nil;

end;


(*----------------------------------
Name: tpgp5.getalgorithms

Description: gets the allowed algorithms

In: NONE

Out: NONE

Returns: PGPError containing any error - kPGPError_noerr if noerrors
         tpgp5.allowedalgs is an array filled with the allowed algorithms
         tpgp5.numalgs is an integer filled with the number of allowed algorithms
-------------------------------------------*)
  function tpgp5.GetAlgorithms:PGPError;
var  prefs:PGPprefref;err:pgperror;len:PGPSize;
count:integer;tempdata,counter:^PGPCipherAlgorithm;
  begin
       tempdata:=nil;
       PrefAlg:=kPGPCipherAlgorithm_CAST5;
       {$IFDEF PGP6}
       	errorhandle(PGPcomdlgOpenClientPrefs(fmemmgr,Prefs));
       {$ELSE}
       	errorhandle(PGPcomdlgOpenClientPrefs(Prefs));
       {$ENDIF}

       err:=PGPGetPrefNumber(Prefs,kPGPPrefPreferredAlgorithm,PrefAlg);
         errorhandle(err);
         if err =kpgperror_noerr then
		err :=PGPGetPrefData(Prefs,kPGPPrefAllowedAlgorithmsList,
			Len, pointer(tempdata));
         errorhandle(err);
         counter:=tempdata;
	if err =kpgperror_noerr then begin
                         numalgs:=len div sizeof(PGPCipheralgorithm);
                         for count:=1 to numalgs do begin
                         allowedalgs[count]:=counter^;
                         inc(counter);
                         end;
		     	PGPDisposePrefData(Prefs,tempdata);
                        end
		else
			NumAlgs := 0;
      	errorhandle(PGPcomdlgCloseClientPrefs (Prefs, FALSE));
         result:=err;
  end;

(*UNUSED CURRENTLY - Gets the name of the keyring files*)  
function tpgp5.getkeyringfiles:integer;
var err:integer;
ppubring,psecring:pchar;
PGPPubref,PGPSecref:PGPFileSpecRef;
begin
ppubring:=nil;
psecring:=nil;
err:=PGPSDKLoadDefaultPrefs(fcontext);
result:=0;
if err=kPGPError_noerr then begin
errorhandle(PGPsdkPrefGetFileSpec(fcontext,kPGPsdkPref_PublicKeyring,PGPPubref));
errorhandle(PGPsdkPrefGetFileSpec(fcontext,kPGPsdkPref_PrivateKeyring,PGPSecref));
errorhandle(PGPGetFullPathFromFileSpec(pgppubref,ppubring));
errorhandle(PGPGetFullPathFromFileSpec(pgpsecref,psecring));
errorhandle(PGPFreeFileSpec(PGPPubref));
errorhandle(PGPFreeFileSpec(PGPSecref));
if ppubring<>nil then begin
fpubring:=strpas(ppubring);
try
PGPFreedata(ppubring);
except end;
end;
if psecring<> nil then begin
fsecring:=strpas(psecring);
try
PGPFreedata(psecring);
except end;
end;
end else result:=err;
end;


(*UNUSED CURRENTLY - Sets the names of keyring files*)
procedure tpgp5.setkeyringfiles(pubring,secring:string);
var
pgppubref,pgpsecref:PGPFileSpecRef;
err:integer;
temp:string;
begin
errorhandle(PGPNewFilespecFromFullPath(fcontext,pchar(pubring) ,pgppubref));
errorhandle(PGPNewFilespecFromFullPath(fcontext,pchar(secring) ,pgpsecref));


err:=PGPsdkPrefSetFileSpec(fcontext,kPGPsdkPref_PublicKeyring,pgppubref);
errorhandle(err);

if err=kpgperror_noerr then
fpubring:=pubring;
err:=PGPsdkPrefSetFileSpec(fcontext,kPGPsdkPref_PrivateKeyring,pgpsecref);
errorhandle(err);
if err=kpgperror_noerr then
fsecring:=secring;

errorhandle(PGPSDKSaveprefs(fcontext));
processname(pubring,temp,fPGPPath);
errorhandle(pgpfreefilespec(pgppubref));
errorhandle(pgpfreefilespec(pgpsecref));

end;


(*----------------------------------
Name: getkeyfromid

Description: function used to find a key in a keyset that has a certain UserID

In: id - string containing the userid
    kset - keysetref containing the keys to be searched

Out: NONE

Returns: PGPKeyRef pointing to the first key that has a UserID that is id

-------------------------------------------*)
function tpgp5.getkeyfromid(id:string;kset:PGPKeysetRef):PGPkeyRef;
var numKeys:PGPUInt32;
filter:PGPFilterRef;
signkeyset,tempkeyset,encryptkeyset,signkeys:pgpkeysetref;
klist:PGPKeyListRef;
signkey:PGPKeyRef;
kiter:PGPKeyIterRef;
options:pgpoptionlistref;
outfilespec,filespec:PGPFilespecref;
tempptr:pgpuservalue;
temp:integer;
begin
result:=nil;
signkeyset:=getkeylistfromid(id,kset);
PGPCountKeys(signkeySet, numKeys);
if( numKeys < 1 ) then
begin
result:=nil;
MessageDlg(nokeys, mtInformation,[mbOk], 0);
end else
if( numKeys > 0 ) then begin
if( numKeys > 1 ) then
MessageDlg(multiplekeys, mtInformation,[mbOk], 0) ;
PGPOrderKeySet(signkeySet, kPGPCreationOrdering, klist );
PGPNewKeyIter( klist, kiter );
PGPKeyIterNext(kiter, signKey );
result:=signkey;
PGPFreeKeyIter( kiter );
PGPFreeKeyList( klist );
PGPFreeKeySet( signkeyset );
end;
end;

(*----------------------------------
Name: tpgp5.extractkey

Description: extracts one or more keys from the keyring

In: selectstat - integer; if mailkeydefault then extracts default public key
                          if mailkeyselect then shows recipient dialog for user selection

Out: output - string containing the extracted key(s)

Returns: true if no error or cancel; false otherwise

-------------------------------------------*)
function tpgp5.ExtractKey(selectstat:integer;var output:string):boolean;
var parmstr:string;
numadd:pgpuint32;
tempkeyset:PGPKeySetRef;
fileref:PGPFileSpecRef;
options:PGPOptionlistref;
name:pchar;bufsize:pgpsize;
defkey:pgpkeyref;res:word;
outbuf:pointer;
recipkey:RECIPIENTDIALOGSTRUCT;
begin
reloadkeyrings;
with recipkey do begin
  Version:=ord(curver[1]) shl 24 + ord(curver[2]) shl 16+ord(curver[3]) shl 8+ord(curver[4]);
    hwndParent:= application.handle;
    szTitle:=pchar(selectkeys);
    context:=fcontext;
    OriginalKeySetRef:= fkeyset;
    SelectedKeySetRef:=nil;
    dwOptions:=PGPCOMDLG_ASCIIARMOR;
    dwnumrecipients:=0;
    dwFlags:=0;
    {$IFDEF PGP6}
    dwDisableFlags:=PGPCOMDLG_DISABLE_ASCIIARMOR+PGPCOMDLG_DISABLE_WIPEORIG+PGPCOMDLG_DISABLE_PASSONLY+PGPCOMDLG_DISABLE_AUTOMODE+PGPCL_DISABLE_FYEO{$IFDEF PGP65}+ PGPCL_DISABLE_SDA{$ENDIF};
    {$ELSE}
    dwDisableFlags:=PGPCOMDLG_DISABLE_ASCIIARMOR+PGPCOMDLG_DISABLE_WIPEORIG+PGPCOMDLG_DISABLE_PASSONLY+PGPCL_DISABLE_FYEO{$IFDEF PGP65}+ PGPCL_DISABLE_SDA{$ENDIF};
    {$ENDIF}

    {$IFDEF PGP6}
    tlscontext:=ftlscontext;
    addedkeys:=nil;
    {$ENDIF}
end;
if selectstat=mailkeydefault then begin
recipkey.dwDisableFlags:=PGPCOMDLG_DISABLE_ASCIIARMOR+PGPCOMDLG_DISABLE_WIPEORIG+PGPCOMDLG_DISABLE_PASSONLY+PGPCL_DISABLE_FYEO{$IFDEF PGP65}+ PGPCL_DISABLE_SDA{$ENDIF};
name:=stralloc(256);
bufsize:=256;
recipkey.dwnumrecipients:=1;
errorhandle(pgpgetdefaultprivatekey(fkeyset,defkey));
errorhandle(pgpgetprimaryuseridnamebuffer(defkey,256,name,bufsize));
recipkey.szRecipientArray:=@name;
end;
result:=false;
try
{$IFDEF PGP6}
res:=PGPclRecipientDialog(@recipkey);
{$ELSE}
res:=PGPRecipientDialog(@recipkey);
{$ENDIF}
except end;
if res<>0 then
begin
{$IFDEF PGP6}
if recipkey.addedkeys<>nil then begin
PGPCountKeys(recipkey.addedkeys,numAdd);
if numadd>0 then begin
messagedlg(newkeys,mtconfirmation,[mbOK],0);
errorhandle(PGPkmQueryAddKeys(fcontext,ftlscontext,
                                         application.handle,
                                         recipkey.AddedKeys,nil));
end;
end;
{$ENDIF}

result:=true;
errorhandle(PGPNewOptionList(fcontext,options));
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOAllocatedOutputBuffer(fcontext,outbuf,1024*1024,bufsize),PGPOLastOption(fcontext)));
errorhandle(PGPExportKeySet(recipkey.selectedkeysetref,options,PGPOLastOption(fcontext)));
output:=strpas(pchar(outbuf));
if isntnull(recipkey.selectedkeysetref) then begin
errorhandle(PGPFreeKeySet(recipkey.selectedkeysetref));
recipkey.selectedkeysetref:=nil;
end;
{$IFDEF PGP6}
if isntnull(recipkey.addedkeys) then begin
errorhandle(PGPFreeKeySet(recipkey.addedkeys));
recipkey.addedkeys:=nil;
end;
{$ENDIF}
if isntnull(options) then errorhandle(pgpfreeoptionlist(options));
if isntnull(outbuf) then
pgpfreedata(outbuf);
if selectstat=mailkeydefault then
if isntnull(name) then
strdispose(name);
      end;

end;



(*----------------------------------
Name: tpgp5.create

Description: automatically called when the component is created on a form
             Initializes the values in the component

In: NONE

Out: NONE

Returns: NONE

-------------------------------------------*)
constructor tpgp5.create(Aowner:TComponent);
var temppath:pchar;
begin
inherited create(Aowner);
fcontext:=nil; //init main context
err:= kPGPError_NoErr;
fpgppath:=''; //init pgp file path
errorhandle(PGPNewContext(kPGPsdkAPIVersion,fcontext)); //init SDK version
{$IFDEF PGP6}
errorhandle(PGPNewMemoryMgr(kPGPMemoryMgrFlags_None,fmemmgr));
errorhandle(PGPNewTLSContext(fcontext,ftlscontext));
{fmemmgr:=PGPGetContextMemoryMgr(fcontext);}
signcachekey:=nil;
decryptcachekey:=nil;
signcachekeylen:=0;
decryptcachekeylen:=0;
{$ENDIF}
loadbothkeyrings;
passwd:=nil; //init global password var;
recipinfo.szrecipientarray:=nil; //init global recipient dialog structure
cachetimer:=ttimer.create(self); //create the caching timer
cachetimer.interval:=1000; //init cache timer
cachetimer.ontimer:=updatecache;
cachetimer.enabled:=false;
signcacheactive:=false;//init cache settings
decryptcacheactive:=false;
signcachephrase:=nil;
decryptcachephrase:=nil;
sendkey:=nil;
fver:=5;
{getalgorithms;}//load the allowed algorithms
{$IFDEF PGP6}
errorhandle(PGPclInitLibrary(fcontext));
{$ENDIF}

end;

(*UNUSED EMPTY PROCEDURE - remnant from prior versions that may be used later*)
procedure tpgp5.clean(filename:string);
begin
{empty}
end;


(*----------------------------------
Name: tpgp5list.getuser

Description: extracts the userid from a user listed in the listbox
             UNUSED CURRENTLY

In: num - zero based integer index of the list

Out: NONE

Returns: string containing the userid

-------------------------------------------*)
function TPGP5List.getuser (num:integer):string;
var
tmpsource:string;
len:integer;
begin
       if Items.count>0 then begin
        len:=length(Items.strings[num]);
        tmpsource :=  Items.strings[num];
        getuser := Copy(tmpsource,pos('<',tmpsource),len-pos('<',tmpsource)+1);
      end;
end;


(*----------------------------------
Name: tpgp5droplist.getuser

Description: extracts the userid from a user listed in the listbox
             UNUSED CURRENTLY

In: num - zero based integer index of the list

Out: NONE

Returns: string containing the userid

-------------------------------------------*)
function TPGP5dropList.getuser (num:integer):string;
var
tmpsource:string;
len:integer;
begin
       if Items.count>0 then begin
        len:=length(Items.strings[num]);
        tmpsource :=  Items.strings[num];
        getuser := Copy(tmpsource,pos('<',tmpsource),len-pos('<',tmpsource)+1);
      end;
end;



(*----------------------------------
Name: tpgp5.updatecache

Description: procedure called by the cache timer every second if either
cache is active

In: Sender - whatever object is sending the request

Out: NONE

Returns: NONE

-------------------------------------------*)
  procedure tpgp5.updatecache(Sender:Tobject);
  begin
  if signcachetime>0 then
  signcachetime:=signcachetime-1; //decrement the sign cache time limit
  if signcachetime=0 then //if time is up clear passphrase
     begin
     signcacheactive:=false;
     if SignCachePhrase <> nil then begin
	PGPcomdlgFreePhrase(SignCachePhrase);
	SignCachePhrase := nil;

      end;
      end;

  if decryptcachetime>0 then
  decryptcachetime:=decryptcachetime-1; //decrement the decrypt cache time limit
    if decryptcachetime=0 then//if time is up clear passphrase
     begin
     decryptcacheactive:=false;
     if decryptCachePhrase <> nil then begin
	PGPcomdlgFreePhrase(decryptCachePhrase);
	decryptCachePhrase := nil;
      end;
      end;
  end;

 (*----------------------------------
 Name: getcachedpassphrase

 Description: key pass phrase caching and request function
              handles almost all passphrase functions

 In: phrasetype - integer containing the type of phrase needed
                     phrasetypesign if signing phrase needed
                     phrasetypedecrypt if decrypt phrase needed
                     phrasetypeconvenc if conventional encryption phrase needed
                     phrasetypeconvdec if conventional decryption phrase needed
     force - true if override cache, false to use cache first
     keys - PGPKeysetRef - keys to show in decryption or signing phrase; nil is acceptable
     keyids - PGPKeyidref - keyids to show in decryption phrase request; nil is acceptable
     numkeys - number of keys in keyids and keys inputs; 0 is acceptable

 Out: password - pchar containing the password selected by the user

 Returns: PGPError with any errors.  kpgperror_noerr if no errors

 -------------------------------------------*)

function getcachedpassphrase(phrasetype:integer;var password:pointer;force:boolean;keys:PGPKeySetRef;keyids:pgpkeyidRef;numkeys:pgpuint32
{$IFDEF PGP6} ;var passkeylen:pgpuint32 {$ENDIF}):pgperror;
var opts:pword;
numadd:pgpuint32;
addedkeyset,nilkeyset:pgpkeysetref;
passkeybuf:ppgpbyte;
nilkey:pgpkeyref;
decprompt:string;
begin
addedkeyset:=nil;
opts:=nil;
nilkey:=nil;
if keys<>nil then
cachetimer.enabled:=signcacheok or decryptcacheok; //turn the cache on if necessary
case phrasetype of
     phrasetypedecrypt:begin //if decrypt phrase
     if decryptcacheok and decryptcacheactive and ((decryptcachephrase<>nil) or (sizeof(decryptcachekey)>0)) and (not force) then //if there is a password in the cache
        begin
           decryptcachetime:=decryptcachemax; //reset the cache time
           {$IFDEF PGP6}
           if decryptcachephrase<>nil then begin
           password:=PGPNewSecureData(fmemmgr,strlen(decryptcachephrase)+1,kPGPMemoryMgrFlags_None);
           passkeylen:=0;
           strcopy(password,decryptcachephrase); //get the cached password and return it
           end else begin
           if sizeof(decryptcachekey)>0 then begin
           passkeylen:=decryptcachekeylen;
           password:=PGPNewSecureData(fmemmgr,decryptcachekeylen,kPGPMemoryMgrFlags_None);
           passmove(decryptcachekey,password,passkeylen);
           end;
           end;
           {$ELSE}
           password:=PGPNewSecureData(fcontext,strlen(decryptcachephrase)+1,nil);
           strcopy(password,decryptcachephrase); //get the cached password and return it
           {$ENDIF}
           result:=kpgperror_noerr;
        end else begin //if no cached phrase or forced output
        cleanpass(pointer(decryptCachePhrase)); //free up what is there
        {$IFDEF PGP6}
        cleanpasskey(decryptcachekey,decryptcachekeylen);
         result:= PGPcomdlgGetPhrase(fcontext,fkeyset,application.handle,pchar(decryptphrase),
       @decryptcachephrase,keys,keyids,numkeys,nilkey,opts,PGPCOMDLG_DECRYPTION,@decryptcachekey,decryptcachekeylen,0,0,ftlscontext,addedkeyset,pchar(enterphrase)); //get a new phrase {last parameter only works in PGP6.5 - it must be removed for a 6.x build}
      if addedkeyset<>nil then begin
      PGPCountKeys(addedkeyset,numAdd);
      if numadd>0 then begin
      messagedlg(newkeys,mtconfirmation,[mbOK],0);
      errorhandle(PGPkmQueryAddKeys(fcontext,ftlscontext,
                                         application.handle,
                                         AddedKeyset,nil));
       if isntnull(addedkeyset) then begin
       errorhandle(PGPFreeKeySet(addedkeyset));
       addedkeyset:=nil;
       end;
       end;
       end;
        {$ELSE}
       result:= PGPcomdlgGetPhrase(fcontext,application.handle,pchar(decryptphrase),
       @decryptcachephrase,keys,keyids,numkeys,nilkey,opts,PGPCOMDLG_DECRYPTION); //get a new phrase
       {$ENDIF}
       if result =kpgperror_noerr then begin
       {$IFDEF PGP6}
            if decryptcachephrase<>nil then begin
           password:=PGPNewSecureData(fmemmgr,strlen(decryptcachephrase)+1,kPGPMemoryMgrFlags_None);
           cleanpasskey(decryptcachekey,decryptcachekeylen);
           passkeylen:=0;
           strcopy(password,decryptcachephrase); //get the cached password and return it
           end else begin
           if sizeof(decryptcachekey)>0 then begin
           cleanpass(pointer(decryptcachephrase));
           passkeylen:=decryptcachekeylen;
           password:=PGPNewSecureData(fmemmgr,decryptcachekeylen,kPGPMemoryMgrFlags_None);
           passmove(decryptcachekey,password,passkeylen);
           end;
           end;
       {$ELSE}
        password:=PGPNewSecureData(fcontext,strlen(decryptcachephrase)+1,nil);
        strcopy(password,decryptcachephrase);//return the phrase if there is no error
       {$ENDIF}
         if decryptcacheok then begin //if the cache is on then set it
            decryptcachetime:=decryptcachemax;
            decryptcacheactive:=true;
            end else begin
         cleanpass(pointer(decryptCachePhrase)); //if not, then clear the memory
         {$IFDEF PGP6}
         cleanpasskey(decryptcachekey,decryptcachekeylen);
         {$ENDIF}
            end;
          end else begin //get here if there is an error
           decryptcachetime:=0; //clean everything up if there is an error
           decryptcacheactive:=false;
           cleanpass(pointer(decryptcachephrase));
           {$IFDEF PGP6}
           cleanpasskey(decryptcachekey,decryptcachekeylen);
           {$ENDIF}

          end;
         end;
       end;

     phrasetypesign:begin //if signing phrase

     if signcacheok and signcacheactive and ({$IFDEF PGP6}signcachekey<>nil{$ELSE}signcachephrase<>nil{$ENDIF}) and (not force) then //if there is a cached phrase
        begin
           signcachetime:=signcachemax; //reset the cache time
           {$IFDEF PGP6}
           {if signcachephrase<>nil then begin
           password:=PGPNewSecureData(fmemmgr,strlen(signcachephrase)+1,kPGPMemoryMgrFlags_None);
           passkeylen:=0;
           strcopy(password,signcachephrase); //get the cached password and return it
           end else} begin
        {   if signcachekey<>nil then} begin
           passkeylen:=signcachekeylen;
           password:=PGPNewSecureData(fmemmgr,signcachekeylen,kPGPMemoryMgrFlags_None);
           passmove(signcachekey,password,passkeylen);
           end;
           end;
           {$ELSE}
           password:=PGPNewSecureData(fcontext,strlen(signcachephrase)+1,nil);//return the cached phrase
           strcopy(password,signcachephrase);
           {$ENDIF}
           result:=kpgperror_noerr;
        end else begin //if no cached phrase or if forced
        {$IFDEF PGP6}
        cleanpasskey(signcachekey,signcachekeylen);
        {$ELSE}
      cleanpass(pointer(signCachePhrase)); //clear what is there
        {$ENDIF}

        if PGPGetKeyContext(sendkey) = kPGPInvalidRef then sendkey:=nil; //clear the cached signing key
{$IFDEF PGP6}
     result:= PGPcomdlgGetPhrase(fcontext,fkeyset,application.handle,pchar(selectandenter),
       @signcachephrase,Keys,nil,0,sendkey,opts,0,@signcachekey,signcachekeylen,0,0,ftlscontext,addedkeyset,pchar(enterphrase)); //get a signing key and passphrase {last parameter only works in PGP6.5 - it must be removed for a 6.x build}
      if addedkeyset<>nil then begin
      PGPCountKeys(recipinfo.addedkeys,numAdd);
      if numadd>0 then begin
      messagedlg(newkeys,mtconfirmation,[mbOK],0);
      errorhandle(PGPkmQueryAddKeys(fcontext,ftlscontext,
                                         application.handle,
                                         AddedKeyset,nil));
       if isntnull(addedkeyset) then begin
       errorhandle(PGPFreeKeySet(addedkeyset));
       addedkeyset:=nil;
       end;
       end;
       end;
{$ELSE}
     result:= PGPcomdlgGetPhrase(fcontext,application.handle,pchar(selectandenter),
       @signcachephrase,Keys,nil,0,sendkey,opts,0); //get a signing key and passphrase
{$ENDIF}

       if result =kpgperror_noerr then begin //if no error or cancel
       {$IFDEF PGP6}
           {if signcachephrase<>nil then begin
           password:=PGPNewSecureData(fmemmgr,strlen(signcachephrase)+1,kPGPMemoryMgrFlags_None);
           passkeylen:=0;
           strcopy(password,signcachephrase); //get the cached password and return it
           end else} begin
         {  if signcachekey<>nil then} begin
         cleanpass(pointer(signcachephrase));
           passkeylen:=signcachekeylen;
           password:=PGPNewSecureData(fmemmgr,signcachekeylen,kPGPMemoryMgrFlags_None);
           passmove(signcachekey,password,passkeylen);
           end;
           end;

       {$ELSE}
        password:=PGPNewSecureData(fcontext,strlen(signcachephrase)+1,nil);//return the passphrase
        strcopy(password,signcachephrase);
       {$ENDIF}


         if signcacheok then begin //if the cache is on
            signcachetime:=signcachemax; //set up the cache
            signcacheactive:=true;
            end else begin

         {$IFDEF PGP6}
         cleanpasskey(signcachekey,signcachekeylen);
         {$ELSE}
         cleanpass(pointer(signCachePhrase)); //clean up if cache is off
         {$ENDIF}
            end;
          end else begin //if error or cancel
           signcachetime:=0; //clean everything up
           signcacheactive:=false;


         {$IFDEF PGP6}
         cleanpasskey(signcachekey,signcachekeylen);
         {$ELSE}
          cleanpass(pointer(signCachePhrase));
         {$ENDIF}
          end;
         end;


       end;

      phrasetypeconvenc:begin nilkey:=nil; nilkeyset:=nil; //if need a conventional encryption phrase
       repeat

      {$IFDEF PGP6}
      passkeybuf:=nil;


      result:=PGPcomdlgGetPhrase(fcontext,fkeyset,application.handle,pchar(convencphrase),
       @password,keys,nil,25,nilkey,opts,PGPCOMDLG_ENCRYPTION,@passkeybuf,passkeylen,0,0,ftlscontext,addedkeyset,pchar(enterphrase)); //get the phrase  {last parameter only works in PGP6.5 - it must be removed for a 6.x build}
       passkeylen:=0;

{$ELSE}
      result:=PGPcomdlgGetPhrase(fcontext,application.handle,pchar(convencphrase),
       @password,keys,nil,25,nilkey,opts,PGPCOMDLG_ENCRYPTION); //get the phrase

{$ENDIF}
  if password<>nil then
       if strcomp(pchar(password),'')=0 then begin
       messagedlg(phrasetooshort,mtError,[mbOK],0);
      cleanpass(pointer(password));
       end;
       until (password<>nil) or (result<>kPGPError_noerr);
        end;
      phrasetypeconvdec:begin nilkey:=nil; nilkeyset:=nil;password:=nil; //if need a conventional decryption phrase
     if force then
     decprompt:= decryptphrasewrong else
     decprompt:=decryptphrase;

{$IFDEF PGP6}
      passkeybuf:=nil;
      result:=PGPcomdlgGetPhrase(fcontext,fkeyset,application.handle,pchar(decprompt),
       @password,keys,nil,0,nilkey,opts,PGPCOMDLG_DECRYPTION,@passkeybuf,passkeylen,0,0,ftlscontext,addedkeyset,pchar(enterphrase)); //get the phrase{last parameter only works in PGP6.5 - it must be removed for a 6.x build}
       passkeylen:=0;

{$ELSE}
      result:=PGPcomdlgGetPhrase(fcontext,application.handle,pchar(decprompt),
       @password,keys,nil,25,nilkey,opts,PGPCOMDLG_DECRYPTION); //get the phrase
{$ENDIF}

end;

end;
end;


(*----------------------------------
Name: tpgp5.cleanencrypt

Description: clean up encryption variables.  Call after encryption functions are
             done.  Function is necessary because attachments need the persistent variables set by earlier
             calls to tpgp5.encrypt.

In: NONE

Out: NONE

Returns: NONE

-------------------------------------------*)
procedure tpgp5.CleanEncrypt;
begin
{$IFDEF PGP6}
cleanpasskey(ppgpbyte(passwd),thepasskeylen);
{$ELSE}
cleanpass(passwd);
{$ENDIF}
recipinfo.dwOptions:=PGPCOMDLG_ASCIIARMOR;
 if isntnull(recipinfo.selectedkeysetref) then begin
errorhandle(PGPFreeKeySet(recipinfo.selectedkeysetref));
recipinfo.selectedkeysetref:=nil;
end;
{$IFDEF PGP6}
 if isntnull(recipinfo.addedkeys) then begin
errorhandle(PGPFreeKeySet(recipinfo.addedkeys));
recipinfo.addedkeys:=nil;
end;
{$ENDIF}
if recipinfo.szrecipientarray<>nil then begin
freemem(recipinfo.szrecipientarray);
recipinfo.szrecipientarray:=nil;
end;
end;

(*----------------------------------
Name: TPGP5.Encrypt

Description: Core encryption procedure.  Handles all of the component's encryption action

In: filename - if attach is true, string containing the full path and filename of file
             - if attach is false, string containing actual text to encrypt
    useropt - integer to determine what should happen, only relevant if properties tpgp5.encryptone and tpgp5.signone are false
                if either encryptone or signone are true, then those settings will be followed
              Values: 0 - Encrypt only
                      1 - Encrypt and sign
                      2 - Sign only - clearsign if possible
                      3 - conventional encryption
    attach - true if filename points to file on disk, false if filename is actual text
             the procedure treats attach as a "second run" option; if it is true, it assumes that the
             procedure was called before with attach set to false.  However, if the procedure had
             not been called, there should be no problem if attach is true for the first pass.
    isinternal - if true, the function will sign only (if signone or useropt instruct it to) and will not encrypt

Out: filename - if attach is true, string containing the name of the encrypted file - simply the input name with the extension changed to '.asc'
              - if attach is false, string containing the actual encrypted text
              - may be the same as what was sent in if procedure does not complete without error

Returns: PGPError containing any errors; kpgperror_noerr if no errors

-------------------------------------------*)
function tpgp5.Encrypt(var filename:string;useropt:integer;attach:boolean;isinternal:boolean):longint;
var
comm,recips,parmstr:string;len,err,num:integer;ideaonly:boolean;
tmprecip,tmpsend:tstringlist;
tempkeyset,encryptkeyset:pgpkeysetref;
options:pgpoptionlistref;
outfilespec,filespec:PGPFilespecref;
tempptr:pgpuservalue;
opts:pword;
temp:mydata;
passptr:ppchar;allok:boolean;
signit,encryptit:boolean;
eopt:integer;
encrypttext:pointer;
count,wraplen,enclen:longint;
wrapped:pchar;
begin
{$IFDEF PGP6}
pgpversionheaderstring:='PGP 6.0.2';
{$ELSE}
pgpversionheaderstring:='PGP 5.5.5';
{$ENDIF}
{$IFDEF PGP652}
pgpversionheaderstring:='PGP 6.5.2';
{$ENDIF}
{$IFDEF PGP651}
pgpversionheaderstring:='PGP 6.5.1';
{$ENDIF}


wrapped:=nil; //clear variables used by procedure
statform.progress.position:=0;
statform.cancelbtn.tag:=0;
wraplen:=0;
reloadkeyrings;
opts:=nil;
allok:=true;
signit:=signone;
encryptit:=encryptone;
if (signit and encryptit) then eopt:=1; //if sign and encrypt, then set up option for that
if (signit and (not encryptit)) then eopt:=2;//if sign only
if ((not signit) and encryptit) then eopt:=0; //if encrypt only
if (not signit) and (not encryptit) then eopt:=useropt; //if neither are set, then use the option passed in to the procedure
if (eopt in [1,2]) and isinternal then eopt:=2; //if isinternal, then turn off encryption and leave signing
if (eopt=0) and isinternal then begin //if encryption only and isinternal, then leave procedure without doing anything
result:=1;
 exit;
end;
if ((recipinfo.dwoptions and PGPCOMDLG_PASSONLY)=PGPCOMDLG_PASSONLY) then eopt:=3;//if the user selected conventional, then set that option
if not attach then begin //if this is not a text file, then clear any password that may be in memory
{if thepasskeylen=0 then
cleanpass(passwd) else}
cleanpasskey(ppgpbyte(passwd),thepasskeylen);
if ((recipinfo.dwoptions and PGPCOMDLG_PASSONLY)=PGPCOMDLG_PASSONLY) then //if conventional, then get a conventional phrase
   allok:=(getcachedpassphrase(phrasetypeconvenc,passwd,false,nil,nil,0{$IFDEF PGP6},thepasskeylen{$ENDIF})=kpgperror_noerr)
  else
      if eopt in [1,2] then //otherwise, if signed, then get a sign phrase
     allok:= (getcachedpassphrase(phrasetypesign,passwd,false,fkeyset,nil,0{$IFDEF PGP6},thepasskeylen{$ENDIF})=kpgperror_noerr);
     end;

if allok or attach then begin //if the password is ok or we are relying on a previous password

{$ifdef debug}
if fileexists(filename) then
log('Encrypt: '+filename+'exists') else
log('Encrypt: '+filename+'does not exist');
{$endif}
  err:=0;
    try
  options:=nil;

errorhandle(PGPNewOptionList(fcontext,options));//setup standard options and callback
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOSendNullEvents(fcontext,1000),PGPOLastOption(fcontext)));
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOVersionString(fcontext,pchar(pgpVersionHeaderString)),PGPOLastOption(fcontext)));
comm:=commentblock;
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOCommentString(fcontext,pchar(comm)),PGPOLastOption(fcontext)));
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOEventHandler(fcontext,@myevents,@globalstatus),PGPOLastOption(fcontext)));
if attach then begin //if a file set up file specific options
errorhandle(PGPNewFilespecFromFullPath(fcontext,pchar(filename),filespec));
errorhandle(PGPNewFilespecFromFullPath(fcontext,pchar(ChangeFileExt(filename,'.asc')),outfilespec));
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOInputFile(fcontext,filespec),PGPOLastOption(fcontext)));
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOoutputFile(fcontext,outfilespec),PGPOLastOption(fcontext)));
end else //if text buffer
begin
if  eopt=2 then //if sign then setup the wrapping for text
begin
wraplen:=wrapbuffer;
if wraplen>0 then
errorhandle(PGPcomdlgWrapBuffer(pchar(filename),wraplen,wrapped));
end
else
begin
wrapped:=strnew(pchar(filename)); //if not signed use what was passed in
end;
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOAllocatedOutputBuffer(fcontext,encrypttext,maxmesslen-10,enclen),PGPOLastOption(fcontext)));//set up the text options
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOInputbuffer(fcontext,wrapped,strlen(wrapped)),PGPOLastOption(fcontext)));
end;
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOArmorOutput(fcontext,1),PGPOLastOption(fcontext)));

    case eopt of
    3:begin errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOConventionalEncrypt(fcontext,PGPOPassphrasebuffer(fcontext,passwd,strlen(passwd)),PGPOLastOption(fcontext)),PGPOLastOption(fcontext)));//set up conventional options
    if getalgorithms=kpgperror_noerr then //if there are algorithms available, then continue
       errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOCipherAlgorithm(fContext,PrefAlg),PGPOLastOption(fcontext)));
        end;
    2:begin
    {$IFDEF PGP6}
    if passwd<>nil {passkeylen=0} then
(*    errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOSignWithKey(fcontext,sendKey,PGPOPassphrasebuffer(fcontext,passwd,strlen(passwd)),PGPOLastOption(fcontext)),PGPOLastOption(fcontext)))//set up clearsign options
    else*)
        errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOSignWithKey(fcontext,sendKey,PGPOPasskeybuffer(fcontext,passwd,thepasskeylen),PGPOLastOption(fcontext)),PGPOLastOption(fcontext)));//set up clearsign options
    {$ELSE}
    errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOSignWithKey(fcontext,sendKey,PGPOPassphrasebuffer(fcontext,passwd,strlen(passwd)),PGPOLastOption(fcontext)),PGPOLastOption(fcontext)));//set up clearsign options
    {$ENDIF}

    errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOClearSign(fcontext,1),PGPOLastOption(fcontext)));end;
    1:begin //set up sign and encrypt options
    {$IFDEF PGP6}
    if passwd<>nil {thepasskeylen=0} then
(*    errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOSignWithKey(fcontext,sendKey,PGPOPassphrasebuffer(fcontext,passwd,strlen(passwd)),PGPOLastOption(fcontext)),PGPOLastOption(fcontext)))//set up clearsign options
    else*)
        errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOSignWithKey(fcontext,sendKey,PGPOPasskeybuffer(fcontext,passwd,thepasskeylen),PGPOLastOption(fcontext)),PGPOLastOption(fcontext)));//set up clearsign options
    {$ELSE}
    errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOSignWithKey(fcontext,sendKey,PGPOPassphrasebuffer(fcontext,passwd,strlen(passwd)),PGPOLastOption(fcontext)),PGPOLastOption(fcontext)));//set up clearsign options
    {$ENDIF}
    errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOEncryptToKeySet(fcontext,recipinfo.selectedkeysetref),PGPOLastOption(fcontext)));  end;
    0:begin errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOEncryptToKeySet(fcontext,recipinfo.selectedkeysetref),PGPOLastOption(fcontext)));end;//set up encrypt only options
  end;
  err:=PGPEncode(fcontext,options, PGPOLastOption ( fcontext ));//finally! do the encode - kind of anticlimactic
  errorhandle(err);
   result:=err;
   statform.progress.position:=100;
   statform.Hide;
   if attach then
   filename:=ChangeFileExt(filename,'.asc');//return the new filename
   if not attach then begin
   for count :=1 to length(filename) do //clear the text memory that came in
   filename[count]:='a';
   filename:=strpas(pchar(encrypttext)); //return the encrypted text
 if isntnull(wrapped) then begin //clear the wrapped buffer


if wraplen>0 then
   errorhandle(PGPcomdlgFreeWrapBuffer(wrapped))
   else
begin
   for count :=0 to (length(wrapped)-1) do //clear the text memory that came in
   wrapped[count]:='a';

strdispose(wrapped);
end;

   wrapped:=nil;
   end;
if IsntNull(encrypttext) then begin
    PGPcomdlgfreephrase(encrypttext); //clear the variable
  encrypttext:=nil;
  end;
  end;
 finally
if IsntNull( options ) then begin //clear the options
	PGPFreeOptionList( options );
	options := Nil;
end;
if attach then begin //if it is a file
if IsntNull( filespec ) then begin    //clear the spec
	PGPFreeFileSpec( filespec );
	filespec := Nil;
end;

if IsntNull(outfilespec  ) then begin //clear the spec
   PGPFreeFileSpec( outfilespec );
   outfilespec:= Nil;
end;
end;
 end;
end;
end;



(*----------------------------------
Name: tpgp5.cleandecrypt

Description: cleans up variables associated with multiple decrypt operations
             must be called after multiple decrypt operations in a row to clear
             variables that are persistent between multiple calls to tpgp5.decrypt

In: NONE

Out: NONE

Returns: NONE

-------------------------------------------*)
procedure tpgp5.cleandecrypt;
begin
cleanpass(globalstatus.password);
end;


(*----------------------------------
Name: TPGP5.Decrypt

Description: This is the decrypt procedure for the component.  All decoding occurs here.
             This will also extract any keys and call the key import window.

In:  filename - if attach is true, string containing the file name of the file to decode
              - if attach is false, actual text to decode
     attach - true if filename contains file to decode, false if filename contains actual text to decode         


Out:  filename - if attach is true, string containing the file name of the decoded file
               - if attach is false, string containing the actual decoded text
      status - statrec containing signature status information

Returns: PGPError with any errors occuring; kpgperror_noerr if no errors

-------------------------------------------*)
function tpgp5.decrypt(var filename:string;var status:statrec;attach:boolean):PGPError;
var parmstr:string;stat,len,err:longint;done:boolean;
signdate,signer:array[0..1023] of char;passwd:pchar;
tempblock,curblock:pdecblock;
options:pgpoptionlistref;
numadd:pgpuint32;
filespec:PGPFilespecref;
tempptr:pgpuservalue;
temp:integer;
addkeyset:pgpkeysetref;
decrypttext:pointer;
declen:longint;
res:pgperror;
begin
globalstatus.ispgp:=false; //set up the globalstatus record that gets sent in to PGPDecode as user data
globalstatus.attach:=attach;
globalstatus.passonce:=false;
globalstatus.outputwanted:=false;
globalstatus.filename:='';
globalstatus.status.checked:=false;
globalstatus.status.bad:=true;
globalstatus.oldfile:=filename;
globalstatus.pgppath:=pgppath;
globalstatus.decryptedblock:=nil;
globalstatus.currentblock:=nil;
globalstatus.keycount:=0;
globalstatus.status.key:=false;
decrypttext:=nil;
addkeyset:=nil;
statform.progress.position:=0;
statform.cancelbtn.tag:=0;
reloadkeyrings;

temp:=32;
tempptr:=@temp;
if not attach then begin
cleanpass(globalstatus.password);
{$IFDEF PGP6}
globalstatus.passkeylen:=0;
{$ENDIF}
end;
globalstatus.handle:=application.handle;


{$ifdef debug}
if fileexists(filename) then
log('Decrypt: '+filename+'exists') else
log('Decrypt: '+filename+'does not exist');
{$endif}

len :=256;
err:=0;
application.processmessages;
setforegroundwindow((owner as tform).handle);
globalstatus.status.mess:='';
try
errorhandle(PGPNewOptionList(fcontext,options)); //set up general options and callback handler
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOEventHandler(fcontext,@myevents,@globalstatus),PGPOLastOption(fcontext)));
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOSendNullEvents(fcontext,1000),PGPOLastOption(fcontext)));
if not attach then begin //set up text decoding options
globalstatus.attach:=false;
{$IFDEF PGP6}
globalstatus.decryptedblock:=PGPNewData(fmemMgr,sizeof(decBlock),kPGPMemoryMgrFlags_Clear);
{$ELSE}
globalstatus.decryptedblock:=PGPNewData(fcontext,sizeof(decBlock));
{$ENDIF}
globalstatus.currentblock:=globalstatus.decryptedblock;
globalstatus.decryptedblock.checked:=false;
globalstatus.decryptedblock.output:=nil;
globalstatus.decryptedblock.sighead:=nil;
globalstatus.decryptedblock.outputsize:=0;
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOPassThroughIfUnrecognized(fcontext,PGPboolean(true)),PGPOLastOption(fcontext)));
(*errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOAllocatedOutputBuffer(fcontext,decrypttext,maxmesslen,declen),PGPOLastOption(fcontext)));*)
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOInputbuffer(fcontext,pchar(filename),length(filename)),PGPOLastOption(fcontext)));
end else begin //set up file decoding options
globalstatus.attach:=true;
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOPassThroughIfUnrecognized(fcontext,PGPboolean(false)),PGPOLastOption(fcontext)));
errorhandle(PGPNewFilespecFromFullPath(fcontext,pchar(filename){pchar(ChangeFileExt(filename,'.asc'))},filespec));
{addkey(filespec);}
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOInputFile(fcontext,filespec),PGPOLastOption(fcontext)));
end;
errorhandle(PGPNewKeySet(fcontext,AddKeySet));//create keyset to hold any keys found and set up import options
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOimportkeysto(fcontext,addkeyset),PGPOLastoption(fcontext)));
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOKeySetRef(fcontext,fkeyset),PGPOLastOption(fcontext)));

if attach and (globalstatus.password <>nil) then //if we have a password then send it
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOPassphrasebuffer(fcontext,globalstatus.password,strlen(globalstatus.password)),PGPOLastOption(fcontext)));
Res:=PGPDecode(fcontext,options,PGPOLastOption(fcontext)); //do the decode
{if res <>kPGPError_DetachedSignatureFound then errorhandle(res);
if res<>kPGPError_DetachedSignatureFound then result:=res else
result:=kPGPError_noerr;}
errorhandle(res);
result:=res;
if res=kpgperror_noerr then
if attach then
if not globalstatus.outputwanted then result:=1;
   statform.progress.position:=100;
statform.Hide;
if attach then
begin
if globalstatus.ispgp then
filename:=globalstatus.filename; //if this was a pgp file, return the new file name
end else
begin
done:=false;
curblock:=globalstatus.decryptedblock;
filename:='';

repeat
if curblock^.sighead<>nil then begin
filename:=filename+strpas(pchar(curblock^.sighead));
{filename:=filename+chr(13)+chr(10);}
end;
if curblock^.output<> nil then
filename:=filename+strpas(pchar(curblock^.output)); //otherwise return the decrypted text
if curblock^.sighead<>nil then
if curblock^.encrypted then
filename:=filename+chr(13)+chr(10)+sigstatenddecver
else
filename:=filename+chr(13)+chr(10)+sigstatendver;
if IsntNull(curblock^.output) then begin //free the decrypt text temp var
{filename:=filename+chr(13)+chr(10);}
   {$IFDEF PGP6}
   pgpfreedata(curblock^.output);
   {$ELSE}
    PGPcomdlgfreephrase(curblock^.output);
    {$ENDIF}
  end;
  if isntnull(curblock^.sighead) then begin
{     PGPcomdlgfreephrase(curblock^.sighead);}
     PGPfreedata(curblock^.sighead);
     end;
  tempblock:=curblock;
  if curblock^.next<>nil then
  curblock:=curblock^.next
  else
  done:=true;
  pgpfreedata(tempblock);
  until done;

end;

PGPCountKeys(AddKeySet,numAdd); //import any keys found
if numadd>0 then begin

  errorhandle(PGPkmQueryAddKeys(fcontext,{$IFDEF PGP6}
                                         ftlscontext,
                                         {$ENDIF}
                                         application.handle,
                                         AddKeySet,nil{fkeyset}));
{messagedlg(keyincluded,mtinformation,[mbOK],0);}
{globalstatus.status.mess:=globalstatus.status.mess+keyincluded;}
globalstatus.status.key:=true;
  end;
status:=globalstatus.status;
finally
if IsntNull( addkeyset ) then begin //free the imported key set
  PGPFreeKeySet(AddKeySet);
  addkeyset:=nil;
  end;
  if IsntNull(globalstatus.recipkeys) then begin //free the recipient key set
  PGPFreeKeySet(globalstatus.recipkeys);
  globalstatus.recipkeys:=nil;
  end;
if IsntNull( options ) then begin //free the options
	PGPFreeOptionList( options );
	options := Nil;
end;
if attach then begin
if IsntNull( filespec ) then begin //free the spec
	PGPFreeFileSpec( filespec );
	filespec := Nil;
end;
if IsntNull(globalstatus.outfilespec) then begin  //free the spec
   PGPFreeFileSpec( globalstatus.outfilespec );
      globalstatus.outfilespec:= Nil;
end;
end;
end;
end;


(*----------------------------------
Name: TPGP5.AddKey

Description: This will find any key in a text buffer and bring up the import dialog

In: filename - string containing the encoded key

Out: NONE

Returns: NONE

-------------------------------------------*)
procedure tpgp5.AddKey(fileref:pgpfilespecref);
var password,parmstr:string;status:statrec;
tempkeyset:PGPKeySetRef;
{fileref:PGPFIlespecref;}
options:PGPOptionlistref;
numadd:pgpuint32;
begin
{reloadkeyrings;}
tempkeyset:=nil;
options:=nil;
{fileref:=nil;}
status.mess:='';
password:='';
{errorhandle(PGPNewFilespecFromFullPath(fcontext,pchar(filename),fileref));}
errorhandle(PGPNewOptionList(fcontext,options));
errorhandle(PGPAppendOptionList({$IFDEF PGP6}{$ELSE}fcontext,{$ENDIF}options,PGPOInputfile(fcontext,fileref),PGPOLastOption(fcontext)));
errorhandle(PGPImportKeySet(fcontext,tempkeyset,options,PGPOLastOption(fcontext)));
PGPCountKeys(tempKeySet,numAdd);
if numadd>0 then begin
  errorhandle(PGPkmQueryAddKeys(fcontext,{$IFDEF PGP6}
                                         ftlscontext,
                                         {$ENDIF}
                                         application.handle,
                                         tempKeySet,nil{fkeyset}));
  end;
if isntnull(tempkeyset) then errorhandle(PGPFreeKeySet(tempkeyset));
{if isntnull(fileref) then errorhandle(PGPFreeFilespec(fileref)); }
if isntnull(options) then errorhandle(pgpfreeoptionlist(options));
end;

(*UNUSED CURRENTLY - creates a string list containing all selected userID's*)
function TPGP5List.GetSelected;
var
count,num:integer;
tmplist:tstringlist;
begin
    fselecteditems.clear;
     for num := 0 to (Items.count -1) do
     begin
         if selected[num] then begin
        fselecteditems.add(getuser(num));

      end;
      end;
end;

(*UNUSED CURRENTLY - creates a string list containing all selected user ID's*)
function TPGP5DropList.GetSelected;
var
count,num:integer;
tmplist:tstringlist;
begin
    fselecteditems.clear;
     for num := 0 to (Items.count -1) do
     begin
         if num = itemindex then begin
        fselecteditems.add(getuser(num));

      end;
      end;
end;


(*UNUSED CURRENTLY - loads userid's into list box*)
procedure TPGP5List.load;
var err:integer;
sUserID, sKeyID, sCreationDate, sExpirationDate,  sKeyTypeES, sKeyState:array[0..255] of char;
iKeyLen, ivaliddays,iKeyType:longint;
pgpfileref:pgpfilespecref;
list:pgpkeylistref;iter:pgpkeyiterref;key:PGPKeyref;userid:pgpuseridref;
name:pchar;size:integer;bufsize:pgpsize;
test:pgpboolean;
defkey:pgpkeyref;
begin
reloadkeyrings;
err:=0;
items.clear;
list:=nil;
 key:=nil;
 iter:=nil;
errorhandle(pgporderkeyset(fkeyset,kPGPCreationOrdering ,list));
errorhandle(pgpnewkeyiter(list,iter));
name:=stralloc(256);
bufsize:=256;
test:=0;
while isntpgperror(pgpkeyiternext(iter,key)) do begin
if ftype<>'public' then
errorhandle(PGPGetKeyBoolean(key,kPGPKeyPropIsSecret,test))
else test:=1;
if test =1 then begin
errorhandle(pgpgetprimaryuseridnamebuffer(key,256,name,bufsize));
items.add(strpas(name));
end;
end;
errorhandle(pgpgetdefaultprivatekey(fkeyset,defkey));
errorhandle(pgpgetprimaryuseridnamebuffer(defkey,256,name,bufsize));
items.insert(0,strpas(name));
pgpfreekeyiter(iter);
pgpfreekeylist(list);
end;

(*UNUSED CURRENTLY - loads userid's into list box*)
procedure TPGP5dropList.load;
var err:integer;

sUserID, sKeyID, sCreationDate, sExpirationDate,  sKeyTypeES, sKeyState:array[0..255] of char;
iKeyLen, ivaliddays,iKeyType:longint;
pgpfileref:pgpfilespecref;
list:pgpkeylistref;iter:pgpkeyiterref;defkey,key:PGPKeyref;userid:pgpuseridref;
name:pchar;size:integer;bufsize:pgpsize;
test:pgpboolean;
begin
reloadkeyrings;
err:=0;
items.clear;
list:=nil;
 key:=nil;
 iter:=nil;
errorhandle(pgporderkeyset(fkeyset,kPGPCreationOrdering ,list));
errorhandle(pgpnewkeyiter(list,iter));
name:=stralloc(256);
bufsize:=256;
test:=0;
while isntpgperror(pgpkeyiternext(iter,key)) do begin
if ftype<>'public' then
errorhandle(PGPGetKeyBoolean(key,kPGPKeyPropIsSecret,test))
else test:=1;
if test =1 then begin
errorhandle(pgpgetprimaryuseridnamebuffer(key,256,name,bufsize));
items.add(strpas(name));
end;
end;
errorhandle(pgpgetdefaultprivatekey(fkeyset,defkey));
errorhandle(pgpgetprimaryuseridnamebuffer(defkey,256,name,bufsize));
items.insert(0,strpas(name));
pgpfreekeyiter(iter);
pgpfreekeylist(list);
itemindex:=0;
end;

(*UNUSED CURRENTLY - reset the selected list when someone clicks*)
procedure TPGP5dropList.click;
begin
getselected;
inherited click;
end;

(*UNUSED CURRENTLY - reset the selected list when someone clicks*)
procedure TPGP5List.click;
begin
getselected;
inherited click;
end;

(*CURRENTLY UNUSED - creates the list*)
constructor TPGP5List.create(Aowner:Tcomponent);
begin
inherited create(Aowner);
FSelectedItems:=tstringlist.create;
end;

(*CURRENTLY UNUSED - creates the list*)
constructor TPGP5DropList.create(Aowner:Tcomponent);
begin
inherited create(Aowner);
FSelectedItems:=tstringlist.create;
end;

(*----------------------------------
Name: TPGP5.cleanup

Description: cleans up the component variables.  Call only prior to quitting.

In: NONE

Out: NONE

Returns: NONE

-------------------------------------------*)
procedure tpgp5.cleanup;
begin
try
cleanpass(pointer(decryptCachePhrase));
cleanpass(pointer(signCachePhrase));

closekeyrings;
{$IFDEF PGP6}
PGPcomdlgCloseLibrary;
cleanpasskey(signcachekey,signcachekeylen);
cleanpasskey(decryptcachekey,decryptcachekeylen);

if fmemmgr<>nil then errorhandle(PGPFreeMemoryMgr(fmemmgr));
if ftlscontext<>nil then errorhandle(PGPFreeTLSContext(ftlscontext));
{$ENDIF}
if fcontext<>nil then PGPFreeContext(fcontext);
fcontext:=nil;
cachetimer.free;
except end;
end;

destructor TPGP5.destroy;
begin
cleanup;
inherited destroy;
end;




(*CURRENTLY UNUSED - destroys list; automatically called*)
destructor TPGP5List.destroy;
begin
fSelectedItems.Free;

inherited destroy;
end;

(*CURRENTLY UNUSED - destroys list; automatically called*)
destructor TPGP5DropList.destroy;
begin
fSelectedItems.Free;
inherited destroy;
end;


end.
