unit PGPGROUPS;

interface
Uses WinTypes,pgppubtypes,{pgpPFLConfig,pflContext.pas,}
     WinProcs,pgpbase;

{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }



{-$Id: pgpgroups.pas,v 1.5.12.2 1999/08/27 22:00:50 build Exp $ }
{=____________________________________________________________________________ }

Const kPGPMaxGroupNameLength = 63;
Const kPGPMaxGroupDescriptionLength = 63;
Type PGPGROUPNAME = array[0..KPGPMAXGROUPNAMELENGTH ] of CHAR ;
Type PGPGROUPDESCRIPTION = array[0.. KPGPMAXGROUPDESCRIPTIONLENGTH] of CHAR ;



Type PGPGroupSetRef =pointer;
type PGPGroupItemIterRef=pointer;
CONST KINVALIDPGPGROUPSETREF = nil;
Const kInvalidPGPGroupItemIterRef = nil;

{+// any type will do that is distinct */ }
type PGPGroupID= PGPUInt32;
Const kPGPInvalidGroupID = 0 ;
kPGPGroupItem_KeyID = 1;
kPGPGroupItem_Group=kPGPGroupItem_KeyID +1;


type PGPGroupItemType =kPGPGroupItem_KeyID..kPGPGroupItem_Group;



{+//____________________________________________________________________________ }
{-A run-time group item, used when iterating through a group. }
{-For client use; not necessarily the internal storage format. }

{-'userValue' is *not* saved to disk. }
{=____________________________________________________________________________ }

grouprec =record
id:PGPGroupID;
end;

const   kPGPGroupItemPad=0;
kPGPMaxkeysize= 8 + 1 + kPGPGroupItemPad;

type keyrec=record
algorithm:PGPUint32;
length:	PGPByte	;		//* actual size of data */
exportedKeyID:array[0..kPGPMaxkeysize ] of PGPByte;

end;

urec=record
case word of
1:(group:grouprec);
2:(key:keyrec);
end;

Type PGPGroupItem = record
                      typev: PGPGROUPITEMTYPE;
                      userValue: PGPUSERVALUE;
                      u:urec;
                    end {PGPGroupItem};

{+//____________________________________________________________________________ }
{-Info obtained via PGPGetGroupInfo. }
{=____________________________________________________________________________ }

Type PGPGroupInfo = record
                      id: PGPGROUPID;
                      name: PGPGROUPNAME;
                      description: PGPGROUPNAME;
                      userValue: PGPUSERVALUE;
                    end {PGPGroupInfo};


Type PGPGroupItemIterFlags = PGPFLAGS;
{+// flag (1UL << 0 ) is reserved */ }
Const kPGPGroupIterFlags_Recursive =  $2;
Const kPGPGroupIterFlags_Keys =  $4;
Const kPGPGroupIterFlags_Groups =  $8;


const kPGPGroupIterFlags_AllKeysRecursive=( kPGPGroupIterFlags_Recursive or kPGPGroupIterFlags_Keys );

const kPGPGroupIterFlags_AllGroupsRecursive=( kPGPGroupIterFlags_Recursive or kPGPGroupIterFlags_Groups );

const kPGPGroupIterFlags_AllItems=( kPGPGroupIterFlags_Keys or kPGPGroupIterFlags_Groups );

const kPGPGroupIterFlags_AllRecursive=( kPGPGroupIterFlags_Recursive or kPGPGroupIterFlags_AllItems );

{+//____________________________________________________________________________ }
{-Manipulating pgp group sets (PGPGroupSetRef) }
{=____________________________________________________________________________ }
{+// create a new, empty groups collection */ }

{function PGPNewGroupSet(context: PFLCONTEXTREF;
                        outRef: PPGPGROUPSETREF): PGPERROR; cdecl; far;}

{+// file is *not* left open; all data is loaded into memory */ }

{function PGPNewGroupSetFromFile(filev: PFLFILESPECREF;
                                outRef: PPGPGROUPSETREF): PGPERROR; cdecl; far;

function PGPNewGroupSetFromFSSpec(context: PFLCONTEXTREF;
                                  Const spec: PFSSPEC;
                                  outRef: PPGPGROUPSETREF): PGPERROR; cdecl; far;}

{+// overwrites existing. Don't bother unless PGPGroupSetNeedsCommit() */ }

{function PGPSaveGroupSetToFile(setv: PGPGROUPSETREF;
                               filev: PFLFILESPECREF): PGPERROR; cdecl; far;}

{+// free all data structures; be sure to save first if you want */ }

{function PGPFreeGroupSet(setv: PGPGROUPSETREF): PGPERROR; cdecl; far;}


{+// has the group changed? */ }

{function PGPGroupSetNeedsCommit(setv: PGPGROUPSETREF): PGPBOOLEAN; cdecl; far;


function PGPGetGroupSetContext(setv: PGPGROUPSETREF): PFLCONTEXTREF; cdecl; far;


function PGPGroupSetIsValid(setv: PGPGROUPSETREF): PGPBOOLEAN; cdecl; far;     }



{+//____________________________________________________________________________ }
{-Manipulating groups }

{-Groups are always referred to by IDs which remain valid until the set }
{-is disposed. }
{=____________________________________________________________________________ }

{+// initial parent ID is kPGPInvalidGroupID */ }

{function PGPNewGroup(setv: PGPGROUPSETREF;
                     Const name: PChar;
                     Const description: PChar;
                     id: PPGPGROUPID): PGPERROR; cdecl; far;


function PGPCountGroupsInSet(setv: PGPGROUPSETREF;
                             numGroups: PPGPUINT32): PGPERROR; cdecl; far;

function PGPGetIndGroupID(setv: PGPGROUPSETREF;
                          index: PGPUINT32;
                          id: PPGPGROUPID): PGPERROR; cdecl; far;}

{+// delete this group from the set */ }
{+// All references to it are removed in all sets */ }

{function PGPDeleteGroup(setv: PGPGROUPSETREF;
                        id: PGPGROUPID): PGPERROR; cdecl; far;}

{+// delete the indexed item from the group */ }
{+// the item may be a group or a key */ }

{function PGPDeleteIndItemFromGroup(setv: PGPGROUPSETREF;
                                   id: PGPGROUPID;
                                   item: PGPUINT32): PGPERROR; cdecl; far;}

{+// same as PGPDeleteIndItemFromGroup, but accepts an item */ }

{function PGPDeleteItemFromGroup(setv: PGPGROUPSETREF;
                                id: PGPGROUPID;
                                Const item: PPGPGROUPITEM): PGPERROR; cdecl; far;



function PGPGetGroupInfo(setv: PGPGROUPSETREF;
                         id: PGPGROUPID;
                         info: PPGPGROUPINFO): PGPERROR; cdecl; far;


function PGPSetGroupName(setv: PGPGROUPSETREF;
                         id: PGPGROUPID;
                         Const name: PChar): PGPERROR; cdecl; far;

function PGPSetGroupUserValue(setv: PGPGROUPSETREF;
                              id: PGPGROUPID;
                              userValue: PGPUSERVALUE): PGPERROR; cdecl; far;

function PGPSetGroupDescription(setv: PGPGROUPSETREF;
                                id: PGPGROUPID;
                                Const name: PChar): PGPERROR; cdecl; far;}

{+// 'item' specifies a group or a key id */ }
{+// you must fill the item in completely */ }

{function PGPAddItemToGroup(setv: PGPGROUPSETREF;
                           Const item: PPGPGROUPITEM;
                           group: PGPGROUPID): PGPERROR; cdecl; far;



function PGPMergeGroupIntoDifferentSet(fromSet: PGPGROUPSETREF;
                                       fromID: PGPGROUPID;
                                       toSet: PGPGROUPSETREF): PGPERROR; cdecl; far;



function PGPMergeGroupSets(fromSet: PGPGROUPSETREF;
                           intoSet: PGPGROUPSETREF): PGPERROR; cdecl; far;}

{+//____________________________________________________________________________ }
{-Manipulating group items }
{=____________________________________________________________________________ }

{+// count how many items there are in a group */ }
{+// totalItems includes keys and groups */ }

{function PGPCountGroupItems(setv: PGPGROUPSETREF;
                            id: PGPGROUPID;
                            recursive: PGPBOOLEAN;
                            numKeys: PPGPUINT32;
                            totalItems: PPGPUINT32): PGPERROR; cdecl; far;}

{+// non-recursive call; index only applies to group itself */ }

{function PGPGetIndGroupItem(setv: PGPGROUPSETREF;
                            id: PGPGROUPID;
                            index: PGPUINT32;
                            item: PPGPGROUPITEM): PGPERROR; cdecl; far;}

{+// use PGPGetIndGroupItem() if you want to get the user value */ }

{function PGPSetIndGroupItemUserValue(setv: PGPGROUPSETREF;
                                     id: PGPGROUPID;
                                     index: PGPUINT32;
                                     userValue: PGPUSERVALUE): PGPERROR; cdecl; far;


Type  PGPGROUPITEMCOMPAREPROC=function( PGPGROUPITEM:pointer; PGPGROUPITEM: pointer;
                                       USERVALUE:PGPUSERVALUE  ):integer;


function PGPSortGroupItems(setv: PGPGROUPSETREF;
                           id: PGPGROUPID;
                           proc: PGPGROUPITEMCOMPAREPROC;
                           userValue: PGPUSERVALUE): PGPERROR; cdecl; far;


function PGPSortGroupSet(setv: PGPGROUPSETREF;
                         proc: PGPGROUPITEMCOMPAREPROC;
                         userValue: PGPUSERVALUE): PGPERROR; cdecl; far;}

{+//____________________________________________________________________________ }
{-PGPGroupItemIterRef--iterator through group items. }

{-Special note: this is not a full-fledged iterator. You may *not* add }
{-or delete items while iterating and you may only move forward. However, }
{-you may change the values of items. }
{=____________________________________________________________________________ }


{function PGPNewGroupItemIter(setv: PGPGROUPSETREF;
                             id: PGPGROUPID;
                             flags: PGPGROUPITEMITERFLAGS;
                             iter: PPGPGROUPITEMITERREF): PGPERROR; cdecl; far;


function PGPFreeGroupItemIter(iter: PGPGROUPITEMITERREF): PGPERROR; cdecl; far;}

{+// returns kPGPError_EndOfIteration when done */ }

{function PGPGroupItemIterNext(iter: PGPGROUPITEMITERREF;
                              item: PPGPGROUPITEM): PGPERROR; cdecl; far;}












implementation


{function PGPNewGroupSet; external 'PGPGRO~1';

function PGPNewGroupSetFromFile; external 'PGPGRO~1';

function PGPSaveGroupSetToFile; external 'PGPGRO~1';

function PGPFreeGroupSet; external 'PGPGRO~1';

function PGPGroupSetNeedsCommit; external 'PGPGRO~1';

function PGPGetGroupSetContext; external 'PGPGRO~1';

function PGPGroupSetIsValid; external 'PGPGRO~1';

function PGPNewGroup; external 'PGPGRO~1';

function PGPCountGroupsInSet; external 'PGPGRO~1';

function PGPGetIndGroupID; external 'PGPGRO~1';

function PGPDeleteGroup; external 'PGPGRO~1';

function PGPDeleteIndItemFromGroup; external 'PGPGRO~1';

function PGPDeleteItemFromGroup; external 'PGPGRO~1';

function PGPGetGroupInfo; external 'PGPGRO~1';

function PGPSetGroupName; external 'PGPGRO~1';

function PGPSetGroupUserValue; external 'PGPGRO~1';

function PGPSetGroupDescription; external 'PGPGRO~1';

function PGPAddItemToGroup; external 'PGPGRO~1';

function PGPMergeGroupIntoDifferentSet; external 'PGPGRO~1';

function PGPMergeGroupSets; external 'PGPGRO~1';

function PGPCountGroupItems; external 'PGPGRO~1';

function PGPGetIndGroupItem; external 'PGPGRO~1';

function PGPSetIndGroupItemUserValue; external 'PGPGRO~1';

function PGPNewGroupItemIter; external 'PGPGRO~1';

function PGPFreeGroupItemIter; external 'PGPGRO~1';

function PGPGroupItemIterNext; external 'PGPGRO~1';  }
function PGPGroupSetRefIsValid(ref:pointer):boolean;
begin
 result :=ref<> kInvalidPGPGroupSetRef;
 end;
function PGPGroupItemIterRefIsValid(ref:pointer):boolean;
begin
result:= ref<> kInvalidPGPGroupItemIterRef;
end;
{function PGPValidateGroupSet( setv:PGPGROUPSETREF ):boolean;
begin
result:=PGPValidateParam(PGPGroupSetIsValid(setv));
end;}

end.
