unit PGPUI;
interface
Uses WinTypes,
PGPPubTypes,pgptls,
PGPgroups,pgpbase,
WinProcs;


{+//____________________________________________________________________________ }
{-Copyright (C) 1997 Pretty Good Privacy, Inc. }
{-All rights reserved. }

{-This file contains the prototypes for functions which use UI to interact }
{-with the user. }

{-$Id: pgpui.pas,v 1.5.12.2 1999/08/27 22:00:50 build Exp $ }
{=____________________________________________________________________________ }

const
kPGPARREnforcement_Invalid = 0;
kPGPARREnforcement_None = 1;
kPGPARREnforcement_Warn = 2;
kPGPARREnforcement_Strict = 3;

kPGPRecipientSpecType_Invalid	= 0;
	kPGPRecipientSpecType_Key		= 1;
	kPGPRecipientSpecType_UserID	= 2;



Type PGPAdditionalRecipientRequestEnforcement=pgpint32  ;
     PGPRecipientSpecType=pgpint32 ;



Type PGPRecipientSpec = record
                          typev: PGPRECIPIENTSPECTYPE;
                          locked: PGPBOOLEAN;
                          reserved8: Array[0..2] of PGPBOOLEAN;
                          reserved32: Array[0..2] of PGPUINT32;

                          case word of
                          1:(key: PGPKEYREF);
                          2:(userIDStr: Array[0..255] of Char);

                        end {PGPRecipientSpec};



Type PGPKeyServerSpec = record
                          server: PGPKEYSERVERREF;
                          serverName: PCHAR;
                          serverDomain: PCHAR;
                          reserved: Array[0..3] of PGPUINT32;


                        end {PGPKeyServerSpec};


function PGPRecipientDialog(context: PGPCONTEXTREF;
                            allKeys: PGPKEYSETREF;
                            alwaysDisplayDialog: PGPBOOLEAN;
                            var recipientKeys: PGPKEYSETREF;
                            firstOption: PGPOPTIONLISTREF;
                            lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPPassphraseDialog(context: PGPCONTEXTREF;
                             firstOption: PGPOPTIONLISTREF;
                             lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPConfirmationPassphraseDialog(context: PGPCONTEXTREF; 
                                         firstOption: PGPOPTIONLISTREF; 
                                         lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPKeyPassphraseDialog(context: PGPCONTEXTREF;
                                theKey: PGPKEYREF;
                                firstOption: PGPOPTIONLISTREF;
                                lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPSigningPassphraseDialog(context: PGPCONTEXTREF;
                                    allKeys: PGPKEYSETREF;
                                    var signingKey: PGPKEYREF;
                                    firstOption: PGPOPTIONLISTREF;
                                    lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPDecryptionPassphraseDialog(context: PGPCONTEXTREF;
                                       recipientKeys: PGPKEYSETREF;
                                       keyIDCount: PGPUINT32;
                                       keyIDList:array of PGPKEYID;
                                       var decryptionKey: PGPKEYREF;
                                       firstOption: PGPOPTIONLISTREF;
                                       lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPConventionalEncryptionPassphraseDialog(context: PGPCONTEXTREF;
                                                   firstOption: PGPOPTIONLISTREF;
                                                   lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPConventionalDecryptionPassphraseDialog(context: PGPCONTEXTREF;
                                                   firstOption: PGPOPTIONLISTREF;
                                                  lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPOptionsDialog(context: PGPCONTEXTREF;
                          firstOption: PGPOPTIONLISTREF;
                          lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPCollectRandomDataDialog(context: PGPCONTEXTREF;
                                    neededEntropyBits: PGPUINT32;
                                    firstOption: PGPOPTIONLISTREF;
                                    lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPSearchKeyServerDialog(context: PGPCONTEXTREF;
                                  serverCount: PGPUINT32;
                                  serverList:array of PGPKEYSERVERSPEC;
                                  tlsContext: PGPTLSCONTEXTREF;
                                  searchAllServers: PGPBOOLEAN;
                                  var foundKeys: PGPKEYSETREF;
                                  firstOption: PGPOPTIONLISTREF;
                                 lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;


function PGPSendToKeyServerDialog(context: PGPCONTEXTREF;
                                  var server: PGPKEYSERVERSPEC;
                                  tlsContext: PGPTLSCONTEXTREF;
                                  keysToSend: PGPKEYSETREF;
                                  var failedKeys: PGPKEYSETREF;
                                  firstOption: PGPOPTIONLISTREF;
                                  lastOption: PGPOPTIONLISTREF): PGPERROR; cdecl; far;

{+// }
{-** Returns a value in the range 0-100 which crudely estimates }
{-** the "quality" of a passphrase. }
{= }


function PGPEstimatePassphraseQuality(Const passphrase: PChar): PGPUINT32; cdecl; far;

{+// General dialog options */ }


function PGPOUIDialogPrompt(context: PGPCONTEXTREF; 
                            Const prompt: PChar): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIWindowTitle(context: PGPCONTEXTREF; 
                           Const title: PChar): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIDialogOptions(context: PGPCONTEXTREF; 
                             firstOption: PGPOPTIONLISTREF; 
                             lastOption: PGPOPTIONLISTREF): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIParentWindowHandle(context: PGPCONTEXTREF;
                                  hwndParent: HWND): PGPOPTIONLISTREF; cdecl; far;

{+// All passphrase dialogs */ }

{+// Caller should free passphrase with PGPFreeData() */ }

function PGPOUIOutputPassphrase(context: PGPCONTEXTREF; 
                                passphrase: PPChar): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIMinimumPassphraseQuality(context: PGPCONTEXTREF;
                                        minimumPassphraseQuality: PGPUINT32): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIMinimumPassphraseLength(context: PGPCONTEXTREF;
                                       minimumPassphraseLength: PGPUINT32): PGPOPTIONLISTREF; cdecl; far;

{+// PGPConfirmationPassphraseDialog() options */ }


function PGPOUIShowPassphraseQuality(context: PGPCONTEXTREF;
                                     showPassphraseQuality: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl; far;

{+// PGPSigningPassphraseDialog() and PGPDecryptionPassphraseDialog() options */ }


function PGPOUIDefaultKey(context: PGPCONTEXTREF;
                          defaultKey: PGPKEYREF): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIVerifyPassphrase(context: PGPCONTEXTREF;
                                verifyPassphrase: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIFindMatchingKey(context: PGPCONTEXTREF;
                               findMatchingKey: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl; far;

{+// PGPRecipientDialog() options: */ }


function PGPOUIDefaultRecipients(context: PGPCONTEXTREF;
                                 recipientCount: PGPUINT32;
                                 recipientList:array of PGPRECIPIENTSPEC): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIDisplayMarginalValidity(context: PGPCONTEXTREF;
                                       displayMarginalValidity: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIIgnoreMarginalValidity(context: PGPCONTEXTREF;
                                      ignoreMarginalValidity: PGPBOOLEAN): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIRecipientGroups(context: PGPCONTEXTREF;
                               groupSet: PGPGROUPSETREF): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIEnforceAdditionalRecipientRequests(context: PGPCONTEXTREF;
                                                  enforcement: PGPADDITIONALRECIPIENTREQUESTENFORCEMENT): PGPOPTIONLISTREF; cdecl; far;

{+// PGPDecryptionPassphraseDialog() and PGPRecipientDialog() only: */ }


function PGPOUIKeyServerUpdateParams(context: PGPCONTEXTREF;
                                     serverCount: PGPUINT32;
                                     serverList:array of PGPKEYSERVERSPEC;
                                     tlsContext: PGPTLSCONTEXTREF;
                                     searchBeforeDisplay: PGPBOOLEAN;
                                     var foundKeys: PGPKEYSETREF;
                                     firstOption: PGPOPTIONLISTREF;
                                     lastOption: PGPOPTIONLISTREF): PGPOPTIONLISTREF; cdecl; far;

{+// Key server search dialog options */ }


function PGPOUIKeyServerSearchFilter(context: PGPCONTEXTREF;
                                     filter: PGPFILTERREF): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIKeyServerSearchKey(context: PGPCONTEXTREF;
                                  key: PGPKEYREF): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIKeyServerSearchKeySet(context: PGPCONTEXTREF;
                                     keySet: PGPKEYSETREF): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIKeyServerSearchKeyIDList(context: PGPCONTEXTREF;
                                        keyIDCount: PGPUINT32;
                                        keyIDList:array of PGPKEYID): PGPOPTIONLISTREF; cdecl; far;

{+// }
{-** These options are used to build the options dialog and are only }
{-** applicable for the PGPOptionsDialog() and PGPOUIDialogOptions() calls. }
{-** The "description" parameters are optional. }
{= }


function PGPOUICheckbox(context: PGPCONTEXTREF;
                        itemID: PGPUINT32;
                        Const title: PChar;
                        Const description: PChar;
                        initialValue: PGPUINT32;
                        var resultPtr: PGPUINT32): PGPOPTIONLISTREF; cdecl; far;


function PGPOUIPopupList(context: PGPCONTEXTREF;
                         itemID: PGPUINT32;
                         Const title: PChar;
                         Const description: PChar;
                         listItemCount: PGPUINT32;
                         listItems:array of PChar;
                         initialValue: PGPUINT32;
                         var resultPtr: PGPUINT32): PGPOPTIONLISTREF; cdecl; far;


implementation

function PGPRecipientDialog;external 'PGPSDKUI.DLL';

function PGPPassphraseDialog; external 'PGPSDKUI.DLL';

function PGPConfirmationPassphraseDialog; external 'PGPSDKUI.DLL';

function PGPKeyPassphraseDialog; external 'PGPSDKUI.DLL';

function PGPSigningPassphraseDialog; external 'PGPSDKUI.DLL';

function PGPDecryptionPassphraseDialog; external 'PGPSDKUI.DLL';

function PGPConventionalEncryptionPassphraseDialog; external 'PGPSDKUI.DLL';

function PGPConventionalDecryptionPassphraseDialog; external 'PGPSDKUI.DLL';

function PGPOptionsDialog; external 'PGPSDKUI.DLL';

function PGPCollectRandomDataDialog; external 'PGPSDKUI.DLL';

function PGPSearchKeyServerDialog; external 'PGPSDKUI.DLL';

function PGPSendToKeyServerDialog; external 'PGPSDKUI.DLL';

function PGPEstimatePassphraseQuality; external 'PGPSDKUI.DLL';

function PGPOUIDialogPrompt; external 'PGPSDKUI.DLL';

function PGPOUIWindowTitle; external 'PGPSDKUI.DLL';

function PGPOUIDialogOptions; external 'PGPSDKUI.DLL';

function PGPOUIParentWindowHandle; external 'PGPSDKUI.DLL';

function PGPOUIOutputPassphrase; external 'PGPSDKUI.DLL';

function PGPOUIMinimumPassphraseQuality; external 'PGPSDKUI.DLL';

function PGPOUIMinimumPassphraseLength; external 'PGPSDKUI.DLL';

function PGPOUIShowPassphraseQuality; external 'PGPSDKUI.DLL';

function PGPOUIDefaultKey; external 'PGPSDKUI.DLL';

function PGPOUIVerifyPassphrase; external 'PGPSDKUI.DLL';

function PGPOUIFindMatchingKey; external 'PGPSDKUI.DLL';

function PGPOUIDefaultRecipients; external 'PGPSDKUI.DLL';

function PGPOUIDisplayMarginalValidity; external 'PGPSDKUI.DLL';

function PGPOUIIgnoreMarginalValidity; external 'PGPSDKUI.DLL';

function PGPOUIRecipientGroups; external 'PGPSDKUI.DLL';

function PGPOUIEnforceAdditionalRecipientRequests; external 'PGPSDKUI.DLL';

function PGPOUIKeyServerUpdateParams; external 'PGPSDKUI.DLL';

function PGPOUIKeyServerSearchFilter; external 'PGPSDKUI.DLL';

function PGPOUIKeyServerSearchKey; external 'PGPSDKUI.DLL';

function PGPOUIKeyServerSearchKeySet; external 'PGPSDKUI.DLL';

function PGPOUIKeyServerSearchKeyIDList; external 'PGPSDKUI.DLL';

function PGPOUICheckbox; external 'PGPSDKUI.DLL';

function PGPOUIPopupList; external 'PGPSDKUI.DLL';

end.
