/*____________________________________________________________________________
	Copyright (C) 1999 Pretty Good Privacy, Inc.
	All rights reserved.
	

	$Id: FileSystemHandling.c,v 1.1.4.7 2000/08/09 01:23:06 build Exp $
____________________________________________________________________________*/

/*::: MODULE OVERVIEW :::::::::::::

--- revision history --------
8/6/99 Version 1.0: Paul Ryan
::::::::::::::::::::::::::::::::::::*/

#include "FileSystemHandling.h"


/** epc_getTempDirNm( ***
Purpose is to fill the specified buffer with the name of the system's 
temporary directory, ending with the path-specifier character (e.g. backslash 
with Win32).

--- parameters & return ----
pc_buf: pointer to the pre-allocated buffer
ui_LEN_BUF: the amount of space in the buffer
RETURN: pc_buf if successful, else NULL

--- revision history -------
8/1/99 PR: created			*/
char * epc_getTempDirNm( char *const  pc_buf, 
							const unsigned int  ui_LEN_BUF)	{
	const char *const  pc_ENV_TEMP = getenv( "TEMP");

	if (!( pc_buf && ui_LEN_BUF))
		return NULL;

	if (strlen( pc_ENV_TEMP) + strlen( epc_PATH_SPECIFIER) > ui_LEN_BUF - 1)
		return NULL;
	strcat( strcpy( pc_buf, pc_ENV_TEMP), (const char *) (strrchr( 
								pc_ENV_TEMP, ec_PATH_SPECIFIER) != 
								pc_ENV_TEMP + strlen( pc_ENV_TEMP) - 1 ? 
								(int) epc_PATH_SPECIFIER : (int) epc_NULL));

	return pc_buf;
} //epc_getTempDirNm(


/** ef_LoadBinaryFile( ***


--- parameters & return ----


--- revision history -------
8/1/99 PR: created			*/
//DOC!!
BOOL ef_LoadBinaryFile( const char  pc_FILENM[], 
						void *const  pv, 
						const int  i_LEN)	{
	FILE * pfl;
	char * pc = NULL;
	BOOL  f_failure;

	if (!( pc_FILENM && pv && i_LEN))
		return FALSE;

	if (!( pfl = fopen( pc_FILENM, "rb")))
		return FALSE;

	if (f_failure = filelength( fileno( pfl)) < i_LEN)
		goto errJump;

	fread( pv, 1, i_LEN, pfl);
	f_failure = ferror( pfl);

errJump:
	if (fclose( pfl) == EOF)
		if (!f_failure)
			f_failure = TRUE;

	return !f_failure;
} //ef_LoadBinaryFile(


/** ef_LoadTextFileEntire( ***


--- parameters & return ----


--- revision history -------
8/1/99 PR: created			*/
//DOC!!
/*BOOL ef_LoadTextFileEntire( const char  pc_FILENM[], 
							char * *const  ppc)	{
	FILE * pfl;
	int  i;
	char * pc = NULL;
	BOOL  f_failure;

	if (!( pc_FILENM && ppc))
		return FALSE;

	*ppc = NULL;

	if (!( pfl = fopen( pc_FILENM, "rt")))
		return FALSE;

	if (f_failure = (i = filelength( fileno( pfl))) < 0)
		goto errJump;

	if (i)	{
		if (f_failure = !( pc = malloc( i + 1)))
			goto errJump;

		i = fread( pc, 1, i, pfl);
		if (f_failure = ferror( pfl))
			goto errJump;
		pc[ i] = NULL;
	} //if (i)

errJump:
	if (fclose( pfl) == EOF)
		if (!f_failure)
			f_failure = TRUE;

	if (pc)
		if (!f_failure)
			*ppc = pc;
		else 
			free( pc);

	return !f_failure;
} //ef_LoadTextFileEntire(
*/

