/*____________________________________________________________________________
	Copyright (C) 2000 Pretty Good Privacy, Inc.
	All rights reserved.


	$Id: LibItem.h,v 1.7.12.8 2000/08/09 01:23:07 build Exp $
____________________________________________________________________________*/

/*::: FUNCTIONAL OVERVIEW ::::::::::
Provides common Notes item-handling & -manipulation facilities.

--- revision history --------
2/21/00 Version 1.1.5: Paul Ryan
+ added position-found and count output to ef_TextListContainsEntry(), thus 
  changing its signature
+ added eus_IsRtf(), ef_TextListEntryMatches()
+ added eus_ItemScan() utility stub
+ signature change to ef_GetNumberListEntry() to foster consistency with 
														text-list procedures

9/9/99 Version 1.1: Paul Ryan
+ signature change to eus_CreateTextListEntryCopy()
+ removed eus_GetItemContents() as not useful; use NSFItemInfo() instead

12/2/98 Version 1.0: Paul Ryan
::::::::::::::::::::::::::::::::::::*/

#ifndef Included_LibItem_h	/* [ */
#define Included_LibItem_h


extern const BLOCKID  ebid_NULLBLOCKID;


BOOL ef_TextListEntryMatches( void *const, const BOOL, const WORD, 
																const char[]);
STATUS eus_CreateTextListEntryCopy( const WORD, BYTE *const, const BOOL, 
															char * *const);
BOOL ef_GetNumberListEntry( const BYTE *, const BOOL, const WORD, 
															double *const);
BOOL ef_TextListContainsEntry( void *const, const BOOL, const char[], 
													WORD *const, WORD *const);
STATUS eus_RemoveItem( NOTEHANDLE, char[], const BLOCKID);
STATUS eus_TestTextListItemHasEntry( NOTEHANDLE, char[], const char[], 
																BOOL *const);
STATUS eus_AttemptCopyTextListItemEntry( NOTEHANDLE, char[], const WORD, 
															char * *const);
STATUS eus_AttemptCopyTextItemContent( NOTEHANDLE, char[], char[], 
												BYTE * *const, WORD *const);
STATUS eus_ItemScan( WORD, WORD, char *, WORD, void *, DWORD, void *);

#endif /* ] Included_LibItem_h */
