/*____________________________________________________________________________
	Copyright (C) 1999 Pretty Good Privacy, Inc.
	All rights reserved.
	

	$Id: LinkListHandling.c,v 1.1.4.8 2000/08/09 01:23:08 build Exp $
____________________________________________________________________________*/

/*::: MODULE OVERVIEW :::::::::::::
Generic linked-list handling

--- revision history --------
8/26/99: Version 1.0: Paul Ryan
::::::::::::::::::::::::::::::::::::*/

#include <stdlib.h>		//free(), etc.


typedef struct _Node	{
	void * pv;
	struct _Node * pt_next;
}  Node;

typedef enum	{
	FALSE, 
	TRUE
}  BOOL;


/** ef_AddListNodeFifo( ***


--- parameters & return ----

RETURN: TRUE if no error occurred; FALSE otherwise

--- revision history -------
8/26/99 PR: created			*/
//DOC!!
BOOL ef_AddListNodeFifo( void *const  pv, 
							Node * *const  ppt_nd)	{
	Node * pt_nd;

	if (!( pv && ppt_nd))
		return FALSE;

	if (!( pt_nd = *ppt_nd))	{
		if (!( pt_nd = calloc( 1, sizeof( Node))))
			return FALSE;
	//else string on a new entry
	}else	{
		//move to the last node in the list
		while( pt_nd->pt_next)
			pt_nd = pt_nd->pt_next;

		if (!( pt_nd = pt_nd->pt_next = calloc( 1, sizeof( Node))))
			return FALSE;
	} //if (!( pt_nd

	pt_nd->pv = pv;

	*ppt_nd = pt_nd;

	return TRUE;
} //ef_AddListNodeFifo(


/** e_FreeList( ***
Free the resources allocated to the given linked-list.

--- parameters ----------
ppt: Input & Output. Pointer to the head node of the list to be freed. The 
	head node is set to NULL by this procedure, a safety aid for the caller 
	to help ensure that the list is not reused.
f_CONTENTS_TOO: flag telling whether the contents of each node in the list 
	should be freed as well as the nodes themselves

--- revision history ----
8/26/99 PR: created		*/
void e_FreeList( Node * * ppt, 
					const BOOL  f_CONTENTS_TOO)	{
	Node * pt, * pt_next;

	if (!( ppt && *ppt))
		return;

	pt = *ppt;
	do	{
		//get a handle on the next node before freeing the current node
		pt_next = pt->pt_next;

		if (f_CONTENTS_TOO && pt->pv)
			free( pt->pv);
		free( pt);
	} while (pt = pt_next);

	*ppt = NULL;
} //e_FreeList(


