/*____________________________________________________________________________
	Copyright (C) 2000 Pretty Good Privacy, Inc.
	All rights reserved.
	

	$Id: PgpHandling.h,v 1.10.12.8 2000/08/09 01:23:09 build Exp $
____________________________________________________________________________*/

#ifndef Included_PgpHandling_h	/* [ */
#define Included_PgpHandling_h

//system headers
#include <stdio.h>				//for sprintf()
#include <windows.h>
#include <crtdbg.h>

//PGPsdk headers
#include <pgpSC.h>
#include <pgpErrors.h>
#include <pgpSDKPrefs.h>
#include <pgpMem.h>

//shared headers
#include <PGPcl.h>
#include <DecryptVerify.h>
#include <EncryptSign.h>
#include <Working.h>
#include <WorkingResource.h>
#include <Prefs.h>
#include <pgpClientPrefs.h>		//for kPGPPrefDecryptCacheEnable
#include <SharedStrings.h>
#include <SigEvent.h>
#include <VerificationBlock.h>
#include <pgpVersionHeader.h>

//local headers
#include "VbCallable.h"


typedef struct	{
	HINSTANCE  h_Instance;
	HWND  h_wndMain;
	PGPContextRef  pgpContext;
	PGPtlsContextRef  pgpTlsContext;
	char *  pc_AppNm;
	const char *  pc_ModuleNm;
}  PgpBasicInput;

typedef enum	{
	mi_TEST_FOR_PGP_ASCII = 1, 
	mi_GET_PGP_BLOCK_COORDS, 
	mi_DECODE_BINARY, 
	mi_NO_TASK = 0
}  SpecialPlugInTask;

typedef struct	{
	SpecialPlugInTask  i_Task;
	BOOL * pf_Successful;
	void * pv_return;
}  SpecialPlugInTaskInfo;

typedef struct	{
	DWORD  ul_offsetBegin;
	DWORD  ul_offsetEnd;
}  PgpBlockCoordInfo;

typedef struct	{
	BYTE * * ppc_output;
	DWORD * pul_lenOutput;
}  DecodeBinaryInfo;

typedef struct	{
	BOOL  f_Sign;
	BOOL  f_Encrypt;
	RECIPIENTDIALOGSTRUCT  t_recipients;
	PGPOptionListRef  pgpUserOptions;
}  PgpEncodeContext;

//structure copied from shared-code PGP module DecryptVerify.c
typedef struct _VerificationBlock	{
	struct _VerificationBlock * next;
	struct _VerificationBlock * previous;
	char * szBlockBegin;
	char * szBlockEnd;
	void * pOutput;
	PGPSize  outSize;
	PGPBoolean  bEncrypted;
	PGPBoolean  FYEO;
}  VerificationBlock;

//structure copied from shared-code PGP module DecryptVerify.c
typedef struct	{
	HINSTANCE  h_Instance;
	HWND  h_wndMain;
	HWND  h_wndWorking;
	PGPtlsContextRef  pgpTlsContext;
	char * pc_AppNm;
	PGPKeySetRef  pgpPubKeySet;
	PGPKeySetRef  pgpRecipients;
	PGPUInt32  ul_keyCount;
	PGPKeyID * pt_keyIds;
	VerificationBlock *	pt_block;
}  DecodeEventData;

typedef struct	{
	DecodeEventData  t_normalData;
	SpecialPlugInTaskInfo  t_task;
}  MyDecodeEventData;

typedef struct _NameFoundNode	{
	struct	{
		char * pc_nm;
		BOOL  f_found;
		BYTE  opaque[ sizeof( void *)];
	} * pt_name;
	struct _NameFoundNode * pt_next;
}  NameFoundNode;


extern const char  epc_CRLF[];
extern const int  ei_NOT_FOUND, ei_LEN_CRLF, ei_SAME;

extern HINSTANCE  eh_Instance;


PGPError DecodeEventHandler(PGPContextRef, PGPEvent *, PGPUserValue);
PGPError EncodeEventHandler(PGPContextRef, PGPEvent *, PGPUserValue);

static PGPError i_DecodeEventHandlerOverride( PGPContextRef, PGPEvent *, 
																PGPUserValue);
static void DisplayPgpError( const char *const, const int, const char *const, 
																		int);
static PGPError i_DecryptVerify( const PgpBasicInput *const, 
								PGPOptionListRef, const BOOL, 
								const SpecialPlugInTaskInfo, 
								VerificationBlock *const, PGPBoolean *const);
static PGPError i_DecryptVerifyBuffer( const PgpBasicInput *const, 
								const char *const, const DWORD, const BOOL, 
								SpecialPlugInTaskInfo, char * *const, 
								PGPSize *const, BOOL *const);
static PGPError i_GetPgpAsciiCoords( char * *const, const DWORD, DWORD *const, 
																DWORD *const);
static PGPError i_EncryptSignBuffer( const PgpBasicInput *const, void *, 
									DWORD, RECIPIENTDIALOGSTRUCT *const, 
									PGPOptionListRef, PGPOptionListRef *, 
									void * *, PGPSize *, BOOL, BOOL, BOOL);
static PGPError i_EncryptSign( const PgpBasicInput *const, 
								RECIPIENTDIALOGSTRUCT *, PGPOptionListRef, 
								PGPOptionListRef, PGPOptionListRef *, BOOL, 
								BOOL, BOOL);


#endif /* ] Included_PgpHandling_h */
